/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.showcase;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.shapefileParser.ShapefileRDD;
import org.apache.sedona.core.serde.SedonaKryoRegistrator;
import org.apache.sedona.core.showcase.ScalaExample$delayedInit$body;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialOperator.KNNQuery;
import org.apache.sedona.core.spatialOperator.RangeQuery;
import org.apache.sedona.core.spatialRDD.CircleRDD;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.sedona.core.spatialRDD.PolygonRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.storage.StorageLevel$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ScalaExample$
implements App {
    public static ScalaExample$ MODULE$;
    private final SparkConf conf;
    private final SparkContext sc;
    private final String resourceFolder;
    private final String PointRDDInputLocation;
    private final FileDataSplitter PointRDDSplitter;
    private final IndexType PointRDDIndexType;
    private final int PointRDDNumPartitions;
    private final int PointRDDOffset;
    private final String PolygonRDDInputLocation;
    private final FileDataSplitter PolygonRDDSplitter;
    private final int PolygonRDDNumPartitions;
    private final int PolygonRDDStartOffset;
    private final int PolygonRDDEndOffset;
    private final GeometryFactory geometryFactory;
    private final Point kNNQueryPoint;
    private final Envelope rangeQueryWindow;
    private final GridType joinQueryPartitioningType;
    private final int eachQueryLoopTimes;
    private String ShapeFileInputLocation;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ScalaExample$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public String resourceFolder() {
        return this.resourceFolder;
    }

    public String PointRDDInputLocation() {
        return this.PointRDDInputLocation;
    }

    public FileDataSplitter PointRDDSplitter() {
        return this.PointRDDSplitter;
    }

    public IndexType PointRDDIndexType() {
        return this.PointRDDIndexType;
    }

    public int PointRDDNumPartitions() {
        return this.PointRDDNumPartitions;
    }

    public int PointRDDOffset() {
        return this.PointRDDOffset;
    }

    public String PolygonRDDInputLocation() {
        return this.PolygonRDDInputLocation;
    }

    public FileDataSplitter PolygonRDDSplitter() {
        return this.PolygonRDDSplitter;
    }

    public int PolygonRDDNumPartitions() {
        return this.PolygonRDDNumPartitions;
    }

    public int PolygonRDDStartOffset() {
        return this.PolygonRDDStartOffset;
    }

    public int PolygonRDDEndOffset() {
        return this.PolygonRDDEndOffset;
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public Point kNNQueryPoint() {
        return this.kNNQueryPoint;
    }

    public Envelope rangeQueryWindow() {
        return this.rangeQueryWindow;
    }

    public GridType joinQueryPartitioningType() {
        return this.joinQueryPartitioningType;
    }

    public int eachQueryLoopTimes() {
        return this.eachQueryLoopTimes;
    }

    public String ShapeFileInputLocation() {
        return this.ShapeFileInputLocation;
    }

    public void ShapeFileInputLocation_$eq(String x$1) {
        this.ShapeFileInputLocation = x$1;
    }

    public void testSpatialRangeQuery() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.rawSpatialRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long l = RangeQuery.SpatialRangeQuery(objectRDD, MODULE$.rangeQueryWindow(), false, false).count();
        });
    }

    public void testSpatialRangeQueryUsingIndex() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.buildIndex(this.PointRDDIndexType(), false);
        objectRDD.indexedRawRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long l = RangeQuery.SpatialRangeQuery(objectRDD, MODULE$.rangeQueryWindow(), false, true).count();
        });
    }

    public void testSpatialKnnQuery() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.rawSpatialRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List<Point> list = KNNQuery.SpatialKnnQuery(objectRDD, MODULE$.kNNQueryPoint(), Predef$.MODULE$.int2Integer(1000), false);
        });
    }

    public void testSpatialKnnQueryUsingIndex() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.buildIndex(this.PointRDDIndexType(), false);
        objectRDD.indexedRawRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List<Point> list = KNNQuery.SpatialKnnQuery(objectRDD, MODULE$.kNNQueryPoint(), Predef$.MODULE$.int2Integer(1000), true);
        });
    }

    public void testSpatialJoinQuery() {
        PolygonRDD queryWindowRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PolygonRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PolygonRDDStartOffset()), Predef$.MODULE$.int2Integer(this.PolygonRDDEndOffset()), this.PolygonRDDSplitter(), true);
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.spatialPartitioning(this.joinQueryPartitioningType());
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        objectRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long l = JoinQuery.SpatialJoinQuery(objectRDD, queryWindowRDD, false, true).count();
        });
    }

    public void testSpatialJoinQueryUsingIndex() {
        PolygonRDD queryWindowRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PolygonRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PolygonRDDStartOffset()), Predef$.MODULE$.int2Integer(this.PolygonRDDEndOffset()), this.PolygonRDDSplitter(), true);
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        objectRDD.spatialPartitioning(this.joinQueryPartitioningType());
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        objectRDD.buildIndex(this.PointRDDIndexType(), true);
        objectRDD.indexedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long l = JoinQuery.SpatialJoinQuery(objectRDD, queryWindowRDD, true, false).count();
        });
    }

    public void testDistanceJoinQuery() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        CircleRDD queryWindowRDD = new CircleRDD(objectRDD, Predef$.MODULE$.double2Double(0.1));
        objectRDD.spatialPartitioning(GridType.QUADTREE);
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        objectRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long l = JoinQuery.DistanceJoinQuery(objectRDD, queryWindowRDD, false, true).count();
        });
    }

    public void testDistanceJoinQueryUsingIndex() {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY());
        CircleRDD queryWindowRDD = new CircleRDD(objectRDD, Predef$.MODULE$.double2Double(0.1));
        objectRDD.spatialPartitioning(GridType.QUADTREE);
        queryWindowRDD.spatialPartitioning(objectRDD.getPartitioner());
        objectRDD.buildIndex(IndexType.RTREE, true);
        objectRDD.indexedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        queryWindowRDD.spatialPartitionedRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.eachQueryLoopTimes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long l = JoinQuery.DistanceJoinQuery(objectRDD, queryWindowRDD, true, true).count();
        });
    }

    public void testCRSTransformationSpatialRangeQuery() throws Exception {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY(), "epsg:4326", "epsg:3005");
        objectRDD.rawSpatialRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        int i = 0;
        while (i < this.eachQueryLoopTimes()) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, this.rangeQueryWindow(), false, false).count();
            Predef$.MODULE$.assert(resultSize > -1L);
            int cfr_ignored_0 = ++i - 1;
        }
    }

    public void testCRSTransformationSpatialRangeQueryUsingIndex() throws Exception {
        PointRDD objectRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.PointRDDInputLocation(), Predef$.MODULE$.int2Integer(this.PointRDDOffset()), this.PointRDDSplitter(), true, StorageLevel$.MODULE$.MEMORY_ONLY(), "epsg:4326", "epsg:3005");
        objectRDD.buildIndex(this.PointRDDIndexType(), false);
        objectRDD.indexedRawRDD.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        int i = 0;
        while (i < this.eachQueryLoopTimes()) {
            long resultSize = RangeQuery.SpatialRangeQuery(objectRDD, this.rangeQueryWindow(), false, true).count();
            Predef$.MODULE$.assert(resultSize > -1L);
            int cfr_ignored_0 = ++i - 1;
        }
    }

    public void testLoadShapefileIntoPolygonRDD() throws Exception {
        ShapefileRDD shapefileRDD = new ShapefileRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.ShapeFileInputLocation());
        PolygonRDD spatialRDD = new PolygonRDD(shapefileRDD.getPolygonRDD());
        try {
            RangeQuery.SpatialRangeQuery(spatialRDD, new Envelope(-180.0, 180.0, -90.0, 90.0), false, false).count();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void delayedEndpoint$org$apache$sedona$core$showcase$ScalaExample$1() {
        this.conf = new SparkConf().setAppName("SedonaRunnableExample").setMaster("local[2]");
        this.conf().set("spark.serializer", KryoSerializer.class.getName());
        this.conf().set("spark.kryo.registrator", SedonaKryoRegistrator.class.getName());
        this.sc = new SparkContext(this.conf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        this.resourceFolder = new StringBuilder(20).append(System.getProperty("user.dir")).append("/src/test/resources/").toString();
        this.PointRDDInputLocation = new StringBuilder(16).append(this.resourceFolder()).append("arealm-small.csv").toString();
        this.PointRDDSplitter = FileDataSplitter.CSV;
        this.PointRDDIndexType = IndexType.RTREE;
        this.PointRDDNumPartitions = 5;
        this.PointRDDOffset = 1;
        this.PolygonRDDInputLocation = new StringBuilder(24).append(this.resourceFolder()).append("primaryroads-polygon.csv").toString();
        this.PolygonRDDSplitter = FileDataSplitter.CSV;
        this.PolygonRDDNumPartitions = 5;
        this.PolygonRDDStartOffset = 0;
        this.PolygonRDDEndOffset = 8;
        this.geometryFactory = new GeometryFactory();
        this.kNNQueryPoint = this.geometryFactory().createPoint(new Coordinate(-84.01, 34.01));
        this.rangeQueryWindow = new Envelope(-90.01, -80.01, 30.01, 40.01);
        this.joinQueryPartitioningType = GridType.QUADTREE;
        this.eachQueryLoopTimes = 5;
        this.ShapeFileInputLocation = new StringBuilder(18).append(this.resourceFolder()).append("shapefiles/polygon").toString();
        this.testSpatialRangeQuery();
        this.testSpatialRangeQueryUsingIndex();
        this.testSpatialKnnQuery();
        this.testSpatialKnnQueryUsingIndex();
        this.testSpatialJoinQuery();
        this.testSpatialJoinQueryUsingIndex();
        this.testDistanceJoinQuery();
        this.testDistanceJoinQueryUsingIndex();
        this.testCRSTransformationSpatialRangeQuery();
        this.testCRSTransformationSpatialRangeQueryUsingIndex();
        this.sc().stop();
        System.out.println("All DEMOs passed!");
    }

    private ScalaExample$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new ScalaExample$delayedInit$body(this));
    }
}

