/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import java.io.Serializable;
import org.apache.sedona.core.enums.JoinSparitionDominantSide;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.core.utils.SedonaConf;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BasePredicate;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Predicate$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeRowJoiner$;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowJoiner;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.SparkPlan;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e!C\b\u0011!\u0003\r\taHA@\u0011\u00151\u0003\u0001\"\u0001(\u0011!Y\u0003\u0001#b\u0001\n\u0013a\u0003bB\u001f\u0001\u0005\u00045\tA\u0010\u0005\b\u000b\u0002\u0011\rQ\"\u0001?\u0011\u001d1\u0005A1A\u0007\u0002\u001dCqA\u0014\u0001C\u0002\u001b\u0005q\tC\u0004P\u0001\t\u0007i\u0011\u0001)\t\u000fE\u0003!\u0019!D\u0001%\")a\u000b\u0001C!/\")q\r\u0001C)Q\")q\u000e\u0001C\u0001a\"9\u0011\u0011\u0006\u0001\u0005\u0012\u0005-\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003G\u0002A\u0011AA3\u0005I!&/Y5u\u0015>Lg.U;fef,\u00050Z2\u000b\u0005E\u0011\u0012\u0001\u00026pS:T!a\u0005\u000b\u0002\u0011M$(/\u0019;fOfT!!\u0006\f\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u00181\u0005\u00191/\u001d7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u0015\u0011\u0005\u0005J\u0013B\u0001\u0016#\u0005\u0011)f.\u001b;\u0002\u001d\t|WO\u001c3D_:$\u0017\u000e^5p]V\tQ\u0006\u0005\u0003\"]A2\u0014BA\u0018#\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00022i5\t!G\u0003\u00024-\u0005A1-\u0019;bYf\u001cH/\u0003\u00026e\tY\u0011J\u001c;fe:\fGNU8x!\t\ts'\u0003\u00029E\t9!i\\8mK\u0006t\u0007F\u0001\u0002;!\t\t3(\u0003\u0002=E\tIAO]1og&,g\u000e^\u0001\u0005Y\u00164G/F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011e#A\u0005fq\u0016\u001cW\u000f^5p]&\u0011A)\u0011\u0002\n'B\f'o\u001b)mC:\fQA]5hQR\f\u0011\u0002\\3giNC\u0017\r]3\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u001a\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u001b*\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003)\u0011\u0018n\u001a5u'\"\f\u0007/Z\u0001\u000bS:$XM]:fGR\u001cX#\u0001\u001c\u0002\u001d\u0015DHO]1D_:$\u0017\u000e^5p]V\t1\u000bE\u0002\")\"K!!\u0016\u0012\u0003\r=\u0003H/[8o\u0003\u0019yW\u000f\u001e9viV\t\u0001\fE\u0002ZC\u0012t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005us\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0001'%A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'aA*fc*\u0011\u0001M\t\t\u0003\u0013\u0016L!A\u001a&\u0003\u0013\u0005#HO]5ckR,\u0017!\u00033p\u000bb,7-\u001e;f)\u0005I\u0007c\u00016na5\t1N\u0003\u0002m1\u0005\u0019!\u000f\u001a3\n\u00059\\'a\u0001*E\t\u0006\u0001Bo\\*qCRL\u0017\r\u001c*eIB\u000b\u0017N\u001d\u000b\nc\u0006E\u0011QDA\u0011\u0003K\u0001B!\t:ui&\u00111O\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007Udh0D\u0001w\u0015\t9\b0\u0001\u0006ta\u0006$\u0018.\u00197S\t\u0012S!!\u001f>\u0002\t\r|'/\u001a\u0006\u0003wj\taa]3e_:\f\u0017BA?w\u0005)\u0019\u0006/\u0019;jC2\u0014F\t\u0012\t\u0004\u007f\u00065QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\t\u001d,w.\u001c\u0006\u0005\u0003\u000f\tI!A\u0002kiNT1!a\u0003\u001d\u00031awnY1uS>tG/Z2i\u0013\u0011\ty!!\u0001\u0003\u0011\u001d+w.\\3uefDq!a\u0005\f\u0001\u0004\t)\"\u0001\u0005ck&dGM\u00153e!\u0011QW.a\u0006\u0011\u0007%\u000bI\"C\u0002\u0002\u001c)\u0013\u0011\"\u00168tC\u001a,'k\\<\t\r\u0005}1\u00021\u0001I\u0003%\u0011W/\u001b7e\u000bb\u0004(\u000fC\u0004\u0002$-\u0001\r!!\u0006\u0002\u0017M$(/Z1nK\u0012\u0014F\r\u001a\u0005\u0007\u0003OY\u0001\u0019\u0001%\u0002\u0019M$(/Z1nK\u0012,\u0005\u0010\u001d:\u0002\u0019Q|7\u000b]1uS\u0006d'\u000b\u001a3\u0015\u000bQ\fi#a\f\t\r1d\u0001\u0019AA\u000b\u0011\u0019\t\t\u0004\u0004a\u0001\u0011\u0006y1\u000f[1qK\u0016C\bO]3tg&|g.A\u000be_N\u0003\u0018\r^5bYB\u000b'\u000f^5uS>t\u0017N\\4\u0015\u0013!\n9$a\u000f\u0002@\u0005M\u0003BBA\u001d\u001b\u0001\u0007A/\u0001\be_6Lg.\u00198u'\"\f\u0007/Z:\t\r\u0005uR\u00021\u0001u\u000391w\u000e\u001c7po\u0016\u00148\u000b[1qKNDq!!\u0011\u000e\u0001\u0004\t\u0019%A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0013\u0001\u00026bm\u0006LA!!\u0015\u0002H\t9\u0011J\u001c;fO\u0016\u0014\bbBA+\u001b\u0001\u0007\u0011qK\u0001\u000bg\u0016$wN\\1D_:4\u0007\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005u\u00030A\u0003vi&d7/\u0003\u0003\u0002b\u0005m#AC*fI>t\u0017mQ8oM\u0006I\"n\\5o!\u0006\u0014H/\u001b;j_:tU/\\(qi&l\u0017N_3s)!\t9'!\u001c\u0002r\u0005U\u0004cA\u0011\u0002j%\u0019\u00111\u000e\u0012\u0003\u0007%sG\u000fC\u0004\u0002p9\u0001\r!a\u001a\u0002'\u0011|W.\u001b8b]R\u001c\u0016\u000eZ3QCJ$h*^7\t\u000f\u0005Md\u00021\u0001\u0002h\u0005\u0019bm\u001c7m_^,'oU5eKB\u000b'\u000f\u001e(v[\"9\u0011q\u000f\bA\u0002\u0005e\u0014!\u00053p[&t\u0017M\u001c;TS\u0012,7i\\;oiB\u0019\u0011%a\u001f\n\u0007\u0005u$E\u0001\u0003M_:<'#BAA\u0003\u000b{dABAB\u0001\u0001\tyH\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002\u0002\b\u0002i\u0011\u0001\u0005")
public interface TraitJoinQueryExec {
    public static /* synthetic */ Function1 org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition$(TraitJoinQueryExec $this) {
        return $this.org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition();
    }

    default public Function1<InternalRow, Object> org$apache$spark$sql$sedona_sql$strategy$join$TraitJoinQueryExec$$boundCondition() {
        Function1 & Serializable & scala.Serializable intersect;
        if (this.extraCondition().isDefined()) {
            BasePredicate basePredicate = Predicate$.MODULE$.create((Expression)this.extraCondition().get(), (Seq)this.left().output().$plus$plus((GenTraversableOnce)this.right().output(), Seq$.MODULE$.canBuildFrom()));
            intersect = (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)basePredicate.eval(r));
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)TraitJoinQueryExec.$anonfun$boundCondition$2(r));
        }
        return intersect;
    }

    public SparkPlan left();

    public SparkPlan right();

    public Expression leftShape();

    public Expression rightShape();

    public boolean intersects();

    public Option<Expression> extraCondition();

    public static /* synthetic */ Seq output$(TraitJoinQueryExec $this) {
        return $this.output();
    }

    default public Seq<Attribute> output() {
        return (Seq)this.left().output().$plus$plus((GenTraversableOnce)this.right().output(), Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ RDD doExecute$(TraitJoinQueryExec $this) {
        return $this.doExecute();
    }

    default public RDD<InternalRow> doExecute() {
        Expression boundLeftShape = BindReferences$.MODULE$.bindReference(this.leftShape(), package$.MODULE$.AttributeSeq(this.left().output()), BindReferences$.MODULE$.bindReference$default$3());
        Expression boundRightShape = BindReferences$.MODULE$.bindReference(this.rightShape(), package$.MODULE$.AttributeSeq(this.right().output()), BindReferences$.MODULE$.bindReference$default$3());
        RDD leftResultsRaw = this.left().execute();
        RDD rightResultsRaw = this.right().execute();
        SedonaConf sedonaConf = new SedonaConf(((SparkPlan)this).sparkContext().conf());
        Tuple2<SpatialRDD<Geometry>, SpatialRDD<Geometry>> tuple2 = this.toSpatialRddPair((RDD<UnsafeRow>)leftResultsRaw, boundLeftShape, (RDD<UnsafeRow>)rightResultsRaw, boundRightShape);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SpatialRDD leftShapes = (SpatialRDD)tuple2._1();
        SpatialRDD rightShapes = (SpatialRDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftShapes, (Object)rightShapes);
        Tuple2 tuple23 = tuple22;
        SpatialRDD leftShapes2 = (SpatialRDD)tuple23._1();
        SpatialRDD rightShapes2 = (SpatialRDD)tuple23._2();
        if (BoxesRunTime.equalsNumObject((Number)sedonaConf.getJoinApproximateTotalCount(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide2 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !((Object)((Object)joinSparitionDominantSide)).equals((Object)joinSparitionDominantSide2) : joinSparitionDominantSide2 != null)) {
                leftShapes2.analyze();
                sedonaConf.setJoinApproximateTotalCount(Predef$.MODULE$.long2Long(leftShapes2.approximateTotalCount));
                sedonaConf.setDatasetBoundary(leftShapes2.boundaryEnvelope);
            } else {
                rightShapes2.analyze();
                sedonaConf.setJoinApproximateTotalCount(Predef$.MODULE$.long2Long(rightShapes2.approximateTotalCount));
                sedonaConf.setDatasetBoundary(rightShapes2.boundaryEnvelope);
            }
        }
        ((Logging)this).log().info(new StringBuilder(46).append("[SedonaSQL] Number of partitions on the left: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftResultsRaw.partitions())).size()).toString());
        ((Logging)this).log().info(new StringBuilder(47).append("[SedonaSQL] Number of partitions on the right: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightResultsRaw.partitions())).size()).toString());
        int numPartitions = -1;
        try {
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide3 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !((Object)((Object)joinSparitionDominantSide)).equals((Object)joinSparitionDominantSide3) : joinSparitionDominantSide3 != null)) {
                numPartitions = !BoxesRunTime.equalsNumObject((Number)sedonaConf.getFallbackPartitionNum(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum()) : this.joinPartitionNumOptimizer(leftShapes2.rawSpatialRDD.partitions().size(), rightShapes2.rawSpatialRDD.partitions().size(), leftShapes2.approximateTotalCount);
                this.doSpatialPartitioning(leftShapes2, rightShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            } else {
                if (!BoxesRunTime.equalsNumObject((Number)sedonaConf.getFallbackPartitionNum(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
                    numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                } else {
                    numPartitions = rightShapes2.rawSpatialRDD.partitions().size();
                    numPartitions = this.joinPartitionNumOptimizer(rightShapes2.rawSpatialRDD.partitions().size(), leftShapes2.rawSpatialRDD.partitions().size(), rightShapes2.approximateTotalCount);
                }
                this.doSpatialPartitioning(rightShapes2, leftShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            }
        }
        catch (IllegalArgumentException e) {
            Predef$.MODULE$.print((Object)e.getMessage());
            JoinSparitionDominantSide joinSparitionDominantSide = sedonaConf.getJoinSparitionDominantSide();
            JoinSparitionDominantSide joinSparitionDominantSide4 = JoinSparitionDominantSide.LEFT;
            if (!(joinSparitionDominantSide != null ? !((Object)((Object)joinSparitionDominantSide)).equals((Object)joinSparitionDominantSide4) : joinSparitionDominantSide4 != null)) {
                numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
                this.doSpatialPartitioning(leftShapes2, rightShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
            }
            numPartitions = Predef$.MODULE$.Integer2int(sedonaConf.getFallbackPartitionNum());
            this.doSpatialPartitioning(rightShapes2, leftShapes2, Predef$.MODULE$.int2Integer(numPartitions), sedonaConf);
        }
        JoinQuery.JoinParams joinParams = new JoinQuery.JoinParams(this.intersects(), sedonaConf.getIndexType(), sedonaConf.getJoinBuildSide());
        JavaPairRDD matches = JoinQuery.spatialJoin(leftShapes2, rightShapes2, joinParams);
        ((Logging)this).logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Join result has ").append(matches.count()).append(" rows").toString());
        return matches.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Iterator iterator;
            if (this.extraCondition().isDefined()) {
                BasePredicate boundCondition = Predicate$.MODULE$.create((Expression)this.extraCondition().get(), (Seq)this.left().output().$plus$plus((GenTraversableOnce)this.right().output(), Seq$.MODULE$.canBuildFrom()));
                iterator = iter.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TraitJoinQueryExec.$anonfun$doExecute$3(this, boundCondition, x0$1)));
            } else {
                iterator = iter;
            }
            Iterator filtered = iterator;
            return filtered.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Geometry l = (Geometry)tuple2._1();
                Geometry r = (Geometry)tuple2._2();
                UnsafeRow leftRow = (UnsafeRow)l.getUserData();
                UnsafeRow rightRow = (UnsafeRow)r.getUserData();
                UnsafeRowJoiner joiner = GenerateUnsafeRowJoiner$.MODULE$.create(this.left().schema(), this.right().schema());
                UnsafeRow unsafeRow = joiner.join(leftRow, rightRow);
                return unsafeRow;
            });
        }, matches.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public static /* synthetic */ Tuple2 toSpatialRddPair$(TraitJoinQueryExec $this, RDD buildRdd, Expression buildExpr, RDD streamedRdd, Expression streamedExpr) {
        return $this.toSpatialRddPair((RDD<UnsafeRow>)buildRdd, buildExpr, (RDD<UnsafeRow>)streamedRdd, streamedExpr);
    }

    default public Tuple2<SpatialRDD<Geometry>, SpatialRDD<Geometry>> toSpatialRddPair(RDD<UnsafeRow> buildRdd, Expression buildExpr, RDD<UnsafeRow> streamedRdd, Expression streamedExpr) {
        return new Tuple2(this.toSpatialRdd(buildRdd, buildExpr), this.toSpatialRdd(streamedRdd, streamedExpr));
    }

    public static /* synthetic */ SpatialRDD toSpatialRdd$(TraitJoinQueryExec $this, RDD rdd, Expression shapeExpression) {
        return $this.toSpatialRdd((RDD<UnsafeRow>)rdd, shapeExpression);
    }

    /*
     * WARNING - void declaration
     */
    default public SpatialRDD<Geometry> toSpatialRdd(RDD<UnsafeRow> rdd, Expression shapeExpression) {
        void var3_3;
        SpatialRDD spatialRdd = new SpatialRDD();
        spatialRdd.setRawSpatialRDD(rdd.map((Function1 & Serializable & scala.Serializable)x -> {
            void var2_2;
            Geometry shape = GeometrySerializer$.MODULE$.deserialize((ArrayData)shapeExpression.eval((InternalRow)x));
            shape.setUserData(x.copy());
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class)).toJavaRDD());
        return var3_3;
    }

    public static /* synthetic */ void doSpatialPartitioning$(TraitJoinQueryExec $this, SpatialRDD dominantShapes, SpatialRDD followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        $this.doSpatialPartitioning(dominantShapes, followerShapes, numPartitions, sedonaConf);
    }

    default public void doSpatialPartitioning(SpatialRDD<Geometry> dominantShapes, SpatialRDD<Geometry> followerShapes, Integer numPartitions, SedonaConf sedonaConf) {
        dominantShapes.spatialPartitioning(sedonaConf.getJoinGridType(), Predef$.MODULE$.Integer2int(numPartitions));
        followerShapes.spatialPartitioning(dominantShapes.getPartitioner());
    }

    public static /* synthetic */ int joinPartitionNumOptimizer$(TraitJoinQueryExec $this, int dominantSidePartNum, int followerSidePartNum, long dominantSideCount) {
        return $this.joinPartitionNumOptimizer(dominantSidePartNum, followerSidePartNum, dominantSideCount);
    }

    default public int joinPartitionNumOptimizer(int dominantSidePartNum, int followerSidePartNum, long dominantSideCount) {
        ((Logging)this).log().info(new StringBuilder(33).append("[SedonaSQL] Dominant side count: ").append(dominantSideCount).toString());
        int numPartition = -1;
        int candidatePartitionNum = Predef$.MODULE$.long2Long(dominantSideCount / 2L).intValue();
        if ((long)(dominantSidePartNum * 2) > dominantSideCount) {
            ((Logging)this).log().warn(new StringBuilder(95).append("[SedonaSQL] Join dominant side partition number ").append(dominantSidePartNum).append(" is larger than 1/2 of the dominant side count ").append(dominantSideCount).toString());
            ((Logging)this).log().warn(new StringBuilder(54).append("[SedonaSQL] Try to use follower side partition number ").append(followerSidePartNum).toString());
            if ((long)(followerSidePartNum * 2) > dominantSideCount) {
                ((Logging)this).log().warn(new StringBuilder(99).append("[SedonaSQL] Join follower side partition number is also larger than 1/2 of the dominant side count ").append(dominantSideCount).toString());
                ((Logging)this).log().warn(new StringBuilder(92).append("[SedonaSQL] Try to use 1/2 of the dominant side count ").append(candidatePartitionNum).append(" as the partition number of both sides").toString());
                if (candidatePartitionNum == 0) {
                    ((Logging)this).log().warn(new StringBuilder(87).append("[SedonaSQL] 1/2 of ").append(candidatePartitionNum).append(" is equal to 0. Use 1 as the partition number of both sides instead.").toString());
                    numPartition = 1;
                } else {
                    numPartition = candidatePartitionNum;
                }
            } else {
                numPartition = followerSidePartNum;
            }
        } else {
            numPartition = dominantSidePartNum;
        }
        return numPartition;
    }

    public static /* synthetic */ boolean $anonfun$boundCondition$2(InternalRow r) {
        return true;
    }

    public static /* synthetic */ boolean $anonfun$doExecute$3(TraitJoinQueryExec $this, BasePredicate boundCondition$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Geometry l = (Geometry)tuple2._1();
        Geometry r = (Geometry)tuple2._2();
        UnsafeRow leftRow = (UnsafeRow)l.getUserData();
        UnsafeRow rightRow = (UnsafeRow)r.getUserData();
        UnsafeRowJoiner joiner = GenerateUnsafeRowJoiner$.MODULE$.create($this.left().schema(), $this.right().schema());
        boolean bl = boundCondition$1.eval((InternalRow)joiner.join(leftRow, rightRow));
        return bl;
    }

    public static void $init$(TraitJoinQueryExec $this) {
    }
}

