/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.StringFormatUtils;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.exception.JobException;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobInfo;
import org.apache.seatunnel.engine.core.job.JobResult;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.master.JobHistoryService;
import org.apache.seatunnel.engine.server.master.JobMaster;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManager;
import org.apache.seatunnel.engine.server.resourcemanager.ResourceManagerFactory;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;

public class CoordinatorService {
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private volatile ResourceManager resourceManager;
    private JobHistoryService jobHistoryService;
    private IMap<Long, JobInfo> runningJobInfoIMap;
    IMap<Object, Object> runningJobStateIMap;
    IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private Map<Long, JobMaster> runningJobMasterMap = new ConcurrentHashMap<Long, JobMaster>();
    private IMap<PipelineLocation, Map<TaskGroupLocation, SlotProfile>> ownedSlotProfilesIMap;
    private volatile boolean isActive = false;
    private final ExecutorService executorService;
    private final SeaTunnelServer seaTunnelServer;
    private final ScheduledExecutorService masterActiveListener;
    private final EngineConfig engineConfig;

    public CoordinatorService(@NonNull NodeEngineImpl nodeEngine, @NonNull SeaTunnelServer seaTunnelServer, EngineConfig engineConfig) {
        if (nodeEngine == null) {
            throw new NullPointerException("nodeEngine is marked non-null but is null");
        }
        if (seaTunnelServer == null) {
            throw new NullPointerException("seaTunnelServer is marked non-null but is null");
        }
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("seatunnel-coordinator-service-%d").build());
        this.seaTunnelServer = seaTunnelServer;
        this.engineConfig = engineConfig;
        this.masterActiveListener = Executors.newSingleThreadScheduledExecutor();
        this.masterActiveListener.scheduleAtFixedRate(this::checkNewActiveMaster, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public JobHistoryService getJobHistoryService() {
        return this.jobHistoryService;
    }

    public JobMaster getJobMaster(Long jobId) {
        return this.runningJobMasterMap.get(jobId);
    }

    private void initCoordinatorService() {
        this.runningJobInfoIMap = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobInfo");
        this.runningJobStateIMap = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobState");
        this.runningJobStateTimestampsIMap = this.nodeEngine.getHazelcastInstance().getMap("engine_stateTimestamps");
        this.ownedSlotProfilesIMap = this.nodeEngine.getHazelcastInstance().getMap("engine_ownedSlotProfilesIMap");
        this.jobHistoryService = new JobHistoryService(this.runningJobStateIMap, this.logger, this.runningJobMasterMap, this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobState"), this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobMetrics"), this.nodeEngine.getHazelcastInstance().getMap("engine_finishedJobVertexInfo"));
        List<CompletableFuture> collect2 = this.runningJobInfoIMap.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> {
            this.logger.info(String.format("begin restore job (%s) from master active switch", entry.getKey()));
            try {
                this.restoreJobFromMasterActiveSwitch((Long)entry.getKey(), (JobInfo)entry.getValue());
            }
            catch (Exception e) {
                this.logger.severe(e);
            }
            this.logger.info(String.format("restore job (%s) from master active switch finished", entry.getKey()));
        }, this.executorService)).collect(Collectors.toList());
        try {
            CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(collect2.toArray(new CompletableFuture[0]));
            voidCompletableFuture.get();
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException(e);
        }
    }

    private void restoreJobFromMasterActiveSwitch(@NonNull Long jobId, @NonNull JobInfo jobInfo) {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        if (jobInfo == null) {
            throw new NullPointerException("jobInfo is marked non-null but is null");
        }
        if (this.runningJobStateIMap.get(jobId) == null) {
            this.runningJobInfoIMap.remove(jobId);
            return;
        }
        JobStatus jobStatus = (JobStatus)((Object)this.runningJobStateIMap.get(jobId));
        JobMaster jobMaster = new JobMaster(jobInfo.getJobImmutableInformation(), this.nodeEngine, this.executorService, this.getResourceManager(), this.getJobHistoryService(), this.runningJobStateIMap, this.runningJobStateTimestampsIMap, this.ownedSlotProfilesIMap, this.runningJobInfoIMap, this.engineConfig);
        try {
            jobMaster.init(this.runningJobInfoIMap.get(jobId).getInitializationTimestamp(), true, !JobStatus.CANCELLING.equals((Object)jobStatus));
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException(String.format("Job id %s init failed", jobId), e);
        }
        String jobFullName = jobMaster.getPhysicalPlan().getJobFullName();
        if (jobStatus.isEndState()) {
            this.logger.info(String.format("The restore %s is in an end state %s, store the job info to JobHistory and clear the job running time info", new Object[]{jobFullName, jobStatus}));
            jobMaster.cleanJob();
            return;
        }
        if (jobStatus.ordinal() < JobStatus.RUNNING.ordinal()) {
            this.logger.info(String.format("The restore %s is state %s, cancel job and submit it again.", new Object[]{jobFullName, jobStatus}));
            jobMaster.cancelJob();
            jobMaster.getJobMasterCompleteFuture().join();
            this.submitJob(jobId, jobInfo.getJobImmutableInformation()).join();
            return;
        }
        this.runningJobMasterMap.put(jobId, jobMaster);
        jobMaster.markRestore();
        if (JobStatus.CANCELLING.equals((Object)jobStatus)) {
            this.logger.info(String.format("The restore %s is in %s state, cancel the job", new Object[]{jobFullName, jobStatus}));
            CompletableFuture.runAsync(() -> {
                try {
                    jobMaster.cancelJob();
                    jobMaster.run();
                }
                finally {
                    if (!jobMaster.getJobMasterCompleteFuture().isCancelled()) {
                        this.runningJobMasterMap.remove(jobId);
                    }
                }
            }, this.executorService);
            return;
        }
        if (JobStatus.RUNNING.equals((Object)jobStatus)) {
            this.logger.info(String.format("The restore %s is in %s state, restore pipeline and take over this job running", new Object[]{jobFullName, jobStatus}));
            CompletableFuture.runAsync(() -> {
                try {
                    jobMaster.getPhysicalPlan().getPipelineList().forEach(SubPlan::restorePipelineState);
                    jobMaster.run();
                }
                finally {
                    if (!jobMaster.getJobMasterCompleteFuture().isCancelled()) {
                        this.runningJobMasterMap.remove(jobId);
                    }
                }
            }, this.executorService);
        }
    }

    private void checkNewActiveMaster() {
        try {
            if (!this.isActive && this.seaTunnelServer.isMasterNode()) {
                this.logger.info("This node become a new active master node, begin init coordinator service");
                this.initCoordinatorService();
                this.isActive = true;
            } else if (this.isActive && !this.seaTunnelServer.isMasterNode()) {
                this.isActive = false;
                this.logger.info("This node become leave active master node, begin clear coordinator service");
                this.clearCoordinatorService();
            }
        }
        catch (Exception e) {
            this.isActive = false;
            this.logger.severe(ExceptionUtils.getMessage(e));
            throw new SeaTunnelEngineException("check new active master error, stop loop", e);
        }
    }

    private void clearCoordinatorService() {
        this.runningJobMasterMap.values().forEach(JobMaster::interrupt);
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new SeaTunnelEngineException("wait clean executor service error", e);
        }
        if (this.resourceManager != null) {
            this.resourceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            CoordinatorService coordinatorService = this;
            synchronized (coordinatorService) {
                if (this.resourceManager == null) {
                    ResourceManager manager = new ResourceManagerFactory(this.nodeEngine).getResourceManager();
                    manager.init();
                    this.resourceManager = manager;
                }
            }
        }
        return this.resourceManager;
    }

    public PassiveCompletableFuture<Void> submitJob(long jobId, Data jobImmutableInformation) {
        CompletableFuture jobSubmitFuture = new CompletableFuture();
        JobMaster jobMaster = new JobMaster(jobImmutableInformation, this.nodeEngine, this.executorService, this.getResourceManager(), this.getJobHistoryService(), this.runningJobStateIMap, this.runningJobStateTimestampsIMap, this.ownedSlotProfilesIMap, this.runningJobInfoIMap, this.engineConfig);
        this.executorService.submit(() -> {
            try {
                this.runningJobInfoIMap.put(jobId, new JobInfo(System.currentTimeMillis(), jobImmutableInformation));
                this.runningJobMasterMap.put(jobId, jobMaster);
                jobMaster.init(this.runningJobInfoIMap.get(jobId).getInitializationTimestamp(), false, true);
                jobSubmitFuture.complete(null);
            }
            catch (Throwable e) {
                this.logger.severe(String.format("submit job %s error %s ", jobId, ExceptionUtils.getMessage(e)));
                jobSubmitFuture.completeExceptionally(e);
            }
            if (!jobSubmitFuture.isCompletedExceptionally()) {
                try {
                    jobMaster.run();
                }
                finally {
                    if (!jobMaster.getJobMasterCompleteFuture().isCancelled()) {
                        this.runningJobMasterMap.remove(jobId);
                    }
                }
            } else {
                this.runningJobInfoIMap.remove(jobId);
                this.runningJobMasterMap.remove(jobId);
            }
        });
        return new PassiveCompletableFuture<Void>(jobSubmitFuture);
    }

    public PassiveCompletableFuture<Void> savePoint(long jobId) {
        CompletableFuture<Object> voidCompletableFuture = new CompletableFuture();
        if (!this.runningJobMasterMap.containsKey(jobId)) {
            Throwable throwable = new Throwable("The jobId: " + jobId + "of savePoint does not exist");
            this.logger.warning(throwable);
            voidCompletableFuture.completeExceptionally(throwable);
        } else {
            JobMaster jobMaster = this.runningJobMasterMap.get(jobId);
            voidCompletableFuture = jobMaster.savePoint();
        }
        return new PassiveCompletableFuture<Void>(voidCompletableFuture);
    }

    public PassiveCompletableFuture<JobResult> waitForJobComplete(long jobId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jobId);
        if (runningJobMaster == null) {
            JobStatus jobStatus = this.jobHistoryService.getJobDetailState(jobId).getJobStatus();
            CompletableFuture<JobResult> future = new CompletableFuture<JobResult>();
            future.complete(new JobResult(jobStatus, null));
            return new PassiveCompletableFuture<JobResult>(future);
        }
        return new PassiveCompletableFuture<JobResult>(runningJobMaster.getJobMasterCompleteFuture());
    }

    public PassiveCompletableFuture<Void> cancelJob(long jodId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jodId);
        if (runningJobMaster == null) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.complete(null);
            return new PassiveCompletableFuture<Void>(future);
        }
        return new PassiveCompletableFuture<Void>(CompletableFuture.supplyAsync(() -> {
            runningJobMaster.cancelJob();
            return null;
        }, this.executorService));
    }

    public JobStatus getJobStatus(long jobId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jobId);
        if (runningJobMaster == null) {
            JobHistoryService.JobState jobDetailState = this.jobHistoryService.getJobDetailState(jobId);
            return null == jobDetailState ? null : jobDetailState.getJobStatus();
        }
        return runningJobMaster.getJobStatus();
    }

    public JobMetrics getJobMetrics(long jobId) {
        JobMaster runningJobMaster = this.runningJobMasterMap.get(jobId);
        if (runningJobMaster == null) {
            return this.jobHistoryService.getJobMetrics(jobId);
        }
        JobMetrics jobMetrics = JobMetricsUtil.toJobMetrics(runningJobMaster.getCurrJobMetrics());
        JobMetrics jobMetricsImap = this.jobHistoryService.getJobMetrics(jobId);
        return jobMetricsImap != null ? jobMetricsImap.merge(jobMetrics) : jobMetrics;
    }

    public JobDAGInfo getJobInfo(long jobId) {
        JobDAGInfo jobInfo = this.jobHistoryService.getJobDAGInfo(jobId);
        if (jobInfo != null) {
            return jobInfo;
        }
        return this.runningJobMasterMap.get(jobId).getJobDAGInfo();
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        TaskGroupLocation taskGroupLocation = taskExecutionState.getTaskGroupLocation();
        JobMaster runningJobMaster = this.runningJobMasterMap.get(taskGroupLocation.getJobId());
        if (runningJobMaster == null) {
            throw new JobException(String.format("Job %s not running", taskGroupLocation.getJobId()));
        }
        runningJobMaster.updateTaskExecutionState(taskExecutionState);
    }

    public void shutdown() {
        if (this.masterActiveListener != null) {
            this.masterActiveListener.shutdownNow();
        }
        this.clearCoordinatorService();
    }

    public boolean isCoordinatorActive() {
        return this.isActive;
    }

    public void failedTaskOnMemberRemoved(MembershipServiceEvent event) {
        Address lostAddress = event.getMember().getAddress();
        this.runningJobMasterMap.forEach((aLong, jobMaster) -> jobMaster.getPhysicalPlan().getPipelineList().forEach(subPlan -> {
            this.makeTasksFailed(subPlan.getCoordinatorVertexList(), lostAddress);
            this.makeTasksFailed(subPlan.getPhysicalVertexList(), lostAddress);
        }));
    }

    private void makeTasksFailed(@NonNull List<PhysicalVertex> physicalVertexList, @NonNull Address lostAddress) {
        if (physicalVertexList == null) {
            throw new NullPointerException("physicalVertexList is marked non-null but is null");
        }
        if (lostAddress == null) {
            throw new NullPointerException("lostAddress is marked non-null but is null");
        }
        physicalVertexList.forEach(physicalVertex -> {
            Address deployAddress = physicalVertex.getCurrentExecutionAddress();
            ExecutionState executionState = physicalVertex.getExecutionState();
            if (null != deployAddress && deployAddress.equals(lostAddress) && (executionState.equals(ExecutionState.DEPLOYING) || executionState.equals(ExecutionState.RUNNING) || executionState.equals(ExecutionState.CANCELING))) {
                TaskGroupLocation taskGroupLocation = physicalVertex.getTaskGroupLocation();
                physicalVertex.updateTaskExecutionState(new TaskExecutionState(taskGroupLocation, ExecutionState.FAILED, new JobException(String.format("The taskGroup(%s) deployed node(%s) offline", taskGroupLocation, lostAddress))));
            }
        });
    }

    public void memberRemoved(MembershipServiceEvent event) {
        if (this.isCoordinatorActive()) {
            this.getResourceManager().memberRemoved(event);
        }
        this.failedTaskOnMemberRemoved(event);
    }

    public void printExecutionInfo() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executorService;
        int activeCount = threadPoolExecutor.getActiveCount();
        int corePoolSize = threadPoolExecutor.getCorePoolSize();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        int poolSize = threadPoolExecutor.getPoolSize();
        long completedTaskCount = threadPoolExecutor.getCompletedTaskCount();
        long taskCount = threadPoolExecutor.getTaskCount();
        this.logger.info(StringFormatUtils.formatTable("CoordinatorService Thread Pool Status", "activeCount", activeCount, "corePoolSize", corePoolSize, "maximumPoolSize", maximumPoolSize, "poolSize", poolSize, "completedTaskCount", completedTaskCount, "taskCount", taskCount));
    }

    public void printJobDetailInfo() {
        AtomicLong createdJobCount = new AtomicLong();
        AtomicLong scheduledJobCount = new AtomicLong();
        AtomicLong runningJobCount = new AtomicLong();
        AtomicLong failingJobCount = new AtomicLong();
        AtomicLong failedJobCount = new AtomicLong();
        AtomicLong cancellingJobCount = new AtomicLong();
        AtomicLong canceledJobCount = new AtomicLong();
        AtomicLong finishedJobCount = new AtomicLong();
        AtomicLong restartingJobCount = new AtomicLong();
        AtomicLong suspendedJobCount = new AtomicLong();
        AtomicLong reconcilingJobCount = new AtomicLong();
        if (this.runningJobInfoIMap != null) {
            this.runningJobInfoIMap.keySet().forEach(jobId -> {
                if (this.runningJobStateIMap.get(jobId) != null) {
                    JobStatus jobStatus = (JobStatus)((Object)((Object)this.runningJobStateIMap.get(jobId)));
                    switch (jobStatus) {
                        case CREATED: {
                            createdJobCount.addAndGet(1L);
                            break;
                        }
                        case SCHEDULED: {
                            scheduledJobCount.addAndGet(1L);
                            break;
                        }
                        case RUNNING: {
                            runningJobCount.addAndGet(1L);
                            break;
                        }
                        case FAILING: {
                            failingJobCount.addAndGet(1L);
                            break;
                        }
                        case FAILED: {
                            failedJobCount.addAndGet(1L);
                            break;
                        }
                        case CANCELLING: {
                            cancellingJobCount.addAndGet(1L);
                            break;
                        }
                        case CANCELED: {
                            canceledJobCount.addAndGet(1L);
                            break;
                        }
                        case FINISHED: {
                            finishedJobCount.addAndGet(1L);
                            break;
                        }
                        case RESTARTING: {
                            restartingJobCount.addAndGet(1L);
                            break;
                        }
                        case SUSPENDED: {
                            suspendedJobCount.addAndGet(1L);
                            break;
                        }
                        case RECONCILING: {
                            reconcilingJobCount.addAndGet(1L);
                            break;
                        }
                    }
                }
            });
        }
        this.logger.info(StringFormatUtils.formatTable("Job info detail", "createdJobCount", createdJobCount, "scheduledJobCount", scheduledJobCount, "runningJobCount", runningJobCount, "failingJobCount", failingJobCount, "failedJobCount", failedJobCount, "cancellingJobCount", cancellingJobCount, "canceledJobCount", canceledJobCount, "finishedJobCount", finishedJobCount, "restartingJobCount", restartingJobCount, "suspendedJobCount", suspendedJobCount, "reconcilingJobCount", reconcilingJobCount));
    }
}

