/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.sql.impl.NodeServiceProvider;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.state.QueryClientStateRegistry;
import com.hazelcast.sql.impl.state.QueryResultRegistry;
import com.hazelcast.sql.impl.state.QueryStateRegistryUpdater;

public class SqlInternalService {
    public static final String SERVICE_NAME = "hz:impl:sqlService";
    private final QueryResultRegistry resultRegistry;
    private final QueryClientStateRegistry clientStateRegistry;
    private final QueryStateRegistryUpdater stateRegistryUpdater;

    public SqlInternalService(QueryResultRegistry resultRegistry, String instanceName, NodeServiceProvider nodeServiceProvider, long stateCheckFrequency, PlanCacheChecker planCacheChecker) {
        this.resultRegistry = resultRegistry;
        this.clientStateRegistry = new QueryClientStateRegistry();
        this.stateRegistryUpdater = new QueryStateRegistryUpdater(instanceName, nodeServiceProvider, this.clientStateRegistry, planCacheChecker, stateCheckFrequency);
    }

    public void start() {
        this.stateRegistryUpdater.start();
    }

    public void shutdown() {
        this.stateRegistryUpdater.shutdown();
        this.resultRegistry.shutdown();
        this.clientStateRegistry.shutdown();
    }

    public QueryResultRegistry getResultRegistry() {
        return this.resultRegistry;
    }

    public QueryClientStateRegistry getClientStateRegistry() {
        return this.clientStateRegistry;
    }

    public QueryStateRegistryUpdater getStateRegistryUpdater() {
        return this.stateRegistryUpdater;
    }
}

