/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.cp;

import com.hazelcast.internal.util.Preconditions;

public class SemaphoreConfig {
    public static final boolean DEFAULT_SEMAPHORE_JDK_COMPATIBILITY = false;
    public static final int DEFAULT_INITIAL_PERMITS = 0;
    private String name;
    private boolean jdkCompatible = false;
    private int initialPermits = 0;

    public SemaphoreConfig() {
    }

    public SemaphoreConfig(String name) {
        this.name = name;
    }

    public SemaphoreConfig(String name, boolean jdkCompatible, int initialPermits) {
        this.name = name;
        this.jdkCompatible = jdkCompatible;
        this.initialPermits = initialPermits;
    }

    SemaphoreConfig(SemaphoreConfig config) {
        this.name = config.name;
        this.jdkCompatible = config.jdkCompatible;
        this.initialPermits = config.initialPermits;
    }

    public String getName() {
        return this.name;
    }

    public SemaphoreConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isJDKCompatible() {
        return this.jdkCompatible;
    }

    public SemaphoreConfig setJDKCompatible(boolean jdkCompatible) {
        this.jdkCompatible = jdkCompatible;
        return this;
    }

    public int getInitialPermits() {
        return this.initialPermits;
    }

    public SemaphoreConfig setInitialPermits(int initialPermits) {
        Preconditions.checkNotNegative(initialPermits, "initial permits cannot be negative");
        this.initialPermits = initialPermits;
        return this;
    }

    public String toString() {
        return "SemaphoreConfig{name='" + this.name + '\'' + ", jdkCompatible=" + this.jdkCompatible + ", initialPermits=" + this.initialPermits + '}';
    }
}

