/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.structuredstream;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.apis.base.env.Execution;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.spark.BaseSparkTransform;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.spark.structuredstream.StructuredStreamingSink;
import org.apache.seatunnel.spark.structuredstream.StructuredStreamingSource;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class StructuredStreamingExecution
implements Execution<StructuredStreamingSource, BaseSparkTransform, StructuredStreamingSink, SparkEnvironment> {
    private final SparkEnvironment sparkEnvironment;
    private Config config = ConfigFactory.empty();

    public StructuredStreamingExecution(SparkEnvironment sparkEnvironment) {
        this.sparkEnvironment = sparkEnvironment;
    }

    @Override
    public void start(List<StructuredStreamingSource> sources, List<BaseSparkTransform> transforms, List<StructuredStreamingSink> sinks) throws Exception {
        List datasetList = sources.stream().map(s2 -> SparkEnvironment.registerInputTempView(s2, this.sparkEnvironment)).collect(Collectors.toList());
        if (datasetList.size() > 0) {
            Dataset<Row> ds = (Dataset<Row>)datasetList.get(0);
            for (BaseSparkTransform tf : transforms) {
                ds = SparkEnvironment.transformProcess(this.sparkEnvironment, tf, ds);
                SparkEnvironment.registerTransformTempView(tf, ds);
            }
            for (StructuredStreamingSink sink : sinks) {
                SparkEnvironment.sinkProcess(this.sparkEnvironment, sink, ds).start();
            }
            this.sparkEnvironment.getSparkSession().streams().awaitAnyTermination();
        }
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }
}

