/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.schema.SeaTunnelSchema;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeDataGenerator;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeSourceReader
implements SourceReader<SeaTunnelRow, FakeSourceSplit> {
    private static final Logger log = LoggerFactory.getLogger(FakeSourceReader.class);
    private final SourceReader.Context context;
    private final Deque<FakeSourceSplit> splits = new LinkedList<FakeSourceSplit>();
    private final FakeConfig config;
    private final FakeDataGenerator fakeDataGenerator;
    private volatile boolean noMoreSplit;
    private volatile long latestTimestamp = 0L;

    public FakeSourceReader(SourceReader.Context context, SeaTunnelSchema schema, FakeConfig fakeConfig) {
        this.context = context;
        this.config = fakeConfig;
        this.fakeDataGenerator = new FakeDataGenerator(schema, fakeConfig);
    }

    public void open() {
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNext(Collector<SeaTunnelRow> output) throws InterruptedException {
        long currentTimestamp = Instant.now().toEpochMilli();
        if (currentTimestamp <= this.latestTimestamp + (long)this.config.getSplitReadInterval()) {
            return;
        }
        this.latestTimestamp = currentTimestamp;
        Object object = output.getCheckpointLock();
        synchronized (object) {
            FakeSourceSplit split = this.splits.poll();
            if (null != split) {
                List<SeaTunnelRow> seaTunnelRows = this.fakeDataGenerator.generateFakedRows(split.getRowNum());
                for (SeaTunnelRow seaTunnelRow : seaTunnelRows) {
                    output.collect((Object)seaTunnelRow);
                }
                log.info("{} rows of data have been generated in split({}). Generation time: {}", new Object[]{split.getRowNum(), split.splitId(), this.latestTimestamp});
            } else if (!this.noMoreSplit) {
                log.info("wait split!");
            }
        }
        if (this.splits.isEmpty() && this.noMoreSplit && Boundedness.BOUNDED.equals((Object)this.context.getBoundedness())) {
            log.info("Closed the bounded fake source");
            this.context.signalNoMoreElement();
        }
        Thread.sleep(1000L);
    }

    public List<FakeSourceSplit> snapshotState(long checkpointId) throws Exception {
        return new ArrayList<FakeSourceSplit>(this.splits);
    }

    public void addSplits(List<FakeSourceSplit> splits) {
        this.splits.addAll(splits);
    }

    public void handleNoMoreSplits() {
        this.noMoreSplit = true;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

