/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.dag.physical.SubPlan;
import org.apache.seatunnel.engine.server.dag.physical.UnknownPhysicalPlanException;
import org.apache.seatunnel.engine.server.master.JobMaster;

public class PhysicalPlan {
    private static final ILogger LOGGER = Logger.getLogger(PhysicalPlan.class);
    public static final int PIPELINE_MAX_RESTORE_NUM = 3;
    private final List<SubPlan> pipelineList;
    private AtomicInteger finishedPipelineNum = new AtomicInteger(0);
    private AtomicInteger canceledPipelineNum = new AtomicInteger(0);
    private AtomicInteger failedPipelineNum = new AtomicInteger(0);
    private final JobImmutableInformation jobImmutableInformation;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private CompletableFuture<JobStatus> jobEndFuture;
    private final String jobFullName;
    private final long jobId;
    private JobMaster jobMaster;
    private volatile boolean needRestore = true;
    private boolean makeJobEndWhenPipelineEnded = true;

    public PhysicalPlan(@NonNull List<SubPlan> pipelineList, @NonNull ExecutorService executorService, @NonNull JobImmutableInformation jobImmutableInformation, long initializationTimestamp, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap) {
        if (pipelineList == null) {
            throw new NullPointerException("pipelineList is marked @NonNull but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked @NonNull but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked @NonNull but is null");
        }
        this.jobImmutableInformation = jobImmutableInformation;
        this.jobId = jobImmutableInformation.getJobId();
        Long[] stateTimestamps = new Long[JobStatus.values().length];
        if (runningJobStateTimestampsIMap.get(this.jobId) == null) {
            stateTimestamps[JobStatus.INITIALIZING.ordinal()] = initializationTimestamp;
            runningJobStateTimestampsIMap.put(this.jobId, stateTimestamps);
        }
        if (runningJobStateIMap.get(this.jobId) == null) {
            stateTimestamps[JobStatus.CREATED.ordinal()] = System.currentTimeMillis();
            runningJobStateTimestampsIMap.put(this.jobId, stateTimestamps);
            runningJobStateIMap.put(this.jobId, JobStatus.CREATED);
        }
        this.pipelineList = pipelineList;
        if (pipelineList.isEmpty()) {
            throw new UnknownPhysicalPlanException("The physical plan didn't have any can execute pipeline");
        }
        this.jobFullName = String.format("Job %s (%s)", jobImmutableInformation.getJobConfig().getName(), jobImmutableInformation.getJobId());
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
    }

    public void setJobMaster(JobMaster jobMaster) {
        this.jobMaster = jobMaster;
        this.pipelineList.forEach(pipeline -> pipeline.setJobMaster(jobMaster));
    }

    public PassiveCompletableFuture<JobStatus> initStateFuture() {
        this.jobEndFuture = new CompletableFuture();
        this.pipelineList.forEach(this::addPipelineEndCallback);
        return new PassiveCompletableFuture<JobStatus>(this.jobEndFuture);
    }

    public void addPipelineEndCallback(SubPlan subPlan) {
        PassiveCompletableFuture<PipelineStatus> future = subPlan.initStateFuture();
        future.thenAcceptAsync(pipelineState -> {
            try {
                this.jobMaster.getCheckpointManager().listenPipelineRetry(subPlan.getPipelineLocation().getPipelineId(), subPlan.getPipelineState()).join();
                if (PipelineStatus.CANCELED.equals(pipelineState)) {
                    if (this.canRestorePipeline(subPlan)) {
                        subPlan.restorePipeline();
                        return;
                    }
                    this.canceledPipelineNum.incrementAndGet();
                    if (this.makeJobEndWhenPipelineEnded) {
                        LOGGER.info(String.format("cancel job %s because makeJobEndWhenPipelineEnded is true", this.jobFullName));
                        this.cancelJob();
                    }
                    LOGGER.info(String.format("release the pipeline %s resource", subPlan.getPipelineFullName()));
                    this.jobMaster.releasePipelineResource(subPlan);
                } else if (PipelineStatus.FAILED.equals(pipelineState)) {
                    if (this.canRestorePipeline(subPlan)) {
                        subPlan.restorePipeline();
                        return;
                    }
                    this.failedPipelineNum.incrementAndGet();
                    if (this.makeJobEndWhenPipelineEnded) {
                        this.cancelJob();
                    }
                    this.jobMaster.releasePipelineResource(subPlan);
                    LOGGER.severe("Pipeline Failed, Begin to cancel other pipelines in this job.");
                }
                this.notifyCheckpointManagerPipelineEnd(subPlan);
                if (this.finishedPipelineNum.incrementAndGet() == this.pipelineList.size()) {
                    if (this.failedPipelineNum.get() > 0) {
                        this.updateJobState(JobStatus.FAILING);
                    } else if (this.canceledPipelineNum.get() > 0) {
                        this.turnToEndState(JobStatus.CANCELED);
                    } else {
                        this.turnToEndState(JobStatus.FINISHED);
                    }
                    this.jobEndFuture.complete((JobStatus)((Object)((Object)this.runningJobStateIMap.get(this.jobId))));
                }
            }
            catch (Throwable e) {
                LOGGER.severe("Never come here ", e);
            }
        });
    }

    private void notifyCheckpointManagerPipelineEnd(@NonNull SubPlan subPlan) {
        if (subPlan == null) {
            throw new NullPointerException("subPlan is marked @NonNull but is null");
        }
        this.jobMaster.getCheckpointManager().listenPipeline(subPlan.getPipelineLocation().getPipelineId(), subPlan.getPipelineState()).join();
    }

    private boolean canRestorePipeline(SubPlan subPlan) {
        return this.needRestore && subPlan.getPipelineRestoreNum() < 3;
    }

    public void cancelJob() {
        if (this.getJobStatus().isEndState()) {
            LOGGER.warning(String.format("%s is in end state %s, can not be cancel", new Object[]{this.jobFullName, this.getJobStatus()}));
            return;
        }
        if (JobStatus.CANCELLING.equals((Object)this.getJobStatus())) {
            this.cancelJobPipelines();
            return;
        }
        this.updateJobState((JobStatus)((Object)this.runningJobStateIMap.get(this.jobId)), JobStatus.CANCELLING);
        this.cancelJobPipelines();
    }

    private void cancelJobPipelines() {
        List<CompletableFuture> collect2 = this.pipelineList.stream().map(pipeline -> CompletableFuture.runAsync(pipeline::cancelPipeline)).collect(Collectors.toList());
        try {
            CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(collect2.toArray(new CompletableFuture[0]));
            voidCompletableFuture.join();
        }
        catch (Exception e) {
            LOGGER.severe(String.format("%s cancel error with exception: %s", this.jobFullName, ExceptionUtils.getMessage(e)));
        }
    }

    public List<SubPlan> getPipelineList() {
        return this.pipelineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnToEndState(@NonNull JobStatus endState) {
        if (endState == null) {
            throw new NullPointerException("endState is marked @NonNull but is null");
        }
        PhysicalPlan physicalPlan = this;
        synchronized (physicalPlan) {
            JobStatus current = (JobStatus)((Object)this.runningJobStateIMap.get(this.jobId));
            if (current.isEndState()) {
                String message = "Job is trying to leave terminal state " + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (!endState.isEndState()) {
                String message = "Need a end state, not " + (Object)((Object)endState);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            this.jobMaster.getCheckpointManager().shutdown(endState);
            LOGGER.info(String.format("%s end with state %s", new Object[]{this.getJobFullName(), endState}));
            this.updateStateTimestamps(endState);
            this.runningJobStateIMap.put(this.jobId, (Object)endState);
        }
    }

    private void updateStateTimestamps(@NonNull JobStatus targetState) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        Long[] stateTimestamps = this.runningJobStateTimestampsIMap.get(this.jobId);
        stateTimestamps[targetState.ordinal()] = System.currentTimeMillis();
        this.runningJobStateTimestampsIMap.set(this.jobId, stateTimestamps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateJobState(@NonNull JobStatus targetState) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        PhysicalPlan physicalPlan = this;
        synchronized (physicalPlan) {
            return this.updateJobState((JobStatus)((Object)this.runningJobStateIMap.get(this.jobId)), targetState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateJobState(@NonNull JobStatus current, @NonNull JobStatus targetState) {
        if (current == null) {
            throw new NullPointerException("current is marked @NonNull but is null");
        }
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        PhysicalPlan physicalPlan = this;
        synchronized (physicalPlan) {
            if (current.isEndState()) {
                String message = "Job is trying to leave terminal state " + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (current.equals(this.runningJobStateIMap.get(this.jobId))) {
                LOGGER.info(String.format("Job %s (%s) turn from state %s to %s.", new Object[]{this.jobImmutableInformation.getJobConfig().getName(), this.jobId, current, targetState}));
                this.updateStateTimestamps(targetState);
                this.runningJobStateIMap.set(this.jobId, (Object)targetState);
                return true;
            }
            return false;
        }
    }

    public JobImmutableInformation getJobImmutableInformation() {
        return this.jobImmutableInformation;
    }

    public JobStatus getJobStatus() {
        return (JobStatus)((Object)this.runningJobStateIMap.get(this.jobId));
    }

    public String getJobFullName() {
        return this.jobFullName;
    }

    public void neverNeedRestore() {
        this.needRestore = false;
    }
}

