/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.serializable;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import org.apache.seatunnel.engine.core.dag.logical.LogicalDag;
import org.apache.seatunnel.engine.core.dag.logical.LogicalEdge;
import org.apache.seatunnel.engine.core.dag.logical.LogicalVertex;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.JobInfo;

@PrivateApi
public final class JobDataSerializerHook
implements DataSerializerHook {
    public static final int LOGICAL_DAG = 0;
    public static final int LOGICAL_VERTEX = 1;
    public static final int LOGICAL_EDGE = 2;
    public static final int JOB_IMMUTABLE_INFORMATION = 3;
    public static final int JOB_INFO = 4;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.seatunnel.engine.job", -30002);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new LogicalDag();
                }
                case 1: {
                    return new LogicalVertex();
                }
                case 2: {
                    return new LogicalEdge();
                }
                case 3: {
                    return new JobImmutableInformation();
                }
                case 4: {
                    return new JobInfo();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

