/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.seatunnel.command;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import java.nio.file.Path;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.apache.seatunnel.core.starter.command.Command;
import org.apache.seatunnel.core.starter.exception.CommandExecuteException;
import org.apache.seatunnel.core.starter.seatunnel.args.ClientCommandArgs;
import org.apache.seatunnel.core.starter.utils.FileUtils;
import org.apache.seatunnel.engine.client.SeaTunnelClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.JobExecutionEnvironment;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.runtime.ExecutionMode;
import org.apache.seatunnel.engine.server.SeaTunnelNodeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExecuteCommand
implements Command<ClientCommandArgs> {
    private static final Logger log = LoggerFactory.getLogger(ClientExecuteCommand.class);
    private final ClientCommandArgs clientCommandArgs;

    public ClientExecuteCommand(ClientCommandArgs clientCommandArgs) {
        this.clientCommandArgs = clientCommandArgs;
    }

    @Override
    public void execute() throws CommandExecuteException {
        HazelcastInstance instance = null;
        SeaTunnelClient engineClient = null;
        SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
        try {
            String clusterName = this.clientCommandArgs.getClusterName();
            if (this.clientCommandArgs.getExecutionMode().equals((Object)ExecutionMode.LOCAL)) {
                clusterName = this.creatRandomClusterName(clusterName);
                instance = this.createServerInLocal(clusterName);
            }
            seaTunnelConfig.getHazelcastConfig().setClusterName(clusterName);
            ClientConfig clientConfig = ConfigProvider.locateAndGetClientConfig();
            clientConfig.setClusterName(clusterName);
            engineClient = new SeaTunnelClient(clientConfig);
            if (this.clientCommandArgs.isListJob()) {
                String jobstatus = engineClient.listJobStatus();
                System.out.println(jobstatus);
            } else if (null != this.clientCommandArgs.getJobId()) {
                String jobState = engineClient.getJobDetailStatus(Long.parseLong(this.clientCommandArgs.getJobId()));
                System.out.println(jobState);
            } else if (null != this.clientCommandArgs.getCancelJobId()) {
                engineClient.cancelJob(Long.parseLong(this.clientCommandArgs.getCancelJobId()));
            } else if (null != this.clientCommandArgs.getMetricsJobId()) {
                String jobMetrics = engineClient.getJobMetrics(Long.parseLong(this.clientCommandArgs.getMetricsJobId()));
                System.out.println(jobMetrics);
            } else {
                Path configFile = FileUtils.getConfigPath(this.clientCommandArgs);
                FileUtils.checkConfigExist(configFile);
                JobConfig jobConfig = new JobConfig();
                jobConfig.setName(this.clientCommandArgs.getJobName());
                JobExecutionEnvironment jobExecutionEnv = engineClient.createExecutionContext(configFile.toString(), jobConfig);
                ClientJobProxy clientJobProxy = jobExecutionEnv.execute();
                clientJobProxy.waitForJobComplete();
                long jobId = clientJobProxy.getJobId();
                System.out.println(engineClient.getJobMetrics(jobId));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CommandExecuteException("SeaTunnel job executed failed", e);
        }
        finally {
            if (engineClient != null) {
                engineClient.close();
            }
            if (instance != null) {
                instance.shutdown();
            }
        }
    }

    private HazelcastInstance createServerInLocal(String clusterName) {
        SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
        seaTunnelConfig.getHazelcastConfig().setClusterName(clusterName);
        return HazelcastInstanceFactory.newHazelcastInstance(seaTunnelConfig.getHazelcastConfig(), Thread.currentThread().getName(), new SeaTunnelNodeContext(seaTunnelConfig));
    }

    private String creatRandomClusterName(String namePrefix) {
        Random random = new Random();
        return namePrefix + "-" + random.nextInt(1000000);
    }
}

