/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteArrayInput;
import io.protostuff.CodedInput;
import io.protostuff.IOUtil;
import io.protostuff.Input;
import io.protostuff.LimitedInputStream;
import io.protostuff.LinkedBuffer;
import io.protostuff.Pipe;
import io.protostuff.ProtobufException;
import io.protostuff.ProtobufOutput;
import io.protostuff.Schema;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class ProtobufIOUtil {
    private ProtobufIOUtil() {
    }

    public static Pipe newPipe(byte[] data) {
        return ProtobufIOUtil.newPipe(data, 0, data.length);
    }

    public static Pipe newPipe(byte[] data, int offset, int len) {
        final ByteArrayInput byteArrayInput = new ByteArrayInput(data, offset, len, false);
        return new Pipe(){

            @Override
            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return byteArrayInput;
            }

            @Override
            protected void end(Pipe.Schema<?> pipeSchema, Input input2, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                assert (input2 == byteArrayInput);
            }
        };
    }

    public static Pipe newPipe(InputStream in) {
        final CodedInput codedInput = new CodedInput(in, false);
        return new Pipe(){

            @Override
            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return codedInput;
            }

            @Override
            protected void end(Pipe.Schema<?> pipeSchema, Input input2, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                assert (input2 == codedInput);
            }
        };
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema) {
        IOUtil.mergeFrom(data, 0, data.length, message, schema, false);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema) {
        IOUtil.mergeFrom(data, offset, length, message, schema, false);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        IOUtil.mergeFrom(in, message, schema, false);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        IOUtil.mergeFrom(in, buffer.buffer, message, schema, false);
    }

    public static <T> int mergeDelimitedFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        return IOUtil.mergeDelimitedFrom(in, message, schema, false);
    }

    public static <T> int mergeDelimitedFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        return IOUtil.mergeDelimitedFrom(in, buffer.buffer, message, schema, false);
    }

    public static <T> int mergeDelimitedFrom(DataInput in, T message, Schema<T> schema) throws IOException {
        return IOUtil.mergeDelimitedFrom(in, message, schema, false);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        try {
            schema.writeTo(output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> int writeTo(LinkedBuffer buffer, T message, Schema<T> schema) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        try {
            schema.writeTo(output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a LinkedBuffer threw an IOException (should never happen).", e);
        }
        return output.getSize();
    }

    public static <T> int writeTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        schema.writeTo(output, message);
        return LinkedBuffer.writeTo(out, buffer);
    }

    public static <T> int writeDelimitedTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        schema.writeTo(output, message);
        int size2 = output.getSize();
        ProtobufOutput.writeRawVarInt32Bytes(out, size2);
        int msgSize = LinkedBuffer.writeTo(out, buffer);
        assert (size2 == msgSize);
        return size2;
    }

    public static <T> int writeDelimitedTo(DataOutput out, T message, Schema<T> schema) throws IOException {
        LinkedBuffer buffer = new LinkedBuffer(256);
        ProtobufOutput output = new ProtobufOutput(buffer);
        schema.writeTo(output, message);
        int size2 = output.getSize();
        ProtobufOutput.writeRawVarInt32Bytes(out, size2);
        int msgSize = LinkedBuffer.writeTo(out, buffer);
        assert (size2 == msgSize);
        return size2;
    }

    public static <T> int writeListTo(OutputStream out, List<T> messages, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        int totalSize = 0;
        for (T m : messages) {
            schema.writeTo(output, m);
            int size2 = output.getSize();
            ProtobufOutput.writeRawVarInt32Bytes(out, size2);
            int msgSize = LinkedBuffer.writeTo(out, buffer);
            assert (size2 == msgSize);
            totalSize += size2;
            output.clear();
        }
        return totalSize;
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        byte[] buf = null;
        int biggestLen = 0;
        LimitedInputStream lin = null;
        int size2 = in.read();
        while (size2 != -1) {
            int len;
            T message = schema.newMessage();
            list.add(message);
            int n = len = size2 < 128 ? size2 : CodedInput.readRawVarint32(in, size2);
            if (len != 0) {
                Input input2;
                if (len > 4096) {
                    if (lin == null) {
                        lin = new LimitedInputStream(in);
                    }
                    input2 = new CodedInput(lin.limit(len), false);
                    schema.mergeFrom(input2, message);
                    ((CodedInput)input2).checkLastTagWas(0);
                } else {
                    if (biggestLen < len) {
                        buf = new byte[len];
                        biggestLen = len;
                    }
                    IOUtil.fillBufferFrom(in, buf, 0, len);
                    input2 = new ByteArrayInput(buf, 0, len, false);
                    try {
                        schema.mergeFrom(input2, message);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ProtobufException.truncatedMessage(e);
                    }
                    ((ByteArrayInput)input2).checkLastTagWas(0);
                }
            }
            size2 = in.read();
        }
        return list;
    }

    public static <T> boolean optMergeDelimitedFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        return ProtobufIOUtil.optMergeDelimitedFrom(in, message, schema, true, buffer);
    }

    public static <T> boolean optMergeDelimitedFrom(InputStream in, T message, Schema<T> schema, boolean drainRemainingBytesIfTooLarge, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        int size2 = IOUtil.fillBufferWithDelimitedMessageFrom(in, drainRemainingBytesIfTooLarge, buffer);
        if (size2 == 0) {
            return true;
        }
        if (buffer.start == buffer.offset) {
            return false;
        }
        ByteArrayInput input2 = new ByteArrayInput(buffer.buffer, buffer.offset, size2, false);
        try {
            schema.mergeFrom(input2, message);
            input2.checkLastTagWas(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ProtobufException.truncatedMessage(e);
        }
        finally {
            buffer.offset = buffer.start;
        }
        return true;
    }

    public static <T> int optWriteDelimitedTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        buffer.offset = buffer.start + 5;
        output.size += 5;
        schema.writeTo(output, message);
        int size2 = output.size - 5;
        int delimOffset = IOUtil.putVarInt32AndGetOffset(size2, buffer.buffer, buffer.start);
        out.write(buffer.buffer, delimOffset, buffer.offset - delimOffset);
        if (buffer.next != null) {
            LinkedBuffer.writeTo(out, buffer.next);
        }
        return size2;
    }
}

