/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.JetConfigDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class EdgeConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    public static final int DEFAULT_RECEIVE_WINDOW_MULTIPLIER = 3;
    public static final int DEFAULT_PACKET_SIZE_LIMIT = 16384;
    private int queueSize = 1024;
    private int receiveWindowMultiplier = 3;
    private int packetSizeLimit = 16384;

    public EdgeConfig setQueueSize(int queueSize) {
        Preconditions.checkPositive(queueSize, "queueSize should be a positive number");
        this.queueSize = queueSize;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public EdgeConfig setReceiveWindowMultiplier(int receiveWindowMultiplier) {
        Preconditions.checkPositive(receiveWindowMultiplier, "receiveWindowMultiplier should be a positive number");
        this.receiveWindowMultiplier = receiveWindowMultiplier;
        return this;
    }

    public int getReceiveWindowMultiplier() {
        return this.receiveWindowMultiplier;
    }

    public EdgeConfig setPacketSizeLimit(int packetSizeLimit) {
        Preconditions.checkPositive(packetSizeLimit, "packetSizeLimit should be a positive number");
        this.packetSizeLimit = packetSizeLimit;
        return this;
    }

    public int getPacketSizeLimit() {
        return this.packetSizeLimit;
    }

    @Override
    public int getFactoryId() {
        return JetConfigDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.queueSize);
        out.writeInt(this.receiveWindowMultiplier);
        out.writeInt(this.packetSizeLimit);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.queueSize = in.readInt();
        this.receiveWindowMultiplier = in.readInt();
        this.packetSizeLimit = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeConfig that = (EdgeConfig)o;
        if (this.queueSize != that.queueSize) {
            return false;
        }
        if (this.receiveWindowMultiplier != that.receiveWindowMultiplier) {
            return false;
        }
        return this.packetSizeLimit == that.packetSizeLimit;
    }

    public int hashCode() {
        int result2 = this.queueSize;
        result2 = 31 * result2 + this.receiveWindowMultiplier;
        result2 = 31 * result2 + this.packetSizeLimit;
        return result2;
    }
}

