/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.utils;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsciiArtUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciiArtUtils.class);
    private static final int FONT_SIZE = 24;
    private static final int DRAW_X = 6;
    private static final int RGB = -16777216;

    private AsciiArtUtils() {
    }

    public static void printAsciiArt(String str) {
        int width = 144;
        int height = 32;
        BufferedImage image = new BufferedImage(144, 32, 1);
        Graphics g = image.getGraphics();
        g.setFont(new Font("Dialog", 0, 24));
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.drawString(str, 6, 24);
        for (int y = 0; y < 32; ++y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < 144; ++x) {
                if (image.getRGB(x, y) == -16777216) {
                    sb.append(" ");
                    continue;
                }
                sb.append(image.getRGB(x, y) == -1 ? "#" : "*");
            }
            if (sb.toString().trim().isEmpty()) continue;
            LOGGER.info(String.valueOf(sb));
        }
    }
}

