/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.filter;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.namingserver.filter.CachedBodyHttpServletRequest;
import org.apache.seata.namingserver.manager.NamingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.client.AsyncRestTemplate;

public class ConsoleRemotingFilter
implements Filter {
    private final NamingManager namingManager;
    private final AsyncRestTemplate asyncRestTemplate;
    private final Pattern urlPattern = Pattern.compile("^/api/.*/console/.*");
    private final Logger logger = LoggerFactory.getLogger(ConsoleRemotingFilter.class);

    public ConsoleRemotingFilter(NamingManager namingManager, AsyncRestTemplate asyncRestTemplate) {
        this.namingManager = namingManager;
        this.asyncRestTemplate = asyncRestTemplate;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && this.urlPattern.matcher(((HttpServletRequest)servletRequest).getRequestURI()).matches()) {
            CachedBodyHttpServletRequest request = new CachedBodyHttpServletRequest((HttpServletRequest)servletRequest);
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String namespace = request.getHeader("x-seata-namespace");
            String cluster = request.getHeader("x-seata-cluster");
            String vgroup = request.getParameter("vgroup");
            if (StringUtils.isNotBlank((String)namespace) && (StringUtils.isNotBlank((String)cluster) || StringUtils.isNotBlank((String)vgroup))) {
                NamingServerNode node;
                Node.Endpoint controlEndpoint;
                List list = null;
                if (StringUtils.isNotBlank((String)vgroup)) {
                    list = this.namingManager.getInstancesByVgroupAndNamespace(namespace, vgroup, StringUtils.equalsIgnoreCase((String)request.getMethod(), (String)HttpMethod.GET.name()));
                } else if (StringUtils.isNotBlank((String)cluster)) {
                    list = this.namingManager.getInstances(namespace, cluster);
                }
                if (CollectionUtils.isNotEmpty(list) && (controlEndpoint = (node = (NamingServerNode)list.get(ThreadLocalRandom.current().nextInt(list.size()))).getControl()) != null) {
                    String targetUrl = "http://" + controlEndpoint.getHost() + ":" + controlEndpoint.getPort() + request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
                    HttpHeaders headers = new HttpHeaders();
                    if (node.getRole() == ClusterRole.LEADER) {
                        headers.add("X-SEATA-RAFT-GROUP", node.getUnit());
                    }
                    Collections.list(request.getHeaderNames()).forEach(headerName -> headers.add(headerName, request.getHeader(headerName)));
                    HttpEntity httpEntity = new HttpEntity((Object)request.getCachedBody(), (MultiValueMap)headers);
                    AsyncContext asyncContext = servletRequest.startAsync();
                    asyncContext.setTimeout(5000L);
                    ListenableFuture responseEntityFuture = this.asyncRestTemplate.exchange(URI.create(targetUrl), Objects.requireNonNull(HttpMethod.resolve((String)request.getMethod())), httpEntity, byte[].class);
                    responseEntityFuture.addCallback((ListenableFutureCallback)new /* Unavailable Anonymous Inner Class!! */);
                    return;
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    static /* synthetic */ Logger access$000(ConsoleRemotingFilter x0) {
        return x0.logger;
    }
}

