/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.coordinator;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import org.apache.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.apache.seata.core.protocol.transaction.BranchRegisterRequest;
import org.apache.seata.core.protocol.transaction.BranchRegisterResponse;
import org.apache.seata.core.protocol.transaction.BranchReportRequest;
import org.apache.seata.core.protocol.transaction.BranchReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalBeginRequest;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.core.protocol.transaction.GlobalCommitRequest;
import org.apache.seata.core.protocol.transaction.GlobalCommitResponse;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryRequest;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryResponse;
import org.apache.seata.core.protocol.transaction.GlobalReportRequest;
import org.apache.seata.core.protocol.transaction.GlobalReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalRollbackRequest;
import org.apache.seata.core.protocol.transaction.GlobalRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalStatusRequest;
import org.apache.seata.core.protocol.transaction.GlobalStatusResponse;
import org.apache.seata.core.protocol.transaction.TCInboundHandler;
import org.apache.seata.core.protocol.transaction.UndoLogDeleteRequest;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.RpcContext;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.core.rpc.netty.NettyRemotingServer;
import org.apache.seata.server.AbstractTCInboundHandler;
import org.apache.seata.server.coordinator.DefaultCoordinator;
import org.apache.seata.server.coordinator.DefaultCore;
import org.apache.seata.server.coordinator.RaftCoordinator;
import org.apache.seata.server.limit.LimitRequestDecorator;
import org.apache.seata.server.metrics.MetricsPublisher;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.session.SessionHelper;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultCoordinator
extends AbstractTCInboundHandler
implements TransactionMessageHandler,
Disposable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCoordinator.class);
    private static final int TIMED_TASK_SHUTDOWN_MAX_WAIT_MILLS = 5000;
    private static final String TIME_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    protected static final long COMMITTING_RETRY_PERIOD = CONFIG.getLong("server.recovery.committingRetryPeriod", 1000L);
    protected static final long ASYNC_COMMITTING_RETRY_PERIOD = CONFIG.getLong("server.recovery.asyncCommittingRetryPeriod", 1000L);
    protected static final long ROLLBACKING_RETRY_PERIOD = CONFIG.getLong("server.recovery.rollbackingRetryPeriod", 1000L);
    protected static final long END_STATUS_RETRY_PERIOD = CONFIG.getLong("server.recovery.endstatusRetryPeriod", 30000L);
    protected static final long TIMEOUT_RETRY_PERIOD = CONFIG.getLong("server.recovery.timeoutRetryPeriod", 1000L);
    protected static final long UNDO_LOG_DELETE_PERIOD = CONFIG.getLong("server.undo.logDeletePeriod", 86400000L);
    protected static final long UNDO_LOG_DELAY_DELETE_PERIOD = 180000L;
    private static final int ALWAYS_RETRY_BOUNDARY = 0;
    private static final int DEFAULT_BRANCH_ASYNC_QUEUE_SIZE = 5000;
    private static final int BRANCH_ASYNC_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final long MAX_COMMIT_RETRY_TIMEOUT = ConfigurationFactory.getInstance().getLong("server.maxCommitRetryTimeout", -1L);
    private static final long MAX_ROLLBACK_RETRY_TIMEOUT = ConfigurationFactory.getInstance().getLong("server.maxRollbackRetryTimeout", -1L);
    private static final boolean ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE = ConfigurationFactory.getInstance().getBoolean("server.rollbackRetryTimeoutUnlockEnable", false);
    private static final boolean ROLLBACK_FAILED_UNLOCK_ENABLE = ConfigurationFactory.getInstance().getBoolean("server.rollbackFailedUnlockEnable", false);
    private static final int RETRY_DEAD_THRESHOLD = ConfigurationFactory.getInstance().getInt("server.retryDeadThreshold", 130000);
    private final ScheduledThreadPoolExecutor retryRollbacking = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RetryRollbacking", 1));
    private final ScheduledThreadPoolExecutor retryCommitting = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RetryCommitting", 1));
    private final ScheduledThreadPoolExecutor asyncCommitting = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("AsyncCommitting", 1));
    private final ScheduledThreadPoolExecutor timeoutCheck = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("TxTimeoutCheck", 1));
    private final ScheduledThreadPoolExecutor undoLogDelete = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("UndologDelete", 1));
    private final ScheduledThreadPoolExecutor syncProcessing = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("SyncProcessing", 1));
    private final GlobalStatus[] retryRollbackingStatuses = new GlobalStatus[]{GlobalStatus.TimeoutRollbacking, GlobalStatus.TimeoutRollbackRetrying, GlobalStatus.RollbackRetrying};
    private final GlobalStatus[] retryCommittingStatuses = new GlobalStatus[]{GlobalStatus.CommitRetrying};
    private final GlobalStatus[] rollbackingStatuses = new GlobalStatus[]{GlobalStatus.Rollbacking};
    private final GlobalStatus[] committingStatuses = new GlobalStatus[]{GlobalStatus.Committing};
    private final GlobalStatus[] endStatuses = new GlobalStatus[]{GlobalStatus.Rollbacked, GlobalStatus.TimeoutRollbacked, GlobalStatus.Committed, GlobalStatus.Finished};
    private final ThreadPoolExecutor branchRemoveExecutor;
    private RemotingServer remotingServer;
    private final DefaultCore core;
    private static volatile DefaultCoordinator instance;

    protected DefaultCoordinator(RemotingServer remotingServer) {
        if (remotingServer == null) {
            throw new IllegalArgumentException("RemotingServer not allowed be null.");
        }
        this.remotingServer = remotingServer;
        this.core = new DefaultCore(remotingServer);
        boolean enableBranchAsyncRemove = CONFIG.getBoolean("server.session.enableBranchAsyncRemove", false);
        this.branchRemoveExecutor = enableBranchAsyncRemove && StoreConfig.getSessionMode() != SessionMode.FILE ? new ThreadPoolExecutor(BRANCH_ASYNC_POOL_SIZE, BRANCH_ASYNC_POOL_SIZE, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(CONFIG.getInt("server.session.branchAsyncQueueSize", 5000)), (ThreadFactory)new NamedThreadFactory("branchSessionRemove", BRANCH_ASYNC_POOL_SIZE), new ThreadPoolExecutor.CallerRunsPolicy()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultCoordinator getInstance(RemotingServer remotingServer) {
        if (null != instance) return instance;
        Class<DefaultCoordinator> clazz = DefaultCoordinator.class;
        synchronized (DefaultCoordinator.class) {
            if (null != instance) return instance;
            SessionMode storeMode = StoreConfig.getSessionMode();
            instance = Objects.equals(SessionMode.RAFT, storeMode) ? new RaftCoordinator(remotingServer) : new DefaultCoordinator(remotingServer);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static DefaultCoordinator getInstance() {
        if (null == instance) {
            throw new IllegalArgumentException("The instance has not been created.");
        }
        return instance;
    }

    public boolean doGlobalCommit(GlobalSession globalSession, boolean retrying) throws TransactionException {
        if (globalSession == null) {
            return true;
        }
        return this.core.doGlobalCommit(globalSession, retrying);
    }

    public boolean doGlobalRollback(GlobalSession globalSession, boolean retrying) throws TransactionException {
        if (globalSession == null) {
            return true;
        }
        return this.core.doGlobalRollback(globalSession, retrying);
    }

    public Boolean doBranchDelete(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        if (globalSession == null) {
            return true;
        }
        if (branchSession == null) {
            return true;
        }
        return this.core.doBranchDelete(globalSession, branchSession);
    }

    public void doBranchRemoveAsync(GlobalSession globalSession, BranchSession branchSession) {
        if (globalSession == null) {
            return;
        }
        this.branchRemoveExecutor.execute((Runnable)new BranchRemoveTask(globalSession, branchSession));
    }

    public void doBranchRemoveAllAsync(GlobalSession globalSession) {
        if (globalSession == null) {
            return;
        }
        this.branchRemoveExecutor.execute((Runnable)new BranchRemoveTask(globalSession));
    }

    protected void doGlobalBegin(GlobalBeginRequest request, GlobalBeginResponse response, RpcContext rpcContext) throws TransactionException {
        response.setXid(this.core.begin(rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout()));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin new global transaction applicationId: {},transactionServiceGroup: {}, transactionName: {},timeout:{},xid:{}", new Object[]{rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout(), response.getXid()});
        }
    }

    protected void doGlobalCommit(GlobalCommitRequest request, GlobalCommitResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.commit(request.getXid()));
    }

    protected void doGlobalRollback(GlobalRollbackRequest request, GlobalRollbackResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.rollback(request.getXid()));
    }

    protected void doGlobalStatus(GlobalStatusRequest request, GlobalStatusResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.getStatus(request.getXid()));
    }

    protected void doGlobalReport(GlobalReportRequest request, GlobalReportResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.globalReport(request.getXid(), request.getGlobalStatus()));
    }

    protected void doBranchRegister(BranchRegisterRequest request, BranchRegisterResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setBranchId(this.core.branchRegister(request.getBranchType(), request.getResourceId(), rpcContext.getClientId(), request.getXid(), request.getApplicationData(), request.getLockKey()).longValue());
    }

    protected void doBranchReport(BranchReportRequest request, BranchReportResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(request.getBranchId()));
        this.core.branchReport(request.getBranchType(), request.getXid(), request.getBranchId(), request.getStatus(), request.getApplicationData());
    }

    protected void doLockCheck(GlobalLockQueryRequest request, GlobalLockQueryResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setLockable(this.core.lockQuery(request.getBranchType(), request.getResourceId(), request.getXid(), request.getLockKey()));
    }

    protected void timeoutCheck() {
        SessionCondition sessionCondition = new SessionCondition(GlobalStatus.Begin);
        sessionCondition.setLazyLoadBranch(true);
        List beginGlobalSessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty((Collection)beginGlobalSessions)) {
            return;
        }
        if (!beginGlobalSessions.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Global transaction timeout check begin, size: {}", (Object)beginGlobalSessions.size());
        }
        SessionHelper.forEach((Collection)beginGlobalSessions, globalSession -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(globalSession.getXid() + " " + globalSession.getStatus() + " " + globalSession.getBeginTime() + " " + globalSession.getTimeout());
            }
            SessionHolder.lockAndExecute((GlobalSession)globalSession, () -> {
                if (globalSession.getStatus() != GlobalStatus.Begin || !globalSession.isTimeout()) {
                    return false;
                }
                LOGGER.warn("Global transaction[{}] is timeout and will be rollback,transaction begin time:{} and now:{}", new Object[]{globalSession.getXid(), DateFormatUtils.format((long)globalSession.getBeginTime(), (String)TIME_FORMAT_PATTERN), DateFormatUtils.format((long)System.currentTimeMillis(), (String)TIME_FORMAT_PATTERN)});
                globalSession.close();
                globalSession.changeGlobalStatus(GlobalStatus.TimeoutRollbacking);
                MetricsPublisher.postSessionDoingEvent((GlobalSession)globalSession, (String)GlobalStatus.TimeoutRollbacking.name(), (boolean)false, (boolean)false);
                return true;
            });
        });
        if (!beginGlobalSessions.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Global transaction timeout check end. ");
        }
    }

    protected void handleRetryRollbacking() {
        SessionCondition sessionCondition = new SessionCondition(this.retryRollbackingStatuses);
        sessionCondition.setLazyLoadBranch(true);
        List rollbackingSessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty((Collection)rollbackingSessions)) {
            return;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach((Collection)rollbackingSessions, rollbackingSession -> {
            try {
                if (this.isRetryTimeout(now, MAX_ROLLBACK_RETRY_TIMEOUT, rollbackingSession.getBeginTime())) {
                    if (ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE || ROLLBACK_FAILED_UNLOCK_ENABLE) {
                        rollbackingSession.clean();
                    }
                    SessionHelper.endRollbackFailed((GlobalSession)rollbackingSession, (boolean)true, (boolean)true);
                    return;
                }
                this.core.doGlobalRollback(rollbackingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to retry rollbacking [{}] {} {}", new Object[]{rollbackingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
    }

    protected void handleRetryCommitting() {
        SessionCondition retryCommittingSessionCondition = new SessionCondition(this.retryCommittingStatuses);
        retryCommittingSessionCondition.setLazyLoadBranch(true);
        List committingSessions = SessionHolder.getRootSessionManager().findGlobalSessions(retryCommittingSessionCondition);
        if (CollectionUtils.isEmpty((Collection)committingSessions)) {
            return;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach((Collection)committingSessions, committingSession -> {
            try {
                if (this.isRetryTimeout(now, MAX_COMMIT_RETRY_TIMEOUT, committingSession.getBeginTime())) {
                    SessionHelper.endCommitFailed((GlobalSession)committingSession, (boolean)true, (boolean)true);
                    return;
                }
                if (GlobalStatus.Committed.equals((Object)committingSession.getStatus()) && committingSession.getBranchSessions().isEmpty()) {
                    SessionHelper.endCommitted((GlobalSession)committingSession, (boolean)true);
                }
                this.core.doGlobalCommit(committingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to retry committing [{}] {} {}", new Object[]{committingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
    }

    protected void handleAsyncCommitting() {
        SessionCondition sessionCondition = new SessionCondition(GlobalStatus.AsyncCommitting);
        List asyncCommittingSessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty((Collection)asyncCommittingSessions)) {
            return;
        }
        SessionHelper.forEach((Collection)asyncCommittingSessions, asyncCommittingSession -> {
            try {
                this.core.doGlobalCommit(asyncCommittingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to async committing [{}] {} {}", new Object[]{asyncCommittingSession.getXid(), ex.getCode(), ex.getMessage(), ex});
            }
        });
    }

    protected void undoLogDelete() {
        Map rmChannels = ChannelManager.getRmChannels();
        if (rmChannels == null || rmChannels.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no active rm channels to delete undo log");
            }
            return;
        }
        short saveDays = CONFIG.getShort("server.undo.logSaveDays", (short)7);
        for (Map.Entry channelEntry : rmChannels.entrySet()) {
            String resourceId = (String)channelEntry.getKey();
            UndoLogDeleteRequest deleteRequest = new UndoLogDeleteRequest();
            deleteRequest.setResourceId(resourceId);
            deleteRequest.setSaveDays(saveDays > 0 ? saveDays : (short)7);
            try {
                this.remotingServer.sendAsyncRequest((Channel)channelEntry.getValue(), (Object)deleteRequest);
            }
            catch (Exception e) {
                LOGGER.error("Failed to async delete undo log resourceId = {}, exception: {}", (Object)resourceId, (Object)e.getMessage());
            }
        }
    }

    private boolean isRetryTimeout(long now, long timeout, long beginTime) {
        return timeout >= 0L && now - beginTime > timeout;
    }

    protected void handleRollbackingByScheduled() {
        SessionCondition sessionCondition = new SessionCondition(this.rollbackingStatuses);
        sessionCondition.setLazyLoadBranch(true);
        List rollbackingSessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty((Collection)rollbackingSessions)) {
            this.rollbackingSchedule((long)RETRY_DEAD_THRESHOLD);
            return;
        }
        long delay = ROLLBACKING_RETRY_PERIOD;
        rollbackingSessions.sort(Comparator.comparingLong(GlobalSession::getBeginTime));
        ArrayList<GlobalSession> needDoRollbackingSessions = new ArrayList<GlobalSession>();
        for (GlobalSession rollbackingSession2 : rollbackingSessions) {
            long time = rollbackingSession2.timeToDeadSession();
            if (time <= 0L) {
                needDoRollbackingSessions.add(rollbackingSession2);
                continue;
            }
            delay = Math.max(time, ROLLBACKING_RETRY_PERIOD);
            break;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(needDoRollbackingSessions, rollbackingSession -> {
            try {
                if (this.isRetryTimeout(now, MAX_ROLLBACK_RETRY_TIMEOUT, rollbackingSession.getBeginTime())) {
                    if (ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE || ROLLBACK_FAILED_UNLOCK_ENABLE) {
                        rollbackingSession.clean();
                    }
                    SessionHelper.endRollbackFailed((GlobalSession)rollbackingSession, (boolean)true, (boolean)true);
                    return;
                }
                this.core.doGlobalRollback(rollbackingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to handle rollbacking [{}] {} {}", new Object[]{rollbackingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
        this.rollbackingSchedule(delay);
    }

    private void rollbackingSchedule(long delay) {
        this.syncProcessing.schedule(() -> {
            boolean called = SessionHolder.distributedLockAndExecute((String)"Rollbacking", () -> this.handleRollbackingByScheduled());
            if (!called) {
                this.rollbackingSchedule(ROLLBACKING_RETRY_PERIOD);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    protected void handleCommittingByScheduled() {
        SessionCondition sessionCondition = new SessionCondition(this.committingStatuses);
        sessionCondition.setLazyLoadBranch(true);
        List committingSessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty((Collection)committingSessions)) {
            this.committingSchedule((long)RETRY_DEAD_THRESHOLD);
            return;
        }
        long delay = COMMITTING_RETRY_PERIOD;
        committingSessions.sort(Comparator.comparingLong(GlobalSession::getBeginTime));
        ArrayList<GlobalSession> needDoCommittingSessions = new ArrayList<GlobalSession>();
        for (GlobalSession committingSession2 : committingSessions) {
            long time = committingSession2.timeToDeadSession();
            if (time <= 0L) {
                needDoCommittingSessions.add(committingSession2);
                continue;
            }
            delay = Math.max(time, COMMITTING_RETRY_PERIOD);
            break;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(needDoCommittingSessions, committingSession -> {
            try {
                if (this.isRetryTimeout(now, MAX_COMMIT_RETRY_TIMEOUT, committingSession.getBeginTime())) {
                    SessionHelper.endCommitFailed((GlobalSession)committingSession, (boolean)true, (boolean)true);
                    return;
                }
                this.core.doGlobalCommit(committingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to handle committing [{}] {} {}", new Object[]{committingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
        this.committingSchedule(delay);
    }

    private void committingSchedule(long delay) {
        this.syncProcessing.schedule(() -> {
            boolean called = SessionHolder.distributedLockAndExecute((String)"Committing", () -> this.handleCommittingByScheduled());
            if (!called) {
                this.committingSchedule(COMMITTING_RETRY_PERIOD);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    protected void handleEndStatesByScheduled() {
        SessionCondition sessionCondition = new SessionCondition(this.endStatuses);
        sessionCondition.setLazyLoadBranch(true);
        List endStatusSessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty((Collection)endStatusSessions)) {
            this.endSchedule((long)RETRY_DEAD_THRESHOLD);
            return;
        }
        long delay = END_STATUS_RETRY_PERIOD;
        endStatusSessions.sort(Comparator.comparingLong(GlobalSession::getBeginTime));
        ArrayList<GlobalSession> needDoEndStatusSessions = new ArrayList<GlobalSession>();
        for (GlobalSession endStatusSession2 : endStatusSessions) {
            long time = endStatusSession2.timeToDeadSession();
            if (time <= 0L) {
                needDoEndStatusSessions.add(endStatusSession2);
                continue;
            }
            delay = Math.max(time, END_STATUS_RETRY_PERIOD);
            break;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(needDoEndStatusSessions, endStatusSession -> {
            try {
                if (this.isRetryTimeout(now, MAX_ROLLBACK_RETRY_TIMEOUT, endStatusSession.getBeginTime())) {
                    this.handleEndStateSession(endStatusSession);
                }
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to handle end status session [{}] {} {}", new Object[]{endStatusSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
        this.endSchedule(delay);
    }

    private void handleEndStateSession(GlobalSession globalSession) throws TransactionException {
        SessionHelper.processEndState((GlobalSession)globalSession);
    }

    private void endSchedule(long delay) {
        this.syncProcessing.schedule(() -> {
            boolean called = SessionHolder.distributedLockAndExecute((String)"END", () -> this.handleEndStatesByScheduled());
            if (!called) {
                this.endSchedule(END_STATUS_RETRY_PERIOD);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    public void init() {
        this.retryRollbacking.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute((String)"RetryRollbacking", () -> this.handleRetryRollbacking()), 0L, ROLLBACKING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.retryCommitting.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute((String)"RetryCommitting", () -> this.handleRetryCommitting()), 0L, COMMITTING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.asyncCommitting.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute((String)"AsyncCommitting", () -> this.handleAsyncCommitting()), 0L, ASYNC_COMMITTING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.timeoutCheck.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute((String)"TxTimeoutCheck", () -> this.timeoutCheck()), 0L, TIMEOUT_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.undoLogDelete.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute((String)"UndologDelete", () -> this.undoLogDelete()), 180000L, UNDO_LOG_DELETE_PERIOD, TimeUnit.MILLISECONDS);
        this.rollbackingSchedule(0L);
        this.committingSchedule(0L);
        this.endSchedule(0L);
    }

    public AbstractResultMessage onRequest(AbstractMessage request, RpcContext context) {
        if (!(request instanceof AbstractTransactionRequestToTC)) {
            throw new IllegalArgumentException();
        }
        AbstractTransactionRequestToTC transactionRequest = (AbstractTransactionRequestToTC)request;
        transactionRequest.setTCInboundHandler((TCInboundHandler)this);
        LimitRequestDecorator limitRequestDecorator = new LimitRequestDecorator(transactionRequest);
        return limitRequestDecorator.handle(context);
    }

    public void onResponse(AbstractResultMessage response, RpcContext context) {
        if (!(response instanceof AbstractTransactionResponse)) {
            throw new IllegalArgumentException();
        }
    }

    public void destroy() {
        this.retryRollbacking.shutdown();
        this.retryCommitting.shutdown();
        this.asyncCommitting.shutdown();
        this.timeoutCheck.shutdown();
        this.undoLogDelete.shutdown();
        if (this.branchRemoveExecutor != null) {
            this.branchRemoveExecutor.shutdown();
        }
        try {
            this.retryRollbacking.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.retryCommitting.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.asyncCommitting.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.timeoutCheck.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.undoLogDelete.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            if (this.branchRemoveExecutor != null) {
                this.branchRemoveExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.remotingServer instanceof NettyRemotingServer) {
            ((NettyRemotingServer)this.remotingServer).destroy();
        }
        SessionHolder.destroy();
        instance = null;
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }
}

