/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.thread.RejectedPolicies;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.auth.AuthSigner;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.RegisterTMRequest;
import org.apache.seata.core.protocol.RegisterTMResponse;
import org.apache.seata.core.rpc.netty.AbstractNettyRemotingClient;
import org.apache.seata.core.rpc.netty.NettyClientConfig;
import org.apache.seata.core.rpc.netty.NettyPoolKey;
import org.apache.seata.core.rpc.processor.client.ClientHeartbeatProcessor;
import org.apache.seata.core.rpc.processor.client.ClientOnResponseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TmNettyRemotingClient
extends AbstractNettyRemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmNettyRemotingClient.class);
    private static volatile TmNettyRemotingClient instance;
    private static final long KEEP_ALIVE_TIME = Integer.MAX_VALUE;
    private static final int MAX_QUEUE_SIZE = 2000;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private String applicationId;
    private String transactionServiceGroup;
    private final AuthSigner signer = (AuthSigner)EnhancedServiceLoader.load(AuthSigner.class);
    private String accessKey;
    private String secretKey;

    private TmNettyRemotingClient(NettyClientConfig nettyClientConfig, EventExecutorGroup eventExecutorGroup, ThreadPoolExecutor messageExecutor) {
        super(nettyClientConfig, eventExecutorGroup, messageExecutor, NettyPoolKey.TransactionRole.TMROLE);
        Configuration configuration = ConfigurationFactory.getInstance();
        this.enableClientBatchSendRequest = configuration.getBoolean("transport.enableTmClientBatchSendRequest", false);
        configuration.addConfigListener("transport.enableTmClientBatchSendRequest", (ConfigurationChangeListener)new CachedConfigurationChangeListener(){

            public void onChangeEvent(ConfigurationChangeEvent event) {
                String dataId = event.getDataId();
                String newValue = event.getNewValue();
                if ("transport.enableTmClientBatchSendRequest".equals(dataId) && org.apache.commons.lang.StringUtils.isNotBlank((String)newValue)) {
                    TmNettyRemotingClient.this.enableClientBatchSendRequest = Boolean.parseBoolean(newValue);
                }
            }
        });
    }

    public static TmNettyRemotingClient getInstance(String applicationId, String transactionServiceGroup) {
        return TmNettyRemotingClient.getInstance(applicationId, transactionServiceGroup, null, null);
    }

    public static TmNettyRemotingClient getInstance(String applicationId, String transactionServiceGroup, String accessKey, String secretKey) {
        TmNettyRemotingClient tmRpcClient = TmNettyRemotingClient.getInstance();
        tmRpcClient.setApplicationId(applicationId);
        tmRpcClient.setTransactionServiceGroup(transactionServiceGroup);
        tmRpcClient.setAccessKey(accessKey);
        tmRpcClient.setSecretKey(secretKey);
        return tmRpcClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TmNettyRemotingClient getInstance() {
        if (instance != null) return instance;
        Class<TmNettyRemotingClient> clazz = TmNettyRemotingClient.class;
        synchronized (TmNettyRemotingClient.class) {
            if (instance != null) return instance;
            NettyClientConfig nettyClientConfig = new NettyClientConfig();
            ThreadPoolExecutor messageExecutor = new ThreadPoolExecutor(nettyClientConfig.getClientWorkerThreads(), nettyClientConfig.getClientWorkerThreads(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), (ThreadFactory)new NamedThreadFactory(nettyClientConfig.getTmDispatchThreadPrefix(), nettyClientConfig.getClientWorkerThreads()), RejectedPolicies.runsOldestTaskPolicy());
            instance = new TmNettyRemotingClient(nettyClientConfig, null, messageExecutor);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    protected void setAccessKey(String accessKey) {
        if (null != accessKey) {
            this.accessKey = accessKey;
            return;
        }
        this.accessKey = System.getProperty("seata.accesskey");
    }

    protected void setSecretKey(String secretKey) {
        if (null != secretKey) {
            this.secretKey = secretKey;
            return;
        }
        this.secretKey = System.getProperty("seata.secretkey");
    }

    @Override
    public void init() {
        this.registerProcessor();
        if (this.initialized.compareAndSet(false, true)) {
            super.init();
            if (StringUtils.isNotBlank((String)this.transactionServiceGroup)) {
                this.initConnection();
            }
        }
    }

    @Override
    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    @Override
    public boolean isEnableClientBatchSendRequest() {
        return this.enableClientBatchSendRequest;
    }

    @Override
    public long getRpcRequestTimeout() {
        return NettyClientConfig.getRpcTmRequestTimeout();
    }

    @Override
    public void onRegisterMsgSuccess(String serverAddress, Channel channel, Object response, AbstractMessage requestMessage) {
        RegisterTMRequest registerTMRequest = (RegisterTMRequest)requestMessage;
        RegisterTMResponse registerTMResponse = (RegisterTMResponse)response;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("register TM success. client version:{}, server version:{},channel:{}", new Object[]{registerTMRequest.getVersion(), registerTMResponse.getVersion(), channel});
        }
        this.getClientChannelManager().registerChannel(serverAddress, channel, registerTMRequest.getVersion());
    }

    @Override
    public void onRegisterMsgFail(String serverAddress, Channel channel, Object response, AbstractMessage requestMessage) {
        RegisterTMRequest registerTMRequest = (RegisterTMRequest)requestMessage;
        RegisterTMResponse registerTMResponse = (RegisterTMResponse)response;
        String errMsg = String.format("register TM failed. client version: %s,server version: %s, errorMsg: %s, channel: %s", registerTMRequest.getVersion(), registerTMResponse.getVersion(), registerTMResponse.getMsg(), channel);
        throw new FrameworkException(errMsg);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.initialized.getAndSet(false);
        instance = null;
    }

    @Override
    protected Function<String, NettyPoolKey> getPoolKeyFunction() {
        return severAddress -> {
            RegisterTMRequest message = new RegisterTMRequest(this.applicationId, this.transactionServiceGroup, this.getExtraData());
            return new NettyPoolKey(NettyPoolKey.TransactionRole.TMROLE, (String)severAddress, message);
        };
    }

    private void registerProcessor() {
        ClientOnResponseProcessor onResponseProcessor = new ClientOnResponseProcessor(this.mergeMsgMap, super.getFutures(), this.childToParentMap, this.getTransactionMessageHandler());
        super.registerProcessor(60, onResponseProcessor, null);
        super.registerProcessor(2, onResponseProcessor, null);
        super.registerProcessor(8, onResponseProcessor, null);
        super.registerProcessor(18, onResponseProcessor, null);
        super.registerProcessor(10, onResponseProcessor, null);
        super.registerProcessor(16, onResponseProcessor, null);
        super.registerProcessor(102, onResponseProcessor, null);
        super.registerProcessor(121, onResponseProcessor, null);
        ClientHeartbeatProcessor clientHeartbeatProcessor = new ClientHeartbeatProcessor();
        super.registerProcessor(120, clientHeartbeatProcessor, null);
    }

    private String getExtraData() {
        String ip = NetUtil.getLocalIp((String[])new String[0]);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String digestSource = org.apache.commons.lang.StringUtils.isEmpty((String)ip) ? this.transactionServiceGroup + ",127.0.0.1," + timestamp : this.transactionServiceGroup + "," + ip + "," + timestamp;
        String digest = this.signer.sign(digestSource, this.secretKey);
        StringBuilder sb = new StringBuilder();
        sb.append("ak").append("=").append(this.accessKey).append("\n");
        sb.append("digest").append("=").append(digest).append("\n");
        sb.append("timestamp").append("=").append(timestamp).append("\n");
        sb.append("authVersion").append("=").append(this.signer.getSignVersion()).append("\n");
        return sb.toString();
    }

    private void initConnection() {
        boolean failFast = ConfigurationFactory.getInstance().getBoolean("transport.enableTmClientChannelCheckFailFast", true);
        this.getClientChannelManager().initReconnect(this.transactionServiceGroup, failFast);
    }
}

