/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.AbstractLob;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.util.ByteUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbBlob
extends AbstractLob
implements Blob {
    public byte[] data;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    private DmdbBlob(byte[] byArray, DmdbConnection dmdbConnection, Column column, boolean bl) {
        super(byArray, (byte)0, dmdbConnection, column);
        this.length = this.bytesLength;
        if (this.storageType == 1) {
            int n2 = this.getHeadSize();
            this.data = new byte[(int)this.length];
            ByteUtil.setBytes(this.data, 0, byArray, n2, this.data.length);
        } else if (bl) {
            this.loadAllData();
        }
    }

    private DmdbBlob(byte[] byArray, DmdbConnection dmdbConnection) {
        super((byte)0, dmdbConnection);
        this.data = byArray;
        this.length = this.data.length;
    }

    public static DmdbBlob newInstanceFromDB(byte[] byArray, DmdbConnection dmdbConnection, Column column, boolean bl) {
        return new DmdbBlob(byArray, dmdbConnection, column, bl);
    }

    public static DmdbBlob newInstanceOfLocal(byte[] byArray, DmdbConnection dmdbConnection) {
        return new DmdbBlob(byArray, dmdbConnection);
    }

    public static DmdbBlob getEmptyBlob() {
        try {
            DmdbBlob dmdbBlob = new DmdbBlob(new byte[0], new DmdbConnection(null));
            dmdbBlob.empty = true;
            return dmdbBlob;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public byte[] do_getBytes(long l2, int n2) {
        long l3;
        this.checkFreed();
        if (l2 < 1L || n2 < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if ((l3 = this.do_length() - --l2) < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        n2 = (int)((long)n2 > l3 ? l3 : (long)n2);
        if (this.local || this.storageType == 1 || this.fetchAll) {
            byte[] byArray = new byte[n2];
            ByteUtil.setBytes(byArray, 0, this.data, (int)l2, byArray.length);
            return byArray;
        }
        this.connection.checkClosed();
        return this.connection.dbAccess.a(this, l2, n2);
    }

    public DmdbInputStream do_getBinaryStream() {
        this.checkFreed();
        return new DmdbInputStream(this, 1);
    }

    public long do_position(byte[] byArray, long l2) {
        this.checkFreed();
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        byte[] byArray2 = this.do_getBytes(l2, (int)this.do_length());
        if (byArray2 == null || byArray2.length == 0) {
            return -1L;
        }
        long l3 = ByteUtil.indexOf(byArray2, byArray);
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    public long do_position(Blob blob, long l2) {
        return this.do_position(blob.getBytes(1L, (int)blob.length()), l2);
    }

    public int do_setBytes(long l2, byte[] byArray) {
        return this.do_setBytes(l2, byArray, 0, byArray.length);
    }

    public int do_setBytes(long l2, byte[] byArray, int n2, int n3) {
        this.checkFreed();
        if (l2 < 1L || n3 < 0 || n2 < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        n3 = n2 + n3 > byArray.length ? byArray.length - n2 : n3;
        --l2;
        int n4 = 0;
        if (this.local || this.fetchAll) {
            if (l2 > this.do_length()) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
            }
            this.setLocalData((int)l2, byArray, n2, n3);
            n4 = n3;
        } else {
            this.connection.checkClosed();
            int n5 = this.connection.dbAccess.a(this, l2, byArray, n2, n3);
            if (this.storageType == 1) {
                this.setLocalData((int)l2, byArray, n2, n5);
            }
            n4 = n5;
        }
        this.modify = true;
        return n4;
    }

    public DmdbOutputStream do_setBinaryStream(long l2) {
        this.checkFreed();
        if (this.compatibleOracle && l2 == 0L) {
            l2 = 1L;
        }
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        return new DmdbOutputStream(this, l2, 1);
    }

    public DmdbOutputStream getBinaryOutputStream() {
        return this.do_setBinaryStream(1L);
    }

    public DmdbOutputStream getBinaryOutputStream(long l2) {
        return this.do_setBinaryStream(l2);
    }

    public void do_truncate(long l2) {
        this.checkFreed();
        if (l2 < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        if (this.local || this.fetchAll) {
            if (l2 >= (long)this.data.length) {
                return;
            }
            byte[] byArray = new byte[(int)l2];
            ByteUtil.setBytes(byArray, 0, this.data, 0, byArray.length);
            this.data = byArray;
            this.length = byArray.length;
        } else {
            this.connection.checkClosed();
            this.length = this.connection.dbAccess.a(this, l2);
            if (this.storageType == 1) {
                byte[] byArray = new byte[(int)this.do_length()];
                ByteUtil.setBytes(byArray, 0, this.data, 0, byArray.length);
                this.data = byArray;
            }
        }
        this.modify = true;
    }

    @Override
    public void do_free() {
        super.do_free();
        this.data = null;
    }

    public DmdbInputStream do_getBinaryStream(long l2, long l3) {
        this.checkFreed();
        return new DmdbInputStream(this, l2, l3);
    }

    @Override
    protected void loadAllData() {
        this.checkFreed();
        if (this.local || this.storageType == 1 || this.fetchAll) {
            return;
        }
        this.data = this.do_getBytes(1L, (int)this.do_length());
        this.fetchAll = true;
    }

    private void setLocalData(int n2, byte[] byArray, int n3, int n4) {
        if ((long)(n2 + n4) > this.length) {
            byte[] byArray2 = new byte[n2 + n4];
            ByteUtil.setBytes(byArray2, 0, this.data, 0, n2);
            ByteUtil.setBytes(byArray2, n2, byArray, n3, n4);
            this.data = byArray2;
        } else {
            ByteUtil.setBytes(this.data, n2, byArray, n3, n4);
        }
        this.length = this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_length();
            }
            return this.filterChain.reset().Blob_length(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l2, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBytes(l2, n2);
            }
            return this.filterChain.reset().Blob_getBytes(this, l2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream();
            }
            return this.filterChain.reset().Blob_getBinaryStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(byte[] byArray, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(byArray, l2);
            }
            return this.filterChain.reset().Blob_position(this, byArray, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Blob blob, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(blob, l2);
            }
            return this.filterChain.reset().Blob_position(this, blob, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l2, byte[] byArray) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setBytes(l2, byArray);
            }
            return this.filterChain.reset().Blob_setBytes(this, l2, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setBytes(l2, byArray, n2, n3);
            }
            return this.filterChain.reset().Blob_setBytes(this, l2, byArray, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setBinaryStream(l2);
            }
            return this.filterChain.reset().Blob_setBinaryStream(this, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_truncate(l2);
            } else {
                this.filterChain.reset().Blob_truncate(this, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        if (this.connection == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_free();
            } else {
                this.filterChain.reset().Blob_free(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(long l2, long l3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream(l2, l3);
            }
            return this.filterChain.reset().Blob_getBinaryStream(this, l2, l3);
        }
    }
}

