/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry;

import java.util.Objects;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.registry.RegistryProvider;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.RegistryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryFactory.class);

    public static RegistryService getInstance() {
        return RegistryFactoryHolder.INSTANCE;
    }

    private static RegistryService buildRegistryService() {
        RegistryType registryType;
        String registryTypeName = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig("registry.type");
        LOGGER.info("use registry center type: {}", (Object)registryTypeName);
        try {
            registryType = RegistryType.getType(registryTypeName);
        }
        catch (Exception exx) {
            throw new NotSupportYetException("not support registry type: " + registryTypeName);
        }
        return ((RegistryProvider)EnhancedServiceLoader.load(RegistryProvider.class, (String)Objects.requireNonNull(registryType).name())).provide();
    }

    static /* synthetic */ RegistryService access$100() {
        return RegistryFactory.buildRegistryService();
    }

    private static class RegistryFactoryHolder {
        private static final RegistryService INSTANCE = RegistryFactory.access$100();

        private RegistryFactoryHolder() {
        }
    }
}

