/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.store;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.IsolationLevel;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.store.db.AbstractDataSourceProvider;

@LoadLevel(name="hikari")
public class HikariDataSourceProvider
extends AbstractDataSourceProvider {
    public DataSource doGenerate() {
        Properties properties = new Properties();
        properties.setProperty("dataSource.cachePrepStmts", "true");
        properties.setProperty("dataSource.prepStmtCacheSize", "250");
        properties.setProperty("dataSource.prepStmtCacheSqlLimit", "2048");
        properties.setProperty("dataSource.useServerPrepStmts", "true");
        properties.setProperty("dataSource.useLocalSessionState", "true");
        properties.setProperty("dataSource.rewriteBatchedStatements", "true");
        properties.setProperty("dataSource.cacheResultSetMetadata", "true");
        properties.setProperty("dataSource.cacheServerConfiguration", "true");
        properties.setProperty("dataSource.elideSetAutoCommits", "true");
        properties.setProperty("dataSource.maintainTimeStats", "false");
        HikariConfig config = new HikariConfig(properties);
        config.setDriverClassName(this.getDriverClassName());
        config.setJdbcUrl(this.getUrl());
        config.setUsername(this.getUser());
        config.setPassword(this.getPassword());
        config.setMaximumPoolSize(this.getMaxConn());
        config.setMinimumIdle(this.getMinConn());
        config.setAutoCommit(true);
        config.setConnectionTimeout(this.getMaxWait().longValue());
        config.setInitializationFailTimeout(-1L);
        config.setTransactionIsolation(IsolationLevel.TRANSACTION_READ_COMMITTED.name());
        return new HikariDataSource(config);
    }
}

