/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.core.store.GlobalTransactionDO;
import org.apache.seata.server.cluster.raft.sync.msg.dto.BranchTransactionDTO;
import org.apache.seata.server.console.vo.BranchSessionVO;
import org.apache.seata.server.console.vo.GlobalSessionVO;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.store.SessionStorable;
import org.springframework.beans.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionConverter {
    public static GlobalSession convertGlobalSession(GlobalTransactionDO globalTransactionDO, boolean lazyLoadBranch) {
        if (globalTransactionDO == null) {
            return null;
        }
        GlobalSession session = new GlobalSession(globalTransactionDO.getApplicationId(), globalTransactionDO.getTransactionServiceGroup(), globalTransactionDO.getTransactionName(), globalTransactionDO.getTimeout().intValue(), lazyLoadBranch);
        session.setXid(globalTransactionDO.getXid());
        session.setTransactionId(globalTransactionDO.getTransactionId().longValue());
        session.setStatus(GlobalStatus.get((int)globalTransactionDO.getStatus()));
        session.setApplicationData(globalTransactionDO.getApplicationData());
        session.setBeginTime(globalTransactionDO.getBeginTime().longValue());
        return session;
    }

    public static GlobalSession convertGlobalSession(GlobalTransactionDO globalTransactionDO) {
        return SessionConverter.convertGlobalSession((GlobalTransactionDO)globalTransactionDO, (boolean)false);
    }

    public static BranchSession convertBranchSession(BranchTransactionDO branchTransactionDO) {
        if (branchTransactionDO == null) {
            return null;
        }
        BranchSession branchSession = new BranchSession();
        branchSession.setXid(branchTransactionDO.getXid());
        branchSession.setTransactionId(branchTransactionDO.getTransactionId().longValue());
        branchSession.setApplicationData(branchTransactionDO.getApplicationData());
        branchSession.setBranchId(branchTransactionDO.getBranchId().longValue());
        branchSession.setBranchType(BranchType.valueOf((String)branchTransactionDO.getBranchType()));
        branchSession.setResourceId(branchTransactionDO.getResourceId());
        branchSession.setClientId(branchTransactionDO.getClientId());
        branchSession.setResourceGroupId(branchTransactionDO.getResourceGroupId());
        branchSession.setStatus(BranchStatus.get((int)branchTransactionDO.getStatus()));
        if (branchTransactionDO instanceof BranchTransactionDTO) {
            branchSession.setLockKey(((BranchTransactionDTO)branchTransactionDO).getLockKey());
        }
        return branchSession;
    }

    public static GlobalTransactionDO convertGlobalTransactionDO(SessionStorable session) {
        GlobalTransactionDO globalTransactionDO = new GlobalTransactionDO();
        SessionConverter.convertGlobalTransactionDO((GlobalTransactionDO)globalTransactionDO, (SessionStorable)session);
        return globalTransactionDO;
    }

    public static void convertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO, SessionStorable session) {
        if (!(session instanceof GlobalSession)) {
            throw new IllegalArgumentException("The parameter of SessionStorable is not available, SessionStorable:" + StringUtils.toString((Object)session));
        }
        GlobalSession globalSession = (GlobalSession)session;
        globalTransactionDO.setXid(globalSession.getXid());
        globalTransactionDO.setStatus(globalSession.getStatus().getCode());
        globalTransactionDO.setApplicationId(globalSession.getApplicationId());
        globalTransactionDO.setBeginTime(globalSession.getBeginTime());
        globalTransactionDO.setTimeout(globalSession.getTimeout());
        globalTransactionDO.setTransactionId(globalSession.getTransactionId());
        globalTransactionDO.setTransactionName(globalSession.getTransactionName());
        globalTransactionDO.setTransactionServiceGroup(globalSession.getTransactionServiceGroup());
        globalTransactionDO.setApplicationData(globalSession.getApplicationData());
    }

    public static BranchTransactionDO convertBranchTransactionDO(SessionStorable session) {
        if (!(session instanceof BranchSession)) {
            throw new IllegalArgumentException("The parameter of SessionStorable is not available, SessionStorable:" + StringUtils.toString((Object)session));
        }
        BranchTransactionDO branchTransactionDO = new BranchTransactionDO();
        SessionConverter.convertBranchTransaction((BranchTransactionDO)branchTransactionDO, (SessionStorable)session);
        return branchTransactionDO;
    }

    public static BranchTransactionDTO convertBranchTransactionDTO(SessionStorable session) {
        if (!(session instanceof BranchSession)) {
            throw new IllegalArgumentException("The parameter of SessionStorable is not available, SessionStorable:" + StringUtils.toString((Object)session));
        }
        BranchTransactionDTO branchTransactionDTO = new BranchTransactionDTO();
        SessionConverter.convertBranchTransaction((BranchTransactionDO)branchTransactionDTO, (SessionStorable)session);
        return branchTransactionDTO;
    }

    public static void convertBranchTransaction(BranchTransactionDO branchTransactionDO, SessionStorable session) {
        BranchSession branchSession = (BranchSession)session;
        branchTransactionDO.setXid(branchSession.getXid());
        branchTransactionDO.setBranchId(branchSession.getBranchId());
        branchTransactionDO.setBranchType(branchSession.getBranchType().name());
        branchTransactionDO.setClientId(branchSession.getClientId());
        branchTransactionDO.setResourceGroupId(branchSession.getResourceGroupId());
        branchTransactionDO.setTransactionId(branchSession.getTransactionId());
        branchTransactionDO.setApplicationData(branchSession.getApplicationData());
        branchTransactionDO.setResourceId(branchSession.getResourceId());
        branchTransactionDO.setStatus(branchSession.getStatus().getCode());
        if (branchTransactionDO instanceof BranchTransactionDTO) {
            ((BranchTransactionDTO)branchTransactionDO).setLockKey(branchSession.getLockKey());
        }
    }

    public static void convertToGlobalSessionVo(List<GlobalSessionVO> result, List<GlobalSession> globalSessions) {
        if (CollectionUtils.isNotEmpty(globalSessions)) {
            for (GlobalSession globalSession : globalSessions) {
                GlobalSessionVO globalSessionVO = new GlobalSessionVO();
                BeanUtils.copyProperties((Object)globalSession, (Object)globalSessionVO);
                globalSessionVO.setStatus(Integer.valueOf(globalSession.getStatus().getCode()));
                globalSessionVO.setTimeout(Long.valueOf(globalSession.getTimeout()));
                globalSessionVO.setBranchSessionVOs(SessionConverter.convertToBranchSession((List)globalSession.getBranchSessions()));
                result.add(globalSessionVO);
            }
        }
    }

    public static Set<BranchSessionVO> convertToBranchSession(List<BranchSession> branchSessions) {
        HashSet<BranchSessionVO> branchSessionVOs = new HashSet<BranchSessionVO>(branchSessions.size());
        if (CollectionUtils.isNotEmpty(branchSessions)) {
            for (BranchSession branchSession : branchSessions) {
                BranchSessionVO branchSessionVONew = new BranchSessionVO();
                BeanUtils.copyProperties((Object)branchSession, (Object)branchSessionVONew);
                branchSessionVONew.setBranchType(branchSession.getBranchType().name());
                branchSessionVONew.setStatus(Integer.valueOf(branchSession.getStatus().getCode()));
                branchSessionVOs.add(branchSessionVONew);
            }
        }
        return branchSessionVOs;
    }

    public static List<GlobalSessionVO> convertGlobalSession(List<GlobalSession> filteredSessions) {
        if (CollectionUtils.isEmpty(filteredSessions)) {
            return Collections.emptyList();
        }
        ArrayList<GlobalSessionVO> result = new ArrayList<GlobalSessionVO>(filteredSessions.size());
        for (GlobalSession session : filteredSessions) {
            result.add(new GlobalSessionVO(session.getXid(), Long.valueOf(session.getTransactionId()), Integer.valueOf(session.getStatus().getCode()), session.getApplicationId(), session.getTransactionServiceGroup(), session.getTransactionName(), Long.valueOf(session.getTimeout()), Long.valueOf(session.getBeginTime()), session.getApplicationData(), SessionConverter.convertBranchSession((List)session.getBranchSessions())));
        }
        return result;
    }

    public static Set<BranchSessionVO> convertBranchSession(List<BranchSession> branchSessions) {
        if (CollectionUtils.isEmpty(branchSessions)) {
            return Collections.emptySet();
        }
        ArrayList<BranchSession> safeBranchSessions = new ArrayList<BranchSession>(branchSessions);
        HashSet<BranchSessionVO> result = new HashSet<BranchSessionVO>(safeBranchSessions.size());
        for (BranchSession session : safeBranchSessions) {
            result.add(new BranchSessionVO(session.getXid(), Long.valueOf(session.getTransactionId()), Long.valueOf(session.getBranchId()), session.getResourceGroupId(), session.getResourceId(), session.getBranchType().name(), Integer.valueOf(session.getStatus().getCode()), session.getClientId(), session.getApplicationData()));
        }
        return result;
    }
}

