/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.session;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.seata.common.XID;
import org.apache.seata.common.util.BufferUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.common.util.UUIDGenerator;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.lock.LockerManagerFactory;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.session.SessionLifecycle;
import org.apache.seata.server.session.SessionLifecycleListener;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSession
implements SessionLifecycle,
SessionStorable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSession.class);
    private static final int MAX_GLOBAL_SESSION_SIZE = StoreConfig.getMaxGlobalSessionSize();
    private static ThreadLocal<ByteBuffer> byteBufferThreadLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(MAX_GLOBAL_SESSION_SIZE));
    private static final ThreadLocal<GlobalStatus> EXPECTED_STATUS_THREAD_LOCAL = new ThreadLocal();
    private static final int RETRY_DEAD_THRESHOLD = ConfigurationFactory.getInstance().getInt("server.retryDeadThreshold", 130000);
    private String xid;
    private long transactionId;
    private volatile GlobalStatus status;
    private String applicationId;
    private String transactionServiceGroup;
    private String transactionName;
    private int timeout;
    private long beginTime;
    private String applicationData;
    private final boolean lazyLoadBranch;
    private volatile boolean active = true;
    private List<BranchSession> branchSessions;
    private GlobalSessionLock globalSessionLock = new GlobalSessionLock(null);
    private Set<SessionLifecycleListener> lifecycleListeners = new HashSet(2);

    public boolean add(BranchSession branchSession) {
        if (null != this.branchSessions) {
            return this.branchSessions.add(branchSession);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BranchSession branchSession) {
        GlobalSession globalSession = this;
        synchronized (globalSession) {
            return this.branchSessions.remove(branchSession);
        }
    }

    public boolean remove(Long branchId) {
        return this.remove(this.getBranch(branchId.longValue()));
    }

    public boolean canBeCommittedAsync() {
        List branchSessions = this.getBranchSessions();
        for (BranchSession branchSession : branchSessions) {
            if (branchSession.canBeCommittedAsync()) continue;
            return false;
        }
        return true;
    }

    public boolean hasATBranch() {
        List branchSessions = this.getBranchSessions();
        for (BranchSession branchSession : branchSessions) {
            if (branchSession.getBranchType() != BranchType.AT) continue;
            return true;
        }
        return false;
    }

    public boolean isSaga() {
        List branchSessions = this.getBranchSessions();
        if (branchSessions.size() > 0) {
            return BranchType.SAGA == ((BranchSession)branchSessions.get(0)).getBranchType();
        }
        return StringUtils.isNotBlank((String)this.transactionName) && this.transactionName.startsWith("$Saga_");
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.beginTime > (long)this.timeout;
    }

    public boolean isDeadSession() {
        return System.currentTimeMillis() - this.beginTime > (long)RETRY_DEAD_THRESHOLD;
    }

    public long timeToDeadSession() {
        return this.beginTime + (long)RETRY_DEAD_THRESHOLD - System.currentTimeMillis();
    }

    public void begin() throws TransactionException {
        this.status = GlobalStatus.Begin;
        this.beginTime = System.currentTimeMillis();
        this.active = true;
        SessionHolder.getRootSessionManager().onBegin(this);
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onBegin(this);
        }
    }

    public void changeGlobalStatus(GlobalStatus status) throws TransactionException {
        if (GlobalStatus.Rollbacking == status || GlobalStatus.TimeoutRollbacking == status) {
            LockerManagerFactory.getLockManager().updateLockStatus(this.xid, LockStatus.Rollbacking);
        }
        SessionHolder.getRootSessionManager().onStatusChange(this, status);
        this.status = status;
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onStatusChange(this, status);
        }
    }

    public void changeBranchStatus(BranchSession branchSession, BranchStatus status) throws TransactionException {
        SessionHolder.getRootSessionManager().onBranchStatusChange(this, branchSession, status);
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onBranchStatusChange(this, branchSession, status);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void close() throws TransactionException {
        if (this.active) {
            SessionHolder.getRootSessionManager().onClose(this);
            for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onClose(this);
            }
        }
    }

    public void end() throws TransactionException {
        if (GlobalStatus.isTwoPhaseSuccess((GlobalStatus)this.status)) {
            this.clean();
            SessionHolder.getRootSessionManager().onSuccessEnd(this);
            for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onSuccessEnd(this);
            }
        } else {
            SessionHolder.getRootSessionManager().onFailEnd(this);
            for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onFailEnd(this);
            }
        }
    }

    public void clean() throws TransactionException {
        if (!LockerManagerFactory.getLockManager().releaseGlobalSessionLock(this)) {
            throw new TransactionException("UnLock globalSession error, xid = " + this.xid);
        }
    }

    public void closeAndClean() throws TransactionException {
        this.close();
        if (this.hasATBranch()) {
            this.clean();
        }
    }

    public void addSessionLifecycleListener(SessionLifecycleListener sessionLifecycleListener) {
        this.lifecycleListeners.add(sessionLifecycleListener);
    }

    public void removeSessionLifecycleListener(SessionLifecycleListener sessionLifecycleListener) {
        this.lifecycleListeners.remove(sessionLifecycleListener);
    }

    public void addBranch(BranchSession branchSession) throws TransactionException {
        SessionHolder.getRootSessionManager().onAddBranch(this, branchSession);
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onAddBranch(this, branchSession);
        }
        if (!RaftServerManager.isRaftMode()) {
            this.add(branchSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBranchs() {
        if (this.branchSessions == null && this.isLazyLoadBranch()) {
            GlobalSession globalSession2 = this;
            synchronized (globalSession2) {
                if (this.branchSessions == null && this.isLazyLoadBranch()) {
                    this.branchSessions = new ArrayList();
                    Optional.ofNullable(SessionHolder.getRootSessionManager().findGlobalSession(this.xid, true)).ifPresent(globalSession -> this.branchSessions.addAll(globalSession.getBranchSessions()));
                }
            }
        }
    }

    public void unlockBranch(BranchSession branchSession) throws TransactionException {
        if (this.status != GlobalStatus.Committing && this.status != GlobalStatus.CommitRetrying && this.status != GlobalStatus.AsyncCommitting && !branchSession.unlock()) {
            throw new TransactionException("Unlock branch lock failed, xid = " + this.xid + ", branchId = " + branchSession.getBranchId());
        }
    }

    public void removeBranch(BranchSession branchSession) throws TransactionException {
        SessionHolder.getRootSessionManager().onRemoveBranch(this, branchSession);
        for (SessionLifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onRemoveBranch(this, branchSession);
        }
        if (!RaftServerManager.isRaftMode()) {
            this.remove(branchSession);
        }
    }

    public void removeAndUnlockBranch(BranchSession branchSession) throws TransactionException {
        this.unlockBranch(branchSession);
        this.removeBranch(branchSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BranchSession getBranch(long branchId) {
        GlobalSession globalSession = this;
        synchronized (globalSession) {
            List branchSessions = this.getBranchSessions();
            for (BranchSession branchSession : branchSessions) {
                if (branchSession.getBranchId() != branchId) continue;
                return branchSession;
            }
            return null;
        }
    }

    public List<BranchSession> getSortedBranches() {
        return new ArrayList<BranchSession>(this.getBranchSessions());
    }

    public List<BranchSession> getReverseSortedBranches() {
        ArrayList<BranchSession> reversed = new ArrayList<BranchSession>(this.getBranchSessions());
        Collections.reverse(reversed);
        return reversed;
    }

    public GlobalSession() {
        this.lazyLoadBranch = false;
    }

    public GlobalSession(String applicationId, String transactionServiceGroup, String transactionName, int timeout, boolean lazyLoadBranch) {
        this.transactionId = UUIDGenerator.generateUUID();
        this.status = GlobalStatus.Begin;
        this.lazyLoadBranch = lazyLoadBranch;
        if (!lazyLoadBranch) {
            this.branchSessions = new ArrayList();
        }
        this.applicationId = applicationId;
        this.transactionServiceGroup = transactionServiceGroup;
        this.transactionName = transactionName;
        this.timeout = timeout;
        this.xid = XID.generateXID((long)this.transactionId);
    }

    public GlobalSession(String applicationId, String transactionServiceGroup, String transactionName, int timeout) {
        this(applicationId, transactionServiceGroup, transactionName, timeout, false);
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public GlobalStatus getStatus() {
        return this.status;
    }

    public void setStatus(GlobalStatus status) {
        this.status = status;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    public boolean isLazyLoadBranch() {
        return this.lazyLoadBranch;
    }

    public static GlobalSession createGlobalSession(String applicationId, String txServiceGroup, String txName, int timeout) {
        GlobalSession session = new GlobalSession(applicationId, txServiceGroup, txName, timeout, false);
        return session;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public byte[] encode() {
        byte[] applicationDataBytes;
        byte[] xidBytes;
        byte[] byTxNameBytes;
        byte[] byServiceGroupBytes;
        byte[] byApplicationIdBytes = this.applicationId != null ? this.applicationId.getBytes() : null;
        int size = this.calGlobalSessionSize(byApplicationIdBytes, byServiceGroupBytes = this.transactionServiceGroup != null ? this.transactionServiceGroup.getBytes() : null, byTxNameBytes = this.transactionName != null ? this.transactionName.getBytes() : null, xidBytes = this.xid != null ? this.xid.getBytes() : null, applicationDataBytes = this.applicationData != null ? this.applicationData.getBytes() : null);
        if (size > MAX_GLOBAL_SESSION_SIZE) {
            throw new RuntimeException("global session size exceeded, size : " + size + " byte, maxGlobalSessionSize : " + MAX_GLOBAL_SESSION_SIZE + " byte");
        }
        ByteBuffer byteBuffer = (ByteBuffer)byteBufferThreadLocal.get();
        byteBuffer.clear();
        byteBuffer.putLong(this.transactionId);
        byteBuffer.putInt(this.timeout);
        if (byApplicationIdBytes != null) {
            byteBuffer.putShort((short)byApplicationIdBytes.length);
            byteBuffer.put(byApplicationIdBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (byServiceGroupBytes != null) {
            byteBuffer.putShort((short)byServiceGroupBytes.length);
            byteBuffer.put(byServiceGroupBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (byTxNameBytes != null) {
            byteBuffer.putShort((short)byTxNameBytes.length);
            byteBuffer.put(byTxNameBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (xidBytes != null) {
            byteBuffer.putInt(xidBytes.length);
            byteBuffer.put(xidBytes);
        } else {
            byteBuffer.putInt(0);
        }
        if (applicationDataBytes != null) {
            byteBuffer.putInt(applicationDataBytes.length);
            byteBuffer.put(applicationDataBytes);
        } else {
            byteBuffer.putInt(0);
        }
        byteBuffer.putLong(this.beginTime);
        byteBuffer.put((byte)this.status.getCode());
        BufferUtils.flip((Buffer)byteBuffer);
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }

    private int calGlobalSessionSize(byte[] byApplicationIdBytes, byte[] byServiceGroupBytes, byte[] byTxNameBytes, byte[] xidBytes, byte[] applicationDataBytes) {
        return 35 + (byApplicationIdBytes == null ? 0 : byApplicationIdBytes.length) + (byServiceGroupBytes == null ? 0 : byServiceGroupBytes.length) + (byTxNameBytes == null ? 0 : byTxNameBytes.length) + (xidBytes == null ? 0 : xidBytes.length) + (applicationDataBytes == null ? 0 : applicationDataBytes.length);
    }

    public void decode(byte[] a) {
        int applicationDataLen;
        int xidLen;
        short txNameLen;
        short serviceGroupLen;
        this.branchSessions = new ArrayList();
        ByteBuffer byteBuffer = ByteBuffer.wrap(a);
        this.transactionId = byteBuffer.getLong();
        this.timeout = byteBuffer.getInt();
        short applicationIdLen = byteBuffer.getShort();
        if (applicationIdLen > 0) {
            byte[] byApplicationId = new byte[applicationIdLen];
            byteBuffer.get(byApplicationId);
            this.applicationId = new String(byApplicationId);
        }
        if ((serviceGroupLen = byteBuffer.getShort()) > 0) {
            byte[] byServiceGroup = new byte[serviceGroupLen];
            byteBuffer.get(byServiceGroup);
            this.transactionServiceGroup = new String(byServiceGroup);
        }
        if ((txNameLen = byteBuffer.getShort()) > 0) {
            byte[] byTxName = new byte[txNameLen];
            byteBuffer.get(byTxName);
            this.transactionName = new String(byTxName);
        }
        if ((xidLen = byteBuffer.getInt()) > 0) {
            byte[] xidBytes = new byte[xidLen];
            byteBuffer.get(xidBytes);
            this.xid = new String(xidBytes);
        }
        if ((applicationDataLen = byteBuffer.getInt()) > 0) {
            byte[] applicationDataLenBytes = new byte[applicationDataLen];
            byteBuffer.get(applicationDataLenBytes);
            this.applicationData = new String(applicationDataLenBytes);
        }
        this.beginTime = byteBuffer.getLong();
        this.status = GlobalStatus.get((byte)byteBuffer.get());
    }

    public boolean hasBranch() {
        return this.getBranchSessions().size() > 0;
    }

    public void lock() throws TransactionException {
        this.globalSessionLock.lock();
    }

    public void unlock() {
        this.globalSessionLock.unlock();
    }

    public List<BranchSession> getBranchSessions() {
        this.loadBranchs();
        return this.branchSessions;
    }

    public void asyncCommit() throws TransactionException {
        this.changeGlobalStatus(GlobalStatus.AsyncCommitting);
    }

    public void queueToRetryCommit() throws TransactionException {
        this.changeGlobalStatus(GlobalStatus.CommitRetrying);
    }

    public void queueToRetryRollback() throws TransactionException {
        GlobalStatus currentStatus = this.getStatus();
        GlobalStatus newStatus = GlobalStatus.TimeoutRollbacking == currentStatus ? GlobalStatus.TimeoutRollbackRetrying : GlobalStatus.RollbackRetrying;
        this.changeGlobalStatus(newStatus);
    }

    public void setExpectedStatusFromCurrent() {
        EXPECTED_STATUS_THREAD_LOCAL.set(this.status);
    }

    public void cleanExpectedStatus() {
        EXPECTED_STATUS_THREAD_LOCAL.remove();
    }

    public GlobalStatus getExpectedStatus() {
        return (GlobalStatus)EXPECTED_STATUS_THREAD_LOCAL.get();
    }

    public String toString() {
        return "GlobalSession{xid='" + this.xid + '\'' + ", transactionId=" + this.transactionId + ", status=" + this.status + ", applicationId='" + this.applicationId + '\'' + ", transactionServiceGroup='" + this.transactionServiceGroup + '\'' + ", transactionName='" + this.transactionName + '\'' + ", timeout=" + this.timeout + ", beginTime=" + this.beginTime + ", applicationData='" + this.applicationData + '\'' + ", lazyLoadBranch=" + this.lazyLoadBranch + ", active=" + this.active + ", branchSessions=" + this.branchSessions + ", globalSessionLock=" + this.globalSessionLock + ", lifecycleListeners=" + this.lifecycleListeners + '}';
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

