/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure.properties;

import org.apache.seata.common.DefaultValues;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="seata.transport")
public class TransportProperties {
    private String type = "TCP";
    private String server = "NIO";
    private boolean heartbeat = true;
    private String serialization = "seata";
    private String compressor = "none";
    private String protocol = "seata";
    private boolean enableClientBatchSendRequest = true;
    private boolean enableTmClientBatchSendRequest = false;
    private boolean enableRmClientBatchSendRequest = true;
    private boolean enableTcServerBatchSendResponse = false;
    private long rpcRmRequestTimeout = DefaultValues.DEFAULT_RPC_RM_REQUEST_TIMEOUT;
    private long rpcTmRequestTimeout = DefaultValues.DEFAULT_RPC_TM_REQUEST_TIMEOUT;
    private long rpcTcRequestTimeout = DefaultValues.DEFAULT_RPC_TC_REQUEST_TIMEOUT;

    public String getType() {
        return this.type;
    }

    public TransportProperties setType(String type) {
        this.type = type;
        return this;
    }

    public String getServer() {
        return this.server;
    }

    public TransportProperties setServer(String server) {
        this.server = server;
        return this;
    }

    public boolean isHeartbeat() {
        return this.heartbeat;
    }

    public TransportProperties setHeartbeat(boolean heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public TransportProperties setSerialization(String serialization) {
        this.serialization = serialization;
        return this;
    }

    public String getCompressor() {
        return this.compressor;
    }

    public TransportProperties setCompressor(String compressor) {
        this.compressor = compressor;
        return this;
    }

    public boolean isEnableClientBatchSendRequest() {
        return this.enableClientBatchSendRequest;
    }

    public TransportProperties setEnableClientBatchSendRequest(boolean enableClientBatchSendRequest) {
        this.enableClientBatchSendRequest = enableClientBatchSendRequest;
        return this;
    }

    public boolean isEnableTmClientBatchSendRequest() {
        return this.enableTmClientBatchSendRequest;
    }

    public TransportProperties setEnableTmClientBatchSendRequest(boolean enableTmClientBatchSendRequest) {
        this.enableTmClientBatchSendRequest = enableTmClientBatchSendRequest;
        return this;
    }

    public boolean isEnableRmClientBatchSendRequest() {
        return this.enableRmClientBatchSendRequest;
    }

    public TransportProperties setEnableRmClientBatchSendRequest(boolean enableRmClientBatchSendRequest) {
        this.enableRmClientBatchSendRequest = enableRmClientBatchSendRequest;
        return this;
    }

    public boolean isEnableTcServerBatchSendResponse() {
        return this.enableTcServerBatchSendResponse;
    }

    public void setEnableTcServerBatchSendResponse(boolean enableTcServerBatchSendResponse) {
        this.enableTcServerBatchSendResponse = enableTcServerBatchSendResponse;
    }

    public long getRpcRmRequestTimeout() {
        return this.rpcRmRequestTimeout;
    }

    public void setRpcRmRequestTimeout(long rpcRmRequestTimeout) {
        this.rpcRmRequestTimeout = rpcRmRequestTimeout;
    }

    public long getRpcTmRequestTimeout() {
        return this.rpcTmRequestTimeout;
    }

    public void setRpcTmRequestTimeout(long rpcTmRequestTimeout) {
        this.rpcTmRequestTimeout = rpcTmRequestTimeout;
    }

    public long getRpcTcRequestTimeout() {
        return this.rpcTcRequestTimeout;
    }

    public void setRpcTcRequestTimeout(long rpcTcRequestTimeout) {
        this.rpcTcRequestTimeout = rpcTcRequestTimeout;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

