/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.grpc;

import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seata.core.compressor.Compressor;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.protocol.generated.GrpcMessageProto;
import org.apache.seata.core.rpc.netty.grpc.GrpcHeaderEnum;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerServiceLoader;
import org.apache.seata.core.serializer.SerializerType;

public class GrpcEncoder
extends ChannelOutboundHandlerAdapter {
    private final AtomicBoolean headerSent = new AtomicBoolean(false);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteString dataBytes;
        if (!(msg instanceof RpcMessage)) {
            throw new UnsupportedOperationException("GrpcEncoder not support class:" + msg.getClass());
        }
        RpcMessage rpcMessage = (RpcMessage)msg;
        byte messageType = rpcMessage.getMessageType();
        Map<String, String> headMap = rpcMessage.getHeadMap();
        Object body = rpcMessage.getBody();
        int id = rpcMessage.getId();
        if (this.headerSent.compareAndSet(false, true)) {
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.add((Object)GrpcHeaderEnum.HTTP2_STATUS.header, (Object)String.valueOf(200));
            headers.add((Object)GrpcHeaderEnum.GRPC_STATUS.header, (Object)String.valueOf(0));
            headers.add((Object)GrpcHeaderEnum.GRPC_CONTENT_TYPE.header, (Object)"application/grpc");
            ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers));
        }
        if (messageType != 3 && messageType != 4) {
            Serializer serializer = SerializerServiceLoader.load(SerializerType.getByCode(SerializerType.GRPC.getCode()));
            byte[] serializedBytes = serializer.serialize(body);
            Compressor compressor = CompressorFactory.getCompressor(rpcMessage.getCompressor());
            dataBytes = ByteString.copyFrom((byte[])compressor.compress(serializedBytes));
        } else {
            dataBytes = ByteString.EMPTY;
        }
        headMap.put(GrpcHeaderEnum.CODEC_TYPE.header, String.valueOf(SerializerType.GRPC.getCode()));
        headMap.put(GrpcHeaderEnum.COMPRESS_TYPE.header, String.valueOf(rpcMessage.getCompressor()));
        GrpcMessageProto.Builder builder = GrpcMessageProto.newBuilder().putAllHeadMap(headMap).setMessageType(messageType).setId(id);
        builder.setBody(ByteString.copyFrom((byte[])dataBytes.toByteArray()));
        GrpcMessageProto grpcMessageProto = builder.build();
        byte[] bodyBytes = grpcMessageProto.toByteArray();
        if (bodyBytes != null) {
            byte[] messageWithPrefix = new byte[bodyBytes.length + 5];
            messageWithPrefix[0] = 0;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(bodyBytes.length);
            byte[] lengthBytes = buffer.array();
            System.arraycopy(lengthBytes, 0, messageWithPrefix, 1, 4);
            System.arraycopy(bodyBytes, 0, messageWithPrefix, 5, bodyBytes.length);
            ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.wrappedBuffer((byte[])messageWithPrefix)));
        }
    }
}

