/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.manager;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.seata.common.metadata.Cluster;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.metadata.namingserver.Unit;
import org.apache.seata.common.result.Result;
import org.apache.seata.common.util.HttpClientUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.namingserver.entity.bo.ClusterBO;
import org.apache.seata.namingserver.entity.bo.NamespaceBO;
import org.apache.seata.namingserver.entity.pojo.ClusterData;
import org.apache.seata.namingserver.entity.vo.monitor.ClusterVO;
import org.apache.seata.namingserver.listener.ClusterChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NamingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingManager.class);
    private final ConcurrentMap<InetSocketAddress, Long> instanceLiveTable;
    private volatile LoadingCache<String, ConcurrentMap<String, NamespaceBO>> vGroupMap;
    private final ConcurrentMap<String, ConcurrentMap<String, ClusterData>> namespaceClusterDataMap;
    @Value(value="${heartbeat.threshold:90000}")
    private int heartbeatTimeThreshold;
    @Value(value="${heartbeat.period:60000}")
    private int heartbeatCheckTimePeriod;
    protected final ScheduledExecutorService heartBeatCheckService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new CustomizableThreadFactory("heartBeatCheckExcuter"));
    @Autowired
    private ApplicationContext applicationContext;

    public NamingManager() {
        this.instanceLiveTable = new ConcurrentHashMap();
        this.namespaceClusterDataMap = new ConcurrentHashMap();
    }

    @PostConstruct
    public void init() {
        this.vGroupMap = Caffeine.newBuilder().expireAfterAccess((long)(this.heartbeatTimeThreshold + 1000), TimeUnit.MILLISECONDS).maximumSize(Integer.MAX_VALUE).removalListener((RemovalListener)new /* Unavailable Anonymous Inner Class!! */).build(k -> new ConcurrentHashMap());
        this.heartBeatCheckService.scheduleAtFixedRate(() -> {
            try {
                this.instanceHeartBeatCheck();
            }
            catch (Exception e) {
                LOGGER.error("Heart Beat Check Exception", (Throwable)e);
            }
        }, this.heartbeatCheckTimePeriod, this.heartbeatCheckTimePeriod, TimeUnit.MILLISECONDS);
    }

    public List<ClusterVO> monitorCluster(String namespace) {
        HashMap<String, ClusterVO> clusterVOHashMap = new HashMap<String, ClusterVO>();
        Map clusterDataMap = (Map)this.namespaceClusterDataMap.get(namespace);
        if (clusterDataMap != null) {
            for (Map.Entry entry : clusterDataMap.entrySet()) {
                String clusterName = (String)entry.getKey();
                ClusterData clusterData = (ClusterData)entry.getValue();
                clusterVOHashMap.put(clusterName, ClusterVO.convertFromClusterData((ClusterData)clusterData));
            }
        } else {
            LOGGER.warn("no cluster in namespace:" + namespace);
        }
        this.vGroupMap.asMap().forEach((vGroup, namespaceMap) -> {
            NamespaceBO namespaceBO = (NamespaceBO)namespaceMap.get(namespace);
            if (namespaceBO != null) {
                namespaceBO.getClusterMap().forEach((clusterName, clusterBO) -> {
                    ClusterVO clusterVO = (ClusterVO)clusterVOHashMap.get(clusterName);
                    if (clusterVO != null) {
                        clusterVO.addMapping(vGroup);
                    }
                });
            }
        });
        return new ArrayList<ClusterVO>(clusterVOHashMap.values());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<String> createGroup(String namespace, String vGroup, String clusterName, String unitName) {
        List nodeList = this.getInstances(namespace, clusterName);
        if (nodeList == null || nodeList.size() == 0) {
            LOGGER.error("no instance in cluster {}", (Object)clusterName);
            return new Result("301", "no instance in cluster" + clusterName);
        }
        Node node = (Node)nodeList.get(0);
        String controlHost = node.getControl().getHost();
        int controlPort = node.getControl().getPort();
        String httpUrl = "http://" + controlHost + ":" + controlPort + "/vgroup/v1/addVGroup?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vGroup", vGroup);
        params.put("unit", unitName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        try (CloseableHttpResponse closeableHttpResponse = HttpClientUtil.doGet((String)httpUrl, params, header, (int)3000);){
            if (closeableHttpResponse == null || closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                Result result = new Result(String.valueOf(closeableHttpResponse.getStatusLine().getStatusCode()), "add vGroup in new cluster failed");
                return result;
            }
            LOGGER.info("namespace: {} add vGroup: {} in new cluster: {} successfully!", new Object[]{namespace, vGroup, clusterName});
            return new Result("200", "add vGroup successfully!");
        }
        catch (IOException e) {
            LOGGER.warn("add vGroup in new cluster failed");
            return new Result("500", "add vGroup in new cluster failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<String> removeGroup(Unit unit, String vGroup, String clusterName, String namespace, String unitName) {
        if (unit == null) return new Result("200", "remove group in old cluster successfully!");
        if (CollectionUtils.isEmpty((Collection)unit.getNamingInstanceList())) return new Result("200", "remove group in old cluster successfully!");
        Node node = (Node)unit.getNamingInstanceList().get(0);
        String httpUrl = "http://" + node.getControl().getHost() + ":" + node.getControl().getPort() + "/vgroup/v1/removeVGroup?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vGroup", vGroup);
        params.put("unit", unitName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        try (CloseableHttpResponse closeableHttpResponse = HttpClientUtil.doGet((String)httpUrl, params, header, (int)3000);){
            if (closeableHttpResponse == null || closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                LOGGER.warn("remove vGroup in old cluster failed");
                Result result = new Result(String.valueOf(closeableHttpResponse.getStatusLine().getStatusCode()), "removing vGroup " + vGroup + " in old cluster " + clusterName + " failed");
                return result;
            }
            LOGGER.info("namespace: {} remove vGroup: {} in new cluster: {} successfully!", new Object[]{namespace, vGroup, clusterName});
            return new Result("200", "remove group in old cluster successfully!");
        }
        catch (IOException e) {
            LOGGER.warn("handle removing vGroup in old cluster failed");
            return new Result("500", "handle removing vGroup " + vGroup + " in old cluster " + clusterName + " failed");
        }
    }

    public boolean addGroup(String namespace, String clusterName, String unitName, String vGroup) {
        try {
            ClusterBO clusterBO = ((ConcurrentMap)this.vGroupMap.get((Object)vGroup, k -> new ConcurrentHashMap())).computeIfAbsent(namespace, k -> new NamespaceBO()).getCluster(clusterName);
            if (clusterBO != null) {
                boolean needNotify = !clusterBO.getUnitNames().contains(unitName);
                NamespaceBO namespaceBO = (NamespaceBO)((ConcurrentMap)this.vGroupMap.getIfPresent((Object)vGroup)).get(namespace);
                namespaceBO.removeOldCluster(clusterName);
                if (needNotify) {
                    clusterBO.addUnit(unitName);
                }
                return needNotify;
            }
        }
        catch (Exception e) {
            LOGGER.error("change vGroup mapping failed:{}", (Object)vGroup, (Object)e);
        }
        return false;
    }

    public void notifyClusterChange(String vGroup, String namespace, String clusterName, String unitName, long term) {
        Optional.ofNullable(this.vGroupMap.asMap().get(vGroup)).flatMap(map -> Optional.ofNullable(map.get(namespace)).flatMap(namespaceBO -> Optional.ofNullable(namespaceBO.getCluster(clusterName)))).ifPresent(clusterBO -> this.applicationContext.publishEvent((ApplicationEvent)new ClusterChangeEvent((Object)this, vGroup, term)));
    }

    public boolean registerInstance(NamingServerNode node, String namespace, String clusterName, String unitName) {
        try {
            Map vGroups;
            Map clusterDataHashMap = this.namespaceClusterDataMap.computeIfAbsent(namespace, k -> new ConcurrentHashMap());
            ClusterData clusterData = clusterDataHashMap.computeIfAbsent(clusterName, key -> new ClusterData(clusterName, (String)node.getMetadata().get("cluster-type")));
            boolean hasChanged = clusterData.registerInstance(node, unitName);
            Object mappingObj = node.getMetadata().get("vGroup");
            if (mappingObj instanceof Map && !CollectionUtils.isEmpty((Map)(vGroups = (Map)mappingObj))) {
                vGroups.forEach((k, v) -> {
                    boolean changed = this.addGroup(namespace, clusterName, StringUtils.isBlank((String)v) ? unitName : v, k);
                    if (hasChanged || changed) {
                        this.notifyClusterChange(k, namespace, clusterName, unitName, node.getTerm());
                    }
                });
            }
            this.instanceLiveTable.put(new InetSocketAddress(node.getTransaction().getHost(), node.getTransaction().getPort()), System.currentTimeMillis());
        }
        catch (Exception e) {
            LOGGER.error("Instance registered failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean unregisterInstance(String namespace, String clusterName, String unitName, NamingServerNode node) {
        try {
            ClusterData clusterData;
            Map clusterMap = (Map)this.namespaceClusterDataMap.get(namespace);
            if (clusterMap != null && (clusterData = (ClusterData)clusterMap.get(clusterName)).getUnitData() != null && clusterData.getUnitData().containsKey(unitName)) {
                clusterData.removeInstance((Node)node, unitName);
                Object vgroupMap = node.getMetadata().get("vGroup");
                if (vgroupMap instanceof Map) {
                    ((Map)vgroupMap).forEach((group, realUnitName) -> {
                        ((NamespaceBO)((ConcurrentMap)this.vGroupMap.get(group, k -> new ConcurrentHashMap())).get(namespace)).getCluster(clusterName).remove(realUnitName == null ? unitName : (String)realUnitName);
                        this.notifyClusterChange(group, namespace, clusterName, unitName, node.getTerm());
                    });
                }
                this.instanceLiveTable.remove(new InetSocketAddress(node.getTransaction().getHost(), node.getTransaction().getPort()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Instance unregistered failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    public List<Cluster> getClusterListByVgroup(String vGroup, String namespace) {
        HashMap concurrentVgroupMap = new HashMap(this.vGroupMap.asMap());
        ConcurrentMap vgroupNamespaceMap = (ConcurrentMap)concurrentVgroupMap.get(vGroup);
        ArrayList<Cluster> clusterList = new ArrayList<Cluster>();
        if (!CollectionUtils.isEmpty((Map)vgroupNamespaceMap)) {
            NamespaceBO namespaceBO = (NamespaceBO)vgroupNamespaceMap.get(namespace);
            ConcurrentMap clusterDataMap = (ConcurrentMap)this.namespaceClusterDataMap.get(namespace);
            if (namespaceBO != null && !CollectionUtils.isEmpty((Map)clusterDataMap)) {
                clusterList.addAll(namespaceBO.getCluster(clusterDataMap));
            }
        }
        return clusterList;
    }

    public List<Node> getInstances(String namespace, String clusterName) {
        Map clusterDataHashMap = (Map)this.namespaceClusterDataMap.get(namespace);
        ClusterData clusterData = (ClusterData)clusterDataHashMap.get(clusterName);
        if (clusterData == null) {
            LOGGER.warn("no instances in {} : {}", (Object)namespace, (Object)clusterName);
            return Collections.emptyList();
        }
        return clusterData.getInstanceList();
    }

    public void instanceHeartBeatCheck() {
        for (String namespace : this.namespaceClusterDataMap.keySet()) {
            for (ClusterData clusterData : ((ConcurrentMap)this.namespaceClusterDataMap.get(namespace)).values()) {
                for (Unit unit : clusterData.getUnitData().values()) {
                    ArrayList<NamingServerNode> removeList = new ArrayList<NamingServerNode>();
                    for (NamingServerNode instance : unit.getNamingInstanceList()) {
                        InetSocketAddress inetSocketAddress = new InetSocketAddress(instance.getTransaction().getHost(), instance.getTransaction().getPort());
                        long lastHeatBeatTimeStamp = this.instanceLiveTable.getOrDefault(inetSocketAddress, 0L);
                        if (Math.abs(lastHeatBeatTimeStamp - System.currentTimeMillis()) <= (long)this.heartbeatTimeThreshold) continue;
                        this.instanceLiveTable.remove(inetSocketAddress);
                        removeList.add(instance);
                    }
                    if (CollectionUtils.isEmpty(removeList)) continue;
                    unit.getNamingInstanceList().removeAll(removeList);
                    for (NamingServerNode instance : removeList) {
                        clusterData.removeInstance((Node)instance, unit.getUnitName());
                        Object vgoupMap = instance.getMetadata().get("vGroup");
                        if (vgoupMap instanceof Map) {
                            ((Map)vgoupMap).forEach((group, unitName) -> {
                                ClusterBO clusterBO = ((ConcurrentMap)this.vGroupMap.get(group)).computeIfAbsent(namespace, k -> new NamespaceBO()).getCluster(clusterData.getClusterName());
                                Set units = clusterBO.getUnitNames();
                                if (units != null) {
                                    units.remove(unitName == null ? instance.getUnit() : unitName);
                                    this.notifyClusterChange(group, namespace, clusterData.getClusterName(), unit.getUnitName(), -1L);
                                }
                            });
                        }
                        LOGGER.warn("{} instance has gone offline", (Object)(instance.getTransaction().getHost() + ":" + instance.getTransaction().getPort()));
                    }
                }
            }
        }
    }

    public Result<String> changeGroup(String namespace, String vGroup, String clusterName, String unitName) {
        long changeTime = System.currentTimeMillis();
        ConcurrentHashMap namespaceMap = new ConcurrentHashMap((Map)this.vGroupMap.get((Object)vGroup));
        Set currentNamespaces = namespaceMap.keySet();
        HashMap<String, Set> namespaceClusters = new HashMap<String, Set>();
        for (String currentNamespace : currentNamespaces) {
            namespaceClusters.put(currentNamespace, new HashSet(((NamespaceBO)namespaceMap.get(currentNamespace)).getClusterMap().keySet()));
        }
        Result res = this.createGroup(namespace, vGroup, clusterName, unitName);
        if (!res.isSuccess()) {
            LOGGER.error("add vgroup failed!" + res.getMessage());
            return res;
        }
        AtomicReference result = new AtomicReference();
        namespaceClusters.forEach((oldNamespace, clusters) -> {
            for (String cluster : clusters) {
                Optional.ofNullable(this.namespaceClusterDataMap.get(oldNamespace)).flatMap(map -> Optional.ofNullable(map.get(cluster))).ifPresent(clusterData -> {
                    Optional optionalEntry;
                    if (!CollectionUtils.isEmpty((Map)clusterData.getUnitData()) && (optionalEntry = clusterData.getUnitData().entrySet().stream().findFirst()).isPresent()) {
                        String unit = (String)((Map.Entry)optionalEntry.get()).getKey();
                        Unit unitData = (Unit)((Map.Entry)optionalEntry.get()).getValue();
                        result.set(this.removeGroup(unitData, vGroup, cluster, oldNamespace, unitName));
                        this.notifyClusterChange(vGroup, namespace, cluster, unit, changeTime);
                    }
                });
            }
        });
        return Optional.ofNullable(result.get()).orElseGet(() -> new Result("200", "change vGroup successfully!"));
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

