/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.transaction.saga;

import io.netty.channel.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.exception.GlobalTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.protocol.transaction.BranchCommitRequest;
import org.apache.seata.core.protocol.transaction.BranchCommitResponse;
import org.apache.seata.core.protocol.transaction.BranchRollbackRequest;
import org.apache.seata.core.protocol.transaction.BranchRollbackResponse;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.netty.ChannelManager;
import org.apache.seata.server.coordinator.AbstractCore;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHelper;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.transaction.saga.SagaCore;

public class SagaCore
extends AbstractCore {
    public SagaCore(RemotingServer remotingServer) {
        super(remotingServer);
    }

    public BranchType getHandleBranchType() {
        return BranchType.SAGA;
    }

    public void globalSessionStatusCheck(GlobalSession globalSession) throws GlobalTransactionException {
    }

    public BranchStatus branchCommitSend(BranchCommitRequest request, GlobalSession globalSession, BranchSession branchSession) throws IOException, TimeoutException {
        Map channels = ChannelManager.getRmChannels();
        if (CollectionUtils.isEmpty((Map)channels)) {
            LOGGER.error("Failed to commit SAGA global[" + globalSession.getXid() + ", RM channels is empty.");
            return BranchStatus.PhaseTwo_CommitFailed_Retryable;
        }
        String sagaResourceId = this.getSagaResourceId(globalSession);
        Channel sagaChannel = (Channel)channels.get(sagaResourceId);
        if (sagaChannel == null) {
            LOGGER.error("Failed to commit SAGA global[" + globalSession.getXid() + ", cannot find channel by resourceId[" + sagaResourceId + "]");
            return BranchStatus.PhaseTwo_CommitFailed_Retryable;
        }
        BranchCommitResponse response = (BranchCommitResponse)this.remotingServer.sendSyncRequest(sagaChannel, (Object)request);
        return response.getBranchStatus();
    }

    public BranchStatus branchRollbackSend(BranchRollbackRequest request, GlobalSession globalSession, BranchSession branchSession) throws IOException, TimeoutException {
        Map channels = ChannelManager.getRmChannels();
        if (CollectionUtils.isEmpty((Map)channels)) {
            LOGGER.error("Failed to rollback SAGA global[" + globalSession.getXid() + ", RM channels is empty.");
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
        String sagaResourceId = this.getSagaResourceId(globalSession);
        Channel sagaChannel = (Channel)channels.get(sagaResourceId);
        if (sagaChannel == null) {
            LOGGER.error("Failed to rollback SAGA global[" + globalSession.getXid() + ", cannot find channel by resourceId[" + sagaResourceId + "]");
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
        BranchRollbackResponse response = (BranchRollbackResponse)this.remotingServer.sendSyncRequest(sagaChannel, (Object)request);
        return response.getBranchStatus();
    }

    public boolean doGlobalCommit(GlobalSession globalSession, boolean retrying) throws TransactionException {
        try {
            BranchStatus branchStatus = this.branchCommit(globalSession, SessionHelper.newBranch((BranchType)BranchType.SAGA, (String)globalSession.getXid(), (long)-1L, (String)this.getSagaResourceId(globalSession), (String)globalSession.getStatus().name()));
            switch (1.$SwitchMap$org$apache$seata$core$model$BranchStatus[branchStatus.ordinal()]) {
                case 1: {
                    SessionHelper.removeAllBranch((GlobalSession)globalSession, (!retrying ? 1 : 0) != 0);
                    LOGGER.info("Successfully committed SAGA global[" + globalSession.getXid() + "]");
                    break;
                }
                case 2: {
                    LOGGER.info("Successfully rollbacked SAGA global[" + globalSession.getXid() + "]");
                    SessionHelper.removeAllBranch((GlobalSession)globalSession, (!retrying ? 1 : 0) != 0);
                    SessionHelper.endRollbacked((GlobalSession)globalSession, (boolean)retrying);
                    return false;
                }
                case 3: {
                    LOGGER.error("By [{}], failed to rollback SAGA global [{}], will retry later.", (Object)branchStatus, (Object)globalSession.getXid());
                    SessionHolder.getRootSessionManager().removeGlobalSession(globalSession);
                    globalSession.queueToRetryRollback();
                    return false;
                }
                case 4: {
                    LOGGER.error("By [{}], finish SAGA global [{}]", (Object)branchStatus, (Object)globalSession.getXid());
                    SessionHelper.removeAllBranch((GlobalSession)globalSession, (!retrying ? 1 : 0) != 0);
                    globalSession.changeGlobalStatus(GlobalStatus.Finished);
                    globalSession.end();
                    return false;
                }
                case 5: {
                    if (globalSession.canBeCommittedAsync()) {
                        LOGGER.error("By [{}], failed to commit SAGA global [{}]", (Object)branchStatus, (Object)globalSession.getXid());
                        break;
                    }
                    SessionHelper.endCommitFailed((GlobalSession)globalSession, (boolean)retrying);
                    LOGGER.error("Finally, failed to commit SAGA global[{}]", (Object)globalSession.getXid());
                    return false;
                }
                default: {
                    if (!retrying) {
                        globalSession.queueToRetryCommit();
                    } else {
                        LOGGER.error("Failed to commit SAGA global[{}], will retry later.", (Object)globalSession.getXid());
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to commit global[" + globalSession.getXid() + "]", (Throwable)ex);
            if (!retrying) {
                globalSession.queueToRetryRollback();
            }
            throw new TransactionException((Throwable)ex);
        }
        return true;
    }

    public boolean doGlobalRollback(GlobalSession globalSession, boolean retrying) throws TransactionException {
        try {
            BranchStatus branchStatus = this.branchRollback(globalSession, SessionHelper.newBranch((BranchType)BranchType.SAGA, (String)globalSession.getXid(), (long)-1L, (String)this.getSagaResourceId(globalSession), (String)globalSession.getStatus().name()));
            switch (1.$SwitchMap$org$apache$seata$core$model$BranchStatus[branchStatus.ordinal()]) {
                case 2: {
                    SessionHelper.removeAllBranch((GlobalSession)globalSession, (!retrying ? 1 : 0) != 0);
                    LOGGER.info("Successfully rollbacked SAGA global[{}]", (Object)globalSession.getXid());
                    break;
                }
                case 6: {
                    SessionHelper.endRollbackFailed((GlobalSession)globalSession, (boolean)retrying);
                    LOGGER.error("Failed to rollback SAGA global[{}]", (Object)globalSession.getXid());
                    return false;
                }
                case 7: {
                    SessionHolder.getRootSessionManager().removeGlobalSession(globalSession);
                    globalSession.queueToRetryCommit();
                    LOGGER.warn("Retry by custom recover strategy [Forward] on timeout, SAGA global[{}]", (Object)globalSession.getXid());
                    return false;
                }
                default: {
                    LOGGER.error("Failed to rollback SAGA global[{}]", (Object)globalSession.getXid());
                    if (!retrying) {
                        globalSession.queueToRetryRollback();
                    }
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to rollback global[{}]", (Object)globalSession.getXid(), (Object)ex);
            if (!retrying) {
                globalSession.queueToRetryRollback();
            }
            throw new TransactionException((Throwable)ex);
        }
        return true;
    }

    public void doGlobalReport(GlobalSession globalSession, String xid, GlobalStatus globalStatus) throws TransactionException {
        if (GlobalStatus.Committed.equals((Object)globalStatus)) {
            SessionHelper.removeAllBranch((GlobalSession)globalSession, (boolean)false);
            SessionHelper.endCommitted((GlobalSession)globalSession, (boolean)false);
            LOGGER.info("Global[{}] committed", (Object)globalSession.getXid());
        } else if (GlobalStatus.Rollbacked.equals((Object)globalStatus) || GlobalStatus.Finished.equals((Object)globalStatus)) {
            SessionHelper.removeAllBranch((GlobalSession)globalSession, (boolean)false);
            SessionHelper.endRollbacked((GlobalSession)globalSession, (boolean)false);
            LOGGER.info("Global[{}] rollbacked", (Object)globalSession.getXid());
        } else {
            globalSession.changeGlobalStatus(globalStatus);
            LOGGER.info("Global[{}] reporting is successfully done. status[{}]", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            if (GlobalStatus.RollbackRetrying.equals((Object)globalStatus) || GlobalStatus.TimeoutRollbackRetrying.equals((Object)globalStatus) || GlobalStatus.UnKnown.equals((Object)globalStatus)) {
                globalSession.queueToRetryRollback();
                LOGGER.info("Global[{}] will retry rollback", (Object)globalSession.getXid());
            } else if (GlobalStatus.CommitRetrying.equals((Object)globalStatus)) {
                globalSession.queueToRetryCommit();
                LOGGER.info("Global[{}] will retry commit", (Object)globalSession.getXid());
            }
        }
    }

    private String getSagaResourceId(GlobalSession globalSession) {
        return globalSession.getApplicationId() + "#" + globalSession.getTransactionServiceGroup();
    }
}

