/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.store;

import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.store.db.AbstractDataSourceProvider;

@LoadLevel(name="dbcp")
public class DbcpDataSourceProvider
extends AbstractDataSourceProvider {
    public DataSource doGenerate() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(this.getDriverClassName());
        ds.setDriverClassLoader(this.getDriverClassLoader());
        ds.setUrl(this.getUrl());
        ds.setUsername(this.getUser());
        ds.setPassword(this.getPassword());
        ds.setInitialSize(this.getMinConn());
        ds.setMaxTotal(this.getMaxConn());
        ds.setMinIdle(this.getMinConn());
        ds.setMaxIdle(this.getMinConn());
        ds.setMaxWaitMillis(this.getMaxWait().longValue());
        ds.setTimeBetweenEvictionRunsMillis(120000L);
        ds.setNumTestsPerEvictionRun(1);
        ds.setTestWhileIdle(true);
        ds.setValidationQuery(this.getValidationQuery(this.getDBType()));
        ds.setConnectionProperties("useUnicode=yes;characterEncoding=utf8;socketTimeout=5000;connectTimeout=500");
        ds.setDefaultTransactionIsolation(2);
        return ds;
    }
}

