/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.exception.RedisException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.metadata.namingserver.Instance;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.apache.seata.server.store.VGroupMappingStoreManager;
import redis.clients.jedis.Jedis;

@LoadLevel(name="redis")
public class RedisVGroupMappingStoreManager
implements VGroupMappingStoreManager {
    private static final String REDIS_PREFIX = "SEATA_NAMINGSERVER_NAMESPACE_";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addVGroup(MappingDO mappingDO) {
        String vGroup = mappingDO.getVGroup();
        String namespace = REDIS_PREFIX + mappingDO.getNamespace();
        String clusterName = mappingDO.getCluster();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            jedis.hset(namespace, vGroup, clusterName);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeVGroup(String vGroup) {
        Instance instance = Instance.getInstance();
        String namespace = REDIS_PREFIX + instance.getNamespace();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String currentVgroup = jedis.hget(namespace, vGroup);
            if (StringUtils.equalsIgnoreCase((String)currentVgroup, (String)instance.getClusterName())) {
                jedis.hdel(namespace, new String[]{vGroup});
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, Object> loadVGroups() {
        Instance instance = Instance.getInstance();
        String namespace = REDIS_PREFIX + instance.getNamespace();
        String clusterName = instance.getClusterName();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map mappingKeyMap = jedis.hgetAll(namespace);
            HashMap<String, Object> result = new HashMap<String, Object>();
            mappingKeyMap.forEach((vgroup, clusterNameValue) -> {
                if (StringUtils.equals((String)clusterName, (String)clusterNameValue)) {
                    result.put((String)vgroup, null);
                }
            });
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }
}

