/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.raft.session;

import com.alipay.sofa.jraft.Closure;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.core.store.GlobalTransactionDO;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftGlobalSessionSyncMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftSyncMsgType;
import org.apache.seata.server.cluster.raft.sync.msg.dto.BranchTransactionDTO;
import org.apache.seata.server.cluster.raft.sync.msg.dto.GlobalTransactionDTO;
import org.apache.seata.server.cluster.raft.util.RaftTaskUtil;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.storage.SessionConverter;
import org.apache.seata.server.storage.file.session.FileSessionManager;
import org.apache.seata.server.store.SessionStorable;

@LoadLevel(name="raft", scope=Scope.PROTOTYPE)
public class RaftSessionManager
extends FileSessionManager {
    public RaftSessionManager(String name) throws IOException {
        super(name);
    }

    public void addGlobalSession(GlobalSession globalSession) throws TransactionException {
        super.addGlobalSession(globalSession);
    }

    public GlobalSession findGlobalSession(String xid) {
        return super.findGlobalSession(xid);
    }

    public void onBegin(GlobalSession globalSession) throws TransactionException {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = status -> {
            if (status.isOk()) {
                try {
                    super.addGlobalSession(globalSession);
                    completableFuture.complete(true);
                }
                catch (TransactionException e) {
                    completableFuture.completeExceptionally(e);
                }
            } else {
                try {
                    completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + status.getErrorMsg()));
                }
                finally {
                    try {
                        super.removeGlobalSession(globalSession);
                    }
                    catch (TransactionException e) {
                        completableFuture.completeExceptionally(e);
                    }
                }
            }
        };
        GlobalTransactionDTO globalTransactionDTO = new GlobalTransactionDTO();
        SessionConverter.convertGlobalTransactionDO((GlobalTransactionDO)globalTransactionDTO, (SessionStorable)globalSession);
        RaftGlobalSessionSyncMsg raftSyncMsg = new RaftGlobalSessionSyncMsg(RaftSyncMsgType.ADD_GLOBAL_SESSION, globalTransactionDTO);
        RaftTaskUtil.createTask((Closure)closure, (Object)raftSyncMsg, completableFuture);
    }

    public void onStatusChange(GlobalSession globalSession, GlobalStatus globalStatus) throws TransactionException {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = closureStatus -> {
            if (closureStatus.isOk()) {
                globalSession.setStatus(globalStatus);
                if (GlobalStatus.RollbackRetrying.equals((Object)globalSession.getStatus()) || GlobalStatus.Rollbacking.equals((Object)globalSession.getStatus()) || GlobalStatus.TimeoutRollbacking.equals((Object)globalSession.getStatus())) {
                    globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
                }
                completableFuture.complete(true);
            } else {
                completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + closureStatus.getErrorMsg()));
            }
        };
        GlobalTransactionDTO globalTransactionDO = new GlobalTransactionDTO(globalSession.getXid());
        globalTransactionDO.setStatus(globalStatus.getCode());
        RaftGlobalSessionSyncMsg raftSyncMsg = new RaftGlobalSessionSyncMsg(RaftSyncMsgType.UPDATE_GLOBAL_SESSION_STATUS, globalTransactionDO);
        RaftTaskUtil.createTask((Closure)closure, (Object)raftSyncMsg, completableFuture);
    }

    public void onBranchStatusChange(GlobalSession globalSession, BranchSession branchSession, BranchStatus branchStatus) throws TransactionException {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = closureStatus -> {
            if (closureStatus.isOk()) {
                branchSession.setStatus(branchStatus);
                completableFuture.complete(true);
            } else {
                completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + closureStatus.getErrorMsg()));
            }
        };
        BranchTransactionDTO branchTransactionDO = new BranchTransactionDTO(globalSession.getXid(), branchSession.getBranchId());
        branchTransactionDO.setStatus(branchStatus.getCode());
        RaftBranchSessionSyncMsg raftSyncMsg = new RaftBranchSessionSyncMsg(RaftSyncMsgType.UPDATE_BRANCH_SESSION_STATUS, branchTransactionDO);
        RaftTaskUtil.createTask((Closure)closure, (Object)raftSyncMsg, completableFuture);
    }

    public void onAddBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        CompletableFuture completableFuture = new CompletableFuture();
        branchSession.setStatus(BranchStatus.Registered);
        Closure closure = status -> {
            if (status.isOk()) {
                completableFuture.complete(globalSession.add(branchSession));
            } else {
                try {
                    completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + status.getErrorMsg()));
                }
                finally {
                    try {
                        globalSession.removeBranch(branchSession);
                    }
                    catch (TransactionException e) {
                        completableFuture.completeExceptionally(e);
                    }
                }
            }
        };
        BranchTransactionDTO branchTransactionDTO = new BranchTransactionDTO();
        SessionConverter.convertBranchTransaction((BranchTransactionDO)branchTransactionDTO, (SessionStorable)branchSession);
        RaftBranchSessionSyncMsg raftSyncMsg = new RaftBranchSessionSyncMsg(RaftSyncMsgType.ADD_BRANCH_SESSION, branchTransactionDTO);
        RaftTaskUtil.createTask((Closure)closure, (Object)raftSyncMsg, completableFuture);
    }

    public void onRemoveBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = closureStatus -> {
            if (closureStatus.isOk()) {
                completableFuture.complete(globalSession.remove(branchSession));
            } else {
                completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + closureStatus.getErrorMsg()));
            }
        };
        BranchTransactionDTO branchTransactionDO = new BranchTransactionDTO(globalSession.getXid(), branchSession.getBranchId());
        RaftBranchSessionSyncMsg raftSyncMsg = new RaftBranchSessionSyncMsg(RaftSyncMsgType.REMOVE_BRANCH_SESSION, branchTransactionDO);
        RaftTaskUtil.createTask((Closure)closure, (Object)raftSyncMsg, completableFuture);
    }

    public void onSuccessEnd(GlobalSession globalSession) throws TransactionException {
        CompletableFuture completableFuture = new CompletableFuture();
        Closure closure = status -> {
            if (status.isOk()) {
                try {
                    super.removeGlobalSession(globalSession);
                    completableFuture.complete(true);
                }
                catch (TransactionException e) {
                    completableFuture.completeExceptionally(e);
                }
            } else {
                completableFuture.completeExceptionally(new TransactionException(TransactionExceptionCode.NotRaftLeader, "seata raft state machine exception: " + status.getErrorMsg()));
            }
        };
        GlobalTransactionDTO globalTransactionDO = new GlobalTransactionDTO(globalSession.getXid());
        RaftGlobalSessionSyncMsg raftSyncMsg = new RaftGlobalSessionSyncMsg(RaftSyncMsgType.REMOVE_GLOBAL_SESSION, globalTransactionDO);
        RaftTaskUtil.createTask((Closure)closure, (Object)raftSyncMsg, completableFuture);
    }

    public void onFailEnd(GlobalSession globalSession) throws TransactionException {
        super.onFailEnd(globalSession);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void destroy() {
    }
}

