/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.instance;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.Instance;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.server.Server;
import org.apache.seata.server.ServerRunner;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.store.StoreConfig;
import org.apache.seata.server.store.VGroupMappingStoreManager;
import org.apache.seata.spring.boot.autoconfigure.properties.registry.RegistryNamingServerProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.registry.RegistryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component(value="serverInstance")
public class ServerInstance {
    @Resource
    private RegistryProperties registryProperties;
    protected static volatile ScheduledExecutorService EXECUTOR_SERVICE;
    @Resource
    private RegistryNamingServerProperties registryNamingServerProperties;
    private static final Logger LOGGER;

    public void serverInstanceInit() {
        if (StringUtils.equals((String)this.registryProperties.getType(), (String)"seata")) {
            VGroupMappingStoreManager vGroupMappingStoreManager = SessionHolder.getRootVGroupMappingManager();
            EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("scheduledExcuter", 1, true));
            ConfigurableEnvironment environment = (ConfigurableEnvironment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment");
            Instance instance = Instance.getInstance();
            String namespace = this.registryNamingServerProperties.getNamespace();
            instance.setNamespace(namespace);
            String clusterName = this.registryNamingServerProperties.getCluster();
            instance.setClusterName(clusterName);
            String clusterType = String.valueOf(StoreConfig.getSessionMode());
            instance.addMetadata("cluster-type", (Object)("raft".equals(clusterType) ? clusterType : "default"));
            instance.setUnit(String.valueOf(UUID.randomUUID()));
            instance.setTerm(System.currentTimeMillis());
            instance.setControl(new Node.Endpoint(NetUtil.getLocalIp((String[])new String[0]), Integer.parseInt(Objects.requireNonNull(environment.getProperty("server.port"))), "http"));
            for (PropertySource propertySource : environment.getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                    if (!propertyName.startsWith("seata.registry.metadata.")) continue;
                    instance.addMetadata(propertyName.substring("seata.registry.metadata.".length()), enumerablePropertySource.getProperty(propertyName));
                }
            }
            instance.addMetadata("vGroup", (Object)vGroupMappingStoreManager.loadVGroups());
            EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
                try {
                    vGroupMappingStoreManager.notifyMapping();
                }
                catch (Exception e) {
                    LOGGER.error("Naming server register Exception", (Throwable)e);
                }
            }, this.registryNamingServerProperties.getHeartbeatPeriod(), this.registryNamingServerProperties.getHeartbeatPeriod(), TimeUnit.MILLISECONDS);
            ServerRunner.addDisposable(EXECUTOR_SERVICE::shutdown);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(Server.class);
    }
}

