/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.PageUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.core.store.db.sql.lock.LockStoreSqlFactory;
import org.apache.seata.server.console.param.GlobalLockParam;
import org.apache.seata.server.console.service.GlobalLockService;
import org.apache.seata.server.console.vo.GlobalLockVO;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'db'.equals('${lockMode}')}")
public class GlobalLockDBServiceImpl
implements GlobalLockService {
    private String lockTable;
    private String dbType;
    private DataSource dataSource;

    public GlobalLockDBServiceImpl() {
        org.apache.seata.config.Configuration configuration = ConfigurationFactory.getInstance();
        this.lockTable = configuration.getConfig("store.db.lockTable", "lock_table");
        this.dbType = configuration.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new IllegalArgumentException("store.db.dbType should not be blank");
        }
        String dbDataSource = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)dbDataSource)) {
            throw new IllegalArgumentException("store.db.datasource should not be blank");
        }
        this.dataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)dbDataSource)).provide();
    }

    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        PageUtil.checkParam((int)param.getPageNum(), (int)param.getPageSize());
        ArrayList sqlParamList = new ArrayList();
        String whereCondition = this.getWhereConditionByParam(param, sqlParamList);
        String sourceSql = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getAllLockSql(this.lockTable, whereCondition);
        String queryLockSql = PageUtil.pageSql((String)sourceSql, (String)this.dbType, (int)param.getPageNum(), (int)param.getPageSize());
        String lockCountSql = PageUtil.countSql((String)sourceSql, (String)this.dbType);
        ArrayList<GlobalLockVO> list = new ArrayList<GlobalLockVO>();
        int count = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        PreparedStatement countPs = null;
        ResultSet rs = null;
        ResultSet countRs = null;
        try {
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(queryLockSql);
            countPs = conn.prepareStatement(lockCountSql);
            PageUtil.setObject((PreparedStatement)ps, sqlParamList);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(GlobalLockVO.convert((ResultSet)rs));
            }
            PageUtil.setObject((PreparedStatement)countPs, sqlParamList);
            countRs = countPs.executeQuery();
            if (countRs.next()) {
                count = countRs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, countRs, ps, countPs, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, countRs, ps, countPs, conn});
        return PageResult.success(list, (Integer)count, (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private String getWhereConditionByParam(GlobalLockParam param, List<Object> sqlParamList) {
        StringBuilder whereConditionBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)param.getXid())) {
            whereConditionBuilder.append(" and xid = ? ");
            sqlParamList.add(param.getXid());
        }
        if (StringUtils.isNotBlank((String)param.getTableName())) {
            whereConditionBuilder.append(" and table_name = ? ");
            sqlParamList.add(param.getTableName());
        }
        if (StringUtils.isNotBlank((String)param.getTransactionId())) {
            whereConditionBuilder.append(" and transaction_id = ? ");
            sqlParamList.add(param.getTransactionId());
        }
        if (StringUtils.isNotBlank((String)param.getBranchId())) {
            whereConditionBuilder.append(" and branch_id = ? ");
            sqlParamList.add(param.getBranchId());
        }
        if (param.getTimeStart() != null) {
            whereConditionBuilder.append(PageUtil.getTimeStartSql((String)this.dbType, (String)"gmt_create"));
            sqlParamList.add(param.getTimeStart() / 1000L);
        }
        if (param.getTimeEnd() != null) {
            whereConditionBuilder.append(PageUtil.getTimeEndSql((String)this.dbType, (String)"gmt_create"));
            sqlParamList.add(param.getTimeEnd() / 1000L);
        }
        String whereCondition = whereConditionBuilder.toString();
        return whereCondition.replaceFirst("and", "where");
    }
}

