/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.sync.msg.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.protocol.Version;

public class RaftClusterMetadata
implements Serializable {
    private static final long serialVersionUID = 6208583637662412658L;
    private Node leader;
    private List<Node> followers = new ArrayList();
    private List<Node> learner = new ArrayList();
    private long term;

    public RaftClusterMetadata() {
    }

    public RaftClusterMetadata(long term) {
        this.term = term;
    }

    public Node createNode(String host, int txPort, int internalPort, int controlPort, String group, Map<String, Object> metadata) {
        Node node = new Node();
        node.setTransaction(node.createEndpoint(host, txPort, "seata"));
        node.setControl(node.createEndpoint(host, controlPort, "http"));
        node.setGroup(group);
        node.setVersion(Version.getCurrent());
        node.setInternal(node.createEndpoint(host, internalPort, "raft"));
        Optional.ofNullable(metadata).ifPresent(arg_0 -> ((Node)node).setMetadata(arg_0));
        return node;
    }

    public Node getLeader() {
        return this.leader;
    }

    public void setLeader(Node leader) {
        this.leader = leader;
    }

    public long getTerm() {
        return this.term;
    }

    public List<Node> getFollowers() {
        return this.followers;
    }

    public void setFollowers(List<Node> followers) {
        this.followers = followers;
    }

    public List<Node> getLearner() {
        return this.learner;
    }

    public void setLearner(List<Node> learner) {
        this.learner = learner;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public String toString() {
        return StringUtils.toString((Object)this);
    }
}

