/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Service;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.exception.ConfigNotFoundException;
import org.apache.seata.discovery.registry.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRegistryServiceImpl
implements RegistryService<EventListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRegistryServiceImpl.class);
    private static final String DEFAULT_NAMESPACE = "";
    private static final String DEFAULT_CLUSTER = "default";
    private static final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private static final String DEFAULT_APPLICATION = "seata-server";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final String REGISTRY_TYPE = "nacos";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String PRO_APPLICATION_KEY = "application";
    private static final String PRO_CLIENT_APPLICATION = "clientApplication";
    private static final String PRO_GROUP_KEY = "group";
    private static final String USER_NAME = "username";
    private static final String PASSWORD = "password";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String RAM_ROLE_NAME_KEY = "ramRoleName";
    private static final String SLB_PATTERN = "slbPattern";
    private static final String CONTEXT_PATH = "contextPath";
    private static final String USE_PARSE_RULE = "false";
    private static final String PUBLIC_NAMING_ADDRESS_PREFIX = "public_";
    private static final String PUBLIC_NAMING_SERVICE_META_IP_KEY = "publicIp";
    private static final String PUBLIC_NAMING_SERVICE_META_PORT_KEY = "publicPort";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static volatile NamingService naming;
    private static final ConcurrentMap<String, List<EventListener>> LISTENER_SERVICE_MAP;
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP;
    private static volatile NacosRegistryServiceImpl instance;
    private static volatile NamingMaintainService namingMaintain;
    private static final Object LOCK_OBJ;
    private static final Pattern DEFAULT_SLB_REGISTRY_PATTERN;
    private static volatile Boolean useSLBWay;
    private String transactionServiceGroup;

    private NacosRegistryServiceImpl() {
        String configForNacosSLB = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosUrlPatternOfSLB());
        Pattern patternOfNacosRegistryForSLB = StringUtils.isBlank((String)configForNacosSLB) ? DEFAULT_SLB_REGISTRY_PATTERN : Pattern.compile(configForNacosSLB);
        useSLBWay = patternOfNacosRegistryForSLB.matcher(NacosRegistryServiceImpl.getNamingProperties().getProperty(PRO_SERVER_ADDR_KEY)).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static NacosRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new NacosRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        NacosRegistryServiceImpl.getNamingInstance().registerInstance(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), address.getAddress().getHostAddress(), address.getPort(), NacosRegistryServiceImpl.getClusterName());
    }

    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        NacosRegistryServiceImpl.getNamingInstance().deregisterInstance(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), address.getAddress().getHostAddress(), address.getPort(), NacosRegistryServiceImpl.getClusterName());
    }

    public void subscribe(String cluster, EventListener listener) throws Exception {
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        LISTENER_SERVICE_MAP.computeIfAbsent(cluster, key -> new ArrayList()).add(listener);
        NacosRegistryServiceImpl.getNamingInstance().subscribe(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), clusters, listener);
    }

    public void unsubscribe(String cluster, EventListener listener) throws Exception {
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
        if (subscribeList != null) {
            List newSubscribeList = subscribeList.stream().filter(eventListener -> !eventListener.equals(listener)).collect(Collectors.toList());
            LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
        }
        NacosRegistryServiceImpl.getNamingInstance().unsubscribe(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), clusters, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            String missingDataId = "service.vgroupMapping." + key;
            throw new ConfigNotFoundException("%s configuration item is required", new String[]{missingDataId});
        }
        if (useSLBWay.booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("look up service address of SLB by nacos");
            }
            if (!CLUSTER_ADDRESS_MAP.containsKey(PUBLIC_NAMING_ADDRESS_PREFIX + clusterName)) {
                Service service = NacosRegistryServiceImpl.getNamingMaintainInstance().queryService(DEFAULT_APPLICATION, clusterName);
                String pubnetIp = (String)service.getMetadata().get(PUBLIC_NAMING_SERVICE_META_IP_KEY);
                String pubnetPort = (String)service.getMetadata().get(PUBLIC_NAMING_SERVICE_META_PORT_KEY);
                if (StringUtils.isBlank((String)pubnetIp) || StringUtils.isBlank((String)pubnetPort)) {
                    throw new Exception("cannot find service address from nacos naming mata-data");
                }
                InetSocketAddress publicAddress = new InetSocketAddress(pubnetIp, (int)Integer.valueOf(pubnetPort));
                List<InetSocketAddress> publicAddressList = Arrays.asList(publicAddress);
                CLUSTER_ADDRESS_MAP.put(PUBLIC_NAMING_ADDRESS_PREFIX + clusterName, publicAddressList);
                return publicAddressList;
            }
            return (List)CLUSTER_ADDRESS_MAP.get(PUBLIC_NAMING_ADDRESS_PREFIX + clusterName);
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            Object object = LOCK_OBJ;
            synchronized (object) {
                if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
                    ArrayList<String> clusters = new ArrayList<String>();
                    clusters.add(clusterName);
                    List firstAllInstances = NacosRegistryServiceImpl.getNamingInstance().getAllInstances(NacosRegistryServiceImpl.getServiceName(), NacosRegistryServiceImpl.getServiceGroup(), clusters);
                    if (null != firstAllInstances) {
                        List newAddressList = firstAllInstances.stream().filter(eachInstance -> eachInstance.isEnabled() && eachInstance.isHealthy()).map(eachInstance -> new InetSocketAddress(eachInstance.getIp(), eachInstance.getPort())).collect(Collectors.toList());
                        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                    }
                    this.subscribe(clusterName, event -> {
                        List instances = ((NamingEvent)event).getInstances();
                        if (CollectionUtils.isEmpty((Collection)instances) && null != CLUSTER_ADDRESS_MAP.get(clusterName)) {
                            LOGGER.info("receive empty server list,cluster:{}", (Object)clusterName);
                        } else {
                            List newAddressList = instances.stream().filter(eachInstance -> eachInstance.isEnabled() && eachInstance.isHealthy()).map(eachInstance -> new InetSocketAddress(eachInstance.getIp(), eachInstance.getPort())).collect(Collectors.toList());
                            CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                            this.removeOfflineAddressesIfNecessary(this.transactionServiceGroup, clusterName, newAddressList);
                        }
                    });
                }
            }
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingService getNamingInstance() throws Exception {
        if (naming != null) return naming;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (naming != null) return naming;
            naming = NacosFactory.createNamingService((Properties)NacosRegistryServiceImpl.getNamingProperties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return naming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingMaintainService getNamingMaintainInstance() throws Exception {
        if (namingMaintain != null) return namingMaintain;
        Class<NacosRegistryServiceImpl> clazz = NacosRegistryServiceImpl.class;
        synchronized (NacosRegistryServiceImpl.class) {
            if (namingMaintain != null) return namingMaintain;
            namingMaintain = NacosFactory.createMaintainService((Properties)NacosRegistryServiceImpl.getNamingProperties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return namingMaintain;
        }
    }

    private static Properties getNamingProperties() {
        String contextPath;
        Properties properties = new Properties();
        properties.setProperty("isUseCloudNamespaceParsing", USE_PARSE_RULE);
        properties.setProperty("isUseEndpointParsingRule", USE_PARSE_RULE);
        if (System.getProperty(PRO_SERVER_ADDR_KEY) != null) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosAddrFileKey());
            if (address != null) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (System.getProperty(PRO_NAMESPACE_KEY) != null) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosNameSpaceFileKey());
            if (namespace == null) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        if (!NacosRegistryServiceImpl.initNacosAuthProperties(properties)) {
            LOGGER.info("Nacos naming auth properties empty.");
        }
        String string = contextPath = StringUtils.isNotBlank((String)System.getProperty(CONTEXT_PATH)) ? System.getProperty(CONTEXT_PATH) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosContextPathKey());
        if (StringUtils.isNotBlank((String)contextPath)) {
            properties.setProperty(CONTEXT_PATH, contextPath);
        }
        return properties;
    }

    private static boolean initNacosAuthProperties(Properties sourceProperties) {
        String userName;
        String string = userName = StringUtils.isNotBlank((String)System.getProperty(USER_NAME)) ? System.getProperty(USER_NAME) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosUserName());
        if (StringUtils.isNotBlank((String)userName)) {
            String password;
            String string2 = password = StringUtils.isNotBlank((String)System.getProperty(PASSWORD)) ? System.getProperty(PASSWORD) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosPassword());
            if (StringUtils.isNotBlank((String)password)) {
                sourceProperties.setProperty(USER_NAME, userName);
                sourceProperties.setProperty(PASSWORD, password);
                LOGGER.info("Nacos check auth with userName/password.");
                return true;
            }
        } else {
            String ramRoleName;
            String accessKey = StringUtils.isNotBlank((String)System.getProperty(ACCESS_KEY)) ? System.getProperty(ACCESS_KEY) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosAccessKey());
            String string3 = ramRoleName = StringUtils.isNotBlank((String)System.getProperty(RAM_ROLE_NAME_KEY)) ? System.getProperty(RAM_ROLE_NAME_KEY) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosRamRoleNameKey());
            if (StringUtils.isNotBlank((String)accessKey)) {
                String secretKey;
                String string4 = secretKey = StringUtils.isNotBlank((String)System.getProperty(SECRET_KEY)) ? System.getProperty(SECRET_KEY) : FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosSecretKey());
                if (StringUtils.isNotBlank((String)secretKey)) {
                    sourceProperties.put(ACCESS_KEY, accessKey);
                    sourceProperties.put(SECRET_KEY, secretKey);
                    LOGGER.info("Nacos check auth with ak/sk.");
                    return true;
                }
            } else if (StringUtils.isNotBlank((String)ramRoleName)) {
                sourceProperties.put(RAM_ROLE_NAME_KEY, ramRoleName);
                LOGGER.info("Nacos check auth with ram role.");
                return true;
            }
        }
        return false;
    }

    private static String getClusterName() {
        return FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosClusterFileKey(), DEFAULT_CLUSTER);
    }

    private static String getServiceName() {
        return FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosApplicationFileKey(), DEFAULT_APPLICATION);
    }

    private static String getServiceGroup() {
        return FILE_CONFIG.getConfig(NacosRegistryServiceImpl.getNacosApplicationGroupKey(), DEFAULT_GROUP);
    }

    private static String getNacosAddrFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_SERVER_ADDR_KEY);
    }

    private static String getNacosNameSpaceFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_NAMESPACE_KEY);
    }

    private static String getNacosClusterFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, REGISTRY_CLUSTER);
    }

    private static String getNacosApplicationFileKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_APPLICATION_KEY);
    }

    private static String getNacosApplicationGroupKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_GROUP_KEY);
    }

    private static String getNacosUserName() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, USER_NAME);
    }

    private static String getNacosPassword() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PASSWORD);
    }

    public static String getNacosAccessKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, ACCESS_KEY);
    }

    public static String getNacosSecretKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, SECRET_KEY);
    }

    public static String getNacosRamRoleNameKey() {
        return String.join((CharSequence)".", "config", REGISTRY_TYPE, RAM_ROLE_NAME_KEY);
    }

    public static String getClientApplication() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, PRO_CLIENT_APPLICATION);
    }

    private static String getNacosUrlPatternOfSLB() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, SLB_PATTERN);
    }

    private static String getNacosContextPathKey() {
        return String.join((CharSequence)".", "registry", REGISTRY_TYPE, CONTEXT_PATH);
    }

    static {
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<EventListener>>();
        CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        LOCK_OBJ = new Object();
        DEFAULT_SLB_REGISTRY_PATTERN = Pattern.compile("(?!.*internal)(?=.*seata).*mse.aliyuncs.com");
    }
}

