/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.entity.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.common.metadata.Cluster;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.namingserver.entity.bo.ClusterBO;
import org.apache.seata.namingserver.entity.pojo.ClusterData;

public class NamespaceBO {
    Map<String, ClusterBO> clusterMap = new ConcurrentHashMap();

    public Map<String, ClusterBO> getClusterMap() {
        return this.clusterMap;
    }

    public List<Cluster> getCluster(ConcurrentMap<String, ClusterData> clusterDataMap) {
        ArrayList<Cluster> list = new ArrayList<Cluster>();
        this.clusterMap.forEach((clusterName, unitNameSet) -> {
            ClusterData clusterData = (ClusterData)clusterDataMap.get(clusterName);
            if (clusterData != null) {
                list.add(clusterData.getClusterByUnits(unitNameSet.getUnitNames()));
            }
        });
        return list;
    }

    public void setClusterMap(Map<String, ClusterBO> clusterMap) {
        this.clusterMap = clusterMap;
    }

    public ClusterBO getCluster(String clusterName) {
        return this.clusterMap.computeIfAbsent(clusterName, k -> new ClusterBO());
    }

    public void removeOldCluster(String clusterName) {
        Set clusterSet = this.clusterMap.keySet();
        if (clusterSet.size() <= 1) {
            return;
        }
        clusterSet.forEach(currentClusterName -> {
            if (!StringUtils.equals((String)currentClusterName, (String)clusterName)) {
                this.clusterMap.remove(currentClusterName);
            }
        });
    }
}

