/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.protobuf.convertor;

import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.protocol.transaction.BranchRegisterRequest;
import org.apache.seata.serializer.protobuf.convertor.PbConvertor;
import org.apache.seata.serializer.protobuf.generated.AbstractMessageProto;
import org.apache.seata.serializer.protobuf.generated.AbstractTransactionRequestProto;
import org.apache.seata.serializer.protobuf.generated.BranchRegisterRequestProto;
import org.apache.seata.serializer.protobuf.generated.BranchTypeProto;
import org.apache.seata.serializer.protobuf.generated.MessageTypeProto;

public class BranchRegisterRequestConvertor
implements PbConvertor<BranchRegisterRequest, BranchRegisterRequestProto> {
    @Override
    public BranchRegisterRequestProto convert2Proto(BranchRegisterRequest branchRegisterRequest) {
        short typeCode = branchRegisterRequest.getTypeCode();
        AbstractMessageProto abstractMessage = AbstractMessageProto.newBuilder().setMessageType(MessageTypeProto.forNumber(typeCode)).build();
        AbstractTransactionRequestProto abstractTransactionRequestProto = AbstractTransactionRequestProto.newBuilder().setAbstractMessage(abstractMessage).build();
        String applicationData = branchRegisterRequest.getApplicationData();
        String resourceId = branchRegisterRequest.getResourceId();
        String lockKey = branchRegisterRequest.getLockKey();
        BranchRegisterRequestProto result = BranchRegisterRequestProto.newBuilder().setAbstractTransactionRequest(abstractTransactionRequestProto).setApplicationData(applicationData == null ? "" : applicationData).setBranchType(BranchTypeProto.valueOf(branchRegisterRequest.getBranchType().name())).setLockKey(lockKey == null ? "" : lockKey).setResourceId(resourceId == null ? "" : resourceId).setXid(branchRegisterRequest.getXid()).build();
        return result;
    }

    @Override
    public BranchRegisterRequest convert2Model(BranchRegisterRequestProto branchRegisterRequestProto) {
        BranchRegisterRequest branchRegisterRequest = new BranchRegisterRequest();
        branchRegisterRequest.setApplicationData(branchRegisterRequestProto.getApplicationData());
        branchRegisterRequest.setBranchType(BranchType.valueOf((String)branchRegisterRequestProto.getBranchType().name()));
        branchRegisterRequest.setLockKey(branchRegisterRequestProto.getLockKey());
        branchRegisterRequest.setResourceId(branchRegisterRequestProto.getResourceId());
        branchRegisterRequest.setXid(branchRegisterRequestProto.getXid());
        return branchRegisterRequest;
    }
}

