/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.file.lock;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.exception.BranchTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.lock.AbstractLocker;
import org.apache.seata.core.lock.RowLock;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.storage.file.lock.FileLocker;

public class FileLocker
extends AbstractLocker {
    private static final int BUCKET_PER_TABLE = 128;
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, BucketLockMap>>> LOCK_MAP = new ConcurrentHashMap();
    protected BranchSession branchSession;

    public FileLocker(BranchSession branchSession) {
        this.branchSession = branchSession;
    }

    public boolean acquireLock(List<RowLock> rowLocks) {
        return this.acquireLock(rowLocks, true, false);
    }

    public boolean acquireLock(List<RowLock> rowLocks, boolean autoCommit, boolean skipCheckLock) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        String resourceId = this.branchSession.getResourceId();
        long transactionId = this.branchSession.getTransactionId();
        Map bucketHolder = this.branchSession.getLockHolder();
        Map dbLockMap = (Map)CollectionUtils.computeIfAbsent((Map)LOCK_MAP, (Object)resourceId, key -> new ConcurrentHashMap(8));
        boolean failFast = false;
        boolean canLock = true;
        for (RowLock lock : rowLocks) {
            int bucketId;
            String tableName = lock.getTableName();
            String pk = lock.getPk();
            ConcurrentMap tableLockMap = (ConcurrentMap)CollectionUtils.computeIfAbsent((Map)dbLockMap, (Object)tableName, key -> new ConcurrentHashMap(8));
            BucketLockMap bucketLockMap = (BucketLockMap)CollectionUtils.computeIfAbsent((Map)tableLockMap, (Object)(bucketId = pk.hashCode() % 128), key -> new BucketLockMap());
            BranchSession previousLockBranchSession = bucketLockMap.get().putIfAbsent(pk, this.branchSession);
            if (previousLockBranchSession == null) {
                Set keysInHolder = (Set)CollectionUtils.computeIfAbsent((Map)bucketHolder, (Object)bucketLockMap, key -> ConcurrentHashMap.newKeySet());
                keysInHolder.add(pk);
                continue;
            }
            if (previousLockBranchSession.getTransactionId() == transactionId) continue;
            LOGGER.info("Global lock on [" + tableName + ":" + pk + "] is holding by " + previousLockBranchSession.getBranchId());
            try {
                this.branchSession.unlock();
            }
            catch (TransactionException e) {
                throw new FrameworkException((Throwable)e);
            }
            if (!autoCommit && previousLockBranchSession.getLockStatus() == LockStatus.Rollbacking) {
                failFast = true;
                break;
            }
            if (!canLock) continue;
            canLock = false;
            if (!autoCommit) continue;
            break;
        }
        if (failFast) {
            throw new StoreException((Throwable)new BranchTransactionException(TransactionExceptionCode.LockKeyConflictFailFast));
        }
        return canLock;
    }

    public boolean releaseLock(List<RowLock> rowLock) {
        if (CollectionUtils.isEmpty(rowLock)) {
            return true;
        }
        Map lockHolder = this.branchSession.getLockHolder();
        if (CollectionUtils.isEmpty((Map)lockHolder)) {
            return true;
        }
        lockHolder.forEach((bucket, keys) -> {
            for (String key : keys) {
                bucket.get().remove(key, this.branchSession);
            }
        });
        lockHolder.clear();
        return true;
    }

    public boolean isLockable(List<RowLock> rowLocks) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        Long transactionId = rowLocks.get(0).getTransactionId();
        String resourceId = rowLocks.get(0).getResourceId();
        ConcurrentMap dbLockMap = (ConcurrentMap)LOCK_MAP.get(resourceId);
        if (dbLockMap == null) {
            return true;
        }
        for (RowLock rowLock : rowLocks) {
            BranchSession branchSession;
            Long lockingTransactionId;
            int bucketId;
            BucketLockMap bucketLockMap;
            String tableName = rowLock.getTableName();
            String pk = rowLock.getPk();
            ConcurrentMap tableLockMap = (ConcurrentMap)dbLockMap.get(tableName);
            if (tableLockMap == null || (bucketLockMap = (BucketLockMap)tableLockMap.get(bucketId = pk.hashCode() % 128)) == null || (lockingTransactionId = (branchSession = (BranchSession)bucketLockMap.get().get(pk)) != null ? Long.valueOf(branchSession.getTransactionId()) : null) == null || lockingTransactionId.longValue() == transactionId.longValue()) continue;
            LOGGER.info("Global lock on [" + tableName + ":" + pk + "] is holding by " + lockingTransactionId);
            return false;
        }
        return true;
    }

    public void updateLockStatus(String xid, LockStatus lockStatus) {
    }

    public void cleanAllLocks() {
        LOCK_MAP.clear();
    }
}

