/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.lock;

import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.seata.common.exception.DataAccessException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.LambdaUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.BranchTransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.core.store.LockDO;
import org.apache.seata.core.store.LockStore;
import org.apache.seata.core.store.db.sql.lock.LockStoreSqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockStoreDataBaseDAO
implements LockStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockStoreDataBaseDAO.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected DataSource lockStoreDataSource;
    protected String lockTable;
    protected String dbType;

    public LockStoreDataBaseDAO(DataSource lockStoreDataSource) {
        this.lockStoreDataSource = lockStoreDataSource;
        this.lockTable = CONFIG.getConfig("store.db.lockTable", "lock_table");
        this.dbType = CONFIG.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new StoreException("there must be db type.");
        }
        if (lockStoreDataSource == null) {
            throw new StoreException("there must be lockStoreDataSource.");
        }
    }

    public boolean acquireLock(LockDO lockDO) {
        return this.acquireLock(Collections.singletonList(lockDO));
    }

    public boolean acquireLock(List<LockDO> lockDOs) {
        return this.acquireLock(lockDOs, true, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean acquireLock(List<LockDO> lockDOs, boolean autoCommit, boolean skipCheckLock) {
        block46: {
            block45: {
                block43: {
                    block44: {
                        conn = null;
                        ps = null;
                        rs = null;
                        dbExistedRowKeys = new HashSet<String>();
                        originalAutoCommit = true;
                        if (lockDOs.size() > 1) {
                            lockDOs = lockDOs.stream().filter(LambdaUtils.distinctByKey((Function<LockDO, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRowKey(), (Lorg/apache/seata/core/store/LockDO;)Ljava/lang/Object;)())).collect(Collectors.toList());
                        }
                        conn = this.lockStoreDataSource.getConnection();
                        originalAutoCommit = conn.getAutoCommit();
                        if (originalAutoCommit) {
                            conn.setAutoCommit(false);
                        }
                        unrepeatedLockDOs /* !! */  = lockDOs;
                        if (skipCheckLock) break block43;
                        canLock = true;
                        checkLockSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getCheckLockableSql(this.lockTable, lockDOs.size());
                        ps = conn.prepareStatement(checkLockSQL);
                        for (i = 0; i < lockDOs.size(); ++i) {
                            ps.setString(i + 1, ((LockDO)lockDOs.get(i)).getRowKey());
                        }
                        rs = ps.executeQuery();
                        currentXID = ((LockDO)lockDOs.get(0)).getXid();
                        failFast = false;
                        while (rs.next()) {
                            dbXID = rs.getString("xid");
                            if (!StringUtils.equals((String)dbXID, (String)currentXID)) {
                                if (LockStoreDataBaseDAO.LOGGER.isInfoEnabled()) {
                                    dbPk = rs.getString("pk");
                                    dbTableName = rs.getString("table_name");
                                    dbBranchId = rs.getLong("branch_id");
                                    LockStoreDataBaseDAO.LOGGER.info("Global lock on [{}:{}] is holding by xid {} branchId {}", new Object[]{dbTableName, dbPk, dbXID, dbBranchId});
                                }
                                if (!autoCommit && (status = rs.getInt("status")) == LockStatus.Rollbacking.getCode()) {
                                    failFast = true;
                                }
                                canLock = false;
                                break;
                            }
                            dbExistedRowKeys.add(rs.getString("row_key"));
                        }
                        if (canLock) break block44;
                        conn.rollback();
                        if (failFast) {
                            throw new StoreException((Throwable)new BranchTransactionException(TransactionExceptionCode.LockKeyConflictFailFast));
                        }
                        var14_23 = false;
                        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                        if (conn != null) {
                            try {
                                if (originalAutoCommit) {
                                    conn.setAutoCommit(true);
                                }
                                conn.close();
                            }
                            catch (SQLException var15_27) {
                                // empty catch block
                            }
                        }
                        return var14_23;
                    }
                    if (CollectionUtils.isNotEmpty(dbExistedRowKeys)) {
                        unrepeatedLockDOs /* !! */  = lockDOs.stream().filter((Predicate<LockDO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$acquireLock$0(java.util.Set org.apache.seata.core.store.LockDO ), (Lorg/apache/seata/core/store/LockDO;)Z)(dbExistedRowKeys)).collect(Collectors.toList());
                    }
                    if (!CollectionUtils.isEmpty(unrepeatedLockDOs /* !! */ )) break block43;
                    conn.rollback();
                    var14_24 = true;
                    IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                    if (conn != null) {
                        try {
                            if (originalAutoCommit) {
                                conn.setAutoCommit(true);
                            }
                            conn.close();
                        }
                        catch (SQLException var15_28) {
                            // empty catch block
                        }
                    }
                    return var14_24;
                }
                if (unrepeatedLockDOs /* !! */ .size() != 1) ** GOTO lbl93
                lockDO = (LockDO)unrepeatedLockDOs /* !! */ .get(0);
                if (this.doAcquireLock(conn, lockDO)) break block45;
                if (LockStoreDataBaseDAO.LOGGER.isInfoEnabled()) {
                    LockStoreDataBaseDAO.LOGGER.info("Global lock acquire failed, xid {} branchId {} pk {}", new Object[]{lockDO.getXid(), lockDO.getBranchId(), lockDO.getPk()});
                }
                conn.rollback();
                var11_15 = false;
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                if (conn != null) {
                    try {
                        if (originalAutoCommit) {
                            conn.setAutoCommit(true);
                        }
                        conn.close();
                    }
                    catch (SQLException var12_20) {
                        // empty catch block
                    }
                }
                return var11_15;
            }
            break block46;
lbl93:
            // 1 sources

            if (this.doAcquireLocks(conn, unrepeatedLockDOs /* !! */ )) break block46;
            if (LockStoreDataBaseDAO.LOGGER.isInfoEnabled()) {
                LockStoreDataBaseDAO.LOGGER.info("Global lock batch acquire failed, xid {} branchId {} pks {}", new Object[]{((LockDO)unrepeatedLockDOs /* !! */ .get(0)).getXid(), ((LockDO)unrepeatedLockDOs /* !! */ .get(0)).getBranchId(), unrepeatedLockDOs /* !! */ .stream().map((Function<LockDO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$acquireLock$1(org.apache.seata.core.store.LockDO ), (Lorg/apache/seata/core/store/LockDO;)Ljava/lang/String;)()).collect(Collectors.toList())});
            }
            conn.rollback();
            var10_11 = false;
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
            if (conn != null) {
                try {
                    if (originalAutoCommit) {
                        conn.setAutoCommit(true);
                    }
                    conn.close();
                }
                catch (SQLException var11_16) {
                    // empty catch block
                }
            }
            return var10_11;
        }
        try {
            conn.commit();
            var10_13 = true;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable var19_31) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                if (conn != null) {
                    try {
                        if (originalAutoCommit) {
                            conn.setAutoCommit(true);
                        }
                        conn.close();
                    }
                    catch (SQLException var20_32) {
                        // empty catch block
                    }
                }
                throw var19_31;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        if (conn != null) {
            try {
                if (originalAutoCommit) {
                    conn.setAutoCommit(true);
                }
                conn.close();
            }
            catch (SQLException var11_17) {
                // empty catch block
            }
        }
        return var10_13;
    }

    public boolean unLock(LockDO lockDO) {
        return this.unLock(Collections.singletonList(lockDO));
    }

    public boolean unLock(List<LockDO> lockDOs) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.lockStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            String batchDeleteSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getBatchDeleteLockSql(this.lockTable, lockDOs.size());
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setString(1, lockDOs.get(0).getXid());
            for (int i = 0; i < lockDOs.size(); ++i) {
                ps.setString(i + 2, lockDOs.get(i).getRowKey());
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    public boolean unLock(String xid) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.lockStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            String batchDeleteSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getBatchDeleteLockSqlByXid(this.lockTable);
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setString(1, xid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    public boolean unLock(Long branchId) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.lockStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            String batchDeleteSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getBatchDeleteLockSqlByBranchId(this.lockTable);
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setLong(1, branchId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    public boolean isLockable(List<LockDO> lockDOs) {
        Connection conn = null;
        try {
            conn = this.lockStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            if (!this.checkLockable(conn, lockDOs)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            IOUtil.close((AutoCloseable)conn);
        }
    }

    public void updateLockStatus(String xid, LockStatus lockStatus) {
        String updateStatusLockByGlobalSql = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getBatchUpdateStatusLockByGlobalSql(this.lockTable);
        try (Connection conn = this.lockStoreDataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(updateStatusLockByGlobalSql);){
            conn.setAutoCommit(true);
            ps.setInt(1, lockStatus.getCode());
            ps.setString(2, xid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected boolean doAcquireLock(Connection conn, LockDO lockDO) {
        PreparedStatement ps = null;
        try {
            String insertLockSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getInsertLockSQL(this.lockTable);
            ps = conn.prepareStatement(insertLockSQL);
            ps.setString(1, lockDO.getXid());
            ps.setLong(2, lockDO.getTransactionId());
            ps.setLong(3, lockDO.getBranchId());
            ps.setString(4, lockDO.getResourceId());
            ps.setString(5, lockDO.getTableName());
            ps.setString(6, lockDO.getPk());
            ps.setString(7, lockDO.getRowKey());
            ps.setInt(8, LockStatus.Locked.getCode());
            boolean bl = ps.executeUpdate() > 0;
            IOUtil.close((AutoCloseable)ps);
            return bl;
        }
        catch (SQLException e) {
            block6: {
                if (!(e instanceof SQLIntegrityConstraintViolationException)) break block6;
                boolean bl = false;
                return bl;
            }
            throw new StoreException((Throwable)e);
        }
        finally {
            IOUtil.close(ps);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean doAcquireLocks(Connection conn, List<LockDO> lockDOs) throws SQLException {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String insertLockSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getInsertLockSQL(this.lockTable);
            ps = conn.prepareStatement(insertLockSQL);
            for (LockDO lockDO : lockDOs) {
                ps.setString(1, lockDO.getXid());
                ps.setLong(2, lockDO.getTransactionId());
                ps.setLong(3, lockDO.getBranchId());
                ps.setString(4, lockDO.getResourceId());
                ps.setString(5, lockDO.getTableName());
                ps.setString(6, lockDO.getPk());
                ps.setString(7, lockDO.getRowKey());
                ps.setInt(8, lockDO.getStatus());
                ps.addBatch();
            }
            bl = ps.executeBatch().length == lockDOs.size();
        }
        catch (SQLIntegrityConstraintViolationException e) {
            LOGGER.error("Global lock batch acquire error: {}", (Object)e.getMessage(), (Object)e);
            boolean bl2 = false;
            IOUtil.close((AutoCloseable)ps);
            return bl2;
        }
        catch (SQLException e2) {
            throw e2;
            {
                catch (Throwable throwable) {
                    IOUtil.close(ps);
                    throw throwable;
                }
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkLockable(Connection conn, List<LockDO> lockDOs) {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        block7: {
            boolean bl2;
            ps = null;
            rs = null;
            try {
                String checkLockSQL = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getCheckLockableSql(this.lockTable, lockDOs.size());
                ps = conn.prepareStatement(checkLockSQL);
                for (int i = 0; i < lockDOs.size(); ++i) {
                    ps.setString(i + 1, lockDOs.get(i).getRowKey());
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    String xid = rs.getString("xid");
                    if (StringUtils.equals((String)xid, (String)lockDOs.get(0).getXid())) continue;
                    bl = false;
                    break block7;
                }
                bl2 = true;
            }
            catch (SQLException e) {
                try {
                    throw new DataAccessException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
            }
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
            return bl2;
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        return bl;
    }

    public void setLockTable(String lockTable) {
        this.lockTable = lockTable;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setLogStoreDataSource(DataSource lockStoreDataSource) {
        this.lockStoreDataSource = lockStoreDataSource;
    }

    private static /* synthetic */ String lambda$acquireLock$1(LockDO lockDO) {
        return lockDO.getPk();
    }

    private static /* synthetic */ boolean lambda$acquireLock$0(Set dbExistedRowKeys, LockDO lockDO) {
        return !dbExistedRowKeys.contains(lockDO.getRowKey());
    }
}

