/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.spring.listener;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.FileConfiguration;
import org.apache.seata.config.file.FileConfig;
import org.apache.seata.server.store.StoreConfig;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=-2147483648)
public class SeataPropertiesLoader
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    List<String> prefixList = Arrays.asList("config.", "registry.", "server.", "store.", "metrics.", "transport.");

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        FileConfiguration configuration = ConfigurationFactory.getOriginFileInstanceRegistry();
        FileConfig fileConfig = configuration.getFileConfig();
        Map configs = fileConfig.getAllConfig();
        if (CollectionUtils.isNotEmpty((Map)configs)) {
            Optional originFileInstance = ConfigurationFactory.getOriginFileInstance();
            originFileInstance.ifPresent(fileConfiguration -> configs.putAll(fileConfiguration.getFileConfig().getAllConfig()));
            Properties properties = new Properties();
            configs.forEach((k, v) -> {
                if (v instanceof String && StringUtils.isEmpty((CharSequence)((String)v))) {
                    return;
                }
                if (this.prefixList.stream().anyMatch(k::startsWith)) {
                    properties.put("seata." + k, v);
                }
            });
            environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("seataOldConfig", properties));
        }
        System.setProperty("sessionMode", StoreConfig.getSessionMode().getName());
        System.setProperty("lockMode", StoreConfig.getLockMode().getName());
    }
}

