/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.session;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.seata.common.XID;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.core.store.DistributedLockDO;
import org.apache.seata.core.store.DistributedLocker;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.lock.distributed.DistributedLockerFactory;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.Reloadable;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.session.SessionHelper;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.session.SessionManager;
import org.apache.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionHolder.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    public static final String ROOT_SESSION_MANAGER_NAME = "root.data";
    private static long DISTRIBUTED_LOCK_EXPIRE_TIME = CONFIG.getLong("server.distributedLockExpireTime", 10000L);
    private static SessionManager ROOT_SESSION_MANAGER;
    private static volatile Map<String, SessionManager> SESSION_MANAGER_MAP;
    private static DistributedLocker DISTRIBUTED_LOCKER;

    public static void init() {
        SessionHolder.init(null);
    }

    public static void init(StoreConfig.SessionMode sessionMode) {
        if (null == sessionMode) {
            sessionMode = StoreConfig.getSessionMode();
        }
        LOGGER.info("use session store mode: {}", (Object)sessionMode.getName());
        DISTRIBUTED_LOCKER = DistributedLockerFactory.getDistributedLocker((String)sessionMode.getName());
        if (StoreConfig.SessionMode.DB.equals((Object)sessionMode)) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.DB.getName());
            SessionHolder.reload((StoreConfig.SessionMode)sessionMode);
        } else if (StoreConfig.SessionMode.RAFT.equals((Object)sessionMode) || StoreConfig.SessionMode.FILE.equals((Object)sessionMode)) {
            RaftServerManager.init();
            if (CollectionUtils.isNotEmpty((Collection)RaftServerManager.getRaftServers())) {
                sessionMode = StoreConfig.SessionMode.RAFT;
            }
            if (StoreConfig.SessionMode.RAFT.equals((Object)sessionMode)) {
                String group = CONFIG.getConfig("server.raft.group", "default");
                ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.RAFT.getName(), (Object[])new Object[]{"root.data"});
                SESSION_MANAGER_MAP = new HashMap();
                SESSION_MANAGER_MAP.put(group, ROOT_SESSION_MANAGER);
                RaftServerManager.start();
            } else {
                String sessionStorePath = CONFIG.getConfig("store.file.dir", "sessionStore") + File.separator + System.getProperty("server.servicePort");
                if (StringUtils.isBlank((String)sessionStorePath)) {
                    throw new StoreException("the {store.file.dir} is empty.");
                }
                ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.FILE.getName(), (Object[])new Object[]{"root.data", sessionStorePath});
                SessionHolder.reload((StoreConfig.SessionMode)sessionMode);
            }
        } else if (StoreConfig.SessionMode.REDIS.equals((Object)sessionMode)) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.REDIS.getName());
            SessionHolder.reload((StoreConfig.SessionMode)sessionMode);
        } else {
            throw new IllegalArgumentException("unknown store mode:" + sessionMode.getName());
        }
    }

    protected static void reload(StoreConfig.SessionMode sessionMode) {
        if (sessionMode == StoreConfig.SessionMode.FILE) {
            ((Reloadable)ROOT_SESSION_MANAGER).reload();
            SessionHolder.reload((Collection)ROOT_SESSION_MANAGER.allSessions(), (StoreConfig.SessionMode)sessionMode);
        } else {
            SessionHolder.reload(null, (StoreConfig.SessionMode)sessionMode);
        }
    }

    public static void reload(Collection<GlobalSession> allSessions, StoreConfig.SessionMode storeMode) {
        SessionHolder.reload(allSessions, (StoreConfig.SessionMode)storeMode, (boolean)true);
    }

    public static void reload(Collection<GlobalSession> allSessions, StoreConfig.SessionMode storeMode, boolean acquireLock) {
        if ((StoreConfig.SessionMode.FILE == storeMode || StoreConfig.SessionMode.RAFT == storeMode) && CollectionUtils.isNotEmpty(allSessions)) {
            block18: for (GlobalSession globalSession : allSessions) {
                GlobalStatus globalStatus = globalSession.getStatus();
                switch (1.$SwitchMap$org$apache$seata$core$model$GlobalStatus[globalStatus.ordinal()]) {
                    case 6: 
                    case 7: {
                        try {
                            SessionHelper.endRollbacked((GlobalSession)globalSession, (boolean)true);
                        }
                        catch (TransactionException e) {
                            LOGGER.error("Could not handle the global session, xid: {},error: {}", (Object)globalSession.getXid(), (Object)e.getMessage());
                        }
                        continue block18;
                    }
                    case 8: {
                        try {
                            SessionHelper.endCommitted((GlobalSession)globalSession, (boolean)true);
                        }
                        catch (TransactionException e) {
                            LOGGER.error("Could not handle the global session, xid: {},error: {}", (Object)globalSession.getXid(), (Object)e.getMessage());
                        }
                        continue block18;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        SessionHolder.removeInErrorState((GlobalSession)globalSession);
                        continue block18;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        if (!Objects.equals(StoreConfig.SessionMode.RAFT, storeMode)) continue block18;
                        try {
                            globalSession.clean();
                            continue block18;
                        }
                        catch (TransactionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (acquireLock) {
                    SessionHolder.lockBranchSessions((List)globalSession.getSortedBranches());
                    if (GlobalStatus.Rollbacking.equals((Object)globalSession.getStatus()) || GlobalStatus.TimeoutRollbacking.equals((Object)globalSession.getStatus())) {
                        globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
                    }
                }
                switch (1.$SwitchMap$org$apache$seata$core$model$GlobalStatus[globalStatus.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        continue block18;
                    }
                    case 5: {
                        if (Objects.equals(storeMode, StoreConfig.SessionMode.RAFT)) {
                            try {
                                globalSession.changeGlobalStatus(GlobalStatus.RollbackRetrying);
                                LOGGER.info("change global status: {}, xid: {}", (Object)globalSession.getStatus(), (Object)globalSession.getXid());
                            }
                            catch (TransactionException e) {
                                LOGGER.error("change global status fail: {}", (Object)e.getMessage(), (Object)e);
                            }
                            continue block18;
                        }
                        globalSession.setActive(true);
                        continue block18;
                    }
                }
                LOGGER.error("Could not handle the global session, xid: {}", (Object)globalSession.getXid());
                throw new ShouldNeverHappenException("NOT properly handled " + globalStatus);
            }
        } else {
            CompletableFuture.runAsync(() -> {
                SessionCondition searchCondition = new SessionCondition(new GlobalStatus[]{GlobalStatus.UnKnown, GlobalStatus.Committed, GlobalStatus.Rollbacked, GlobalStatus.TimeoutRollbacked, GlobalStatus.Finished});
                searchCondition.setLazyLoadBranch(true);
                long now = System.currentTimeMillis();
                List errorStatusGlobalSessions = ROOT_SESSION_MANAGER.findGlobalSessions(searchCondition);
                while (!CollectionUtils.isEmpty((Collection)errorStatusGlobalSessions)) {
                    for (GlobalSession errorStatusGlobalSession : errorStatusGlobalSessions) {
                        if (errorStatusGlobalSession.getBeginTime() >= now) {
                            return;
                        }
                        SessionHolder.removeInErrorState((GlobalSession)errorStatusGlobalSession);
                    }
                    errorStatusGlobalSessions = ROOT_SESSION_MANAGER.findGlobalSessions(searchCondition);
                }
            });
        }
    }

    private static void removeInErrorState(GlobalSession globalSession) {
        try {
            LOGGER.warn("The global session should NOT be {}, remove it. xid = {}", (Object)globalSession.getStatus(), (Object)globalSession.getXid());
            SessionHolder.getRootSessionManager().removeGlobalSession(globalSession);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Remove global session succeed, xid = {}, status = {}", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            }
        }
        catch (Exception e) {
            LOGGER.error("Remove global session failed, xid = {}, status = {}", new Object[]{globalSession.getXid(), globalSession.getStatus(), e});
        }
    }

    private static void lockBranchSessions(List<BranchSession> branchSessions) {
        branchSessions.forEach(branchSession -> {
            try {
                branchSession.lock();
            }
            catch (TransactionException e) {
                throw new ShouldNeverHappenException((Throwable)e);
            }
        });
    }

    public static SessionManager getRootSessionManager() {
        String group = SeataClusterContext.getGroup();
        return SessionHolder.getRootSessionManager((String)group);
    }

    public static SessionManager getRootSessionManager(String group) {
        return StringUtils.isNotBlank((String)group) && SESSION_MANAGER_MAP != null ? SESSION_MANAGER_MAP.computeIfAbsent(group, k -> ROOT_SESSION_MANAGER) : ROOT_SESSION_MANAGER;
    }

    public static GlobalSession findGlobalSession(String xid) {
        return SessionHolder.findGlobalSession((String)xid, (boolean)true);
    }

    public static GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return SessionHolder.getRootSessionManager().findGlobalSession(xid, withBranchSessions);
    }

    public static <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        return (T)SessionHolder.getRootSessionManager().lockAndExecute(globalSession, lockCallable);
    }

    public static boolean acquireDistributedLock(String lockKey) {
        return DISTRIBUTED_LOCKER.acquireLock(new DistributedLockDO(lockKey, XID.getIpAddressAndPort(), Long.valueOf(DISTRIBUTED_LOCK_EXPIRE_TIME)));
    }

    public static boolean releaseDistributedLock(String lockKey) {
        return DISTRIBUTED_LOCKER.releaseLock(new DistributedLockDO(lockKey, XID.getIpAddressAndPort(), Long.valueOf(DISTRIBUTED_LOCK_EXPIRE_TIME)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean distributedLockAndExecute(String key, NoArgsFunc func) {
        boolean lock = false;
        try {
            lock = SessionHolder.acquireDistributedLock((String)key);
            if (lock) {
                func.call();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception running function with key = {}", (Object)key, (Object)e);
        }
        finally {
            if (lock) {
                try {
                    SessionHolder.releaseDistributedLock((String)key);
                }
                catch (Exception ex) {
                    LOGGER.warn("release distribute lock failure, message = {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        return lock;
    }

    public static void destroy() {
        RaftServerManager.destroy();
        if (ROOT_SESSION_MANAGER != null) {
            ROOT_SESSION_MANAGER.destroy();
        }
        SESSION_MANAGER_MAP = null;
    }
}

