/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.session;

import org.apache.seata.core.exception.BranchTransactionException;
import org.apache.seata.core.exception.GlobalTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionManager;
import org.apache.seata.server.store.SessionStorable;
import org.apache.seata.server.store.TransactionStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionManager
implements SessionManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSessionManager.class);
    protected TransactionStoreManager transactionStoreManager;
    protected String name;

    public AbstractSessionManager() {
    }

    public AbstractSessionManager(String name) {
        this.name = name;
    }

    public void addGlobalSession(GlobalSession session) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, session, TransactionStoreManager.LogOperation.GLOBAL_ADD});
        }
        this.writeSession(TransactionStoreManager.LogOperation.GLOBAL_ADD, (SessionStorable)session);
    }

    public void updateGlobalSessionStatus(GlobalSession session, GlobalStatus status) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, session, TransactionStoreManager.LogOperation.GLOBAL_UPDATE});
        }
        if (GlobalStatus.Rollbacking == status || GlobalStatus.TimeoutRollbacking == status) {
            session.getBranchSessions().forEach(i -> i.setLockStatus(LockStatus.Rollbacking));
        }
        session.setStatus(status);
        this.writeSession(TransactionStoreManager.LogOperation.GLOBAL_UPDATE, (SessionStorable)session);
    }

    public void removeGlobalSession(GlobalSession session) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, session, TransactionStoreManager.LogOperation.GLOBAL_REMOVE});
        }
        this.writeSession(TransactionStoreManager.LogOperation.GLOBAL_REMOVE, (SessionStorable)session);
    }

    public void addBranchSession(GlobalSession session, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, branchSession, TransactionStoreManager.LogOperation.BRANCH_ADD});
        }
        this.writeSession(TransactionStoreManager.LogOperation.BRANCH_ADD, (SessionStorable)branchSession);
    }

    public void updateBranchSessionStatus(BranchSession branchSession, BranchStatus status) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, branchSession, TransactionStoreManager.LogOperation.BRANCH_UPDATE});
        }
        this.writeSession(TransactionStoreManager.LogOperation.BRANCH_UPDATE, (SessionStorable)branchSession);
    }

    public void removeBranchSession(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MANAGER[{}] SESSION[{}] {}", new Object[]{this.name, branchSession, TransactionStoreManager.LogOperation.BRANCH_REMOVE});
        }
        this.writeSession(TransactionStoreManager.LogOperation.BRANCH_REMOVE, (SessionStorable)branchSession);
    }

    public void onBegin(GlobalSession globalSession) throws TransactionException {
        this.addGlobalSession(globalSession);
    }

    public void onStatusChange(GlobalSession globalSession, GlobalStatus status) throws TransactionException {
        this.updateGlobalSessionStatus(globalSession, status);
    }

    public void onBranchStatusChange(GlobalSession globalSession, BranchSession branchSession, BranchStatus status) throws TransactionException {
        branchSession.setStatus(status);
        this.updateBranchSessionStatus(branchSession, status);
    }

    public void onAddBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        this.addBranchSession(globalSession, branchSession);
    }

    public void onRemoveBranch(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        this.removeBranchSession(globalSession, branchSession);
    }

    public void onClose(GlobalSession globalSession) throws TransactionException {
        globalSession.setActive(false);
    }

    public void onSuccessEnd(GlobalSession globalSession) throws TransactionException {
        this.removeGlobalSession(globalSession);
    }

    public void onFailEnd(GlobalSession globalSession) throws TransactionException {
        LOGGER.info("xid:{} fail end, transaction:{}", (Object)globalSession.getXid(), (Object)globalSession);
    }

    private void writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable sessionStorable) throws TransactionException {
        if (!this.transactionStoreManager.writeSession(logOperation, sessionStorable)) {
            if (TransactionStoreManager.LogOperation.GLOBAL_ADD.equals((Object)logOperation)) {
                throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to store global session");
            }
            if (TransactionStoreManager.LogOperation.GLOBAL_UPDATE.equals((Object)logOperation)) {
                throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to update global session");
            }
            if (TransactionStoreManager.LogOperation.GLOBAL_REMOVE.equals((Object)logOperation)) {
                throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to remove global session");
            }
            if (TransactionStoreManager.LogOperation.BRANCH_ADD.equals((Object)logOperation)) {
                throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to store branch session");
            }
            if (TransactionStoreManager.LogOperation.BRANCH_UPDATE.equals((Object)logOperation)) {
                throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to update branch session");
            }
            if (TransactionStoreManager.LogOperation.BRANCH_REMOVE.equals((Object)logOperation)) {
                throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to remove branch session");
            }
            throw new BranchTransactionException(TransactionExceptionCode.FailedWriteSession, "Unknown LogOperation:" + logOperation.name());
        }
    }

    public void destroy() {
    }

    public void setTransactionStoreManager(TransactionStoreManager transactionStoreManager) {
        this.transactionStoreManager = transactionStoreManager;
    }
}

