/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.controller;

import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.seata.common.metadata.MetadataResponse;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.console.result.Result;
import org.apache.seata.server.cluster.manager.ClusterWatcherManager;
import org.apache.seata.server.cluster.raft.RaftServer;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.sync.msg.dto.RaftClusterMetadata;
import org.apache.seata.server.cluster.watch.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metadata/v1"})
public class ClusterController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterController.class);
    @Resource
    private ClusterWatcherManager clusterWatcherManager;
    private ServerProperties serverProperties;
    @Resource
    ApplicationContext applicationContext;

    @PostConstruct
    private void init() {
        this.serverProperties = (ServerProperties)this.applicationContext.getBean(ServerProperties.class);
    }

    @PostMapping(value={"/changeCluster"})
    public Result<?> changeCluster(@RequestParam String raftClusterStr) {
        Result result = new Result();
        Configuration newConf = new Configuration();
        if (!newConf.parse(raftClusterStr)) {
            result.setMessage("fail to parse initConf:" + raftClusterStr);
        } else {
            RaftServerManager.groups().forEach(group -> {
                RaftServerManager.getCliServiceInstance().changePeers(group, RouteTable.getInstance().getConfiguration(group), newConf);
                RouteTable.getInstance().updateConfiguration(group, newConf);
            });
        }
        return result;
    }

    @GetMapping(value={"/cluster"})
    public MetadataResponse cluster(String group) {
        RaftServer raftServer;
        MetadataResponse metadataResponse = new MetadataResponse();
        if (StringUtils.isBlank((String)group)) {
            group = ConfigurationFactory.getInstance().getConfig("server.raft.group", "default");
        }
        if ((raftServer = RaftServerManager.getRaftServer((String)group)) != null) {
            String mode = ConfigurationFactory.getInstance().getConfig("store.mode");
            metadataResponse.setStoreMode(mode);
            RouteTable routeTable = RouteTable.getInstance();
            try {
                routeTable.refreshLeader(RaftServerManager.getCliClientServiceInstance(), group, 1000);
                PeerId leader = routeTable.selectLeader(group);
                if (leader != null) {
                    HashSet<Node> nodes = new HashSet<Node>();
                    RaftClusterMetadata raftClusterMetadata = raftServer.getRaftStateMachine().getRaftLeaderMetadata();
                    Node leaderNode = raftServer.getRaftStateMachine().getRaftLeaderMetadata().getLeader();
                    leaderNode.setGroup(group);
                    nodes.add(leaderNode);
                    nodes.addAll(raftClusterMetadata.getLearner());
                    nodes.addAll(raftClusterMetadata.getFollowers());
                    metadataResponse.setTerm(raftClusterMetadata.getTerm());
                    metadataResponse.setNodes(new ArrayList(nodes));
                }
            }
            catch (Exception e) {
                LOGGER.error("there is an exception to getting the leader address: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return metadataResponse;
    }

    @PostMapping(value={"/watch"})
    public void watch(HttpServletRequest request, @RequestParam Map<String, Object> groupTerms, @RequestParam(defaultValue="28000") int timeout) {
        AsyncContext context = request.startAsync();
        context.setTimeout(0L);
        groupTerms.forEach((group, term) -> {
            Watcher watcher = new Watcher(group, (Object)context, timeout, Long.parseLong(String.valueOf(term)));
            this.clusterWatcherManager.registryWatcher(watcher);
        });
    }
}

