/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.console.param.BaseParam;
import org.apache.seata.console.result.PageResult;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.server.console.param.GlobalSessionParam;
import org.apache.seata.server.console.service.GlobalSessionService;
import org.apache.seata.server.console.vo.GlobalSessionVO;
import org.apache.seata.server.session.SessionCondition;
import org.apache.seata.server.storage.SessionConverter;
import org.apache.seata.server.storage.redis.store.RedisTransactionStoreManager;
import org.apache.seata.server.storage.redis.store.RedisTransactionStoreManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'redis'.equals('${sessionMode}')}")
public class GlobalSessionRedisServiceImpl
implements GlobalSessionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSessionRedisServiceImpl.class);

    public PageResult<GlobalSessionVO> query(GlobalSessionParam param) {
        ArrayList result = new ArrayList();
        Long total = 0L;
        if (param.getTimeStart() != null || param.getTimeEnd() != null) {
            LOGGER.debug("not supported according to time range query");
            return PageResult.failure((String)FrameworkErrorCode.ParameterRequired.getErrCode(), (String)"not supported according to time range query");
        }
        List globalSessions = new ArrayList();
        RedisTransactionStoreManager instance = RedisTransactionStoreManagerFactory.getInstance();
        PageResult.checkPage((BaseParam)param);
        if (StringUtils.isBlank((String)param.getXid()) && param.getStatus() == null) {
            total = instance.countByGlobalSessions(GlobalStatus.values());
            globalSessions = instance.findGlobalSessionByPage(param.getPageNum(), param.getPageSize(), param.isWithBranch());
        } else {
            List<Object> globalSessionsNew = new ArrayList();
            if (StringUtils.isNotBlank((String)param.getXid())) {
                SessionCondition sessionCondition = new SessionCondition();
                sessionCondition.setXid(param.getXid());
                sessionCondition.setLazyLoadBranch(!param.isWithBranch());
                globalSessions = instance.readSession(sessionCondition);
                total = globalSessions.size();
            }
            if (param.getStatus() != null && GlobalStatus.get((int)param.getStatus()) != null) {
                if (CollectionUtils.isNotEmpty(globalSessions)) {
                    globalSessionsNew = globalSessions.stream().filter(globalSession -> globalSession.getStatus().getCode() == param.getStatus().intValue()).collect(Collectors.toList());
                    total = globalSessionsNew.size();
                } else {
                    total = instance.countByGlobalSessions(new GlobalStatus[]{GlobalStatus.get((int)param.getStatus())});
                    globalSessionsNew = instance.readSessionStatusByPage(param);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                if (StringUtils.isNotBlank((String)param.getApplicationId())) {
                    LOGGER.debug("not supported according to applicationId query");
                }
                if (StringUtils.isNotBlank((String)param.getTransactionName())) {
                    LOGGER.debug("not supported according to transactionName query");
                }
            }
            globalSessions = globalSessionsNew.size() > 0 ? globalSessionsNew : globalSessions;
        }
        SessionConverter.convertToGlobalSessionVo(result, globalSessions);
        return PageResult.success(result, (Integer)total.intValue(), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }
}

