/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.file;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.console.result.PageResult;
import org.apache.seata.server.console.param.GlobalSessionParam;
import org.apache.seata.server.console.service.GlobalSessionService;
import org.apache.seata.server.console.vo.GlobalSessionVO;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.SessionConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'file'.equals('${sessionMode}')}")
public class GlobalSessionFileServiceImpl
implements GlobalSessionService {
    public PageResult<GlobalSessionVO> query(GlobalSessionParam param) {
        if (param.getPageSize() <= 0 || param.getPageNum() <= 0) {
            throw new IllegalArgumentException("wrong pageSize or pageNum");
        }
        Collection allSessions = SessionHolder.getRootSessionManager().allSessions();
        List filteredSessions = allSessions.parallelStream().filter(this.obtainPredicate(param)).collect(Collectors.toList());
        return PageResult.build((List)SessionConverter.convertGlobalSession(filteredSessions), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private Predicate<? super GlobalSession> obtainPredicate(GlobalSessionParam param) {
        return session -> !(!StringUtils.isBlank((String)param.getXid()) && !session.getXid().contains(param.getXid()) || !StringUtils.isBlank((String)param.getApplicationId()) && !session.getApplicationId().contains(param.getApplicationId()) || !Objects.isNull(param.getStatus()) && !Objects.equals(session.getStatus().getCode(), param.getStatus()) || !StringUtils.isBlank((String)param.getTransactionName()) && !session.getTransactionName().contains(param.getTransactionName()) || !Objects.isNull(param.getTimeStart()) && param.getTimeStart() / 1000L < session.getBeginTime() / 1000L || !Objects.isNull(param.getTimeEnd()) && param.getTimeEnd() / 1000L > session.getBeginTime() / 1000L);
    }
}

