/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.file;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.console.result.PageResult;
import org.apache.seata.core.lock.RowLock;
import org.apache.seata.server.console.param.GlobalLockParam;
import org.apache.seata.server.console.service.GlobalLockService;
import org.apache.seata.server.console.vo.GlobalLockVO;
import org.apache.seata.server.lock.LockerManagerFactory;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'file'.equals('${lockMode}')}")
public class GlobalLockFileServiceImpl
implements GlobalLockService {
    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        this.checkParam(param);
        Collection allSessions = SessionHolder.getRootSessionManager().allSessions();
        AtomicInteger total = new AtomicInteger();
        List result = allSessions.parallelStream().filter(this.obtainGlobalSessionPredicate(param)).flatMap(globalSession -> globalSession.getBranchSessions().stream()).filter(this.obtainBranchSessionPredicate(param)).flatMap(branchSession -> this.filterAndMap(param, branchSession)).peek(globalSession -> total.incrementAndGet()).collect(Collectors.toList());
        return PageResult.build((List)GlobalLockVO.convert(result), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private Stream<RowLock> filterAndMap(GlobalLockParam param, BranchSession branchSession) {
        if (CollectionUtils.isEmpty((Map)branchSession.getLockHolder())) {
            return Stream.empty();
        }
        String tableName = param.getTableName();
        List rowLocks = LockerManagerFactory.getLockManager().collectRowLocks(branchSession);
        if (StringUtils.isNotBlank((String)tableName)) {
            return rowLocks.parallelStream().filter(rowLock -> rowLock.getTableName().contains(param.getTableName()));
        }
        return rowLocks.stream();
    }

    private void checkParam(GlobalLockParam param) {
        if (param.getPageSize() <= 0 || param.getPageNum() <= 0) {
            throw new IllegalArgumentException("wrong pageSize or pageNum");
        }
        try {
            Long.parseLong(param.getTransactionId());
        }
        catch (NumberFormatException e) {
            param.setTransactionId(null);
        }
        try {
            Long.parseLong(param.getBranchId());
        }
        catch (NumberFormatException e) {
            param.setBranchId(null);
        }
    }

    private Predicate<? super BranchSession> obtainBranchSessionPredicate(GlobalLockParam param) {
        return branchSession -> !(!StringUtils.isBlank((String)param.getTransactionId()) && !String.valueOf(branchSession.getTransactionId()).contains(param.getTransactionId()) || !StringUtils.isBlank((String)param.getBranchId()) && !String.valueOf(branchSession.getBranchId()).contains(param.getBranchId()));
    }

    private Predicate<? super GlobalSession> obtainGlobalSessionPredicate(GlobalLockParam param) {
        return globalSession -> !(!CollectionUtils.isNotEmpty((Collection)globalSession.getBranchSessions()) || !StringUtils.isBlank((String)param.getXid()) && !globalSession.getXid().contains(param.getXid()) || !Objects.isNull(param.getTimeStart()) && param.getTimeStart() / 1000L < globalSession.getBeginTime() / 1000L || !Objects.isNull(param.getTimeEnd()) && param.getTimeEnd() / 1000L > globalSession.getBeginTime() / 1000L);
    }
}

