/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.console.result.PageResult;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.core.store.db.sql.log.LogStoreSqlsFactory;
import org.apache.seata.server.console.service.BranchSessionService;
import org.apache.seata.server.console.vo.BranchSessionVO;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'db'.equals('${sessionMode}')}")
public class BranchSessionDBServiceImpl
implements BranchSessionService {
    private String branchTable;
    private String dbType;
    private DataSource dataSource;

    public BranchSessionDBServiceImpl() {
        org.apache.seata.config.Configuration configuration = ConfigurationFactory.getInstance();
        this.branchTable = configuration.getConfig("store.db.branchTable", "branch_table");
        this.dbType = configuration.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new IllegalArgumentException("store.db.dbType should not be blank");
        }
        String dbDataSource = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)dbDataSource)) {
            throw new IllegalArgumentException("store.db.datasource should not be blank");
        }
        this.dataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)dbDataSource)).provide();
    }

    public PageResult<BranchSessionVO> queryByXid(String xid) {
        if (StringUtils.isBlank((String)xid)) {
            throw new IllegalArgumentException("xid should not be blank");
        }
        String whereCondition = " where xid = ? ";
        String branchSessionSQL = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getAllBranchSessionSQL(this.branchTable, whereCondition);
        ArrayList<BranchSessionVO> list = new ArrayList<BranchSessionVO>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(branchSessionSQL);
            ps.setObject(1, xid);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(BranchSessionVO.convert((ResultSet)rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps, conn});
        return PageResult.success(list, (Integer)list.size(), (Integer)0, (Integer)0, (Integer)0);
    }
}

