/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.server.cluster.raft.serializer.JacksonSerializer;

@LoadLevel(name="JACKSON")
public class JacksonSerializer
implements Serializer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public <T> byte[] serialize(T t) {
        try {
            JsonInfo jsonInfo = new JsonInfo(this.objectMapper.writeValueAsBytes(t), t.getClass());
            return this.objectMapper.writeValueAsBytes((Object)jsonInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T deserialize(byte[] bytes) {
        try {
            JsonInfo jsonInfo = (JsonInfo)this.objectMapper.readValue(bytes, JsonInfo.class);
            return (T)this.objectMapper.readValue(jsonInfo.getObj(), jsonInfo.getClz());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

