/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.context;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.ContextCore;
import org.apache.seata.core.context.ContextCoreLoader;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RootContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootContext.class);
    public static final String KEY_XID = "TX_XID";
    public static final String KEY_BRANCHID = "TX_BRANCHID";
    public static final String HIDDEN_KEY_XID = ".TX_XID";
    public static final String KEY_TIMEOUT = "TX_TIMEOUT";
    public static final String MDC_KEY_XID = "X-TX-XID";
    public static final String MDC_KEY_BRANCH_ID = "X-TX-BRANCH-ID";
    public static final String KEY_BRANCH_TYPE = "TX_BRANCH_TYPE";
    public static final String HIDDEN_KEY_BRANCH_TYPE = ".TX_BRANCH_TYPE";
    public static final String KEY_GLOBAL_LOCK_FLAG = "TX_LOCK";
    public static final Boolean VALUE_GLOBAL_LOCK_FLAG = true;
    private static ContextCore CONTEXT_HOLDER = ContextCoreLoader.load();
    private static BranchType DEFAULT_BRANCH_TYPE;

    private RootContext() {
    }

    public static void setDefaultBranchType(BranchType defaultBranchType) {
        if (defaultBranchType != BranchType.AT && defaultBranchType != BranchType.XA) {
            throw new IllegalArgumentException("The default branch type must be " + (Object)((Object)BranchType.AT) + " or " + (Object)((Object)BranchType.XA) + ". the value of the argument is: " + (Object)((Object)defaultBranchType));
        }
        if (DEFAULT_BRANCH_TYPE != null && DEFAULT_BRANCH_TYPE != defaultBranchType && LOGGER.isWarnEnabled()) {
            LOGGER.warn("The `{}.DEFAULT_BRANCH_TYPE` has been set repeatedly. The value changes from {} to {}", new Object[]{RootContext.class.getSimpleName(), DEFAULT_BRANCH_TYPE, defaultBranchType});
        }
        DEFAULT_BRANCH_TYPE = defaultBranchType;
    }

    @Nullable
    public static String getXID() {
        return (String)CONTEXT_HOLDER.get(KEY_XID);
    }

    public static void bind(@Nonnull String xid) {
        if (StringUtils.isBlank((String)xid)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("xid is blank, switch to unbind operation!");
            }
            RootContext.unbind();
        } else {
            MDC.put((String)MDC_KEY_XID, (String)xid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind {}", (Object)xid);
            }
            CONTEXT_HOLDER.put(KEY_XID, xid);
        }
    }

    public static Integer getTimeout() {
        return (Integer)CONTEXT_HOLDER.get(KEY_TIMEOUT);
    }

    public static void setTimeout(Integer timeout) {
        CONTEXT_HOLDER.put(KEY_TIMEOUT, timeout);
    }

    public static void bindGlobalLockFlag() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Local Transaction Global Lock support enabled");
        }
        CONTEXT_HOLDER.put(KEY_GLOBAL_LOCK_FLAG, VALUE_GLOBAL_LOCK_FLAG);
    }

    @Nullable
    public static String unbind() {
        String xid = (String)CONTEXT_HOLDER.remove(KEY_XID);
        if (xid != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind {} ", (Object)xid);
            }
            MDC.remove((String)MDC_KEY_XID);
        }
        return xid;
    }

    public static void unbindGlobalLockFlag() {
        Boolean lockFlag = (Boolean)CONTEXT_HOLDER.remove(KEY_GLOBAL_LOCK_FLAG);
        if (LOGGER.isDebugEnabled() && lockFlag != null) {
            LOGGER.debug("unbind global lock flag");
        }
    }

    public static boolean inGlobalTransaction() {
        return CONTEXT_HOLDER.get(KEY_XID) != null;
    }

    public static boolean inTccBranch() {
        return BranchType.TCC == RootContext.getBranchType();
    }

    public static boolean inSagaBranch() {
        return BranchType.SAGA == RootContext.getBranchType();
    }

    @Nullable
    public static BranchType getBranchType() {
        if (RootContext.inGlobalTransaction()) {
            BranchType branchType = (BranchType)((Object)CONTEXT_HOLDER.get(KEY_BRANCH_TYPE));
            if (branchType != null) {
                return branchType;
            }
            return DEFAULT_BRANCH_TYPE != null ? DEFAULT_BRANCH_TYPE : BranchType.AT;
        }
        return null;
    }

    public static void bindBranchType(@Nonnull BranchType branchType) {
        if (branchType == null) {
            throw new IllegalArgumentException("branchType must be not null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bind branch type {}", (Object)branchType);
        }
        CONTEXT_HOLDER.put(KEY_BRANCH_TYPE, (Object)branchType);
    }

    @Nullable
    public static BranchType unbindBranchType() {
        BranchType unbindBranchType = (BranchType)((Object)CONTEXT_HOLDER.remove(KEY_BRANCH_TYPE));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unbind branch type {}", (Object)unbindBranchType);
        }
        return unbindBranchType;
    }

    public static boolean requireGlobalLock() {
        return CONTEXT_HOLDER.get(KEY_GLOBAL_LOCK_FLAG) != null;
    }

    public static void assertNotInGlobalTransaction() {
        if (RootContext.inGlobalTransaction()) {
            throw new ShouldNeverHappenException(String.format("expect has not xid, but was:%s", CONTEXT_HOLDER.get(KEY_XID)));
        }
    }

    public static Map<String, Object> entries() {
        return CONTEXT_HOLDER.entries();
    }
}

