/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.loadbalance;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.loadbalance.LoadBalance;

@LoadLevel(name="ConsistentHashLoadBalance")
public class ConsistentHashLoadBalance
implements LoadBalance {
    public static final String LOAD_BALANCE_CONSISTENT_HASH_VIRTUAL_NODES = "client.loadBalance.virtualNodes";
    private static final int VIRTUAL_NODES_NUM = ConfigurationFactory.getInstance().getInt("client.loadBalance.virtualNodes", 10);

    @Override
    public <T> T select(List<T> invokers, String xid) {
        return new ConsistentHashSelector<T>(invokers, VIRTUAL_NODES_NUM).select(xid);
    }

    public static interface HashFunction {
        public long hash(String var1);
    }

    private static class MD5Hash
    implements HashFunction {
        MessageDigest instance;

        public MD5Hash() {
            try {
                this.instance = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public long hash(String key) {
            this.instance.reset();
            this.instance.update(key.getBytes());
            byte[] digest = this.instance.digest();
            long h = 0L;
            for (int i = 0; i < 4; ++i) {
                h <<= 8;
                h |= (long)(digest[i] & 0xFF);
            }
            return h;
        }
    }

    private static final class ConsistentHashSelector<T> {
        private final SortedMap<Long, T> virtualInvokers = new TreeMap<Long, T>();
        private final HashFunction hashFunction = new MD5Hash();

        ConsistentHashSelector(List<T> invokers, int virtualNodes) {
            for (T invoker : invokers) {
                for (int i = 0; i < virtualNodes; ++i) {
                    this.virtualInvokers.put(this.hashFunction.hash(invoker.toString() + i), invoker);
                }
            }
        }

        public T select(String objectKey) {
            SortedMap<Long, T> tailMap = this.virtualInvokers.tailMap(this.hashFunction.hash(objectKey));
            Long nodeHashVal = tailMap.isEmpty() ? this.virtualInvokers.firstKey() : tailMap.firstKey();
            return (T)this.virtualInvokers.get(nodeHashVal);
        }
    }
}

