/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.BatchResultMessage;
import org.apache.seata.core.protocol.MergeResultMessage;
import org.apache.seata.core.protocol.MergedWarpMessage;
import org.apache.seata.core.protocol.RegisterRMRequest;
import org.apache.seata.core.protocol.RegisterRMResponse;
import org.apache.seata.core.protocol.RegisterTMRequest;
import org.apache.seata.core.protocol.RegisterTMResponse;
import org.apache.seata.core.protocol.transaction.BranchCommitRequest;
import org.apache.seata.core.protocol.transaction.BranchCommitResponse;
import org.apache.seata.core.protocol.transaction.BranchRegisterRequest;
import org.apache.seata.core.protocol.transaction.BranchRegisterResponse;
import org.apache.seata.core.protocol.transaction.BranchReportRequest;
import org.apache.seata.core.protocol.transaction.BranchReportResponse;
import org.apache.seata.core.protocol.transaction.BranchRollbackRequest;
import org.apache.seata.core.protocol.transaction.BranchRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalBeginRequest;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.core.protocol.transaction.GlobalCommitRequest;
import org.apache.seata.core.protocol.transaction.GlobalCommitResponse;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryRequest;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryResponse;
import org.apache.seata.core.protocol.transaction.GlobalReportRequest;
import org.apache.seata.core.protocol.transaction.GlobalReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalRollbackRequest;
import org.apache.seata.core.protocol.transaction.GlobalRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalStatusRequest;
import org.apache.seata.core.protocol.transaction.GlobalStatusResponse;
import org.apache.seata.core.protocol.transaction.UndoLogDeleteRequest;
import org.apache.seata.serializer.seata.MessageSeataCodec;
import org.apache.seata.serializer.seata.protocol.BatchResultMessageCodec;
import org.apache.seata.serializer.seata.protocol.MergeResultMessageCodec;
import org.apache.seata.serializer.seata.protocol.MergedWarpMessageCodec;
import org.apache.seata.serializer.seata.protocol.RegisterRMRequestCodec;
import org.apache.seata.serializer.seata.protocol.RegisterRMResponseCodec;
import org.apache.seata.serializer.seata.protocol.RegisterTMRequestCodec;
import org.apache.seata.serializer.seata.protocol.RegisterTMResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchCommitRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchCommitResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRegisterRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRegisterResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchReportRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchReportResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRollbackRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRollbackResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalBeginRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalBeginResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalCommitRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalCommitResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalLockQueryRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalLockQueryResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalReportRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalReportResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalRollbackRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalRollbackResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalStatusRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalStatusResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.UndoLogDeleteRequestCodec;

public class MessageCodecFactory {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;

    public static MessageSeataCodec getMessageCodec(AbstractMessage abstractMessage) {
        return MessageCodecFactory.getMessageCodec(abstractMessage.getTypeCode());
    }

    public static MessageSeataCodec getMessageCodec(short typeCode) {
        MessageSeataCodec msgCodec = null;
        switch (typeCode) {
            case 59: {
                msgCodec = new MergedWarpMessageCodec();
                break;
            }
            case 60: {
                msgCodec = new MergeResultMessageCodec();
                break;
            }
            case 101: {
                msgCodec = new RegisterTMRequestCodec();
                break;
            }
            case 102: {
                msgCodec = new RegisterTMResponseCodec();
                break;
            }
            case 103: {
                msgCodec = new RegisterRMRequestCodec();
                break;
            }
            case 104: {
                msgCodec = new RegisterRMResponseCodec();
                break;
            }
            case 3: {
                msgCodec = new BranchCommitRequestCodec();
                break;
            }
            case 5: {
                msgCodec = new BranchRollbackRequestCodec();
                break;
            }
            case 17: {
                msgCodec = new GlobalReportRequestCodec();
                break;
            }
            case 121: {
                msgCodec = new BatchResultMessageCodec();
                break;
            }
        }
        if (msgCodec != null) {
            return msgCodec;
        }
        try {
            msgCodec = MessageCodecFactory.getMergeRequestMessageSeataCodec(typeCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (msgCodec != null) {
            return msgCodec;
        }
        msgCodec = MessageCodecFactory.getMergeResponseMessageSeataCodec(typeCode);
        return msgCodec;
    }

    protected static MessageSeataCodec getMergeRequestMessageSeataCodec(int typeCode) {
        switch (typeCode) {
            case 1: {
                return new GlobalBeginRequestCodec();
            }
            case 7: {
                return new GlobalCommitRequestCodec();
            }
            case 9: {
                return new GlobalRollbackRequestCodec();
            }
            case 15: {
                return new GlobalStatusRequestCodec();
            }
            case 21: {
                return new GlobalLockQueryRequestCodec();
            }
            case 11: {
                return new BranchRegisterRequestCodec();
            }
            case 13: {
                return new BranchReportRequestCodec();
            }
            case 17: {
                return new GlobalReportRequestCodec();
            }
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }

    protected static MessageSeataCodec getMergeResponseMessageSeataCodec(int typeCode) {
        switch (typeCode) {
            case 2: {
                return new GlobalBeginResponseCodec();
            }
            case 8: {
                return new GlobalCommitResponseCodec();
            }
            case 10: {
                return new GlobalRollbackResponseCodec();
            }
            case 16: {
                return new GlobalStatusResponseCodec();
            }
            case 22: {
                return new GlobalLockQueryResponseCodec();
            }
            case 12: {
                return new BranchRegisterResponseCodec();
            }
            case 14: {
                return new BranchReportResponseCodec();
            }
            case 4: {
                return new BranchCommitResponseCodec();
            }
            case 6: {
                return new BranchRollbackResponseCodec();
            }
            case 111: {
                return new UndoLogDeleteRequestCodec();
            }
            case 18: {
                return new GlobalReportResponseCodec();
            }
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }

    public static AbstractMessage getMessage(short typeCode) {
        MergedWarpMessage abstractMessage = null;
        switch (typeCode) {
            case 59: {
                abstractMessage = new MergedWarpMessage();
                break;
            }
            case 60: {
                abstractMessage = new MergeResultMessage();
                break;
            }
            case 101: {
                abstractMessage = new RegisterTMRequest();
                break;
            }
            case 102: {
                abstractMessage = new RegisterTMResponse();
                break;
            }
            case 103: {
                abstractMessage = new RegisterRMRequest();
                break;
            }
            case 104: {
                abstractMessage = new RegisterRMResponse();
                break;
            }
            case 3: {
                abstractMessage = new BranchCommitRequest();
                break;
            }
            case 5: {
                abstractMessage = new BranchRollbackRequest();
                break;
            }
            case 111: {
                abstractMessage = new UndoLogDeleteRequest();
                break;
            }
            case 17: {
                abstractMessage = new GlobalReportRequest();
                break;
            }
            case 18: {
                abstractMessage = new GlobalReportResponse();
                break;
            }
            case 121: {
                abstractMessage = new BatchResultMessage();
                break;
            }
        }
        if (abstractMessage != null) {
            return abstractMessage;
        }
        try {
            abstractMessage = MessageCodecFactory.getMergeRequestInstanceByCode(typeCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (abstractMessage != null) {
            return abstractMessage;
        }
        return MessageCodecFactory.getMergeResponseInstanceByCode(typeCode);
    }

    protected static AbstractMessage getMergeRequestInstanceByCode(int typeCode) {
        switch (typeCode) {
            case 1: {
                return new GlobalBeginRequest();
            }
            case 7: {
                return new GlobalCommitRequest();
            }
            case 9: {
                return new GlobalRollbackRequest();
            }
            case 15: {
                return new GlobalStatusRequest();
            }
            case 21: {
                return new GlobalLockQueryRequest();
            }
            case 11: {
                return new BranchRegisterRequest();
            }
            case 13: {
                return new BranchReportRequest();
            }
            case 17: {
                return new GlobalReportRequest();
            }
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }

    protected static AbstractMessage getMergeResponseInstanceByCode(int typeCode) {
        switch (typeCode) {
            case 2: {
                return new GlobalBeginResponse();
            }
            case 8: {
                return new GlobalCommitResponse();
            }
            case 10: {
                return new GlobalRollbackResponse();
            }
            case 16: {
                return new GlobalStatusResponse();
            }
            case 22: {
                return new GlobalLockQueryResponse();
            }
            case 12: {
                return new BranchRegisterResponse();
            }
            case 14: {
                return new BranchReportResponse();
            }
            case 4: {
                return new BranchCommitResponse();
            }
            case 6: {
                return new BranchRollbackResponse();
            }
            case 18: {
                return new GlobalReportResponse();
            }
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }
}

