/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.

 * Simple example that shows how to use the domain registry provider
 * API.
 */

#include <stdlib.h>
#include <stdio.h>

#include "domain_registry/domain_registry.h"

static void PrintRegistryLength(const char* hostname) {
  size_t len = GetRegistryLength(hostname);
  fprintf(stderr, "%s: %d\n", hostname, (int) len);
}

int main(int argc, char** argv) {
  if (argc != 2) {
    fprintf(stderr, "Usage: %s <hostname>\n", argv[0]);
    return EXIT_FAILURE;
  }

  InitializeDomainRegistry();
  PrintRegistryLength(argv[1]);
  return EXIT_SUCCESS;
}
