// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Number formatting symbols.
 *
 * This file is generated by
 *   //depot/google3/i18n/tools/java/com/google/i18n/generator:generator
 * using the --for_closure flag.
 *
 * File generated from CLDR ver. 29
 *
 * This file covers those locales that are not covered in
 * "numberformatsymbols.js".
 *
 * Before checking, this file could have been manually edited. This is
 * to incorporate changes before we could fix CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes land to CLDR.
 * @suppress {const}
 */

// clang-format off

goog.provide('goog.i18n.NumberFormatSymbolsExt');
goog.provide('goog.i18n.NumberFormatSymbols_af_NA');
goog.provide('goog.i18n.NumberFormatSymbols_af_ZA');
goog.provide('goog.i18n.NumberFormatSymbols_agq');
goog.provide('goog.i18n.NumberFormatSymbols_agq_CM');
goog.provide('goog.i18n.NumberFormatSymbols_ak');
goog.provide('goog.i18n.NumberFormatSymbols_ak_GH');
goog.provide('goog.i18n.NumberFormatSymbols_am_ET');
goog.provide('goog.i18n.NumberFormatSymbols_ar_001');
goog.provide('goog.i18n.NumberFormatSymbols_ar_AE');
goog.provide('goog.i18n.NumberFormatSymbols_ar_BH');
goog.provide('goog.i18n.NumberFormatSymbols_ar_DJ');
goog.provide('goog.i18n.NumberFormatSymbols_ar_DZ');
goog.provide('goog.i18n.NumberFormatSymbols_ar_EG');
goog.provide('goog.i18n.NumberFormatSymbols_ar_EH');
goog.provide('goog.i18n.NumberFormatSymbols_ar_ER');
goog.provide('goog.i18n.NumberFormatSymbols_ar_IL');
goog.provide('goog.i18n.NumberFormatSymbols_ar_IQ');
goog.provide('goog.i18n.NumberFormatSymbols_ar_JO');
goog.provide('goog.i18n.NumberFormatSymbols_ar_KM');
goog.provide('goog.i18n.NumberFormatSymbols_ar_KW');
goog.provide('goog.i18n.NumberFormatSymbols_ar_LB');
goog.provide('goog.i18n.NumberFormatSymbols_ar_LY');
goog.provide('goog.i18n.NumberFormatSymbols_ar_MA');
goog.provide('goog.i18n.NumberFormatSymbols_ar_MR');
goog.provide('goog.i18n.NumberFormatSymbols_ar_OM');
goog.provide('goog.i18n.NumberFormatSymbols_ar_PS');
goog.provide('goog.i18n.NumberFormatSymbols_ar_QA');
goog.provide('goog.i18n.NumberFormatSymbols_ar_SA');
goog.provide('goog.i18n.NumberFormatSymbols_ar_SD');
goog.provide('goog.i18n.NumberFormatSymbols_ar_SO');
goog.provide('goog.i18n.NumberFormatSymbols_ar_SS');
goog.provide('goog.i18n.NumberFormatSymbols_ar_SY');
goog.provide('goog.i18n.NumberFormatSymbols_ar_TD');
goog.provide('goog.i18n.NumberFormatSymbols_ar_TN');
goog.provide('goog.i18n.NumberFormatSymbols_ar_XB');
goog.provide('goog.i18n.NumberFormatSymbols_ar_YE');
goog.provide('goog.i18n.NumberFormatSymbols_as');
goog.provide('goog.i18n.NumberFormatSymbols_as_IN');
goog.provide('goog.i18n.NumberFormatSymbols_asa');
goog.provide('goog.i18n.NumberFormatSymbols_asa_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_ast');
goog.provide('goog.i18n.NumberFormatSymbols_ast_ES');
goog.provide('goog.i18n.NumberFormatSymbols_az_Cyrl');
goog.provide('goog.i18n.NumberFormatSymbols_az_Cyrl_AZ');
goog.provide('goog.i18n.NumberFormatSymbols_az_Latn');
goog.provide('goog.i18n.NumberFormatSymbols_az_Latn_AZ');
goog.provide('goog.i18n.NumberFormatSymbols_bas');
goog.provide('goog.i18n.NumberFormatSymbols_bas_CM');
goog.provide('goog.i18n.NumberFormatSymbols_be_BY');
goog.provide('goog.i18n.NumberFormatSymbols_bem');
goog.provide('goog.i18n.NumberFormatSymbols_bem_ZM');
goog.provide('goog.i18n.NumberFormatSymbols_bez');
goog.provide('goog.i18n.NumberFormatSymbols_bez_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_bg_BG');
goog.provide('goog.i18n.NumberFormatSymbols_bm');
goog.provide('goog.i18n.NumberFormatSymbols_bm_ML');
goog.provide('goog.i18n.NumberFormatSymbols_bn_BD');
goog.provide('goog.i18n.NumberFormatSymbols_bn_IN');
goog.provide('goog.i18n.NumberFormatSymbols_bo');
goog.provide('goog.i18n.NumberFormatSymbols_bo_CN');
goog.provide('goog.i18n.NumberFormatSymbols_bo_IN');
goog.provide('goog.i18n.NumberFormatSymbols_br_FR');
goog.provide('goog.i18n.NumberFormatSymbols_brx');
goog.provide('goog.i18n.NumberFormatSymbols_brx_IN');
goog.provide('goog.i18n.NumberFormatSymbols_bs_Cyrl');
goog.provide('goog.i18n.NumberFormatSymbols_bs_Cyrl_BA');
goog.provide('goog.i18n.NumberFormatSymbols_bs_Latn');
goog.provide('goog.i18n.NumberFormatSymbols_bs_Latn_BA');
goog.provide('goog.i18n.NumberFormatSymbols_ca_AD');
goog.provide('goog.i18n.NumberFormatSymbols_ca_ES');
goog.provide('goog.i18n.NumberFormatSymbols_ca_FR');
goog.provide('goog.i18n.NumberFormatSymbols_ca_IT');
goog.provide('goog.i18n.NumberFormatSymbols_ce');
goog.provide('goog.i18n.NumberFormatSymbols_ce_RU');
goog.provide('goog.i18n.NumberFormatSymbols_cgg');
goog.provide('goog.i18n.NumberFormatSymbols_cgg_UG');
goog.provide('goog.i18n.NumberFormatSymbols_chr_US');
goog.provide('goog.i18n.NumberFormatSymbols_cs_CZ');
goog.provide('goog.i18n.NumberFormatSymbols_cy_GB');
goog.provide('goog.i18n.NumberFormatSymbols_da_DK');
goog.provide('goog.i18n.NumberFormatSymbols_da_GL');
goog.provide('goog.i18n.NumberFormatSymbols_dav');
goog.provide('goog.i18n.NumberFormatSymbols_dav_KE');
goog.provide('goog.i18n.NumberFormatSymbols_de_BE');
goog.provide('goog.i18n.NumberFormatSymbols_de_DE');
goog.provide('goog.i18n.NumberFormatSymbols_de_LI');
goog.provide('goog.i18n.NumberFormatSymbols_de_LU');
goog.provide('goog.i18n.NumberFormatSymbols_dje');
goog.provide('goog.i18n.NumberFormatSymbols_dje_NE');
goog.provide('goog.i18n.NumberFormatSymbols_dsb');
goog.provide('goog.i18n.NumberFormatSymbols_dsb_DE');
goog.provide('goog.i18n.NumberFormatSymbols_dua');
goog.provide('goog.i18n.NumberFormatSymbols_dua_CM');
goog.provide('goog.i18n.NumberFormatSymbols_dyo');
goog.provide('goog.i18n.NumberFormatSymbols_dyo_SN');
goog.provide('goog.i18n.NumberFormatSymbols_dz');
goog.provide('goog.i18n.NumberFormatSymbols_dz_BT');
goog.provide('goog.i18n.NumberFormatSymbols_ebu');
goog.provide('goog.i18n.NumberFormatSymbols_ebu_KE');
goog.provide('goog.i18n.NumberFormatSymbols_ee');
goog.provide('goog.i18n.NumberFormatSymbols_ee_GH');
goog.provide('goog.i18n.NumberFormatSymbols_ee_TG');
goog.provide('goog.i18n.NumberFormatSymbols_el_CY');
goog.provide('goog.i18n.NumberFormatSymbols_el_GR');
goog.provide('goog.i18n.NumberFormatSymbols_en_001');
goog.provide('goog.i18n.NumberFormatSymbols_en_150');
goog.provide('goog.i18n.NumberFormatSymbols_en_AG');
goog.provide('goog.i18n.NumberFormatSymbols_en_AI');
goog.provide('goog.i18n.NumberFormatSymbols_en_AS');
goog.provide('goog.i18n.NumberFormatSymbols_en_AT');
goog.provide('goog.i18n.NumberFormatSymbols_en_BB');
goog.provide('goog.i18n.NumberFormatSymbols_en_BE');
goog.provide('goog.i18n.NumberFormatSymbols_en_BI');
goog.provide('goog.i18n.NumberFormatSymbols_en_BM');
goog.provide('goog.i18n.NumberFormatSymbols_en_BS');
goog.provide('goog.i18n.NumberFormatSymbols_en_BW');
goog.provide('goog.i18n.NumberFormatSymbols_en_BZ');
goog.provide('goog.i18n.NumberFormatSymbols_en_CC');
goog.provide('goog.i18n.NumberFormatSymbols_en_CH');
goog.provide('goog.i18n.NumberFormatSymbols_en_CK');
goog.provide('goog.i18n.NumberFormatSymbols_en_CM');
goog.provide('goog.i18n.NumberFormatSymbols_en_CX');
goog.provide('goog.i18n.NumberFormatSymbols_en_CY');
goog.provide('goog.i18n.NumberFormatSymbols_en_DE');
goog.provide('goog.i18n.NumberFormatSymbols_en_DG');
goog.provide('goog.i18n.NumberFormatSymbols_en_DK');
goog.provide('goog.i18n.NumberFormatSymbols_en_DM');
goog.provide('goog.i18n.NumberFormatSymbols_en_ER');
goog.provide('goog.i18n.NumberFormatSymbols_en_FI');
goog.provide('goog.i18n.NumberFormatSymbols_en_FJ');
goog.provide('goog.i18n.NumberFormatSymbols_en_FK');
goog.provide('goog.i18n.NumberFormatSymbols_en_FM');
goog.provide('goog.i18n.NumberFormatSymbols_en_GD');
goog.provide('goog.i18n.NumberFormatSymbols_en_GG');
goog.provide('goog.i18n.NumberFormatSymbols_en_GH');
goog.provide('goog.i18n.NumberFormatSymbols_en_GI');
goog.provide('goog.i18n.NumberFormatSymbols_en_GM');
goog.provide('goog.i18n.NumberFormatSymbols_en_GU');
goog.provide('goog.i18n.NumberFormatSymbols_en_GY');
goog.provide('goog.i18n.NumberFormatSymbols_en_HK');
goog.provide('goog.i18n.NumberFormatSymbols_en_IL');
goog.provide('goog.i18n.NumberFormatSymbols_en_IM');
goog.provide('goog.i18n.NumberFormatSymbols_en_IO');
goog.provide('goog.i18n.NumberFormatSymbols_en_JE');
goog.provide('goog.i18n.NumberFormatSymbols_en_JM');
goog.provide('goog.i18n.NumberFormatSymbols_en_KE');
goog.provide('goog.i18n.NumberFormatSymbols_en_KI');
goog.provide('goog.i18n.NumberFormatSymbols_en_KN');
goog.provide('goog.i18n.NumberFormatSymbols_en_KY');
goog.provide('goog.i18n.NumberFormatSymbols_en_LC');
goog.provide('goog.i18n.NumberFormatSymbols_en_LR');
goog.provide('goog.i18n.NumberFormatSymbols_en_LS');
goog.provide('goog.i18n.NumberFormatSymbols_en_MG');
goog.provide('goog.i18n.NumberFormatSymbols_en_MH');
goog.provide('goog.i18n.NumberFormatSymbols_en_MO');
goog.provide('goog.i18n.NumberFormatSymbols_en_MP');
goog.provide('goog.i18n.NumberFormatSymbols_en_MS');
goog.provide('goog.i18n.NumberFormatSymbols_en_MT');
goog.provide('goog.i18n.NumberFormatSymbols_en_MU');
goog.provide('goog.i18n.NumberFormatSymbols_en_MW');
goog.provide('goog.i18n.NumberFormatSymbols_en_MY');
goog.provide('goog.i18n.NumberFormatSymbols_en_NA');
goog.provide('goog.i18n.NumberFormatSymbols_en_NF');
goog.provide('goog.i18n.NumberFormatSymbols_en_NG');
goog.provide('goog.i18n.NumberFormatSymbols_en_NL');
goog.provide('goog.i18n.NumberFormatSymbols_en_NR');
goog.provide('goog.i18n.NumberFormatSymbols_en_NU');
goog.provide('goog.i18n.NumberFormatSymbols_en_NZ');
goog.provide('goog.i18n.NumberFormatSymbols_en_PG');
goog.provide('goog.i18n.NumberFormatSymbols_en_PH');
goog.provide('goog.i18n.NumberFormatSymbols_en_PK');
goog.provide('goog.i18n.NumberFormatSymbols_en_PN');
goog.provide('goog.i18n.NumberFormatSymbols_en_PR');
goog.provide('goog.i18n.NumberFormatSymbols_en_PW');
goog.provide('goog.i18n.NumberFormatSymbols_en_RW');
goog.provide('goog.i18n.NumberFormatSymbols_en_SB');
goog.provide('goog.i18n.NumberFormatSymbols_en_SC');
goog.provide('goog.i18n.NumberFormatSymbols_en_SD');
goog.provide('goog.i18n.NumberFormatSymbols_en_SE');
goog.provide('goog.i18n.NumberFormatSymbols_en_SH');
goog.provide('goog.i18n.NumberFormatSymbols_en_SI');
goog.provide('goog.i18n.NumberFormatSymbols_en_SL');
goog.provide('goog.i18n.NumberFormatSymbols_en_SS');
goog.provide('goog.i18n.NumberFormatSymbols_en_SX');
goog.provide('goog.i18n.NumberFormatSymbols_en_SZ');
goog.provide('goog.i18n.NumberFormatSymbols_en_TC');
goog.provide('goog.i18n.NumberFormatSymbols_en_TK');
goog.provide('goog.i18n.NumberFormatSymbols_en_TO');
goog.provide('goog.i18n.NumberFormatSymbols_en_TT');
goog.provide('goog.i18n.NumberFormatSymbols_en_TV');
goog.provide('goog.i18n.NumberFormatSymbols_en_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_en_UG');
goog.provide('goog.i18n.NumberFormatSymbols_en_UM');
goog.provide('goog.i18n.NumberFormatSymbols_en_US_POSIX');
goog.provide('goog.i18n.NumberFormatSymbols_en_VC');
goog.provide('goog.i18n.NumberFormatSymbols_en_VG');
goog.provide('goog.i18n.NumberFormatSymbols_en_VI');
goog.provide('goog.i18n.NumberFormatSymbols_en_VU');
goog.provide('goog.i18n.NumberFormatSymbols_en_WS');
goog.provide('goog.i18n.NumberFormatSymbols_en_XA');
goog.provide('goog.i18n.NumberFormatSymbols_en_ZM');
goog.provide('goog.i18n.NumberFormatSymbols_en_ZW');
goog.provide('goog.i18n.NumberFormatSymbols_eo');
goog.provide('goog.i18n.NumberFormatSymbols_es_AR');
goog.provide('goog.i18n.NumberFormatSymbols_es_BO');
goog.provide('goog.i18n.NumberFormatSymbols_es_CL');
goog.provide('goog.i18n.NumberFormatSymbols_es_CO');
goog.provide('goog.i18n.NumberFormatSymbols_es_CR');
goog.provide('goog.i18n.NumberFormatSymbols_es_CU');
goog.provide('goog.i18n.NumberFormatSymbols_es_DO');
goog.provide('goog.i18n.NumberFormatSymbols_es_EA');
goog.provide('goog.i18n.NumberFormatSymbols_es_EC');
goog.provide('goog.i18n.NumberFormatSymbols_es_GQ');
goog.provide('goog.i18n.NumberFormatSymbols_es_GT');
goog.provide('goog.i18n.NumberFormatSymbols_es_HN');
goog.provide('goog.i18n.NumberFormatSymbols_es_IC');
goog.provide('goog.i18n.NumberFormatSymbols_es_NI');
goog.provide('goog.i18n.NumberFormatSymbols_es_PA');
goog.provide('goog.i18n.NumberFormatSymbols_es_PE');
goog.provide('goog.i18n.NumberFormatSymbols_es_PH');
goog.provide('goog.i18n.NumberFormatSymbols_es_PR');
goog.provide('goog.i18n.NumberFormatSymbols_es_PY');
goog.provide('goog.i18n.NumberFormatSymbols_es_SV');
goog.provide('goog.i18n.NumberFormatSymbols_es_UY');
goog.provide('goog.i18n.NumberFormatSymbols_es_VE');
goog.provide('goog.i18n.NumberFormatSymbols_et_EE');
goog.provide('goog.i18n.NumberFormatSymbols_eu_ES');
goog.provide('goog.i18n.NumberFormatSymbols_ewo');
goog.provide('goog.i18n.NumberFormatSymbols_ewo_CM');
goog.provide('goog.i18n.NumberFormatSymbols_fa_AF');
goog.provide('goog.i18n.NumberFormatSymbols_fa_IR');
goog.provide('goog.i18n.NumberFormatSymbols_ff');
goog.provide('goog.i18n.NumberFormatSymbols_ff_CM');
goog.provide('goog.i18n.NumberFormatSymbols_ff_GN');
goog.provide('goog.i18n.NumberFormatSymbols_ff_MR');
goog.provide('goog.i18n.NumberFormatSymbols_ff_SN');
goog.provide('goog.i18n.NumberFormatSymbols_fi_FI');
goog.provide('goog.i18n.NumberFormatSymbols_fil_PH');
goog.provide('goog.i18n.NumberFormatSymbols_fo');
goog.provide('goog.i18n.NumberFormatSymbols_fo_DK');
goog.provide('goog.i18n.NumberFormatSymbols_fo_FO');
goog.provide('goog.i18n.NumberFormatSymbols_fr_BE');
goog.provide('goog.i18n.NumberFormatSymbols_fr_BF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_BI');
goog.provide('goog.i18n.NumberFormatSymbols_fr_BJ');
goog.provide('goog.i18n.NumberFormatSymbols_fr_BL');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CD');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CG');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CH');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CI');
goog.provide('goog.i18n.NumberFormatSymbols_fr_CM');
goog.provide('goog.i18n.NumberFormatSymbols_fr_DJ');
goog.provide('goog.i18n.NumberFormatSymbols_fr_DZ');
goog.provide('goog.i18n.NumberFormatSymbols_fr_FR');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GA');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GN');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GP');
goog.provide('goog.i18n.NumberFormatSymbols_fr_GQ');
goog.provide('goog.i18n.NumberFormatSymbols_fr_HT');
goog.provide('goog.i18n.NumberFormatSymbols_fr_KM');
goog.provide('goog.i18n.NumberFormatSymbols_fr_LU');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MA');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MC');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MG');
goog.provide('goog.i18n.NumberFormatSymbols_fr_ML');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MQ');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MR');
goog.provide('goog.i18n.NumberFormatSymbols_fr_MU');
goog.provide('goog.i18n.NumberFormatSymbols_fr_NC');
goog.provide('goog.i18n.NumberFormatSymbols_fr_NE');
goog.provide('goog.i18n.NumberFormatSymbols_fr_PF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_PM');
goog.provide('goog.i18n.NumberFormatSymbols_fr_RE');
goog.provide('goog.i18n.NumberFormatSymbols_fr_RW');
goog.provide('goog.i18n.NumberFormatSymbols_fr_SC');
goog.provide('goog.i18n.NumberFormatSymbols_fr_SN');
goog.provide('goog.i18n.NumberFormatSymbols_fr_SY');
goog.provide('goog.i18n.NumberFormatSymbols_fr_TD');
goog.provide('goog.i18n.NumberFormatSymbols_fr_TG');
goog.provide('goog.i18n.NumberFormatSymbols_fr_TN');
goog.provide('goog.i18n.NumberFormatSymbols_fr_VU');
goog.provide('goog.i18n.NumberFormatSymbols_fr_WF');
goog.provide('goog.i18n.NumberFormatSymbols_fr_YT');
goog.provide('goog.i18n.NumberFormatSymbols_fur');
goog.provide('goog.i18n.NumberFormatSymbols_fur_IT');
goog.provide('goog.i18n.NumberFormatSymbols_fy');
goog.provide('goog.i18n.NumberFormatSymbols_fy_NL');
goog.provide('goog.i18n.NumberFormatSymbols_ga_IE');
goog.provide('goog.i18n.NumberFormatSymbols_gd');
goog.provide('goog.i18n.NumberFormatSymbols_gd_GB');
goog.provide('goog.i18n.NumberFormatSymbols_gl_ES');
goog.provide('goog.i18n.NumberFormatSymbols_gsw_CH');
goog.provide('goog.i18n.NumberFormatSymbols_gsw_FR');
goog.provide('goog.i18n.NumberFormatSymbols_gsw_LI');
goog.provide('goog.i18n.NumberFormatSymbols_gu_IN');
goog.provide('goog.i18n.NumberFormatSymbols_guz');
goog.provide('goog.i18n.NumberFormatSymbols_guz_KE');
goog.provide('goog.i18n.NumberFormatSymbols_gv');
goog.provide('goog.i18n.NumberFormatSymbols_gv_IM');
goog.provide('goog.i18n.NumberFormatSymbols_ha');
goog.provide('goog.i18n.NumberFormatSymbols_ha_GH');
goog.provide('goog.i18n.NumberFormatSymbols_ha_NE');
goog.provide('goog.i18n.NumberFormatSymbols_ha_NG');
goog.provide('goog.i18n.NumberFormatSymbols_haw_US');
goog.provide('goog.i18n.NumberFormatSymbols_he_IL');
goog.provide('goog.i18n.NumberFormatSymbols_hi_IN');
goog.provide('goog.i18n.NumberFormatSymbols_hr_BA');
goog.provide('goog.i18n.NumberFormatSymbols_hr_HR');
goog.provide('goog.i18n.NumberFormatSymbols_hsb');
goog.provide('goog.i18n.NumberFormatSymbols_hsb_DE');
goog.provide('goog.i18n.NumberFormatSymbols_hu_HU');
goog.provide('goog.i18n.NumberFormatSymbols_hy_AM');
goog.provide('goog.i18n.NumberFormatSymbols_id_ID');
goog.provide('goog.i18n.NumberFormatSymbols_ig');
goog.provide('goog.i18n.NumberFormatSymbols_ig_NG');
goog.provide('goog.i18n.NumberFormatSymbols_ii');
goog.provide('goog.i18n.NumberFormatSymbols_ii_CN');
goog.provide('goog.i18n.NumberFormatSymbols_is_IS');
goog.provide('goog.i18n.NumberFormatSymbols_it_CH');
goog.provide('goog.i18n.NumberFormatSymbols_it_IT');
goog.provide('goog.i18n.NumberFormatSymbols_it_SM');
goog.provide('goog.i18n.NumberFormatSymbols_ja_JP');
goog.provide('goog.i18n.NumberFormatSymbols_jgo');
goog.provide('goog.i18n.NumberFormatSymbols_jgo_CM');
goog.provide('goog.i18n.NumberFormatSymbols_jmc');
goog.provide('goog.i18n.NumberFormatSymbols_jmc_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_ka_GE');
goog.provide('goog.i18n.NumberFormatSymbols_kab');
goog.provide('goog.i18n.NumberFormatSymbols_kab_DZ');
goog.provide('goog.i18n.NumberFormatSymbols_kam');
goog.provide('goog.i18n.NumberFormatSymbols_kam_KE');
goog.provide('goog.i18n.NumberFormatSymbols_kde');
goog.provide('goog.i18n.NumberFormatSymbols_kde_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_kea');
goog.provide('goog.i18n.NumberFormatSymbols_kea_CV');
goog.provide('goog.i18n.NumberFormatSymbols_khq');
goog.provide('goog.i18n.NumberFormatSymbols_khq_ML');
goog.provide('goog.i18n.NumberFormatSymbols_ki');
goog.provide('goog.i18n.NumberFormatSymbols_ki_KE');
goog.provide('goog.i18n.NumberFormatSymbols_kk_KZ');
goog.provide('goog.i18n.NumberFormatSymbols_kkj');
goog.provide('goog.i18n.NumberFormatSymbols_kkj_CM');
goog.provide('goog.i18n.NumberFormatSymbols_kl');
goog.provide('goog.i18n.NumberFormatSymbols_kl_GL');
goog.provide('goog.i18n.NumberFormatSymbols_kln');
goog.provide('goog.i18n.NumberFormatSymbols_kln_KE');
goog.provide('goog.i18n.NumberFormatSymbols_km_KH');
goog.provide('goog.i18n.NumberFormatSymbols_kn_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ko_KP');
goog.provide('goog.i18n.NumberFormatSymbols_ko_KR');
goog.provide('goog.i18n.NumberFormatSymbols_kok');
goog.provide('goog.i18n.NumberFormatSymbols_kok_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ks');
goog.provide('goog.i18n.NumberFormatSymbols_ks_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ksb');
goog.provide('goog.i18n.NumberFormatSymbols_ksb_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_ksf');
goog.provide('goog.i18n.NumberFormatSymbols_ksf_CM');
goog.provide('goog.i18n.NumberFormatSymbols_ksh');
goog.provide('goog.i18n.NumberFormatSymbols_ksh_DE');
goog.provide('goog.i18n.NumberFormatSymbols_kw');
goog.provide('goog.i18n.NumberFormatSymbols_kw_GB');
goog.provide('goog.i18n.NumberFormatSymbols_ky_KG');
goog.provide('goog.i18n.NumberFormatSymbols_lag');
goog.provide('goog.i18n.NumberFormatSymbols_lag_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_lb');
goog.provide('goog.i18n.NumberFormatSymbols_lb_LU');
goog.provide('goog.i18n.NumberFormatSymbols_lg');
goog.provide('goog.i18n.NumberFormatSymbols_lg_UG');
goog.provide('goog.i18n.NumberFormatSymbols_lkt');
goog.provide('goog.i18n.NumberFormatSymbols_lkt_US');
goog.provide('goog.i18n.NumberFormatSymbols_ln_AO');
goog.provide('goog.i18n.NumberFormatSymbols_ln_CD');
goog.provide('goog.i18n.NumberFormatSymbols_ln_CF');
goog.provide('goog.i18n.NumberFormatSymbols_ln_CG');
goog.provide('goog.i18n.NumberFormatSymbols_lo_LA');
goog.provide('goog.i18n.NumberFormatSymbols_lrc');
goog.provide('goog.i18n.NumberFormatSymbols_lrc_IQ');
goog.provide('goog.i18n.NumberFormatSymbols_lrc_IR');
goog.provide('goog.i18n.NumberFormatSymbols_lt_LT');
goog.provide('goog.i18n.NumberFormatSymbols_lu');
goog.provide('goog.i18n.NumberFormatSymbols_lu_CD');
goog.provide('goog.i18n.NumberFormatSymbols_luo');
goog.provide('goog.i18n.NumberFormatSymbols_luo_KE');
goog.provide('goog.i18n.NumberFormatSymbols_luy');
goog.provide('goog.i18n.NumberFormatSymbols_luy_KE');
goog.provide('goog.i18n.NumberFormatSymbols_lv_LV');
goog.provide('goog.i18n.NumberFormatSymbols_mas');
goog.provide('goog.i18n.NumberFormatSymbols_mas_KE');
goog.provide('goog.i18n.NumberFormatSymbols_mas_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_mer');
goog.provide('goog.i18n.NumberFormatSymbols_mer_KE');
goog.provide('goog.i18n.NumberFormatSymbols_mfe');
goog.provide('goog.i18n.NumberFormatSymbols_mfe_MU');
goog.provide('goog.i18n.NumberFormatSymbols_mg');
goog.provide('goog.i18n.NumberFormatSymbols_mg_MG');
goog.provide('goog.i18n.NumberFormatSymbols_mgh');
goog.provide('goog.i18n.NumberFormatSymbols_mgh_MZ');
goog.provide('goog.i18n.NumberFormatSymbols_mgo');
goog.provide('goog.i18n.NumberFormatSymbols_mgo_CM');
goog.provide('goog.i18n.NumberFormatSymbols_mk_MK');
goog.provide('goog.i18n.NumberFormatSymbols_ml_IN');
goog.provide('goog.i18n.NumberFormatSymbols_mn_MN');
goog.provide('goog.i18n.NumberFormatSymbols_mr_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ms_BN');
goog.provide('goog.i18n.NumberFormatSymbols_ms_MY');
goog.provide('goog.i18n.NumberFormatSymbols_ms_SG');
goog.provide('goog.i18n.NumberFormatSymbols_mt_MT');
goog.provide('goog.i18n.NumberFormatSymbols_mua');
goog.provide('goog.i18n.NumberFormatSymbols_mua_CM');
goog.provide('goog.i18n.NumberFormatSymbols_my_MM');
goog.provide('goog.i18n.NumberFormatSymbols_mzn');
goog.provide('goog.i18n.NumberFormatSymbols_mzn_IR');
goog.provide('goog.i18n.NumberFormatSymbols_naq');
goog.provide('goog.i18n.NumberFormatSymbols_naq_NA');
goog.provide('goog.i18n.NumberFormatSymbols_nb_NO');
goog.provide('goog.i18n.NumberFormatSymbols_nb_SJ');
goog.provide('goog.i18n.NumberFormatSymbols_nd');
goog.provide('goog.i18n.NumberFormatSymbols_nd_ZW');
goog.provide('goog.i18n.NumberFormatSymbols_ne_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ne_NP');
goog.provide('goog.i18n.NumberFormatSymbols_nl_AW');
goog.provide('goog.i18n.NumberFormatSymbols_nl_BE');
goog.provide('goog.i18n.NumberFormatSymbols_nl_BQ');
goog.provide('goog.i18n.NumberFormatSymbols_nl_CW');
goog.provide('goog.i18n.NumberFormatSymbols_nl_NL');
goog.provide('goog.i18n.NumberFormatSymbols_nl_SR');
goog.provide('goog.i18n.NumberFormatSymbols_nl_SX');
goog.provide('goog.i18n.NumberFormatSymbols_nmg');
goog.provide('goog.i18n.NumberFormatSymbols_nmg_CM');
goog.provide('goog.i18n.NumberFormatSymbols_nn');
goog.provide('goog.i18n.NumberFormatSymbols_nn_NO');
goog.provide('goog.i18n.NumberFormatSymbols_nnh');
goog.provide('goog.i18n.NumberFormatSymbols_nnh_CM');
goog.provide('goog.i18n.NumberFormatSymbols_nus');
goog.provide('goog.i18n.NumberFormatSymbols_nus_SS');
goog.provide('goog.i18n.NumberFormatSymbols_nyn');
goog.provide('goog.i18n.NumberFormatSymbols_nyn_UG');
goog.provide('goog.i18n.NumberFormatSymbols_om');
goog.provide('goog.i18n.NumberFormatSymbols_om_ET');
goog.provide('goog.i18n.NumberFormatSymbols_om_KE');
goog.provide('goog.i18n.NumberFormatSymbols_or_IN');
goog.provide('goog.i18n.NumberFormatSymbols_os');
goog.provide('goog.i18n.NumberFormatSymbols_os_GE');
goog.provide('goog.i18n.NumberFormatSymbols_os_RU');
goog.provide('goog.i18n.NumberFormatSymbols_pa_Arab');
goog.provide('goog.i18n.NumberFormatSymbols_pa_Arab_PK');
goog.provide('goog.i18n.NumberFormatSymbols_pa_Guru');
goog.provide('goog.i18n.NumberFormatSymbols_pa_Guru_IN');
goog.provide('goog.i18n.NumberFormatSymbols_pl_PL');
goog.provide('goog.i18n.NumberFormatSymbols_ps');
goog.provide('goog.i18n.NumberFormatSymbols_ps_AF');
goog.provide('goog.i18n.NumberFormatSymbols_pt_AO');
goog.provide('goog.i18n.NumberFormatSymbols_pt_CV');
goog.provide('goog.i18n.NumberFormatSymbols_pt_GW');
goog.provide('goog.i18n.NumberFormatSymbols_pt_MO');
goog.provide('goog.i18n.NumberFormatSymbols_pt_MZ');
goog.provide('goog.i18n.NumberFormatSymbols_pt_ST');
goog.provide('goog.i18n.NumberFormatSymbols_pt_TL');
goog.provide('goog.i18n.NumberFormatSymbols_qu');
goog.provide('goog.i18n.NumberFormatSymbols_qu_BO');
goog.provide('goog.i18n.NumberFormatSymbols_qu_EC');
goog.provide('goog.i18n.NumberFormatSymbols_qu_PE');
goog.provide('goog.i18n.NumberFormatSymbols_rm');
goog.provide('goog.i18n.NumberFormatSymbols_rm_CH');
goog.provide('goog.i18n.NumberFormatSymbols_rn');
goog.provide('goog.i18n.NumberFormatSymbols_rn_BI');
goog.provide('goog.i18n.NumberFormatSymbols_ro_MD');
goog.provide('goog.i18n.NumberFormatSymbols_ro_RO');
goog.provide('goog.i18n.NumberFormatSymbols_rof');
goog.provide('goog.i18n.NumberFormatSymbols_rof_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_ru_BY');
goog.provide('goog.i18n.NumberFormatSymbols_ru_KG');
goog.provide('goog.i18n.NumberFormatSymbols_ru_KZ');
goog.provide('goog.i18n.NumberFormatSymbols_ru_MD');
goog.provide('goog.i18n.NumberFormatSymbols_ru_RU');
goog.provide('goog.i18n.NumberFormatSymbols_ru_UA');
goog.provide('goog.i18n.NumberFormatSymbols_rw');
goog.provide('goog.i18n.NumberFormatSymbols_rw_RW');
goog.provide('goog.i18n.NumberFormatSymbols_rwk');
goog.provide('goog.i18n.NumberFormatSymbols_rwk_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_sah');
goog.provide('goog.i18n.NumberFormatSymbols_sah_RU');
goog.provide('goog.i18n.NumberFormatSymbols_saq');
goog.provide('goog.i18n.NumberFormatSymbols_saq_KE');
goog.provide('goog.i18n.NumberFormatSymbols_sbp');
goog.provide('goog.i18n.NumberFormatSymbols_sbp_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_se');
goog.provide('goog.i18n.NumberFormatSymbols_se_FI');
goog.provide('goog.i18n.NumberFormatSymbols_se_NO');
goog.provide('goog.i18n.NumberFormatSymbols_se_SE');
goog.provide('goog.i18n.NumberFormatSymbols_seh');
goog.provide('goog.i18n.NumberFormatSymbols_seh_MZ');
goog.provide('goog.i18n.NumberFormatSymbols_ses');
goog.provide('goog.i18n.NumberFormatSymbols_ses_ML');
goog.provide('goog.i18n.NumberFormatSymbols_sg');
goog.provide('goog.i18n.NumberFormatSymbols_sg_CF');
goog.provide('goog.i18n.NumberFormatSymbols_shi');
goog.provide('goog.i18n.NumberFormatSymbols_shi_Latn');
goog.provide('goog.i18n.NumberFormatSymbols_shi_Latn_MA');
goog.provide('goog.i18n.NumberFormatSymbols_shi_Tfng');
goog.provide('goog.i18n.NumberFormatSymbols_shi_Tfng_MA');
goog.provide('goog.i18n.NumberFormatSymbols_si_LK');
goog.provide('goog.i18n.NumberFormatSymbols_sk_SK');
goog.provide('goog.i18n.NumberFormatSymbols_sl_SI');
goog.provide('goog.i18n.NumberFormatSymbols_smn');
goog.provide('goog.i18n.NumberFormatSymbols_smn_FI');
goog.provide('goog.i18n.NumberFormatSymbols_sn');
goog.provide('goog.i18n.NumberFormatSymbols_sn_ZW');
goog.provide('goog.i18n.NumberFormatSymbols_so');
goog.provide('goog.i18n.NumberFormatSymbols_so_DJ');
goog.provide('goog.i18n.NumberFormatSymbols_so_ET');
goog.provide('goog.i18n.NumberFormatSymbols_so_KE');
goog.provide('goog.i18n.NumberFormatSymbols_so_SO');
goog.provide('goog.i18n.NumberFormatSymbols_sq_AL');
goog.provide('goog.i18n.NumberFormatSymbols_sq_MK');
goog.provide('goog.i18n.NumberFormatSymbols_sq_XK');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Cyrl');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Cyrl_BA');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Cyrl_ME');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Cyrl_RS');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Cyrl_XK');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Latn_BA');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Latn_ME');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Latn_RS');
goog.provide('goog.i18n.NumberFormatSymbols_sr_Latn_XK');
goog.provide('goog.i18n.NumberFormatSymbols_sv_AX');
goog.provide('goog.i18n.NumberFormatSymbols_sv_FI');
goog.provide('goog.i18n.NumberFormatSymbols_sv_SE');
goog.provide('goog.i18n.NumberFormatSymbols_sw_CD');
goog.provide('goog.i18n.NumberFormatSymbols_sw_KE');
goog.provide('goog.i18n.NumberFormatSymbols_sw_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_sw_UG');
goog.provide('goog.i18n.NumberFormatSymbols_ta_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ta_LK');
goog.provide('goog.i18n.NumberFormatSymbols_ta_MY');
goog.provide('goog.i18n.NumberFormatSymbols_ta_SG');
goog.provide('goog.i18n.NumberFormatSymbols_te_IN');
goog.provide('goog.i18n.NumberFormatSymbols_teo');
goog.provide('goog.i18n.NumberFormatSymbols_teo_KE');
goog.provide('goog.i18n.NumberFormatSymbols_teo_UG');
goog.provide('goog.i18n.NumberFormatSymbols_th_TH');
goog.provide('goog.i18n.NumberFormatSymbols_ti');
goog.provide('goog.i18n.NumberFormatSymbols_ti_ER');
goog.provide('goog.i18n.NumberFormatSymbols_ti_ET');
goog.provide('goog.i18n.NumberFormatSymbols_to');
goog.provide('goog.i18n.NumberFormatSymbols_to_TO');
goog.provide('goog.i18n.NumberFormatSymbols_tr_CY');
goog.provide('goog.i18n.NumberFormatSymbols_tr_TR');
goog.provide('goog.i18n.NumberFormatSymbols_twq');
goog.provide('goog.i18n.NumberFormatSymbols_twq_NE');
goog.provide('goog.i18n.NumberFormatSymbols_tzm');
goog.provide('goog.i18n.NumberFormatSymbols_tzm_MA');
goog.provide('goog.i18n.NumberFormatSymbols_ug');
goog.provide('goog.i18n.NumberFormatSymbols_ug_CN');
goog.provide('goog.i18n.NumberFormatSymbols_uk_UA');
goog.provide('goog.i18n.NumberFormatSymbols_ur_IN');
goog.provide('goog.i18n.NumberFormatSymbols_ur_PK');
goog.provide('goog.i18n.NumberFormatSymbols_uz_Arab');
goog.provide('goog.i18n.NumberFormatSymbols_uz_Arab_AF');
goog.provide('goog.i18n.NumberFormatSymbols_uz_Cyrl');
goog.provide('goog.i18n.NumberFormatSymbols_uz_Cyrl_UZ');
goog.provide('goog.i18n.NumberFormatSymbols_uz_Latn');
goog.provide('goog.i18n.NumberFormatSymbols_uz_Latn_UZ');
goog.provide('goog.i18n.NumberFormatSymbols_vai');
goog.provide('goog.i18n.NumberFormatSymbols_vai_Latn');
goog.provide('goog.i18n.NumberFormatSymbols_vai_Latn_LR');
goog.provide('goog.i18n.NumberFormatSymbols_vai_Vaii');
goog.provide('goog.i18n.NumberFormatSymbols_vai_Vaii_LR');
goog.provide('goog.i18n.NumberFormatSymbols_vi_VN');
goog.provide('goog.i18n.NumberFormatSymbols_vun');
goog.provide('goog.i18n.NumberFormatSymbols_vun_TZ');
goog.provide('goog.i18n.NumberFormatSymbols_wae');
goog.provide('goog.i18n.NumberFormatSymbols_wae_CH');
goog.provide('goog.i18n.NumberFormatSymbols_xog');
goog.provide('goog.i18n.NumberFormatSymbols_xog_UG');
goog.provide('goog.i18n.NumberFormatSymbols_yav');
goog.provide('goog.i18n.NumberFormatSymbols_yav_CM');
goog.provide('goog.i18n.NumberFormatSymbols_yi');
goog.provide('goog.i18n.NumberFormatSymbols_yi_001');
goog.provide('goog.i18n.NumberFormatSymbols_yo');
goog.provide('goog.i18n.NumberFormatSymbols_yo_BJ');
goog.provide('goog.i18n.NumberFormatSymbols_yo_NG');
goog.provide('goog.i18n.NumberFormatSymbols_yue');
goog.provide('goog.i18n.NumberFormatSymbols_yue_HK');
goog.provide('goog.i18n.NumberFormatSymbols_zgh');
goog.provide('goog.i18n.NumberFormatSymbols_zgh_MA');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hans');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hans_CN');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hans_HK');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hans_MO');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hans_SG');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hant');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hant_HK');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hant_MO');
goog.provide('goog.i18n.NumberFormatSymbols_zh_Hant_TW');
goog.provide('goog.i18n.NumberFormatSymbols_zu_ZA');
goog.require('goog.i18n.NumberFormatSymbols');


/**
 * Number formatting symbols for locale af_NA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_af_NA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NAD'
};


/**
 * Number formatting symbols for locale af_ZA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_af_ZA = goog.i18n.NumberFormatSymbols_af;


/**
 * Number formatting symbols for locale agq.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_agq = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale agq_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_agq_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ak.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ak = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GHS'
};


/**
 * Number formatting symbols for locale ak_GH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ak_GH = goog.i18n.NumberFormatSymbols_ak;


/**
 * Number formatting symbols for locale am_ET.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_am_ET = goog.i18n.NumberFormatSymbols_am;


/**
 * Number formatting symbols for locale ar_001.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_001 = goog.i18n.NumberFormatSymbols_ar;


/**
 * Number formatting symbols for locale ar_AE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_AE = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'AED'
};


/**
 * Number formatting symbols for locale ar_BH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_BH = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.000;-¤ #,##0.000',
  DEF_CURRENCY_CODE: 'BHD'
};


/**
 * Number formatting symbols for locale ar_DJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_DJ = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'DJF'
};


/**
 * Number formatting symbols for locale ar_DZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_DZ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '٪',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '‎+',
  MINUS_SIGN: '‎-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ليس رقمًا',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'DZD'
};


/**
 * Number formatting symbols for locale ar_EG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_EG = goog.i18n.NumberFormatSymbols_ar;


/**
 * Number formatting symbols for locale ar_EH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_EH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '٪',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '‎+',
  MINUS_SIGN: '‎-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ليس رقمًا',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'MAD'
};


/**
 * Number formatting symbols for locale ar_ER.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_ER = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'ERN'
};


/**
 * Number formatting symbols for locale ar_IL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_IL = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'ILS'
};


/**
 * Number formatting symbols for locale ar_IQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_IQ = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'IQD'
};


/**
 * Number formatting symbols for locale ar_JO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_JO = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.000;-¤ #,##0.000',
  DEF_CURRENCY_CODE: 'JOD'
};


/**
 * Number formatting symbols for locale ar_KM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_KM = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'KMF'
};


/**
 * Number formatting symbols for locale ar_KW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_KW = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.000;-¤ #,##0.000',
  DEF_CURRENCY_CODE: 'KWD'
};


/**
 * Number formatting symbols for locale ar_LB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_LB = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'LBP'
};


/**
 * Number formatting symbols for locale ar_LY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_LY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '٪',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '‎+',
  MINUS_SIGN: '‎-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ليس رقمًا',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.000;-¤ #,##0.000',
  DEF_CURRENCY_CODE: 'LYD'
};


/**
 * Number formatting symbols for locale ar_MA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_MA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '٪',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '‎+',
  MINUS_SIGN: '‎-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ليس رقمًا',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'MAD'
};


/**
 * Number formatting symbols for locale ar_MR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_MR = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'MRO'
};


/**
 * Number formatting symbols for locale ar_OM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_OM = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.000;-¤ #,##0.000',
  DEF_CURRENCY_CODE: 'OMR'
};


/**
 * Number formatting symbols for locale ar_PS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_PS = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'ILS'
};


/**
 * Number formatting symbols for locale ar_QA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_QA = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'QAR'
};


/**
 * Number formatting symbols for locale ar_SA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_SA = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'SAR'
};


/**
 * Number formatting symbols for locale ar_SD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_SD = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'SDG'
};


/**
 * Number formatting symbols for locale ar_SO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_SO = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'SOS'
};


/**
 * Number formatting symbols for locale ar_SS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_SS = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'SSP'
};


/**
 * Number formatting symbols for locale ar_SY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_SY = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'SYP'
};


/**
 * Number formatting symbols for locale ar_TD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_TD = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ar_TN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_TN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '٪',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '‎+',
  MINUS_SIGN: '‎-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ليس رقمًا',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.000;-¤ #,##0.000',
  DEF_CURRENCY_CODE: 'TND'
};


/**
 * Number formatting symbols for locale ar_XB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_XB = goog.i18n.NumberFormatSymbols_ar;


/**
 * Number formatting symbols for locale ar_YE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ar_YE = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '٠',
  PLUS_SIGN: '‏+',
  MINUS_SIGN: '‏-',
  EXP_SYMBOL: 'اس',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ليس رقم',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'YER'
};


/**
 * Number formatting symbols for locale as.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_as = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '০',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale as_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_as_IN = goog.i18n.NumberFormatSymbols_as;


/**
 * Number formatting symbols for locale asa.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_asa = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale asa_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_asa_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale ast.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ast = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ND',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale ast_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ast_ES = goog.i18n.NumberFormatSymbols_ast;


/**
 * Number formatting symbols for locale az_Cyrl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_az_Cyrl = goog.i18n.NumberFormatSymbols_az;


/**
 * Number formatting symbols for locale az_Cyrl_AZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_az_Cyrl_AZ = goog.i18n.NumberFormatSymbols_az;


/**
 * Number formatting symbols for locale az_Latn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_az_Latn = goog.i18n.NumberFormatSymbols_az;


/**
 * Number formatting symbols for locale az_Latn_AZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_az_Latn_AZ = goog.i18n.NumberFormatSymbols_az;


/**
 * Number formatting symbols for locale bas.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bas = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale bas_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bas_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale be_BY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_be_BY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'BYR'
};


/**
 * Number formatting symbols for locale bem.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bem = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ZMW'
};


/**
 * Number formatting symbols for locale bem_ZM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bem_ZM = goog.i18n.NumberFormatSymbols_bem;


/**
 * Number formatting symbols for locale bez.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bez = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale bez_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bez_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale bg_BG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bg_BG = goog.i18n.NumberFormatSymbols_bg;


/**
 * Number formatting symbols for locale bm.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bm = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale bm_ML.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bm_ML = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale bn_BD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bn_BD = goog.i18n.NumberFormatSymbols_bn;


/**
 * Number formatting symbols for locale bn_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bn_IN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '০',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'সংখ্যা না',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '#,##,##0.00¤',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale bo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bo = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'CNY'
};


/**
 * Number formatting symbols for locale bo_CN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bo_CN = goog.i18n.NumberFormatSymbols_bo;


/**
 * Number formatting symbols for locale bo_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bo_IN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale br_FR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_br_FR = goog.i18n.NumberFormatSymbols_br;


/**
 * Number formatting symbols for locale brx.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_brx = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale brx_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_brx_IN = goog.i18n.NumberFormatSymbols_brx;


/**
 * Number formatting symbols for locale bs_Cyrl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bs_Cyrl = goog.i18n.NumberFormatSymbols_bs;


/**
 * Number formatting symbols for locale bs_Cyrl_BA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bs_Cyrl_BA = goog.i18n.NumberFormatSymbols_bs;


/**
 * Number formatting symbols for locale bs_Latn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bs_Latn = goog.i18n.NumberFormatSymbols_bs;


/**
 * Number formatting symbols for locale bs_Latn_BA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_bs_Latn_BA = goog.i18n.NumberFormatSymbols_bs;


/**
 * Number formatting symbols for locale ca_AD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca_AD = goog.i18n.NumberFormatSymbols_ca;


/**
 * Number formatting symbols for locale ca_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca_ES = goog.i18n.NumberFormatSymbols_ca;


/**
 * Number formatting symbols for locale ca_FR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca_FR = goog.i18n.NumberFormatSymbols_ca;


/**
 * Number formatting symbols for locale ca_IT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ca_IT = goog.i18n.NumberFormatSymbols_ca;


/**
 * Number formatting symbols for locale ce.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ce = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'Терхьаш дац',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'RUB'
};


/**
 * Number formatting symbols for locale ce_RU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ce_RU = goog.i18n.NumberFormatSymbols_ce;


/**
 * Number formatting symbols for locale cgg.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_cgg = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale cgg_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_cgg_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale chr_US.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_chr_US = goog.i18n.NumberFormatSymbols_chr;


/**
 * Number formatting symbols for locale cs_CZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_cs_CZ = goog.i18n.NumberFormatSymbols_cs;


/**
 * Number formatting symbols for locale cy_GB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_cy_GB = goog.i18n.NumberFormatSymbols_cy;


/**
 * Number formatting symbols for locale da_DK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_da_DK = goog.i18n.NumberFormatSymbols_da;


/**
 * Number formatting symbols for locale da_GL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_da_GL = goog.i18n.NumberFormatSymbols_da;


/**
 * Number formatting symbols for locale dav.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dav = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale dav_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dav_KE = goog.i18n.NumberFormatSymbols_dav;


/**
 * Number formatting symbols for locale de_BE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_BE = goog.i18n.NumberFormatSymbols_de;


/**
 * Number formatting symbols for locale de_DE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_DE = goog.i18n.NumberFormatSymbols_de;


/**
 * Number formatting symbols for locale de_LI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_LI = {
  DECIMAL_SEP: '.',
  GROUP_SEP: '\'',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale de_LU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_de_LU = goog.i18n.NumberFormatSymbols_de;


/**
 * Number formatting symbols for locale dje.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dje = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale dje_NE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dje_NE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale dsb.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dsb = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale dsb_DE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dsb_DE = goog.i18n.NumberFormatSymbols_dsb;


/**
 * Number formatting symbols for locale dua.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dua = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale dua_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dua_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale dyo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dyo = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale dyo_SN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dyo_SN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale dz.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dz = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '༠',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: 'གྲངས་མེད',
  NAN: 'ཨང་མད',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0 %',
  CURRENCY_PATTERN: '¤#,##,##0.00',
  DEF_CURRENCY_CODE: 'BTN'
};


/**
 * Number formatting symbols for locale dz_BT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_dz_BT = goog.i18n.NumberFormatSymbols_dz;


/**
 * Number formatting symbols for locale ebu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ebu = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale ebu_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ebu_KE = goog.i18n.NumberFormatSymbols_ebu;


/**
 * Number formatting symbols for locale ee.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ee = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'mnn',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GHS'
};


/**
 * Number formatting symbols for locale ee_GH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ee_GH = goog.i18n.NumberFormatSymbols_ee;


/**
 * Number formatting symbols for locale ee_TG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ee_TG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'mnn',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale el_CY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_el_CY = goog.i18n.NumberFormatSymbols_el;


/**
 * Number formatting symbols for locale el_GR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_el_GR = goog.i18n.NumberFormatSymbols_el;


/**
 * Number formatting symbols for locale en_001.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_001 = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_150.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_150 = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale en_AG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_AG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_AI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_AI = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_AS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_AS = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_AT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_AT = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_BB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BB = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'BBD'
};


/**
 * Number formatting symbols for locale en_BE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_BI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BI = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'BIF'
};


/**
 * Number formatting symbols for locale en_BM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'BMD'
};


/**
 * Number formatting symbols for locale en_BS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BS = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'BSD'
};


/**
 * Number formatting symbols for locale en_BW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BW = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'BWP'
};


/**
 * Number formatting symbols for locale en_BZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_BZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'BZD'
};


/**
 * Number formatting symbols for locale en_CC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_CC = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_CH = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale en_CK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_CK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NZD'
};


/**
 * Number formatting symbols for locale en_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_CM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale en_CX.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_CX = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_CY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_CY = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_DE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_DE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_DG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_DG = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_DK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_DK = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'DKK'
};


/**
 * Number formatting symbols for locale en_DM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_DM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_ER.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_ER = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ERN'
};


/**
 * Number formatting symbols for locale en_FI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_FI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_FJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_FJ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'FJD'
};


/**
 * Number formatting symbols for locale en_FK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_FK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'FKP'
};


/**
 * Number formatting symbols for locale en_FM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_FM = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_GD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GD = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_GG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale en_GH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GHS'
};


/**
 * Number formatting symbols for locale en_GI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GI = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GIP'
};


/**
 * Number formatting symbols for locale en_GM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GMD'
};


/**
 * Number formatting symbols for locale en_GU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GU = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_GY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_GY = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'GYD'
};


/**
 * Number formatting symbols for locale en_HK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_HK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'HKD'
};


/**
 * Number formatting symbols for locale en_IL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_IL = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ILS'
};


/**
 * Number formatting symbols for locale en_IM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_IM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale en_IO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_IO = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_JE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_JE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale en_JM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_JM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'JMD'
};


/**
 * Number formatting symbols for locale en_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_KE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale en_KI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_KI = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_KN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_KN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_KY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_KY = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KYD'
};


/**
 * Number formatting symbols for locale en_LC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_LC = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_LR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_LR = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'LRD'
};


/**
 * Number formatting symbols for locale en_LS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_LS = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ZAR'
};


/**
 * Number formatting symbols for locale en_MG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'MGA'
};


/**
 * Number formatting symbols for locale en_MH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MH = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_MO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MO = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'MOP'
};


/**
 * Number formatting symbols for locale en_MP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MP = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_MS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MS = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_MT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MT = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_MU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MU = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'MUR'
};


/**
 * Number formatting symbols for locale en_MW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MW = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'MWK'
};


/**
 * Number formatting symbols for locale en_MY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_MY = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'MYR'
};


/**
 * Number formatting symbols for locale en_NA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NA = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NAD'
};


/**
 * Number formatting symbols for locale en_NF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NF = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_NG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NGN'
};


/**
 * Number formatting symbols for locale en_NL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NL = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_NR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NR = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_NU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NU = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NZD'
};


/**
 * Number formatting symbols for locale en_NZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_NZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NZD'
};


/**
 * Number formatting symbols for locale en_PG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'PGK'
};


/**
 * Number formatting symbols for locale en_PH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'PHP'
};


/**
 * Number formatting symbols for locale en_PK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'PKR'
};


/**
 * Number formatting symbols for locale en_PN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NZD'
};


/**
 * Number formatting symbols for locale en_PR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PR = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_PW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_PW = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_RW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_RW = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'RWF'
};


/**
 * Number formatting symbols for locale en_SB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SB = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SBD'
};


/**
 * Number formatting symbols for locale en_SC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SC = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SCR'
};


/**
 * Number formatting symbols for locale en_SD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SD = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SDG'
};


/**
 * Number formatting symbols for locale en_SE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'SEK'
};


/**
 * Number formatting symbols for locale en_SH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SHP'
};


/**
 * Number formatting symbols for locale en_SI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'e',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale en_SL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SL = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'SLL'
};


/**
 * Number formatting symbols for locale en_SS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SS = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SSP'
};


/**
 * Number formatting symbols for locale en_SX.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SX = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ANG'
};


/**
 * Number formatting symbols for locale en_SZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_SZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SZL'
};


/**
 * Number formatting symbols for locale en_TC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TC = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_TK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NZD'
};


/**
 * Number formatting symbols for locale en_TO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TO = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TOP'
};


/**
 * Number formatting symbols for locale en_TT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TT = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TTD'
};


/**
 * Number formatting symbols for locale en_TV.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TV = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'AUD'
};


/**
 * Number formatting symbols for locale en_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale en_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale en_UM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_UM = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_US_POSIX.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_US_POSIX = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '0',
  INFINITY: 'INF',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#0.######',
  SCIENTIFIC_PATTERN: '0.000000E+000',
  PERCENT_PATTERN: '#0%',
  CURRENCY_PATTERN: '¤ #0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale en_VC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_VC = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XCD'
};


/**
 * Number formatting symbols for locale en_VG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_VG = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_VI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_VI = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_VU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_VU = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'VUV'
};


/**
 * Number formatting symbols for locale en_WS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_WS = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'WST'
};


/**
 * Number formatting symbols for locale en_XA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_XA = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale en_ZM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_ZM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ZMW'
};


/**
 * Number formatting symbols for locale en_ZW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_en_ZW = goog.i18n.NumberFormatSymbols_en;


/**
 * Number formatting symbols for locale eo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_eo = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale es_AR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_AR = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'ARS'
};


/**
 * Number formatting symbols for locale es_BO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_BO = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'BOB'
};


/**
 * Number formatting symbols for locale es_CL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_CL = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0;¤-#,##0',
  DEF_CURRENCY_CODE: 'CLP'
};


/**
 * Number formatting symbols for locale es_CO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_CO = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'COP'
};


/**
 * Number formatting symbols for locale es_CR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_CR = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'CRC'
};


/**
 * Number formatting symbols for locale es_CU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_CU = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'CUP'
};


/**
 * Number formatting symbols for locale es_DO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_DO = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'DOP'
};


/**
 * Number formatting symbols for locale es_EA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_EA = goog.i18n.NumberFormatSymbols_es;


/**
 * Number formatting symbols for locale es_EC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_EC = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale es_GQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_GQ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale es_GT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_GT = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GTQ'
};


/**
 * Number formatting symbols for locale es_HN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_HN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'HNL'
};


/**
 * Number formatting symbols for locale es_IC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_IC = goog.i18n.NumberFormatSymbols_es;


/**
 * Number formatting symbols for locale es_NI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_NI = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NIO'
};


/**
 * Number formatting symbols for locale es_PA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_PA = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'PAB'
};


/**
 * Number formatting symbols for locale es_PE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_PE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'PEN'
};


/**
 * Number formatting symbols for locale es_PH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_PH = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'PHP'
};


/**
 * Number formatting symbols for locale es_PR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_PR = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale es_PY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_PY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤ #,##0;¤ -#,##0',
  DEF_CURRENCY_CODE: 'PYG'
};


/**
 * Number formatting symbols for locale es_SV.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_SV = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale es_UY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_UY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'UYU'
};


/**
 * Number formatting symbols for locale es_VE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_es_VE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'VEF'
};


/**
 * Number formatting symbols for locale et_EE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_et_EE = goog.i18n.NumberFormatSymbols_et;


/**
 * Number formatting symbols for locale eu_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_eu_ES = goog.i18n.NumberFormatSymbols_eu;


/**
 * Number formatting symbols for locale ewo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ewo = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ewo_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ewo_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fa_AF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fa_AF = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎−',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ناعدد',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '‎¤#,##0;-‎¤#,##0',
  DEF_CURRENCY_CODE: 'AFN'
};


/**
 * Number formatting symbols for locale fa_IR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fa_IR = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎−',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'ناعدد',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '‎¤#,##0;-‎¤#,##0',
  DEF_CURRENCY_CODE: 'IRR'
};


/**
 * Number formatting symbols for locale ff.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ff = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale ff_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ff_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ff_GN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ff_GN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'GNF'
};


/**
 * Number formatting symbols for locale ff_MR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ff_MR = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'MRO'
};


/**
 * Number formatting symbols for locale ff_SN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ff_SN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fi_FI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fi_FI = goog.i18n.NumberFormatSymbols_fi;


/**
 * Number formatting symbols for locale fil_PH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fil_PH = goog.i18n.NumberFormatSymbols_fil;


/**
 * Number formatting symbols for locale fo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fo = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'DKK'
};


/**
 * Number formatting symbols for locale fo_DK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fo_DK = goog.i18n.NumberFormatSymbols_fo;


/**
 * Number formatting symbols for locale fo_FO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fo_FO = goog.i18n.NumberFormatSymbols_fo;


/**
 * Number formatting symbols for locale fr_BE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_BE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale fr_BF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_BF = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_BI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_BI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'BIF'
};


/**
 * Number formatting symbols for locale fr_BJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_BJ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_BL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_BL = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_CD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CD = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'CDF'
};


/**
 * Number formatting symbols for locale fr_CF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CF = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fr_CG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CG = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fr_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale fr_CI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fr_DJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_DJ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'DJF'
};


/**
 * Number formatting symbols for locale fr_DZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_DZ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'DZD'
};


/**
 * Number formatting symbols for locale fr_FR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_FR = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_GA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fr_GF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GF = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_GN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'GNF'
};


/**
 * Number formatting symbols for locale fr_GP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GP = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_GQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_GQ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fr_HT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_HT = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'HTG'
};


/**
 * Number formatting symbols for locale fr_KM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_KM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'KMF'
};


/**
 * Number formatting symbols for locale fr_LU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_LU = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale fr_MA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MAD'
};


/**
 * Number formatting symbols for locale fr_MC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MC = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_MF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MF = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_MG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MG = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'MGA'
};


/**
 * Number formatting symbols for locale fr_ML.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_ML = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_MQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MQ = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_MR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MR = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'MRO'
};


/**
 * Number formatting symbols for locale fr_MU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_MU = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'MUR'
};


/**
 * Number formatting symbols for locale fr_NC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_NC = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XPF'
};


/**
 * Number formatting symbols for locale fr_NE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_NE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_PF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_PF = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XPF'
};


/**
 * Number formatting symbols for locale fr_PM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_PM = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_RE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_RE = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fr_RW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_RW = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'RWF'
};


/**
 * Number formatting symbols for locale fr_SC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_SC = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'SCR'
};


/**
 * Number formatting symbols for locale fr_SN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_SN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_SY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_SY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'SYP'
};


/**
 * Number formatting symbols for locale fr_TD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_TD = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale fr_TG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_TG = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale fr_TN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_TN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.000 ¤',
  DEF_CURRENCY_CODE: 'TND'
};


/**
 * Number formatting symbols for locale fr_VU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_VU = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'VUV'
};


/**
 * Number formatting symbols for locale fr_WF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_WF = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XPF'
};


/**
 * Number formatting symbols for locale fr_YT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fr_YT = goog.i18n.NumberFormatSymbols_fr;


/**
 * Number formatting symbols for locale fur.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fur = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale fur_IT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fur_IT = goog.i18n.NumberFormatSymbols_fur;


/**
 * Number formatting symbols for locale fy.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fy = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤ #,##0.00-',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale fy_NL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_fy_NL = goog.i18n.NumberFormatSymbols_fy;


/**
 * Number formatting symbols for locale ga_IE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ga_IE = goog.i18n.NumberFormatSymbols_ga;


/**
 * Number formatting symbols for locale gd.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gd = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale gd_GB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gd_GB = goog.i18n.NumberFormatSymbols_gd;


/**
 * Number formatting symbols for locale gl_ES.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gl_ES = goog.i18n.NumberFormatSymbols_gl;


/**
 * Number formatting symbols for locale gsw_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gsw_CH = goog.i18n.NumberFormatSymbols_gsw;


/**
 * Number formatting symbols for locale gsw_FR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gsw_FR = {
  DECIMAL_SEP: '.',
  GROUP_SEP: '’',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale gsw_LI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gsw_LI = goog.i18n.NumberFormatSymbols_gsw;


/**
 * Number formatting symbols for locale gu_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gu_IN = goog.i18n.NumberFormatSymbols_gu;


/**
 * Number formatting symbols for locale guz.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_guz = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale guz_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_guz_KE = goog.i18n.NumberFormatSymbols_guz;


/**
 * Number formatting symbols for locale gv.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gv = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale gv_IM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_gv_IM = goog.i18n.NumberFormatSymbols_gv;


/**
 * Number formatting symbols for locale ha.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ha = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'NGN'
};


/**
 * Number formatting symbols for locale ha_GH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ha_GH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'GHS'
};


/**
 * Number formatting symbols for locale ha_NE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ha_NE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale ha_NG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ha_NG = goog.i18n.NumberFormatSymbols_ha;


/**
 * Number formatting symbols for locale haw_US.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_haw_US = goog.i18n.NumberFormatSymbols_haw;


/**
 * Number formatting symbols for locale he_IL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_he_IL = goog.i18n.NumberFormatSymbols_he;


/**
 * Number formatting symbols for locale hi_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hi_IN = goog.i18n.NumberFormatSymbols_hi;


/**
 * Number formatting symbols for locale hr_BA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hr_BA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'BAM'
};


/**
 * Number formatting symbols for locale hr_HR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hr_HR = goog.i18n.NumberFormatSymbols_hr;


/**
 * Number formatting symbols for locale hsb.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hsb = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale hsb_DE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hsb_DE = goog.i18n.NumberFormatSymbols_hsb;


/**
 * Number formatting symbols for locale hu_HU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hu_HU = goog.i18n.NumberFormatSymbols_hu;


/**
 * Number formatting symbols for locale hy_AM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_hy_AM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'AMD'
};


/**
 * Number formatting symbols for locale id_ID.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_id_ID = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'IDR'
};


/**
 * Number formatting symbols for locale ig.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ig = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NGN'
};


/**
 * Number formatting symbols for locale ig_NG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ig_NG = goog.i18n.NumberFormatSymbols_ig;


/**
 * Number formatting symbols for locale ii.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ii = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'CNY'
};


/**
 * Number formatting symbols for locale ii_CN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ii_CN = goog.i18n.NumberFormatSymbols_ii;


/**
 * Number formatting symbols for locale is_IS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_is_IS = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'ISK'
};


/**
 * Number formatting symbols for locale it_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_it_CH = {
  DECIMAL_SEP: '.',
  GROUP_SEP: '\'',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale it_IT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_it_IT = goog.i18n.NumberFormatSymbols_it;


/**
 * Number formatting symbols for locale it_SM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_it_SM = goog.i18n.NumberFormatSymbols_it;


/**
 * Number formatting symbols for locale ja_JP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ja_JP = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'JPY'
};


/**
 * Number formatting symbols for locale jgo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_jgo = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale jgo_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_jgo_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale jmc.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_jmc = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale jmc_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_jmc_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale ka_GE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ka_GE = goog.i18n.NumberFormatSymbols_ka;


/**
 * Number formatting symbols for locale kab.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kab = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'DZD'
};


/**
 * Number formatting symbols for locale kab_DZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kab_DZ = goog.i18n.NumberFormatSymbols_kab;


/**
 * Number formatting symbols for locale kam.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kam = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale kam_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kam_KE = goog.i18n.NumberFormatSymbols_kam;


/**
 * Number formatting symbols for locale kde.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kde = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale kde_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kde_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale kea.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kea = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'CVE'
};


/**
 * Number formatting symbols for locale kea_CV.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kea_CV = goog.i18n.NumberFormatSymbols_kea;


/**
 * Number formatting symbols for locale khq.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_khq = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale khq_ML.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_khq_ML = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale ki.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ki = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale ki_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ki_KE = goog.i18n.NumberFormatSymbols_ki;


/**
 * Number formatting symbols for locale kk_KZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kk_KZ = goog.i18n.NumberFormatSymbols_kk;


/**
 * Number formatting symbols for locale kkj.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kkj = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale kkj_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kkj_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale kl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kl = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤#,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'DKK'
};


/**
 * Number formatting symbols for locale kl_GL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kl_GL = goog.i18n.NumberFormatSymbols_kl;


/**
 * Number formatting symbols for locale kln.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kln = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale kln_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kln_KE = goog.i18n.NumberFormatSymbols_kln;


/**
 * Number formatting symbols for locale km_KH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_km_KH = goog.i18n.NumberFormatSymbols_km;


/**
 * Number formatting symbols for locale kn_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kn_IN = goog.i18n.NumberFormatSymbols_kn;


/**
 * Number formatting symbols for locale ko_KP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ko_KP = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'KPW'
};


/**
 * Number formatting symbols for locale ko_KR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ko_KR = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'KRW'
};


/**
 * Number formatting symbols for locale kok.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kok = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale kok_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kok_IN = goog.i18n.NumberFormatSymbols_kok;


/**
 * Number formatting symbols for locale ks.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ks = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###;-#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##,##0%;-#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0.00;-¤ #,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale ks_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ks_IN = goog.i18n.NumberFormatSymbols_ks;


/**
 * Number formatting symbols for locale ksb.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ksb = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale ksb_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ksb_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale ksf.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ksf = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ksf_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ksf_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ksh.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ksh = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '¤¤¤',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale ksh_DE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ksh_DE = goog.i18n.NumberFormatSymbols_ksh;


/**
 * Number formatting symbols for locale kw.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kw = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'GBP'
};


/**
 * Number formatting symbols for locale kw_GB.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_kw_GB = goog.i18n.NumberFormatSymbols_kw;


/**
 * Number formatting symbols for locale ky_KG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ky_KG = goog.i18n.NumberFormatSymbols_ky;


/**
 * Number formatting symbols for locale lag.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lag = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale lag_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lag_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale lb.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lb = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale lb_LU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lb_LU = goog.i18n.NumberFormatSymbols_lb;


/**
 * Number formatting symbols for locale lg.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lg = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale lg_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lg_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale lkt.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lkt = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale lkt_US.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lkt_US = goog.i18n.NumberFormatSymbols_lkt;


/**
 * Number formatting symbols for locale ln_AO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ln_AO = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'AOA'
};


/**
 * Number formatting symbols for locale ln_CD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ln_CD = goog.i18n.NumberFormatSymbols_ln;


/**
 * Number formatting symbols for locale ln_CF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ln_CF = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale ln_CG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ln_CG = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale lo_LA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lo_LA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ບໍ່​ແມ່ນ​ໂຕ​ເລກ',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0;¤-#,##0',
  DEF_CURRENCY_CODE: 'LAK'
};


/**
 * Number formatting symbols for locale lrc.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lrc = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'IRR'
};


/**
 * Number formatting symbols for locale lrc_IQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lrc_IQ = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'IQD'
};


/**
 * Number formatting symbols for locale lrc_IR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lrc_IR = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'IRR'
};


/**
 * Number formatting symbols for locale lt_LT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lt_LT = goog.i18n.NumberFormatSymbols_lt;


/**
 * Number formatting symbols for locale lu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lu = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'CDF'
};


/**
 * Number formatting symbols for locale lu_CD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lu_CD = goog.i18n.NumberFormatSymbols_lu;


/**
 * Number formatting symbols for locale luo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_luo = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale luo_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_luo_KE = goog.i18n.NumberFormatSymbols_luo;


/**
 * Number formatting symbols for locale luy.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_luy = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00;¤- #,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale luy_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_luy_KE = goog.i18n.NumberFormatSymbols_luy;


/**
 * Number formatting symbols for locale lv_LV.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_lv_LV = goog.i18n.NumberFormatSymbols_lv;


/**
 * Number formatting symbols for locale mas.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mas = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale mas_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mas_KE = goog.i18n.NumberFormatSymbols_mas;


/**
 * Number formatting symbols for locale mas_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mas_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale mer.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mer = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale mer_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mer_KE = goog.i18n.NumberFormatSymbols_mer;


/**
 * Number formatting symbols for locale mfe.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mfe = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'MUR'
};


/**
 * Number formatting symbols for locale mfe_MU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mfe_MU = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'MUR'
};


/**
 * Number formatting symbols for locale mg.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mg = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'MGA'
};


/**
 * Number formatting symbols for locale mg_MG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mg_MG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'MGA'
};


/**
 * Number formatting symbols for locale mgh.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mgh = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'MZN'
};


/**
 * Number formatting symbols for locale mgh_MZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mgh_MZ = goog.i18n.NumberFormatSymbols_mgh;


/**
 * Number formatting symbols for locale mgo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mgo = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale mgo_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mgo_CM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale mk_MK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mk_MK = goog.i18n.NumberFormatSymbols_mk;


/**
 * Number formatting symbols for locale ml_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ml_IN = goog.i18n.NumberFormatSymbols_ml;


/**
 * Number formatting symbols for locale mn_MN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mn_MN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'MNT'
};


/**
 * Number formatting symbols for locale mr_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mr_IN = goog.i18n.NumberFormatSymbols_mr;


/**
 * Number formatting symbols for locale ms_BN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ms_BN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'BND'
};


/**
 * Number formatting symbols for locale ms_MY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ms_MY = goog.i18n.NumberFormatSymbols_ms;


/**
 * Number formatting symbols for locale ms_SG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ms_SG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SGD'
};


/**
 * Number formatting symbols for locale mt_MT.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mt_MT = goog.i18n.NumberFormatSymbols_mt;


/**
 * Number formatting symbols for locale mua.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mua = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale mua_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mua_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale my_MM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_my_MM = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '၀',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'ဂဏန်းမဟုတ်သော',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'MMK'
};


/**
 * Number formatting symbols for locale mzn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mzn = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'IRR'
};


/**
 * Number formatting symbols for locale mzn_IR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_mzn_IR = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'IRR'
};


/**
 * Number formatting symbols for locale naq.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_naq = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NAD'
};


/**
 * Number formatting symbols for locale naq_NA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_naq_NA = goog.i18n.NumberFormatSymbols_naq;


/**
 * Number formatting symbols for locale nb_NO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nb_NO = goog.i18n.NumberFormatSymbols_nb;


/**
 * Number formatting symbols for locale nb_SJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nb_SJ = goog.i18n.NumberFormatSymbols_nb;


/**
 * Number formatting symbols for locale nd.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nd = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale nd_ZW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nd_ZW = goog.i18n.NumberFormatSymbols_nd;


/**
 * Number formatting symbols for locale ne_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ne_IN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '०',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale ne_NP.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ne_NP = goog.i18n.NumberFormatSymbols_ne;


/**
 * Number formatting symbols for locale nl_AW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_AW = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤ -#,##0.00',
  DEF_CURRENCY_CODE: 'AWG'
};


/**
 * Number formatting symbols for locale nl_BE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_BE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale nl_BQ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_BQ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤ -#,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale nl_CW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_CW = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤ -#,##0.00',
  DEF_CURRENCY_CODE: 'ANG'
};


/**
 * Number formatting symbols for locale nl_NL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_NL = goog.i18n.NumberFormatSymbols_nl;


/**
 * Number formatting symbols for locale nl_SR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_SR = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤ -#,##0.00',
  DEF_CURRENCY_CODE: 'SRD'
};


/**
 * Number formatting symbols for locale nl_SX.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nl_SX = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;¤ -#,##0.00',
  DEF_CURRENCY_CODE: 'ANG'
};


/**
 * Number formatting symbols for locale nmg.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nmg = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale nmg_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nmg_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale nn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nn = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'NOK'
};


/**
 * Number formatting symbols for locale nn_NO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nn_NO = goog.i18n.NumberFormatSymbols_nn;


/**
 * Number formatting symbols for locale nnh.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nnh = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale nnh_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nnh_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale nus.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nus = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SSP'
};


/**
 * Number formatting symbols for locale nus_SS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nus_SS = goog.i18n.NumberFormatSymbols_nus;


/**
 * Number formatting symbols for locale nyn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nyn = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale nyn_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_nyn_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale om.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_om = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ETB'
};


/**
 * Number formatting symbols for locale om_ET.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_om_ET = goog.i18n.NumberFormatSymbols_om;


/**
 * Number formatting symbols for locale om_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_om_KE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale or_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_or_IN = goog.i18n.NumberFormatSymbols_or;


/**
 * Number formatting symbols for locale os.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_os = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'НН',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'GEL'
};


/**
 * Number formatting symbols for locale os_GE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_os_GE = goog.i18n.NumberFormatSymbols_os;


/**
 * Number formatting symbols for locale os_RU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_os_RU = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'НН',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'RUB'
};


/**
 * Number formatting symbols for locale pa_Arab.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pa_Arab = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'PKR'
};


/**
 * Number formatting symbols for locale pa_Arab_PK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pa_Arab_PK = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'PKR'
};


/**
 * Number formatting symbols for locale pa_Guru.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pa_Guru = goog.i18n.NumberFormatSymbols_pa;


/**
 * Number formatting symbols for locale pa_Guru_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pa_Guru_IN = goog.i18n.NumberFormatSymbols_pa;


/**
 * Number formatting symbols for locale pl_PL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pl_PL = goog.i18n.NumberFormatSymbols_pl;


/**
 * Number formatting symbols for locale ps.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ps = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'AFN'
};


/**
 * Number formatting symbols for locale ps_AF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ps_AF = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤;-#,##0 ¤',
  DEF_CURRENCY_CODE: 'AFN'
};


/**
 * Number formatting symbols for locale pt_AO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_AO = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'AOA'
};


/**
 * Number formatting symbols for locale pt_CV.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_CV = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'CVE'
};


/**
 * Number formatting symbols for locale pt_GW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_GW = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale pt_MO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_MO = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MOP'
};


/**
 * Number formatting symbols for locale pt_MZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_MZ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MZN'
};


/**
 * Number formatting symbols for locale pt_ST.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_ST = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'STD'
};


/**
 * Number formatting symbols for locale pt_TL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_pt_TL = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale qu.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_qu = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'PEN'
};


/**
 * Number formatting symbols for locale qu_BO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_qu_BO = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'BOB'
};


/**
 * Number formatting symbols for locale qu_EC.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_qu_EC = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale qu_PE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_qu_PE = goog.i18n.NumberFormatSymbols_qu;


/**
 * Number formatting symbols for locale rm.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rm = {
  DECIMAL_SEP: '.',
  GROUP_SEP: '’',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale rm_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rm_CH = goog.i18n.NumberFormatSymbols_rm;


/**
 * Number formatting symbols for locale rn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rn = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'BIF'
};


/**
 * Number formatting symbols for locale rn_BI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rn_BI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'BIF'
};


/**
 * Number formatting symbols for locale ro_MD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ro_MD = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MDL'
};


/**
 * Number formatting symbols for locale ro_RO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ro_RO = goog.i18n.NumberFormatSymbols_ro;


/**
 * Number formatting symbols for locale rof.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rof = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale rof_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rof_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale ru_BY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_BY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'не число',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'BYR'
};


/**
 * Number formatting symbols for locale ru_KG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_KG = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'не число',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'KGS'
};


/**
 * Number formatting symbols for locale ru_KZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_KZ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'не число',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'KZT'
};


/**
 * Number formatting symbols for locale ru_MD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_MD = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'не число',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MDL'
};


/**
 * Number formatting symbols for locale ru_RU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_RU = goog.i18n.NumberFormatSymbols_ru;


/**
 * Number formatting symbols for locale ru_UA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ru_UA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'не число',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'UAH'
};


/**
 * Number formatting symbols for locale rw.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rw = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'RWF'
};


/**
 * Number formatting symbols for locale rw_RW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rw_RW = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'RWF'
};


/**
 * Number formatting symbols for locale rwk.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rwk = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale rwk_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_rwk_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale sah.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sah = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'RUB'
};


/**
 * Number formatting symbols for locale sah_RU.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sah_RU = goog.i18n.NumberFormatSymbols_sah;


/**
 * Number formatting symbols for locale saq.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_saq = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale saq_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_saq_KE = goog.i18n.NumberFormatSymbols_saq;


/**
 * Number formatting symbols for locale sbp.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sbp = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale sbp_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sbp_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale se.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_se = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '¤¤¤',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'NOK'
};


/**
 * Number formatting symbols for locale se_FI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_se_FI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '¤¤¤',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale se_NO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_se_NO = goog.i18n.NumberFormatSymbols_se;


/**
 * Number formatting symbols for locale se_SE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_se_SE = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '¤¤¤',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'SEK'
};


/**
 * Number formatting symbols for locale seh.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_seh = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'MZN'
};


/**
 * Number formatting symbols for locale seh_MZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_seh_MZ = goog.i18n.NumberFormatSymbols_seh;


/**
 * Number formatting symbols for locale ses.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ses = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale ses_ML.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ses_ML = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale sg.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sg = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00;¤-#,##0.00',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale sg_CF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sg_CF = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0;¤-#,##0',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale shi.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_shi = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'MAD'
};


/**
 * Number formatting symbols for locale shi_Latn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_shi_Latn = goog.i18n.NumberFormatSymbols_shi;


/**
 * Number formatting symbols for locale shi_Latn_MA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_shi_Latn_MA = goog.i18n.NumberFormatSymbols_shi;


/**
 * Number formatting symbols for locale shi_Tfng.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_shi_Tfng = goog.i18n.NumberFormatSymbols_shi;


/**
 * Number formatting symbols for locale shi_Tfng_MA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_shi_Tfng_MA = goog.i18n.NumberFormatSymbols_shi;


/**
 * Number formatting symbols for locale si_LK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_si_LK = goog.i18n.NumberFormatSymbols_si;


/**
 * Number formatting symbols for locale sk_SK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sk_SK = goog.i18n.NumberFormatSymbols_sk;


/**
 * Number formatting symbols for locale sl_SI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sl_SI = goog.i18n.NumberFormatSymbols_sl;


/**
 * Number formatting symbols for locale smn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_smn = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'epiloho',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale smn_FI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_smn_FI = goog.i18n.NumberFormatSymbols_smn;


/**
 * Number formatting symbols for locale sn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sn = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'USD'
};


/**
 * Number formatting symbols for locale sn_ZW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sn_ZW = goog.i18n.NumberFormatSymbols_sn;


/**
 * Number formatting symbols for locale so.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_so = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SOS'
};


/**
 * Number formatting symbols for locale so_DJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_so_DJ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'DJF'
};


/**
 * Number formatting symbols for locale so_ET.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_so_ET = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ETB'
};


/**
 * Number formatting symbols for locale so_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_so_KE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale so_SO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_so_SO = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'SOS'
};


/**
 * Number formatting symbols for locale sq_AL.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sq_AL = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'ALL'
};


/**
 * Number formatting symbols for locale sq_MK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sq_MK = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MKD'
};


/**
 * Number formatting symbols for locale sq_XK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sq_XK = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sr_Cyrl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Cyrl = goog.i18n.NumberFormatSymbols_sr;


/**
 * Number formatting symbols for locale sr_Cyrl_BA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Cyrl_BA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'BAM'
};


/**
 * Number formatting symbols for locale sr_Cyrl_ME.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Cyrl_ME = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sr_Cyrl_RS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Cyrl_RS = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'RSD'
};


/**
 * Number formatting symbols for locale sr_Cyrl_XK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Cyrl_XK = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sr_Latn_BA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Latn_BA = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'BAM'
};


/**
 * Number formatting symbols for locale sr_Latn_ME.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Latn_ME = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sr_Latn_RS.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Latn_RS = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'RSD'
};


/**
 * Number formatting symbols for locale sr_Latn_XK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sr_Latn_XK = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sv_AX.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sv_AX = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '¤¤¤',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sv_FI.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sv_FI = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '−',
  EXP_SYMBOL: '×10^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '¤¤¤',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0 %;-#,##0 %',
  CURRENCY_PATTERN: '#,##0.00 ¤;-#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale sv_SE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sv_SE = goog.i18n.NumberFormatSymbols_sv;


/**
 * Number formatting symbols for locale sw_CD.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sw_CD = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'CDF'
};


/**
 * Number formatting symbols for locale sw_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sw_KE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale sw_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sw_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale sw_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_sw_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale ta_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ta_IN = goog.i18n.NumberFormatSymbols_ta;


/**
 * Number formatting symbols for locale ta_LK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ta_LK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0.00',
  DEF_CURRENCY_CODE: 'LKR'
};


/**
 * Number formatting symbols for locale ta_MY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ta_MY = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'MYR'
};


/**
 * Number formatting symbols for locale ta_SG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ta_SG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'SGD'
};


/**
 * Number formatting symbols for locale te_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_te_IN = goog.i18n.NumberFormatSymbols_te;


/**
 * Number formatting symbols for locale teo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_teo = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale teo_KE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_teo_KE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'KES'
};


/**
 * Number formatting symbols for locale teo_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_teo_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale th_TH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_th_TH = goog.i18n.NumberFormatSymbols_th;


/**
 * Number formatting symbols for locale ti.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ti = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ETB'
};


/**
 * Number formatting symbols for locale ti_ER.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ti_ER = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'ERN'
};


/**
 * Number formatting symbols for locale ti_ET.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ti_ET = goog.i18n.NumberFormatSymbols_ti;


/**
 * Number formatting symbols for locale to.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_to = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'TF',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'TOP'
};


/**
 * Number formatting symbols for locale to_TO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_to_TO = goog.i18n.NumberFormatSymbols_to;


/**
 * Number formatting symbols for locale tr_CY.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tr_CY = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '%#,##0',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale tr_TR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tr_TR = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '%#,##0',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TRY'
};


/**
 * Number formatting symbols for locale twq.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_twq = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale twq_NE.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_twq_NE = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0¤',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale tzm.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tzm = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'MAD'
};


/**
 * Number formatting symbols for locale tzm_MA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_tzm_MA = goog.i18n.NumberFormatSymbols_tzm;


/**
 * Number formatting symbols for locale ug.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ug = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'CNY'
};


/**
 * Number formatting symbols for locale ug_CN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ug_CN = goog.i18n.NumberFormatSymbols_ug;


/**
 * Number formatting symbols for locale uk_UA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uk_UA = goog.i18n.NumberFormatSymbols_uk;


/**
 * Number formatting symbols for locale ur_IN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ur_IN = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##,##0%;-#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0.00;-¤ #,##,##0.00',
  DEF_CURRENCY_CODE: 'INR'
};


/**
 * Number formatting symbols for locale ur_PK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_ur_PK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '‎+',
  MINUS_SIGN: '‎-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##,##0%;-#,##,##0%',
  CURRENCY_PATTERN: '¤ #,##,##0;-¤ #,##,##0',
  DEF_CURRENCY_CODE: 'PKR'
};


/**
 * Number formatting symbols for locale uz_Arab.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uz_Arab = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00;-¤ #,##0.00',
  DEF_CURRENCY_CODE: 'AFN'
};


/**
 * Number formatting symbols for locale uz_Arab_AF.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uz_Arab_AF = {
  DECIMAL_SEP: '٫',
  GROUP_SEP: '٬',
  PERCENT: '٪',
  ZERO_DIGIT: '۰',
  PLUS_SIGN: '‎+‎',
  MINUS_SIGN: '‎-‎',
  EXP_SYMBOL: '×۱۰^',
  PERMILL: '؉',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###;-#,##0.###',
  SCIENTIFIC_PATTERN: '#E0;-#E0',
  PERCENT_PATTERN: '#,##0%;-#,##0%',
  CURRENCY_PATTERN: '¤ #,##0;-¤ #,##0',
  DEF_CURRENCY_CODE: 'AFN'
};


/**
 * Number formatting symbols for locale uz_Cyrl.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uz_Cyrl = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'UZS'
};


/**
 * Number formatting symbols for locale uz_Cyrl_UZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uz_Cyrl_UZ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'UZS'
};


/**
 * Number formatting symbols for locale uz_Latn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uz_Latn = goog.i18n.NumberFormatSymbols_uz;


/**
 * Number formatting symbols for locale uz_Latn_UZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_uz_Latn_UZ = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'haqiqiy son emas',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'UZS'
};


/**
 * Number formatting symbols for locale vai.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vai = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'LRD'
};


/**
 * Number formatting symbols for locale vai_Latn.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vai_Latn = goog.i18n.NumberFormatSymbols_vai;


/**
 * Number formatting symbols for locale vai_Latn_LR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vai_Latn_LR = goog.i18n.NumberFormatSymbols_vai;


/**
 * Number formatting symbols for locale vai_Vaii.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vai_Vaii = goog.i18n.NumberFormatSymbols_vai;


/**
 * Number formatting symbols for locale vai_Vaii_LR.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vai_Vaii_LR = goog.i18n.NumberFormatSymbols_vai;


/**
 * Number formatting symbols for locale vi_VN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vi_VN = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '.',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0',
  DEF_CURRENCY_CODE: 'VND'
};


/**
 * Number formatting symbols for locale vun.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vun = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale vun_TZ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_vun_TZ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'TZS'
};


/**
 * Number formatting symbols for locale wae.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_wae = {
  DECIMAL_SEP: ',',
  GROUP_SEP: '’',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'CHF'
};


/**
 * Number formatting symbols for locale wae_CH.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_wae_CH = goog.i18n.NumberFormatSymbols_wae;


/**
 * Number formatting symbols for locale xog.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_xog = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale xog_UG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_xog_UG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'UGX'
};


/**
 * Number formatting symbols for locale yav.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yav = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0.00 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale yav_CM.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yav_CM = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '#,##0 ¤',
  DEF_CURRENCY_CODE: 'XAF'
};


/**
 * Number formatting symbols for locale yi.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yi = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤ #,##0.00',
  DEF_CURRENCY_CODE: 'EUR'
};


/**
 * Number formatting symbols for locale yi_001.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yi_001 = goog.i18n.NumberFormatSymbols_yi;


/**
 * Number formatting symbols for locale yo.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yo = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'NGN'
};


/**
 * Number formatting symbols for locale yo_BJ.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yo_BJ = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0',
  DEF_CURRENCY_CODE: 'XOF'
};


/**
 * Number formatting symbols for locale yo_NG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yo_NG = goog.i18n.NumberFormatSymbols_yo;


/**
 * Number formatting symbols for locale yue.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yue = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '非數值',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'HKD'
};


/**
 * Number formatting symbols for locale yue_HK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_yue_HK = goog.i18n.NumberFormatSymbols_yue;


/**
 * Number formatting symbols for locale zgh.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zgh = {
  DECIMAL_SEP: ',',
  GROUP_SEP: ' ',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0 %',
  CURRENCY_PATTERN: '#,##0.00¤',
  DEF_CURRENCY_CODE: 'MAD'
};


/**
 * Number formatting symbols for locale zgh_MA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zgh_MA = goog.i18n.NumberFormatSymbols_zgh;


/**
 * Number formatting symbols for locale zh_Hans.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hans = goog.i18n.NumberFormatSymbols_zh;


/**
 * Number formatting symbols for locale zh_Hans_CN.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hans_CN = goog.i18n.NumberFormatSymbols_zh;


/**
 * Number formatting symbols for locale zh_Hans_HK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hans_HK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'HKD'
};


/**
 * Number formatting symbols for locale zh_Hans_MO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hans_MO = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'MOP'
};


/**
 * Number formatting symbols for locale zh_Hans_SG.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hans_SG = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: 'NaN',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'SGD'
};


/**
 * Number formatting symbols for locale zh_Hant.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hant = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '非數值',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TWD'
};


/**
 * Number formatting symbols for locale zh_Hant_HK.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hant_HK = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '非數值',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'HKD'
};


/**
 * Number formatting symbols for locale zh_Hant_MO.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hant_MO = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '非數值',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'MOP'
};


/**
 * Number formatting symbols for locale zh_Hant_TW.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zh_Hant_TW = {
  DECIMAL_SEP: '.',
  GROUP_SEP: ',',
  PERCENT: '%',
  ZERO_DIGIT: '0',
  PLUS_SIGN: '+',
  MINUS_SIGN: '-',
  EXP_SYMBOL: 'E',
  PERMILL: '‰',
  INFINITY: '∞',
  NAN: '非數值',
  DECIMAL_PATTERN: '#,##0.###',
  SCIENTIFIC_PATTERN: '#E0',
  PERCENT_PATTERN: '#,##0%',
  CURRENCY_PATTERN: '¤#,##0.00',
  DEF_CURRENCY_CODE: 'TWD'
};


/**
 * Number formatting symbols for locale zu_ZA.
 * @enum {string}
 */
goog.i18n.NumberFormatSymbols_zu_ZA = goog.i18n.NumberFormatSymbols_zu;


/**
 * Selected number formatting symbols by locale.
 */
if (goog.LOCALE == 'af_NA' || goog.LOCALE == 'af-NA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_af_NA;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_af_ZA;
}

if (goog.LOCALE == 'agq') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_agq;
}

if (goog.LOCALE == 'agq_CM' || goog.LOCALE == 'agq-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_agq_CM;
}

if (goog.LOCALE == 'ak') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ak;
}

if (goog.LOCALE == 'ak_GH' || goog.LOCALE == 'ak-GH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ak_GH;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_am_ET;
}

if (goog.LOCALE == 'ar_001' || goog.LOCALE == 'ar-001') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_001;
}

if (goog.LOCALE == 'ar_AE' || goog.LOCALE == 'ar-AE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_AE;
}

if (goog.LOCALE == 'ar_BH' || goog.LOCALE == 'ar-BH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_BH;
}

if (goog.LOCALE == 'ar_DJ' || goog.LOCALE == 'ar-DJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_DJ;
}

if (goog.LOCALE == 'ar_DZ' || goog.LOCALE == 'ar-DZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_DZ;
}

if (goog.LOCALE == 'ar_EG' || goog.LOCALE == 'ar-EG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_EG;
}

if (goog.LOCALE == 'ar_EH' || goog.LOCALE == 'ar-EH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_EH;
}

if (goog.LOCALE == 'ar_ER' || goog.LOCALE == 'ar-ER') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_ER;
}

if (goog.LOCALE == 'ar_IL' || goog.LOCALE == 'ar-IL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_IL;
}

if (goog.LOCALE == 'ar_IQ' || goog.LOCALE == 'ar-IQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_IQ;
}

if (goog.LOCALE == 'ar_JO' || goog.LOCALE == 'ar-JO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_JO;
}

if (goog.LOCALE == 'ar_KM' || goog.LOCALE == 'ar-KM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_KM;
}

if (goog.LOCALE == 'ar_KW' || goog.LOCALE == 'ar-KW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_KW;
}

if (goog.LOCALE == 'ar_LB' || goog.LOCALE == 'ar-LB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_LB;
}

if (goog.LOCALE == 'ar_LY' || goog.LOCALE == 'ar-LY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_LY;
}

if (goog.LOCALE == 'ar_MA' || goog.LOCALE == 'ar-MA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_MA;
}

if (goog.LOCALE == 'ar_MR' || goog.LOCALE == 'ar-MR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_MR;
}

if (goog.LOCALE == 'ar_OM' || goog.LOCALE == 'ar-OM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_OM;
}

if (goog.LOCALE == 'ar_PS' || goog.LOCALE == 'ar-PS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_PS;
}

if (goog.LOCALE == 'ar_QA' || goog.LOCALE == 'ar-QA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_QA;
}

if (goog.LOCALE == 'ar_SA' || goog.LOCALE == 'ar-SA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_SA;
}

if (goog.LOCALE == 'ar_SD' || goog.LOCALE == 'ar-SD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_SD;
}

if (goog.LOCALE == 'ar_SO' || goog.LOCALE == 'ar-SO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_SO;
}

if (goog.LOCALE == 'ar_SS' || goog.LOCALE == 'ar-SS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_SS;
}

if (goog.LOCALE == 'ar_SY' || goog.LOCALE == 'ar-SY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_SY;
}

if (goog.LOCALE == 'ar_TD' || goog.LOCALE == 'ar-TD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_TD;
}

if (goog.LOCALE == 'ar_TN' || goog.LOCALE == 'ar-TN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_TN;
}

if (goog.LOCALE == 'ar_XB' || goog.LOCALE == 'ar-XB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_XB;
}

if (goog.LOCALE == 'ar_YE' || goog.LOCALE == 'ar-YE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ar_YE;
}

if (goog.LOCALE == 'as') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_as;
}

if (goog.LOCALE == 'as_IN' || goog.LOCALE == 'as-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_as_IN;
}

if (goog.LOCALE == 'asa') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_asa;
}

if (goog.LOCALE == 'asa_TZ' || goog.LOCALE == 'asa-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_asa_TZ;
}

if (goog.LOCALE == 'ast') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ast;
}

if (goog.LOCALE == 'ast_ES' || goog.LOCALE == 'ast-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ast_ES;
}

if (goog.LOCALE == 'az_Cyrl' || goog.LOCALE == 'az-Cyrl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_az_Cyrl;
}

if (goog.LOCALE == 'az_Cyrl_AZ' || goog.LOCALE == 'az-Cyrl-AZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_az_Cyrl_AZ;
}

if (goog.LOCALE == 'az_Latn' || goog.LOCALE == 'az-Latn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_az_Latn;
}

if (goog.LOCALE == 'az_Latn_AZ' || goog.LOCALE == 'az-Latn-AZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_az_Latn_AZ;
}

if (goog.LOCALE == 'bas') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bas;
}

if (goog.LOCALE == 'bas_CM' || goog.LOCALE == 'bas-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bas_CM;
}

if (goog.LOCALE == 'be_BY' || goog.LOCALE == 'be-BY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_be_BY;
}

if (goog.LOCALE == 'bem') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bem;
}

if (goog.LOCALE == 'bem_ZM' || goog.LOCALE == 'bem-ZM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bem_ZM;
}

if (goog.LOCALE == 'bez') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bez;
}

if (goog.LOCALE == 'bez_TZ' || goog.LOCALE == 'bez-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bez_TZ;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bg_BG;
}

if (goog.LOCALE == 'bm') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bm;
}

if (goog.LOCALE == 'bm_ML' || goog.LOCALE == 'bm-ML') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bm_ML;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bn_BD;
}

if (goog.LOCALE == 'bn_IN' || goog.LOCALE == 'bn-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bn_IN;
}

if (goog.LOCALE == 'bo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bo;
}

if (goog.LOCALE == 'bo_CN' || goog.LOCALE == 'bo-CN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bo_CN;
}

if (goog.LOCALE == 'bo_IN' || goog.LOCALE == 'bo-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bo_IN;
}

if (goog.LOCALE == 'br_FR' || goog.LOCALE == 'br-FR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_br_FR;
}

if (goog.LOCALE == 'brx') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_brx;
}

if (goog.LOCALE == 'brx_IN' || goog.LOCALE == 'brx-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_brx_IN;
}

if (goog.LOCALE == 'bs_Cyrl' || goog.LOCALE == 'bs-Cyrl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bs_Cyrl;
}

if (goog.LOCALE == 'bs_Cyrl_BA' || goog.LOCALE == 'bs-Cyrl-BA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bs_Cyrl_BA;
}

if (goog.LOCALE == 'bs_Latn' || goog.LOCALE == 'bs-Latn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bs_Latn;
}

if (goog.LOCALE == 'bs_Latn_BA' || goog.LOCALE == 'bs-Latn-BA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_bs_Latn_BA;
}

if (goog.LOCALE == 'ca_AD' || goog.LOCALE == 'ca-AD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca_AD;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca_ES;
}

if (goog.LOCALE == 'ca_FR' || goog.LOCALE == 'ca-FR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca_FR;
}

if (goog.LOCALE == 'ca_IT' || goog.LOCALE == 'ca-IT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ca_IT;
}

if (goog.LOCALE == 'ce') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ce;
}

if (goog.LOCALE == 'ce_RU' || goog.LOCALE == 'ce-RU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ce_RU;
}

if (goog.LOCALE == 'cgg') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_cgg;
}

if (goog.LOCALE == 'cgg_UG' || goog.LOCALE == 'cgg-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_cgg_UG;
}

if (goog.LOCALE == 'chr_US' || goog.LOCALE == 'chr-US') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_chr_US;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_cs_CZ;
}

if (goog.LOCALE == 'cy_GB' || goog.LOCALE == 'cy-GB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_cy_GB;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_da_DK;
}

if (goog.LOCALE == 'da_GL' || goog.LOCALE == 'da-GL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_da_GL;
}

if (goog.LOCALE == 'dav') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dav;
}

if (goog.LOCALE == 'dav_KE' || goog.LOCALE == 'dav-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dav_KE;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de_BE;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de_DE;
}

if (goog.LOCALE == 'de_LI' || goog.LOCALE == 'de-LI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de_LI;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_de_LU;
}

if (goog.LOCALE == 'dje') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dje;
}

if (goog.LOCALE == 'dje_NE' || goog.LOCALE == 'dje-NE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dje_NE;
}

if (goog.LOCALE == 'dsb') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dsb;
}

if (goog.LOCALE == 'dsb_DE' || goog.LOCALE == 'dsb-DE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dsb_DE;
}

if (goog.LOCALE == 'dua') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dua;
}

if (goog.LOCALE == 'dua_CM' || goog.LOCALE == 'dua-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dua_CM;
}

if (goog.LOCALE == 'dyo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dyo;
}

if (goog.LOCALE == 'dyo_SN' || goog.LOCALE == 'dyo-SN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dyo_SN;
}

if (goog.LOCALE == 'dz') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dz;
}

if (goog.LOCALE == 'dz_BT' || goog.LOCALE == 'dz-BT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_dz_BT;
}

if (goog.LOCALE == 'ebu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ebu;
}

if (goog.LOCALE == 'ebu_KE' || goog.LOCALE == 'ebu-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ebu_KE;
}

if (goog.LOCALE == 'ee') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ee;
}

if (goog.LOCALE == 'ee_GH' || goog.LOCALE == 'ee-GH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ee_GH;
}

if (goog.LOCALE == 'ee_TG' || goog.LOCALE == 'ee-TG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ee_TG;
}

if (goog.LOCALE == 'el_CY' || goog.LOCALE == 'el-CY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_el_CY;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_el_GR;
}

if (goog.LOCALE == 'en_001' || goog.LOCALE == 'en-001') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_001;
}

if (goog.LOCALE == 'en_150' || goog.LOCALE == 'en-150') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_150;
}

if (goog.LOCALE == 'en_AG' || goog.LOCALE == 'en-AG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_AG;
}

if (goog.LOCALE == 'en_AI' || goog.LOCALE == 'en-AI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_AI;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_AS;
}

if (goog.LOCALE == 'en_AT' || goog.LOCALE == 'en-AT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_AT;
}

if (goog.LOCALE == 'en_BB' || goog.LOCALE == 'en-BB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BB;
}

if (goog.LOCALE == 'en_BE' || goog.LOCALE == 'en-BE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BE;
}

if (goog.LOCALE == 'en_BI' || goog.LOCALE == 'en-BI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BI;
}

if (goog.LOCALE == 'en_BM' || goog.LOCALE == 'en-BM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BM;
}

if (goog.LOCALE == 'en_BS' || goog.LOCALE == 'en-BS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BS;
}

if (goog.LOCALE == 'en_BW' || goog.LOCALE == 'en-BW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BW;
}

if (goog.LOCALE == 'en_BZ' || goog.LOCALE == 'en-BZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_BZ;
}

if (goog.LOCALE == 'en_CC' || goog.LOCALE == 'en-CC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_CC;
}

if (goog.LOCALE == 'en_CH' || goog.LOCALE == 'en-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_CH;
}

if (goog.LOCALE == 'en_CK' || goog.LOCALE == 'en-CK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_CK;
}

if (goog.LOCALE == 'en_CM' || goog.LOCALE == 'en-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_CM;
}

if (goog.LOCALE == 'en_CX' || goog.LOCALE == 'en-CX') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_CX;
}

if (goog.LOCALE == 'en_CY' || goog.LOCALE == 'en-CY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_CY;
}

if (goog.LOCALE == 'en_DE' || goog.LOCALE == 'en-DE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_DE;
}

if (goog.LOCALE == 'en_DG' || goog.LOCALE == 'en-DG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_DG;
}

if (goog.LOCALE == 'en_DK' || goog.LOCALE == 'en-DK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_DK;
}

if (goog.LOCALE == 'en_DM' || goog.LOCALE == 'en-DM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_DM;
}

if (goog.LOCALE == 'en_ER' || goog.LOCALE == 'en-ER') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_ER;
}

if (goog.LOCALE == 'en_FI' || goog.LOCALE == 'en-FI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_FI;
}

if (goog.LOCALE == 'en_FJ' || goog.LOCALE == 'en-FJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_FJ;
}

if (goog.LOCALE == 'en_FK' || goog.LOCALE == 'en-FK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_FK;
}

if (goog.LOCALE == 'en_FM' || goog.LOCALE == 'en-FM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_FM;
}

if (goog.LOCALE == 'en_GD' || goog.LOCALE == 'en-GD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GD;
}

if (goog.LOCALE == 'en_GG' || goog.LOCALE == 'en-GG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GG;
}

if (goog.LOCALE == 'en_GH' || goog.LOCALE == 'en-GH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GH;
}

if (goog.LOCALE == 'en_GI' || goog.LOCALE == 'en-GI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GI;
}

if (goog.LOCALE == 'en_GM' || goog.LOCALE == 'en-GM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GM;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GU;
}

if (goog.LOCALE == 'en_GY' || goog.LOCALE == 'en-GY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_GY;
}

if (goog.LOCALE == 'en_HK' || goog.LOCALE == 'en-HK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_HK;
}

if (goog.LOCALE == 'en_IL' || goog.LOCALE == 'en-IL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_IL;
}

if (goog.LOCALE == 'en_IM' || goog.LOCALE == 'en-IM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_IM;
}

if (goog.LOCALE == 'en_IO' || goog.LOCALE == 'en-IO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_IO;
}

if (goog.LOCALE == 'en_JE' || goog.LOCALE == 'en-JE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_JE;
}

if (goog.LOCALE == 'en_JM' || goog.LOCALE == 'en-JM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_JM;
}

if (goog.LOCALE == 'en_KE' || goog.LOCALE == 'en-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_KE;
}

if (goog.LOCALE == 'en_KI' || goog.LOCALE == 'en-KI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_KI;
}

if (goog.LOCALE == 'en_KN' || goog.LOCALE == 'en-KN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_KN;
}

if (goog.LOCALE == 'en_KY' || goog.LOCALE == 'en-KY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_KY;
}

if (goog.LOCALE == 'en_LC' || goog.LOCALE == 'en-LC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_LC;
}

if (goog.LOCALE == 'en_LR' || goog.LOCALE == 'en-LR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_LR;
}

if (goog.LOCALE == 'en_LS' || goog.LOCALE == 'en-LS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_LS;
}

if (goog.LOCALE == 'en_MG' || goog.LOCALE == 'en-MG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MG;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MH;
}

if (goog.LOCALE == 'en_MO' || goog.LOCALE == 'en-MO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MO;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MP;
}

if (goog.LOCALE == 'en_MS' || goog.LOCALE == 'en-MS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MS;
}

if (goog.LOCALE == 'en_MT' || goog.LOCALE == 'en-MT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MT;
}

if (goog.LOCALE == 'en_MU' || goog.LOCALE == 'en-MU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MU;
}

if (goog.LOCALE == 'en_MW' || goog.LOCALE == 'en-MW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MW;
}

if (goog.LOCALE == 'en_MY' || goog.LOCALE == 'en-MY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_MY;
}

if (goog.LOCALE == 'en_NA' || goog.LOCALE == 'en-NA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NA;
}

if (goog.LOCALE == 'en_NF' || goog.LOCALE == 'en-NF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NF;
}

if (goog.LOCALE == 'en_NG' || goog.LOCALE == 'en-NG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NG;
}

if (goog.LOCALE == 'en_NL' || goog.LOCALE == 'en-NL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NL;
}

if (goog.LOCALE == 'en_NR' || goog.LOCALE == 'en-NR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NR;
}

if (goog.LOCALE == 'en_NU' || goog.LOCALE == 'en-NU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NU;
}

if (goog.LOCALE == 'en_NZ' || goog.LOCALE == 'en-NZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_NZ;
}

if (goog.LOCALE == 'en_PG' || goog.LOCALE == 'en-PG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_PG;
}

if (goog.LOCALE == 'en_PH' || goog.LOCALE == 'en-PH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_PH;
}

if (goog.LOCALE == 'en_PK' || goog.LOCALE == 'en-PK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_PK;
}

if (goog.LOCALE == 'en_PN' || goog.LOCALE == 'en-PN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_PN;
}

if (goog.LOCALE == 'en_PR' || goog.LOCALE == 'en-PR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_PR;
}

if (goog.LOCALE == 'en_PW' || goog.LOCALE == 'en-PW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_PW;
}

if (goog.LOCALE == 'en_RW' || goog.LOCALE == 'en-RW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_RW;
}

if (goog.LOCALE == 'en_SB' || goog.LOCALE == 'en-SB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SB;
}

if (goog.LOCALE == 'en_SC' || goog.LOCALE == 'en-SC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SC;
}

if (goog.LOCALE == 'en_SD' || goog.LOCALE == 'en-SD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SD;
}

if (goog.LOCALE == 'en_SE' || goog.LOCALE == 'en-SE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SE;
}

if (goog.LOCALE == 'en_SH' || goog.LOCALE == 'en-SH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SH;
}

if (goog.LOCALE == 'en_SI' || goog.LOCALE == 'en-SI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SI;
}

if (goog.LOCALE == 'en_SL' || goog.LOCALE == 'en-SL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SL;
}

if (goog.LOCALE == 'en_SS' || goog.LOCALE == 'en-SS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SS;
}

if (goog.LOCALE == 'en_SX' || goog.LOCALE == 'en-SX') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SX;
}

if (goog.LOCALE == 'en_SZ' || goog.LOCALE == 'en-SZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_SZ;
}

if (goog.LOCALE == 'en_TC' || goog.LOCALE == 'en-TC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_TC;
}

if (goog.LOCALE == 'en_TK' || goog.LOCALE == 'en-TK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_TK;
}

if (goog.LOCALE == 'en_TO' || goog.LOCALE == 'en-TO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_TO;
}

if (goog.LOCALE == 'en_TT' || goog.LOCALE == 'en-TT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_TT;
}

if (goog.LOCALE == 'en_TV' || goog.LOCALE == 'en-TV') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_TV;
}

if (goog.LOCALE == 'en_TZ' || goog.LOCALE == 'en-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_TZ;
}

if (goog.LOCALE == 'en_UG' || goog.LOCALE == 'en-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_UG;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_UM;
}

if (goog.LOCALE == 'en_US_POSIX' || goog.LOCALE == 'en-US-POSIX') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_US_POSIX;
}

if (goog.LOCALE == 'en_VC' || goog.LOCALE == 'en-VC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_VC;
}

if (goog.LOCALE == 'en_VG' || goog.LOCALE == 'en-VG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_VG;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_VI;
}

if (goog.LOCALE == 'en_VU' || goog.LOCALE == 'en-VU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_VU;
}

if (goog.LOCALE == 'en_WS' || goog.LOCALE == 'en-WS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_WS;
}

if (goog.LOCALE == 'en_XA' || goog.LOCALE == 'en-XA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_XA;
}

if (goog.LOCALE == 'en_ZM' || goog.LOCALE == 'en-ZM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_ZM;
}

if (goog.LOCALE == 'en_ZW' || goog.LOCALE == 'en-ZW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_en_ZW;
}

if (goog.LOCALE == 'eo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_eo;
}

if (goog.LOCALE == 'es_AR' || goog.LOCALE == 'es-AR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_AR;
}

if (goog.LOCALE == 'es_BO' || goog.LOCALE == 'es-BO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_BO;
}

if (goog.LOCALE == 'es_CL' || goog.LOCALE == 'es-CL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_CL;
}

if (goog.LOCALE == 'es_CO' || goog.LOCALE == 'es-CO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_CO;
}

if (goog.LOCALE == 'es_CR' || goog.LOCALE == 'es-CR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_CR;
}

if (goog.LOCALE == 'es_CU' || goog.LOCALE == 'es-CU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_CU;
}

if (goog.LOCALE == 'es_DO' || goog.LOCALE == 'es-DO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_DO;
}

if (goog.LOCALE == 'es_EA' || goog.LOCALE == 'es-EA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_EA;
}

if (goog.LOCALE == 'es_EC' || goog.LOCALE == 'es-EC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_EC;
}

if (goog.LOCALE == 'es_GQ' || goog.LOCALE == 'es-GQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_GQ;
}

if (goog.LOCALE == 'es_GT' || goog.LOCALE == 'es-GT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_GT;
}

if (goog.LOCALE == 'es_HN' || goog.LOCALE == 'es-HN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_HN;
}

if (goog.LOCALE == 'es_IC' || goog.LOCALE == 'es-IC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_IC;
}

if (goog.LOCALE == 'es_NI' || goog.LOCALE == 'es-NI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_NI;
}

if (goog.LOCALE == 'es_PA' || goog.LOCALE == 'es-PA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_PA;
}

if (goog.LOCALE == 'es_PE' || goog.LOCALE == 'es-PE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_PE;
}

if (goog.LOCALE == 'es_PH' || goog.LOCALE == 'es-PH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_PH;
}

if (goog.LOCALE == 'es_PR' || goog.LOCALE == 'es-PR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_PR;
}

if (goog.LOCALE == 'es_PY' || goog.LOCALE == 'es-PY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_PY;
}

if (goog.LOCALE == 'es_SV' || goog.LOCALE == 'es-SV') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_SV;
}

if (goog.LOCALE == 'es_UY' || goog.LOCALE == 'es-UY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_UY;
}

if (goog.LOCALE == 'es_VE' || goog.LOCALE == 'es-VE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_es_VE;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_et_EE;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_eu_ES;
}

if (goog.LOCALE == 'ewo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ewo;
}

if (goog.LOCALE == 'ewo_CM' || goog.LOCALE == 'ewo-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ewo_CM;
}

if (goog.LOCALE == 'fa_AF' || goog.LOCALE == 'fa-AF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fa_AF;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fa_IR;
}

if (goog.LOCALE == 'ff') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ff;
}

if (goog.LOCALE == 'ff_CM' || goog.LOCALE == 'ff-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ff_CM;
}

if (goog.LOCALE == 'ff_GN' || goog.LOCALE == 'ff-GN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ff_GN;
}

if (goog.LOCALE == 'ff_MR' || goog.LOCALE == 'ff-MR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ff_MR;
}

if (goog.LOCALE == 'ff_SN' || goog.LOCALE == 'ff-SN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ff_SN;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fi_FI;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fil_PH;
}

if (goog.LOCALE == 'fo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fo;
}

if (goog.LOCALE == 'fo_DK' || goog.LOCALE == 'fo-DK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fo_DK;
}

if (goog.LOCALE == 'fo_FO' || goog.LOCALE == 'fo-FO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fo_FO;
}

if (goog.LOCALE == 'fr_BE' || goog.LOCALE == 'fr-BE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_BE;
}

if (goog.LOCALE == 'fr_BF' || goog.LOCALE == 'fr-BF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_BF;
}

if (goog.LOCALE == 'fr_BI' || goog.LOCALE == 'fr-BI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_BI;
}

if (goog.LOCALE == 'fr_BJ' || goog.LOCALE == 'fr-BJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_BJ;
}

if (goog.LOCALE == 'fr_BL' || goog.LOCALE == 'fr-BL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_BL;
}

if (goog.LOCALE == 'fr_CD' || goog.LOCALE == 'fr-CD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CD;
}

if (goog.LOCALE == 'fr_CF' || goog.LOCALE == 'fr-CF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CF;
}

if (goog.LOCALE == 'fr_CG' || goog.LOCALE == 'fr-CG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CG;
}

if (goog.LOCALE == 'fr_CH' || goog.LOCALE == 'fr-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CH;
}

if (goog.LOCALE == 'fr_CI' || goog.LOCALE == 'fr-CI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CI;
}

if (goog.LOCALE == 'fr_CM' || goog.LOCALE == 'fr-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_CM;
}

if (goog.LOCALE == 'fr_DJ' || goog.LOCALE == 'fr-DJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_DJ;
}

if (goog.LOCALE == 'fr_DZ' || goog.LOCALE == 'fr-DZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_DZ;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_FR;
}

if (goog.LOCALE == 'fr_GA' || goog.LOCALE == 'fr-GA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_GA;
}

if (goog.LOCALE == 'fr_GF' || goog.LOCALE == 'fr-GF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_GF;
}

if (goog.LOCALE == 'fr_GN' || goog.LOCALE == 'fr-GN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_GN;
}

if (goog.LOCALE == 'fr_GP' || goog.LOCALE == 'fr-GP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_GP;
}

if (goog.LOCALE == 'fr_GQ' || goog.LOCALE == 'fr-GQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_GQ;
}

if (goog.LOCALE == 'fr_HT' || goog.LOCALE == 'fr-HT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_HT;
}

if (goog.LOCALE == 'fr_KM' || goog.LOCALE == 'fr-KM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_KM;
}

if (goog.LOCALE == 'fr_LU' || goog.LOCALE == 'fr-LU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_LU;
}

if (goog.LOCALE == 'fr_MA' || goog.LOCALE == 'fr-MA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MA;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MC;
}

if (goog.LOCALE == 'fr_MF' || goog.LOCALE == 'fr-MF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MF;
}

if (goog.LOCALE == 'fr_MG' || goog.LOCALE == 'fr-MG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MG;
}

if (goog.LOCALE == 'fr_ML' || goog.LOCALE == 'fr-ML') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_ML;
}

if (goog.LOCALE == 'fr_MQ' || goog.LOCALE == 'fr-MQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MQ;
}

if (goog.LOCALE == 'fr_MR' || goog.LOCALE == 'fr-MR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MR;
}

if (goog.LOCALE == 'fr_MU' || goog.LOCALE == 'fr-MU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_MU;
}

if (goog.LOCALE == 'fr_NC' || goog.LOCALE == 'fr-NC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_NC;
}

if (goog.LOCALE == 'fr_NE' || goog.LOCALE == 'fr-NE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_NE;
}

if (goog.LOCALE == 'fr_PF' || goog.LOCALE == 'fr-PF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_PF;
}

if (goog.LOCALE == 'fr_PM' || goog.LOCALE == 'fr-PM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_PM;
}

if (goog.LOCALE == 'fr_RE' || goog.LOCALE == 'fr-RE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_RE;
}

if (goog.LOCALE == 'fr_RW' || goog.LOCALE == 'fr-RW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_RW;
}

if (goog.LOCALE == 'fr_SC' || goog.LOCALE == 'fr-SC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_SC;
}

if (goog.LOCALE == 'fr_SN' || goog.LOCALE == 'fr-SN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_SN;
}

if (goog.LOCALE == 'fr_SY' || goog.LOCALE == 'fr-SY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_SY;
}

if (goog.LOCALE == 'fr_TD' || goog.LOCALE == 'fr-TD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_TD;
}

if (goog.LOCALE == 'fr_TG' || goog.LOCALE == 'fr-TG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_TG;
}

if (goog.LOCALE == 'fr_TN' || goog.LOCALE == 'fr-TN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_TN;
}

if (goog.LOCALE == 'fr_VU' || goog.LOCALE == 'fr-VU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_VU;
}

if (goog.LOCALE == 'fr_WF' || goog.LOCALE == 'fr-WF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_WF;
}

if (goog.LOCALE == 'fr_YT' || goog.LOCALE == 'fr-YT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fr_YT;
}

if (goog.LOCALE == 'fur') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fur;
}

if (goog.LOCALE == 'fur_IT' || goog.LOCALE == 'fur-IT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fur_IT;
}

if (goog.LOCALE == 'fy') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fy;
}

if (goog.LOCALE == 'fy_NL' || goog.LOCALE == 'fy-NL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_fy_NL;
}

if (goog.LOCALE == 'ga_IE' || goog.LOCALE == 'ga-IE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ga_IE;
}

if (goog.LOCALE == 'gd') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gd;
}

if (goog.LOCALE == 'gd_GB' || goog.LOCALE == 'gd-GB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gd_GB;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gl_ES;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gsw_CH;
}

if (goog.LOCALE == 'gsw_FR' || goog.LOCALE == 'gsw-FR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gsw_FR;
}

if (goog.LOCALE == 'gsw_LI' || goog.LOCALE == 'gsw-LI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gsw_LI;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gu_IN;
}

if (goog.LOCALE == 'guz') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_guz;
}

if (goog.LOCALE == 'guz_KE' || goog.LOCALE == 'guz-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_guz_KE;
}

if (goog.LOCALE == 'gv') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gv;
}

if (goog.LOCALE == 'gv_IM' || goog.LOCALE == 'gv-IM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_gv_IM;
}

if (goog.LOCALE == 'ha') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ha;
}

if (goog.LOCALE == 'ha_GH' || goog.LOCALE == 'ha-GH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ha_GH;
}

if (goog.LOCALE == 'ha_NE' || goog.LOCALE == 'ha-NE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ha_NE;
}

if (goog.LOCALE == 'ha_NG' || goog.LOCALE == 'ha-NG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ha_NG;
}

if (goog.LOCALE == 'haw_US' || goog.LOCALE == 'haw-US') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_haw_US;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_he_IL;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hi_IN;
}

if (goog.LOCALE == 'hr_BA' || goog.LOCALE == 'hr-BA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hr_BA;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hr_HR;
}

if (goog.LOCALE == 'hsb') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hsb;
}

if (goog.LOCALE == 'hsb_DE' || goog.LOCALE == 'hsb-DE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hsb_DE;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hu_HU;
}

if (goog.LOCALE == 'hy_AM' || goog.LOCALE == 'hy-AM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_hy_AM;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_id_ID;
}

if (goog.LOCALE == 'ig') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ig;
}

if (goog.LOCALE == 'ig_NG' || goog.LOCALE == 'ig-NG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ig_NG;
}

if (goog.LOCALE == 'ii') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ii;
}

if (goog.LOCALE == 'ii_CN' || goog.LOCALE == 'ii-CN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ii_CN;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_is_IS;
}

if (goog.LOCALE == 'it_CH' || goog.LOCALE == 'it-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_it_CH;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_it_IT;
}

if (goog.LOCALE == 'it_SM' || goog.LOCALE == 'it-SM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_it_SM;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ja_JP;
}

if (goog.LOCALE == 'jgo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_jgo;
}

if (goog.LOCALE == 'jgo_CM' || goog.LOCALE == 'jgo-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_jgo_CM;
}

if (goog.LOCALE == 'jmc') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_jmc;
}

if (goog.LOCALE == 'jmc_TZ' || goog.LOCALE == 'jmc-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_jmc_TZ;
}

if (goog.LOCALE == 'ka_GE' || goog.LOCALE == 'ka-GE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ka_GE;
}

if (goog.LOCALE == 'kab') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kab;
}

if (goog.LOCALE == 'kab_DZ' || goog.LOCALE == 'kab-DZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kab_DZ;
}

if (goog.LOCALE == 'kam') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kam;
}

if (goog.LOCALE == 'kam_KE' || goog.LOCALE == 'kam-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kam_KE;
}

if (goog.LOCALE == 'kde') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kde;
}

if (goog.LOCALE == 'kde_TZ' || goog.LOCALE == 'kde-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kde_TZ;
}

if (goog.LOCALE == 'kea') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kea;
}

if (goog.LOCALE == 'kea_CV' || goog.LOCALE == 'kea-CV') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kea_CV;
}

if (goog.LOCALE == 'khq') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_khq;
}

if (goog.LOCALE == 'khq_ML' || goog.LOCALE == 'khq-ML') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_khq_ML;
}

if (goog.LOCALE == 'ki') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ki;
}

if (goog.LOCALE == 'ki_KE' || goog.LOCALE == 'ki-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ki_KE;
}

if (goog.LOCALE == 'kk_KZ' || goog.LOCALE == 'kk-KZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kk_KZ;
}

if (goog.LOCALE == 'kkj') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kkj;
}

if (goog.LOCALE == 'kkj_CM' || goog.LOCALE == 'kkj-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kkj_CM;
}

if (goog.LOCALE == 'kl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kl;
}

if (goog.LOCALE == 'kl_GL' || goog.LOCALE == 'kl-GL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kl_GL;
}

if (goog.LOCALE == 'kln') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kln;
}

if (goog.LOCALE == 'kln_KE' || goog.LOCALE == 'kln-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kln_KE;
}

if (goog.LOCALE == 'km_KH' || goog.LOCALE == 'km-KH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_km_KH;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kn_IN;
}

if (goog.LOCALE == 'ko_KP' || goog.LOCALE == 'ko-KP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ko_KP;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ko_KR;
}

if (goog.LOCALE == 'kok') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kok;
}

if (goog.LOCALE == 'kok_IN' || goog.LOCALE == 'kok-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kok_IN;
}

if (goog.LOCALE == 'ks') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ks;
}

if (goog.LOCALE == 'ks_IN' || goog.LOCALE == 'ks-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ks_IN;
}

if (goog.LOCALE == 'ksb') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ksb;
}

if (goog.LOCALE == 'ksb_TZ' || goog.LOCALE == 'ksb-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ksb_TZ;
}

if (goog.LOCALE == 'ksf') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ksf;
}

if (goog.LOCALE == 'ksf_CM' || goog.LOCALE == 'ksf-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ksf_CM;
}

if (goog.LOCALE == 'ksh') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ksh;
}

if (goog.LOCALE == 'ksh_DE' || goog.LOCALE == 'ksh-DE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ksh_DE;
}

if (goog.LOCALE == 'kw') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kw;
}

if (goog.LOCALE == 'kw_GB' || goog.LOCALE == 'kw-GB') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_kw_GB;
}

if (goog.LOCALE == 'ky_KG' || goog.LOCALE == 'ky-KG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ky_KG;
}

if (goog.LOCALE == 'lag') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lag;
}

if (goog.LOCALE == 'lag_TZ' || goog.LOCALE == 'lag-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lag_TZ;
}

if (goog.LOCALE == 'lb') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lb;
}

if (goog.LOCALE == 'lb_LU' || goog.LOCALE == 'lb-LU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lb_LU;
}

if (goog.LOCALE == 'lg') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lg;
}

if (goog.LOCALE == 'lg_UG' || goog.LOCALE == 'lg-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lg_UG;
}

if (goog.LOCALE == 'lkt') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lkt;
}

if (goog.LOCALE == 'lkt_US' || goog.LOCALE == 'lkt-US') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lkt_US;
}

if (goog.LOCALE == 'ln_AO' || goog.LOCALE == 'ln-AO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ln_AO;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ln_CD;
}

if (goog.LOCALE == 'ln_CF' || goog.LOCALE == 'ln-CF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ln_CF;
}

if (goog.LOCALE == 'ln_CG' || goog.LOCALE == 'ln-CG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ln_CG;
}

if (goog.LOCALE == 'lo_LA' || goog.LOCALE == 'lo-LA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lo_LA;
}

if (goog.LOCALE == 'lrc') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lrc;
}

if (goog.LOCALE == 'lrc_IQ' || goog.LOCALE == 'lrc-IQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lrc_IQ;
}

if (goog.LOCALE == 'lrc_IR' || goog.LOCALE == 'lrc-IR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lrc_IR;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lt_LT;
}

if (goog.LOCALE == 'lu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lu;
}

if (goog.LOCALE == 'lu_CD' || goog.LOCALE == 'lu-CD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lu_CD;
}

if (goog.LOCALE == 'luo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_luo;
}

if (goog.LOCALE == 'luo_KE' || goog.LOCALE == 'luo-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_luo_KE;
}

if (goog.LOCALE == 'luy') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_luy;
}

if (goog.LOCALE == 'luy_KE' || goog.LOCALE == 'luy-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_luy_KE;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_lv_LV;
}

if (goog.LOCALE == 'mas') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mas;
}

if (goog.LOCALE == 'mas_KE' || goog.LOCALE == 'mas-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mas_KE;
}

if (goog.LOCALE == 'mas_TZ' || goog.LOCALE == 'mas-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mas_TZ;
}

if (goog.LOCALE == 'mer') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mer;
}

if (goog.LOCALE == 'mer_KE' || goog.LOCALE == 'mer-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mer_KE;
}

if (goog.LOCALE == 'mfe') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mfe;
}

if (goog.LOCALE == 'mfe_MU' || goog.LOCALE == 'mfe-MU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mfe_MU;
}

if (goog.LOCALE == 'mg') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mg;
}

if (goog.LOCALE == 'mg_MG' || goog.LOCALE == 'mg-MG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mg_MG;
}

if (goog.LOCALE == 'mgh') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mgh;
}

if (goog.LOCALE == 'mgh_MZ' || goog.LOCALE == 'mgh-MZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mgh_MZ;
}

if (goog.LOCALE == 'mgo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mgo;
}

if (goog.LOCALE == 'mgo_CM' || goog.LOCALE == 'mgo-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mgo_CM;
}

if (goog.LOCALE == 'mk_MK' || goog.LOCALE == 'mk-MK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mk_MK;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ml_IN;
}

if (goog.LOCALE == 'mn_MN' || goog.LOCALE == 'mn-MN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mn_MN;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mr_IN;
}

if (goog.LOCALE == 'ms_BN' || goog.LOCALE == 'ms-BN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ms_BN;
}

if (goog.LOCALE == 'ms_MY' || goog.LOCALE == 'ms-MY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ms_MY;
}

if (goog.LOCALE == 'ms_SG' || goog.LOCALE == 'ms-SG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ms_SG;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mt_MT;
}

if (goog.LOCALE == 'mua') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mua;
}

if (goog.LOCALE == 'mua_CM' || goog.LOCALE == 'mua-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mua_CM;
}

if (goog.LOCALE == 'my_MM' || goog.LOCALE == 'my-MM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_my_MM;
}

if (goog.LOCALE == 'mzn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mzn;
}

if (goog.LOCALE == 'mzn_IR' || goog.LOCALE == 'mzn-IR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_mzn_IR;
}

if (goog.LOCALE == 'naq') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_naq;
}

if (goog.LOCALE == 'naq_NA' || goog.LOCALE == 'naq-NA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_naq_NA;
}

if (goog.LOCALE == 'nb_NO' || goog.LOCALE == 'nb-NO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nb_NO;
}

if (goog.LOCALE == 'nb_SJ' || goog.LOCALE == 'nb-SJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nb_SJ;
}

if (goog.LOCALE == 'nd') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nd;
}

if (goog.LOCALE == 'nd_ZW' || goog.LOCALE == 'nd-ZW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nd_ZW;
}

if (goog.LOCALE == 'ne_IN' || goog.LOCALE == 'ne-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ne_IN;
}

if (goog.LOCALE == 'ne_NP' || goog.LOCALE == 'ne-NP') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ne_NP;
}

if (goog.LOCALE == 'nl_AW' || goog.LOCALE == 'nl-AW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_AW;
}

if (goog.LOCALE == 'nl_BE' || goog.LOCALE == 'nl-BE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_BE;
}

if (goog.LOCALE == 'nl_BQ' || goog.LOCALE == 'nl-BQ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_BQ;
}

if (goog.LOCALE == 'nl_CW' || goog.LOCALE == 'nl-CW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_CW;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_NL;
}

if (goog.LOCALE == 'nl_SR' || goog.LOCALE == 'nl-SR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_SR;
}

if (goog.LOCALE == 'nl_SX' || goog.LOCALE == 'nl-SX') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nl_SX;
}

if (goog.LOCALE == 'nmg') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nmg;
}

if (goog.LOCALE == 'nmg_CM' || goog.LOCALE == 'nmg-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nmg_CM;
}

if (goog.LOCALE == 'nn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nn;
}

if (goog.LOCALE == 'nn_NO' || goog.LOCALE == 'nn-NO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nn_NO;
}

if (goog.LOCALE == 'nnh') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nnh;
}

if (goog.LOCALE == 'nnh_CM' || goog.LOCALE == 'nnh-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nnh_CM;
}

if (goog.LOCALE == 'nus') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nus;
}

if (goog.LOCALE == 'nus_SS' || goog.LOCALE == 'nus-SS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nus_SS;
}

if (goog.LOCALE == 'nyn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nyn;
}

if (goog.LOCALE == 'nyn_UG' || goog.LOCALE == 'nyn-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_nyn_UG;
}

if (goog.LOCALE == 'om') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_om;
}

if (goog.LOCALE == 'om_ET' || goog.LOCALE == 'om-ET') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_om_ET;
}

if (goog.LOCALE == 'om_KE' || goog.LOCALE == 'om-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_om_KE;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_or_IN;
}

if (goog.LOCALE == 'os') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_os;
}

if (goog.LOCALE == 'os_GE' || goog.LOCALE == 'os-GE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_os_GE;
}

if (goog.LOCALE == 'os_RU' || goog.LOCALE == 'os-RU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_os_RU;
}

if (goog.LOCALE == 'pa_Arab' || goog.LOCALE == 'pa-Arab') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pa_Arab;
}

if (goog.LOCALE == 'pa_Arab_PK' || goog.LOCALE == 'pa-Arab-PK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pa_Arab_PK;
}

if (goog.LOCALE == 'pa_Guru' || goog.LOCALE == 'pa-Guru') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pa_Guru;
}

if (goog.LOCALE == 'pa_Guru_IN' || goog.LOCALE == 'pa-Guru-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pa_Guru_IN;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pl_PL;
}

if (goog.LOCALE == 'ps') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ps;
}

if (goog.LOCALE == 'ps_AF' || goog.LOCALE == 'ps-AF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ps_AF;
}

if (goog.LOCALE == 'pt_AO' || goog.LOCALE == 'pt-AO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_AO;
}

if (goog.LOCALE == 'pt_CV' || goog.LOCALE == 'pt-CV') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_CV;
}

if (goog.LOCALE == 'pt_GW' || goog.LOCALE == 'pt-GW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_GW;
}

if (goog.LOCALE == 'pt_MO' || goog.LOCALE == 'pt-MO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_MO;
}

if (goog.LOCALE == 'pt_MZ' || goog.LOCALE == 'pt-MZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_MZ;
}

if (goog.LOCALE == 'pt_ST' || goog.LOCALE == 'pt-ST') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_ST;
}

if (goog.LOCALE == 'pt_TL' || goog.LOCALE == 'pt-TL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_pt_TL;
}

if (goog.LOCALE == 'qu') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_qu;
}

if (goog.LOCALE == 'qu_BO' || goog.LOCALE == 'qu-BO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_qu_BO;
}

if (goog.LOCALE == 'qu_EC' || goog.LOCALE == 'qu-EC') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_qu_EC;
}

if (goog.LOCALE == 'qu_PE' || goog.LOCALE == 'qu-PE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_qu_PE;
}

if (goog.LOCALE == 'rm') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rm;
}

if (goog.LOCALE == 'rm_CH' || goog.LOCALE == 'rm-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rm_CH;
}

if (goog.LOCALE == 'rn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rn;
}

if (goog.LOCALE == 'rn_BI' || goog.LOCALE == 'rn-BI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rn_BI;
}

if (goog.LOCALE == 'ro_MD' || goog.LOCALE == 'ro-MD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ro_MD;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ro_RO;
}

if (goog.LOCALE == 'rof') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rof;
}

if (goog.LOCALE == 'rof_TZ' || goog.LOCALE == 'rof-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rof_TZ;
}

if (goog.LOCALE == 'ru_BY' || goog.LOCALE == 'ru-BY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru_BY;
}

if (goog.LOCALE == 'ru_KG' || goog.LOCALE == 'ru-KG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru_KG;
}

if (goog.LOCALE == 'ru_KZ' || goog.LOCALE == 'ru-KZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru_KZ;
}

if (goog.LOCALE == 'ru_MD' || goog.LOCALE == 'ru-MD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru_MD;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru_RU;
}

if (goog.LOCALE == 'ru_UA' || goog.LOCALE == 'ru-UA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ru_UA;
}

if (goog.LOCALE == 'rw') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rw;
}

if (goog.LOCALE == 'rw_RW' || goog.LOCALE == 'rw-RW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rw_RW;
}

if (goog.LOCALE == 'rwk') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rwk;
}

if (goog.LOCALE == 'rwk_TZ' || goog.LOCALE == 'rwk-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_rwk_TZ;
}

if (goog.LOCALE == 'sah') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sah;
}

if (goog.LOCALE == 'sah_RU' || goog.LOCALE == 'sah-RU') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sah_RU;
}

if (goog.LOCALE == 'saq') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_saq;
}

if (goog.LOCALE == 'saq_KE' || goog.LOCALE == 'saq-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_saq_KE;
}

if (goog.LOCALE == 'sbp') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sbp;
}

if (goog.LOCALE == 'sbp_TZ' || goog.LOCALE == 'sbp-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sbp_TZ;
}

if (goog.LOCALE == 'se') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_se;
}

if (goog.LOCALE == 'se_FI' || goog.LOCALE == 'se-FI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_se_FI;
}

if (goog.LOCALE == 'se_NO' || goog.LOCALE == 'se-NO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_se_NO;
}

if (goog.LOCALE == 'se_SE' || goog.LOCALE == 'se-SE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_se_SE;
}

if (goog.LOCALE == 'seh') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_seh;
}

if (goog.LOCALE == 'seh_MZ' || goog.LOCALE == 'seh-MZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_seh_MZ;
}

if (goog.LOCALE == 'ses') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ses;
}

if (goog.LOCALE == 'ses_ML' || goog.LOCALE == 'ses-ML') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ses_ML;
}

if (goog.LOCALE == 'sg') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sg;
}

if (goog.LOCALE == 'sg_CF' || goog.LOCALE == 'sg-CF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sg_CF;
}

if (goog.LOCALE == 'shi') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_shi;
}

if (goog.LOCALE == 'shi_Latn' || goog.LOCALE == 'shi-Latn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_shi_Latn;
}

if (goog.LOCALE == 'shi_Latn_MA' || goog.LOCALE == 'shi-Latn-MA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_shi_Latn_MA;
}

if (goog.LOCALE == 'shi_Tfng' || goog.LOCALE == 'shi-Tfng') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_shi_Tfng;
}

if (goog.LOCALE == 'shi_Tfng_MA' || goog.LOCALE == 'shi-Tfng-MA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_shi_Tfng_MA;
}

if (goog.LOCALE == 'si_LK' || goog.LOCALE == 'si-LK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_si_LK;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sk_SK;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sl_SI;
}

if (goog.LOCALE == 'smn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_smn;
}

if (goog.LOCALE == 'smn_FI' || goog.LOCALE == 'smn-FI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_smn_FI;
}

if (goog.LOCALE == 'sn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sn;
}

if (goog.LOCALE == 'sn_ZW' || goog.LOCALE == 'sn-ZW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sn_ZW;
}

if (goog.LOCALE == 'so') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_so;
}

if (goog.LOCALE == 'so_DJ' || goog.LOCALE == 'so-DJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_so_DJ;
}

if (goog.LOCALE == 'so_ET' || goog.LOCALE == 'so-ET') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_so_ET;
}

if (goog.LOCALE == 'so_KE' || goog.LOCALE == 'so-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_so_KE;
}

if (goog.LOCALE == 'so_SO' || goog.LOCALE == 'so-SO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_so_SO;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sq_AL;
}

if (goog.LOCALE == 'sq_MK' || goog.LOCALE == 'sq-MK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sq_MK;
}

if (goog.LOCALE == 'sq_XK' || goog.LOCALE == 'sq-XK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sq_XK;
}

if (goog.LOCALE == 'sr_Cyrl' || goog.LOCALE == 'sr-Cyrl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_BA' || goog.LOCALE == 'sr-Cyrl-BA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Cyrl_BA;
}

if (goog.LOCALE == 'sr_Cyrl_ME' || goog.LOCALE == 'sr-Cyrl-ME') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Cyrl_ME;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Cyrl_RS;
}

if (goog.LOCALE == 'sr_Cyrl_XK' || goog.LOCALE == 'sr-Cyrl-XK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Cyrl_XK;
}

if (goog.LOCALE == 'sr_Latn_BA' || goog.LOCALE == 'sr-Latn-BA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Latn_BA;
}

if (goog.LOCALE == 'sr_Latn_ME' || goog.LOCALE == 'sr-Latn-ME') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Latn_ME;
}

if (goog.LOCALE == 'sr_Latn_RS' || goog.LOCALE == 'sr-Latn-RS') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Latn_RS;
}

if (goog.LOCALE == 'sr_Latn_XK' || goog.LOCALE == 'sr-Latn-XK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sr_Latn_XK;
}

if (goog.LOCALE == 'sv_AX' || goog.LOCALE == 'sv-AX') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sv_AX;
}

if (goog.LOCALE == 'sv_FI' || goog.LOCALE == 'sv-FI') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sv_FI;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sv_SE;
}

if (goog.LOCALE == 'sw_CD' || goog.LOCALE == 'sw-CD') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sw_CD;
}

if (goog.LOCALE == 'sw_KE' || goog.LOCALE == 'sw-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sw_KE;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sw_TZ;
}

if (goog.LOCALE == 'sw_UG' || goog.LOCALE == 'sw-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_sw_UG;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ta_IN;
}

if (goog.LOCALE == 'ta_LK' || goog.LOCALE == 'ta-LK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ta_LK;
}

if (goog.LOCALE == 'ta_MY' || goog.LOCALE == 'ta-MY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ta_MY;
}

if (goog.LOCALE == 'ta_SG' || goog.LOCALE == 'ta-SG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ta_SG;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_te_IN;
}

if (goog.LOCALE == 'teo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_teo;
}

if (goog.LOCALE == 'teo_KE' || goog.LOCALE == 'teo-KE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_teo_KE;
}

if (goog.LOCALE == 'teo_UG' || goog.LOCALE == 'teo-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_teo_UG;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_th_TH;
}

if (goog.LOCALE == 'ti') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ti;
}

if (goog.LOCALE == 'ti_ER' || goog.LOCALE == 'ti-ER') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ti_ER;
}

if (goog.LOCALE == 'ti_ET' || goog.LOCALE == 'ti-ET') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ti_ET;
}

if (goog.LOCALE == 'to') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_to;
}

if (goog.LOCALE == 'to_TO' || goog.LOCALE == 'to-TO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_to_TO;
}

if (goog.LOCALE == 'tr_CY' || goog.LOCALE == 'tr-CY') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tr_CY;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tr_TR;
}

if (goog.LOCALE == 'twq') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_twq;
}

if (goog.LOCALE == 'twq_NE' || goog.LOCALE == 'twq-NE') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_twq_NE;
}

if (goog.LOCALE == 'tzm') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tzm;
}

if (goog.LOCALE == 'tzm_MA' || goog.LOCALE == 'tzm-MA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_tzm_MA;
}

if (goog.LOCALE == 'ug') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ug;
}

if (goog.LOCALE == 'ug_CN' || goog.LOCALE == 'ug-CN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ug_CN;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uk_UA;
}

if (goog.LOCALE == 'ur_IN' || goog.LOCALE == 'ur-IN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ur_IN;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_ur_PK;
}

if (goog.LOCALE == 'uz_Arab' || goog.LOCALE == 'uz-Arab') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uz_Arab;
}

if (goog.LOCALE == 'uz_Arab_AF' || goog.LOCALE == 'uz-Arab-AF') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uz_Arab_AF;
}

if (goog.LOCALE == 'uz_Cyrl' || goog.LOCALE == 'uz-Cyrl') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uz_Cyrl;
}

if (goog.LOCALE == 'uz_Cyrl_UZ' || goog.LOCALE == 'uz-Cyrl-UZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uz_Cyrl_UZ;
}

if (goog.LOCALE == 'uz_Latn' || goog.LOCALE == 'uz-Latn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uz_Latn;
}

if (goog.LOCALE == 'uz_Latn_UZ' || goog.LOCALE == 'uz-Latn-UZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_uz_Latn_UZ;
}

if (goog.LOCALE == 'vai') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vai;
}

if (goog.LOCALE == 'vai_Latn' || goog.LOCALE == 'vai-Latn') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vai_Latn;
}

if (goog.LOCALE == 'vai_Latn_LR' || goog.LOCALE == 'vai-Latn-LR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vai_Latn_LR;
}

if (goog.LOCALE == 'vai_Vaii' || goog.LOCALE == 'vai-Vaii') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vai_Vaii;
}

if (goog.LOCALE == 'vai_Vaii_LR' || goog.LOCALE == 'vai-Vaii-LR') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vai_Vaii_LR;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vi_VN;
}

if (goog.LOCALE == 'vun') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vun;
}

if (goog.LOCALE == 'vun_TZ' || goog.LOCALE == 'vun-TZ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_vun_TZ;
}

if (goog.LOCALE == 'wae') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_wae;
}

if (goog.LOCALE == 'wae_CH' || goog.LOCALE == 'wae-CH') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_wae_CH;
}

if (goog.LOCALE == 'xog') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_xog;
}

if (goog.LOCALE == 'xog_UG' || goog.LOCALE == 'xog-UG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_xog_UG;
}

if (goog.LOCALE == 'yav') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yav;
}

if (goog.LOCALE == 'yav_CM' || goog.LOCALE == 'yav-CM') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yav_CM;
}

if (goog.LOCALE == 'yi') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yi;
}

if (goog.LOCALE == 'yi_001' || goog.LOCALE == 'yi-001') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yi_001;
}

if (goog.LOCALE == 'yo') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yo;
}

if (goog.LOCALE == 'yo_BJ' || goog.LOCALE == 'yo-BJ') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yo_BJ;
}

if (goog.LOCALE == 'yo_NG' || goog.LOCALE == 'yo-NG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yo_NG;
}

if (goog.LOCALE == 'yue') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yue;
}

if (goog.LOCALE == 'yue_HK' || goog.LOCALE == 'yue-HK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_yue_HK;
}

if (goog.LOCALE == 'zgh') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zgh;
}

if (goog.LOCALE == 'zgh_MA' || goog.LOCALE == 'zgh-MA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zgh_MA;
}

if (goog.LOCALE == 'zh_Hans' || goog.LOCALE == 'zh-Hans') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hans_CN;
}

if (goog.LOCALE == 'zh_Hans_HK' || goog.LOCALE == 'zh-Hans-HK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hans_HK;
}

if (goog.LOCALE == 'zh_Hans_MO' || goog.LOCALE == 'zh-Hans-MO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hans_MO;
}

if (goog.LOCALE == 'zh_Hans_SG' || goog.LOCALE == 'zh-Hans-SG') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hans_SG;
}

if (goog.LOCALE == 'zh_Hant' || goog.LOCALE == 'zh-Hant') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hant;
}

if (goog.LOCALE == 'zh_Hant_HK' || goog.LOCALE == 'zh-Hant-HK') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hant_HK;
}

if (goog.LOCALE == 'zh_Hant_MO' || goog.LOCALE == 'zh-Hant-MO') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hant_MO;
}

if (goog.LOCALE == 'zh_Hant_TW' || goog.LOCALE == 'zh-Hant-TW') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zh_Hant_TW;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.i18n.NumberFormatSymbols = goog.i18n.NumberFormatSymbols_zu_ZA;
}
